/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.InterestingCallData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class DrawCallData
extends InterestingCallData {
    private static final long serialVersionUID = -5212451131426483743L;
    private final @Nullable AbstractConstantOrAliasSpec mode;
    private static final @NonNull List<@NonNull IStatisticType> supportedStatistics = NullUtils.asList((Object[])new IStatisticType[]{CommonStatistics.NUMBER_OF_VERTICES, CommonStatistics.NUMBER_OF_INSTANCES, CommonStatistics.NUMBER_OF_INSTANCED_VERTICES, CommonStatistics.NUMBER_OF_INDICES, CommonStatistics.NUMBER_OF_UNIQUE_INDICES});

    public DrawCallData(@NonNull DrawFunctionCall drawFunctionCall) {
        ArgumentSpec modeArgument = drawFunctionCall.getFunctionSpec().getDrawCallInfo().getModeArg();
        this.mode = modeArgument != null ? (AbstractConstantOrAliasSpec)((Object)drawFunctionCall.getArgValue(modeArgument.getArgIndex())) : null;
    }

    protected int @Nullable [] getIntegerIndirectBuffer(@NonNull DrawFunctionCall functionCall, @NonNull TraceStateSnapshot currentState, int commandStructSize) {
        ArgumentSpec indirectBufferArg = functionCall.getFunctionSpec().getDrawCallInfo().getIndirectCmdArg();
        assert (indirectBufferArg != null);
        GlBufferAsset indirectBufferAsset = (GlBufferAsset)currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_DRAW_INDIRECT_BUFFER_BINDING).getValueAsAsset();
        if (indirectBufferAsset != null && indirectBufferAsset.getData() != null) {
            Pointer p = (Pointer)functionCall.getArgValue(indirectBufferArg.getArgIndex());
            int offset = p.addressAsInt();
            byte[] indirectBuffer = null;
            try {
                indirectBuffer = Arrays.copyOfRange(indirectBufferAsset.getData(), offset, offset + commandStructSize);
            }
            catch (ArrayIndexOutOfBoundsException x) {
                CoreLogging.severe(null, "Out-of-bounds offset (" + offset + ") for indirect command buffer in " + functionCall);
            }
            return indirectBuffer != null ? NumberUtils.getIntegersFromBytes(indirectBuffer) : null;
        }
        IArgument att = functionCall.getArgument(indirectBufferArg.getArgIndex());
        IByteDataProvider byteData = att instanceof BufferArgAttachment ? ((BufferArgAttachment)att).getData() : null;
        return byteData != null ? NumberUtils.getIntegersFromBytes(byteData) : null;
    }

    public abstract int[] getIndices(@NonNull TraceStateSnapshot var1);

    public abstract long getNumberOfIndices();

    public abstract long getNumberOfUniqueIndices();

    public abstract long getNumberOfInstances();

    public abstract int[] getOrderedUniqueIndices(@NonNull TraceStateSnapshot var1);

    private long getVerticesCount() {
        return this.getNumberOfIndices() * this.getNumberOfInstances();
    }

    private long getNumberInstancedVertices() {
        assert (this.getNumberOfInstances() >= 0L);
        return Math.max(this.getNumberOfIndices() * (this.getNumberOfInstances() - 1L), 0L);
    }

    public @Nullable AbstractConstantOrAliasSpec getMode() {
        return this.mode;
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
        return supportedStatistics.contains(type);
    }

    @Override
    public @NonNull String getDescriptiveText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStatistic(CommonStatistics.NUMBER_OF_VERTICES).getValueString()).append(", ");
        stringBuilder.append(this.getStatistic(CommonStatistics.NUMBER_OF_UNIQUE_INDICES).getValueString());
        return (String)NullUtils.neverNull((Object)stringBuilder.toString());
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
        if (type == CommonStatistics.NUMBER_OF_INDICES) {
            return new Statistic(type, this.getNumberOfIndices());
        }
        if (type == CommonStatistics.NUMBER_OF_INSTANCED_VERTICES) {
            return new Statistic(type, this.getNumberInstancedVertices());
        }
        if (type == CommonStatistics.NUMBER_OF_INSTANCES) {
            return new Statistic(type, this.getNumberOfInstances());
        }
        if (type == CommonStatistics.NUMBER_OF_UNIQUE_INDICES) {
            return new Statistic(type, this.getNumberOfUniqueIndices());
        }
        if (type == CommonStatistics.NUMBER_OF_VERTICES) {
            return new Statistic(type, this.getVerticesCount());
        }
        throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
    }
}

