/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.DrawCallData;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.utils.VersionProperties;
import java.util.AbstractMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class DrawArraysCallData
extends DrawCallData {
    private static final long serialVersionUID = -7507682386302599229L;
    private final int indicesOffset;
    private final int numberOfIndices;
    private final int numberOfUniqueIndices;
    private final int numberOfInstances;

    public DrawArraysCallData(@NonNull DrawFunctionCall functionCall, @NonNull TraceStateSnapshot currentState) {
        super(functionCall);
        IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
        if (functionSpec.getDrawCallInfo().isIndirect()) {
            int commandStructSize = functionSpec.getDrawCallInfo().getIndirectCmdSize().intValue();
            int[] integerIndirectBuffer = this.getIntegerIndirectBuffer(functionCall, currentState, 4 * commandStructSize);
            if (integerIndirectBuffer == null) {
                this.indicesOffset = 0;
                this.numberOfIndices = 0;
                this.numberOfUniqueIndices = 0;
                this.numberOfInstances = 0;
                TraceAnalysisLogger.info(currentState, functionCall, "A draw call takes its parameters from a buffer for which " + VersionProperties.FULL_PRODUCT_NAME + " doesn't have the data ", "It may be that the buffer has been written by the GPU. Turning on \"Send Output Data\" will allow " + VersionProperties.SHORT_PRODUCT_NAME + " to recover those buffers.");
                return;
            }
            assert (integerIndirectBuffer.length == commandStructSize);
            this.numberOfIndices = integerIndirectBuffer[0];
            this.numberOfInstances = integerIndirectBuffer[1];
            this.indicesOffset = integerIndirectBuffer[2];
        } else {
            ArgumentSpec instancesArg = functionSpec.getDrawCallInfo().getInstanceCountArg();
            this.numberOfInstances = instancesArg != null ? ((Number)functionCall.getArgValue(instancesArg.getArgIndex())).intValue() : 1;
            ArgumentSpec vertexArg = functionSpec.getDrawCallInfo().getVerticesArg();
            this.numberOfIndices = ((Number)functionCall.getArgValue(vertexArg.getArgIndex())).intValue();
            ArgumentSpec firstIndexArg = functionSpec.getDrawCallInfo().getFirstIndexArg();
            this.indicesOffset = ((Number)functionCall.getArgValue(firstIndexArg.getArgIndex())).intValue();
        }
        this.numberOfUniqueIndices = this.numberOfIndices;
    }

    private static int[] generateIndices(int first, long numberOfVertices) {
        assert (numberOfVertices <= Integer.MAX_VALUE);
        return NumberUtils.getIntSortedArray(first, Math.max(0, (int)numberOfVertices));
    }

    @Override
    public int[] getOrderedUniqueIndices(TraceStateSnapshot currentState) {
        return this.getIndices(currentState);
    }

    @Override
    public int[] getIndices(TraceStateSnapshot currentState) {
        return DrawArraysCallData.generateIndices(this.indicesOffset, this.numberOfIndices);
    }

    @Override
    public @NonNull List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> getInformation() {
        List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> information = super.getInformation();
        information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Indices offset", "" + this.indicesOffset));
        return information;
    }

    @Override
    public long getNumberOfIndices() {
        return this.numberOfIndices;
    }

    @Override
    public long getNumberOfUniqueIndices() {
        return this.numberOfUniqueIndices;
    }

    @Override
    public long getNumberOfInstances() {
        return this.numberOfInstances;
    }
}

