/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ComputeWorkgroupSize
implements Serializable {
    private static final long serialVersionUID = -3655734307127980388L;
    private final long[] workSize;

    public ComputeWorkgroupSize(long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException("Arguments must be greater than 0");
        }
        this.workSize = new long[]{x};
    }

    public ComputeWorkgroupSize(long x, long y) {
        if (x <= 0L || y <= 0L) {
            throw new IllegalArgumentException("Arguments must be greater than 0");
        }
        this.workSize = new long[]{x, y};
    }

    public ComputeWorkgroupSize(long x, long y, long z) {
        if (x <= 0L || y <= 0L || z <= 0L) {
            throw new IllegalArgumentException("Arguments must be greater than 0");
        }
        this.workSize = new long[]{x, y, z};
    }

    public static @NonNull ComputeWorkgroupSize createFromLongList(@NonNull List<@NonNull Long> dimensions) {
        switch (dimensions.size()) {
            case 1: {
                return new ComputeWorkgroupSize(dimensions.get(0));
            }
            case 2: {
                return new ComputeWorkgroupSize(dimensions.get(0), dimensions.get(1));
            }
            case 3: {
                return new ComputeWorkgroupSize(dimensions.get(0), dimensions.get(1), dimensions.get(2));
            }
        }
        throw new IllegalArgumentException("Size of the dimensions list must be between 1 and 3 inclusive");
    }

    public int getNumDimensions() {
        return this.workSize.length;
    }

    public long getX() {
        return this.workSize[0];
    }

    public long getY() {
        return this.workSize.length >= 2 ? this.workSize[1] : 1L;
    }

    public long getZ() {
        return this.workSize.length >= 3 ? this.workSize[2] : 1L;
    }

    public long getTotalWorkgroupSize() {
        return this.getX() * this.getY() * this.getZ();
    }

    public long[] asLongArray() {
        return Arrays.copyOf(this.workSize, this.workSize.length);
    }

    public @NonNull String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.workSize.length) {
            sb.append(this.workSize[i]);
            if (i != this.workSize.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }
}

