/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.asset.objects.gen.AbstractClSubBufferMemoryAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.ClMemoryRegionAttachment;
import com.arm.mgd.core.target.data.EmulatedClMemoryRegionAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IMemoryRegionAttachment;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClSubBufferMemoryAsset
extends AbstractClSubBufferMemoryAsset
implements IBufferItem {
    private static final long serialVersionUID = -8099265315972425495L;
    private final @NonNull String labelText = "SubBuffer 0x" + Long.toHexString(this.getId());

    public ClSubBufferMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull ClContextAsset contextAsset, @NonNull Bitfield flags,  @NonNull CL.Structs.ClBufferRegionStruct bufferRegion, @NonNull ClMemoryAsset parentBufferAsset) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, contextAsset, flags, bufferRegion, parentBufferAsset);
    }

    @Override
    public @NonNull String getLabelText() {
        return this.labelText;
    }

    public Long getSize() {
        return this.getBufferRegion().getSize();
    }

    @Override
    public int getSizeOfMemory() {
        Long size = this.getSize();
        return size == null ? 0 : size.intValue();
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Parent", this.getParentBufferAsset());
        properties.put("Size", ValueAssetProperty.create(this.getSize() + " bytes"));
        return properties;
    }

    @Override
    public long getSizeOfBuffer() {
        return this.getSizeOfMemory();
    }

    @Override
    public @NonNull IBufferUsage getBufferUsage() {
        return new IBufferUsage(){

            @Override
            public String getLabelText() {
                return "CL_SUBBUFFER";
            }
        };
    }

    @Override
    public byte @Nullable [] getDataForBuffer() {
        return this.getParentBufferAsset().getDataForRegion(this.getBufferRegion().getOrigin().intValue(), this.getBufferRegion().getSize().intValue());
    }

    @Override
    public void addDataAttachment(@NonNull IMemoryRegionAttachment att) {
        IMemoryRegionAttachment attachmentForParent;
        if (att instanceof ClMemoryRegionAttachment) {
            attachmentForParent = new ClMemoryRegionAttachment(att.getOffset() + this.getBufferRegion().getOrigin(), ((ClMemoryRegionAttachment)att).getRawAttachment());
        } else if (att instanceof EmulatedClMemoryRegionAttachment) {
            EmulatedClMemoryRegionAttachment emuAtt = (EmulatedClMemoryRegionAttachment)att;
            attachmentForParent = new EmulatedClMemoryRegionAttachment(emuAtt.getOffset() + this.getBufferRegion().getOrigin(), emuAtt.getSourceOffset(), emuAtt.getSize(), emuAtt.getParent());
        } else {
            assert (false) : String.format("Unrecognised memory attachment: %s", att);
            attachmentForParent = null;
        }
        if (attachmentForParent != null) {
            this.getParentBufferAsset().addDataAttachment(attachmentForParent);
        }
    }

    @Override
    public byte @NonNull [] getCurrentDataContents() {
        byte[] returnVal = this.getDataForBuffer();
        return returnVal == null ? new byte[this.getSize().intValue()] : returnVal;
    }

    @Override
    public @NonNull ClMemoryAsset.ClMemoryType getMemoryType() {
        return ClMemoryAsset.ClMemoryType.BUFFER;
    }
}

