/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.ReferenceCounter;
import com.arm.mgd.core.asset.objects.IRetainableAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractClProgramAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClProgramAsset
extends AbstractClProgramAsset
implements IRetainableAssetItem {
    private static final long serialVersionUID = -5292578757926154008L;
    private final @NonNull CreationMethod creationMethod;
    private final @NonNull ReferenceCounter referenceCounter;

    public ClProgramAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull ClContextAsset contextAsset) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, contextAsset);
        IFunctionOrAliasSpecExtended functionSpec = createdByFunction.getFunctionSpec();
        if (functionSpec.equals(KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE)) {
            this.creationMethod = CreationMethod.WITH_SOURCE;
            this.setSource(createdByFunction, CL.ClCreateProgramWithSourceDecorator.getArgumentStrings(createdByFunction));
        } else if (functionSpec.equals(KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY)) {
            this.creationMethod = CreationMethod.WITH_BINARY;
        } else if (functionSpec.equals(KapiSpec.CL.functions.CLCREATEPROGRAMWITHBUILTINKERNELS)) {
            this.creationMethod = CreationMethod.WITH_BUILT_IN_KERNELS;
        } else if (functionSpec.equals(KapiSpec.CL.functions.CLLINKPROGRAM)) {
            this.creationMethod = CreationMethod.BY_LINKER;
        } else {
            assert (false);
            throw new IllegalArgumentException("Function call " + createdByFunction.getFunctionSpec() + " not a valid way to make a ClProgramAsset");
        }
        this.referenceCounter = new ReferenceCounter(1L);
    }

    @Override
    public String getLabelText() {
        return "Program 0x" + Long.toHexString(this.getId());
    }

    @Override
    public String toString() {
        return "ClProgramAsset 0x" + Long.toHexString(this.getId());
    }

    public @NonNull CreationMethod getCreationMethod() {
        return this.creationMethod;
    }

    @Override
    public @NonNull ReferenceCounter getReferenceCounter() {
        return this.referenceCounter;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Reference Count", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getReferenceCounter().get())));
        properties.put("Creation Method", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getCreationMethod().toString())));
        String buildOptions = this.getBuildOptions();
        if (buildOptions != null && !buildOptions.isEmpty()) {
            properties.put("Build Options", ValueAssetProperty.create(buildOptions));
        }
        return properties;
    }

    @Override
    public @Nullable String getTextForm() {
        return this.getSource();
    }

    public static enum CreationMethod {
        WITH_SOURCE,
        WITH_BINARY,
        WITH_BUILT_IN_KERNELS,
        BY_LINKER;

    }
}

