/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClSubBufferMemoryAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.ReferenceCounter;
import com.arm.mgd.core.asset.objects.IRetainableAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractClMemoryAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IMemoryRegionAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Pair;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;

public abstract class ClMemoryAsset
extends AbstractClMemoryAsset
implements IRetainableAssetItem {
    private static final long serialVersionUID = -8467567485574810096L;
    private final @NonNull ReferenceCounter referenceCounter;
    private final @NonNull List<ClSubBufferMemoryAsset> subBuffers = new ArrayList<ClSubBufferMemoryAsset>();
    private final @NonNull List<Long> subBufferIDs = new ArrayList<Long>();
    private final @NonNull List<OverlappingSubBuffers> knownUnsafeSubBuffers = new ArrayList<OverlappingSubBuffers>();
    private final @NonNull List<@NonNull IMemoryRegionAttachment> memoryAttachments = new ArrayList<IMemoryRegionAttachment>();

    public ClMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull ClContextAsset context, @NonNull Bitfield flags) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, context, flags);
        this.referenceCounter = new ReferenceCounter(1L);
    }

    @Override
    public @NonNull ReferenceCounter getReferenceCounter() {
        return this.referenceCounter;
    }

    public void addSubBuffer(ClSubBufferMemoryAsset subBuffer, FunctionCall createdByFunction, @NonNull TraceStateSnapshot currentState) {
        this.subBuffers.add(subBuffer);
        this.subBufferIDs.add(subBuffer.getId());
        this.generateUnsafeSubBufferWarning(currentState, createdByFunction);
    }

    public void removeSubBuffer(ClSubBufferMemoryAsset subBuffer) {
        this.subBuffers.remove(subBuffer);
        this.subBufferIDs.remove(subBuffer.getId());
    }

    public @NonNull List<Long> getSubBufferIDs() {
        return this.subBufferIDs;
    }

    public @NonNull String getSubBuffersAsString() {
        return StringUtils.commaSeparatedHexValues(this.subBufferIDs);
    }

    public boolean isReadOnly() {
        return this.getFlags().contains(KapiSpec.CL.constants.CL_MEM_READ_ONLY);
    }

    private void generateUnsafeSubBufferWarning(@NonNull TraceStateSnapshot currentState, FunctionCall createdByFunction) {
        List<OverlappingSubBuffers> unsafeSubBuffers = this.checkForUnsafeOverlap(this.getSubBuffers());
        TreeSet<Long> unsafeSubBufferIDs = new TreeSet<Long>();
        for (OverlappingSubBuffers item : unsafeSubBuffers) {
            unsafeSubBufferIDs.addAll(Arrays.asList(item.getHexIDs()));
        }
        if (!unsafeSubBufferIDs.isEmpty()) {
            String message = (String)NullUtils.neverNull((Object)String.format("Overlapping writeable sub-buffers: %s", StringUtils.commaSeparatedHexValues(unsafeSubBufferIDs)));
            TraceAnalysisLogger.warning(currentState, createdByFunction, message);
        }
    }

    protected @NonNull List<ClSubBufferMemoryAsset> getSubBuffers() {
        return this.subBuffers;
    }

    protected static boolean doSubBuffersOverlap(ClSubBufferMemoryAsset sub1, ClSubBufferMemoryAsset sub2) {
        long start1 = sub1.getBufferRegion().getOrigin();
        long end1 = start1 + sub1.getBufferRegion().getSize();
        long start2 = sub2.getBufferRegion().getOrigin();
        long end2 = start2 + sub2.getBufferRegion().getSize();
        return start1 < end2 && start2 < end1;
    }

    public @NonNull List<OverlappingSubBuffers> getKnownUnsafeSubBuffers() {
        return this.knownUnsafeSubBuffers;
    }

    protected @NonNull List<OverlappingSubBuffers> checkForUnsafeOverlap(List<ClSubBufferMemoryAsset> subBuffersToCheck) {
        ArrayList<OverlappingSubBuffers> unsafeList = new ArrayList<OverlappingSubBuffers>();
        ArrayList<OverlappingSubBuffers> processedList = new ArrayList<OverlappingSubBuffers>(this.getKnownUnsafeSubBuffers());
        if (subBuffersToCheck.size() < 2) {
            return unsafeList;
        }
        for (ClSubBufferMemoryAsset firstSub : subBuffersToCheck) {
            for (ClSubBufferMemoryAsset secondSub : subBuffersToCheck) {
                OverlappingSubBuffers overlap;
                if (firstSub.equals(secondSub) || !ClMemoryAsset.doSubBuffersOverlap(firstSub, secondSub) || (overlap = new OverlappingSubBuffers(firstSub, secondSub)).isContainedBy(processedList)) continue;
                if (!overlap.isSafe()) {
                    unsafeList.add(overlap);
                    processedList.add(overlap);
                    this.getKnownUnsafeSubBuffers().add(overlap);
                    continue;
                }
                processedList.add(overlap);
            }
        }
        return unsafeList;
    }

    public abstract int getSizeOfMemory();

    public byte @NonNull [] getDataForRegion(int origin, int size) {
        byte[] returnVal = new byte[size];
        System.arraycopy(this.getCurrentDataContents(), origin, returnVal, 0, size);
        return returnVal;
    }

    public byte @NonNull [] getDataFromAttachments(int index) {
        byte[] dataContents = new byte[this.getSizeOfMemory()];
        int i = 0;
        while (i < index) {
            IMemoryRegionAttachment att = this.memoryAttachments.get(i);
            IByteDataProvider sourceDataProvider = att.getDataForRegion();
            if (sourceDataProvider != null) {
                ByteBuffer sourceData = sourceDataProvider.getData();
                sourceData.get(dataContents, (int)att.getOffset(), att.getSize());
            }
            ++i;
        }
        return dataContents;
    }

    public @NonNull IMemoryRegionAttachment getAttachment(int index) {
        assert (index < this.memoryAttachments.size());
        return this.memoryAttachments.get(index);
    }

    public byte @NonNull [] getCurrentDataContents() {
        return this.getDataFromAttachments(this.getCurrentAttachmentIndex());
    }

    public int getCurrentAttachmentIndex() {
        return this.memoryAttachments.size();
    }

    public void addDataAttachment(@NonNull IMemoryRegionAttachment att) {
        this.memoryAttachments.add(att);
    }

    public boolean hasData() {
        return this.memoryAttachments.size() > 0;
    }

    @Override
    public String toString() {
        return String.format("0x%x", this.getId());
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Reference Count", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getReferenceCounter().get())));
        return properties;
    }

    public abstract @NonNull ClMemoryType getMemoryType();

    public static enum ClMemoryType {
        IMAGE,
        BUFFER;

    }

    protected final class OverlappingSubBuffers
    extends Pair<ClSubBufferMemoryAsset, ClSubBufferMemoryAsset> {
        public OverlappingSubBuffers(ClSubBufferMemoryAsset firstValue, ClSubBufferMemoryAsset secondValue) {
            super(firstValue, secondValue);
        }

        public boolean isSafe() {
            return ((ClSubBufferMemoryAsset)this.getFirstValue()).isReadOnly() && ((ClSubBufferMemoryAsset)this.getSecondValue()).isReadOnly();
        }

        public boolean isContainedBy(List<OverlappingSubBuffers> list) {
            OverlappingSubBuffers reversed = new OverlappingSubBuffers((ClSubBufferMemoryAsset)this.getSecondValue(), (ClSubBufferMemoryAsset)this.getFirstValue());
            for (OverlappingSubBuffers item : list) {
                if (!this.equals(item) && !reversed.equals(item)) continue;
                return true;
            }
            return false;
        }

        public @NonNull Long[] getHexIDs() {
            Object[] returnVal = new Long[]{((ClSubBufferMemoryAsset)this.getFirstValue()).getId(), ((ClSubBufferMemoryAsset)this.getSecondValue()).getId()};
            return (Long[])NullUtils.neverNull((Object[])returnVal);
        }
    }
}

