/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.ReferenceCounter;
import com.arm.mgd.core.asset.objects.IRetainableAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractClKernelAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClKernelAsset
extends AbstractClKernelAsset
implements IRetainableAssetItem {
    private static final long serialVersionUID = 8391346836854510613L;
    private final @NonNull String labelText;
    private final @NonNull ReferenceCounter referenceCounter;
    private final @NonNull List<@NonNull KernelInvocation> kernelInvocations = new ArrayList<KernelInvocation>();

    public ClKernelAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull String kernelName, @NonNull ClProgramAsset programAsset) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, kernelName, programAsset);
        this.referenceCounter = new ReferenceCounter(1L);
        String kernelHexID = "0x" + Long.toHexString(id);
        String programHexID = "0x" + Long.toHexString(programAsset.getId());
        this.labelText = String.valueOf(kernelName) + " (" + programHexID + "::" + kernelHexID + ")";
    }

    @Override
    public String getLabelText() {
        return this.labelText;
    }

    public void addInvocation(@Nullable ComputeWorkgroupSize localWorkSize, @NonNull ComputeWorkgroupSize globalWorkSize) {
        this.kernelInvocations.add(new KernelInvocation(localWorkSize, globalWorkSize));
    }

    public @NonNull List<@NonNull KernelInvocation> getInvocationHistory() {
        return new ReadOnlySubList<KernelInvocation>(this.kernelInvocations, 0, this.kernelInvocations.size());
    }

    @Override
    public @NonNull ReferenceCounter getReferenceCounter() {
        return this.referenceCounter;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Reference Count", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getReferenceCounter().get())));
        properties.put("Program", this.getProgramAsset());
        return properties;
    }

    public static class KernelInvocation
    implements Serializable {
        private static final long serialVersionUID = 4238678096964745371L;
        public final @Nullable ComputeWorkgroupSize localWorkSize;
        public final @NonNull ComputeWorkgroupSize globalWorkSize;

        private KernelInvocation(@Nullable ComputeWorkgroupSize localWorkSize, @NonNull ComputeWorkgroupSize globalWorkSize) {
            this.localWorkSize = localWorkSize;
            this.globalWorkSize = globalWorkSize;
        }
    }
}

