/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractClImageMemoryAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class ClImageMemoryAsset
extends AbstractClImageMemoryAsset {
    private static final long serialVersionUID = -3695726571942899883L;
    private final @NonNull String labelText = "Image 0x" + Long.toHexString(this.getId());
    private final @NonNull ImageChannelDataType type = ImageChannelDataType.getTypeFromConstant(this.getChannelDataType());

    public ClImageMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull ClContextAsset contextAsset, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended channelOrder, @NonNull AbstractConstantOrAliasSpecExtended channelDataType, @NonNull AbstractConstantOrAliasSpecExtended type) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, contextAsset, flags, channelOrder, channelDataType, type);
    }

    @Override
    public @NonNull String getLabelText() {
        return this.labelText;
    }

    @Override
    public @NonNull AbstractConstantOrAliasSpecExtended getType() {
        return super.getType();
    }

    private @NonNull String getDescriptiveTextDimensionality() {
        AbstractConstantOrAliasSpecExtended[] ONE = new AbstractConstantOrAliasSpecExtended[]{KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_ARRAY, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_BUFFER};
        AbstractConstantOrAliasSpecExtended[] TWO = new AbstractConstantOrAliasSpecExtended[]{KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D_ARRAY};
        if (Arrays.asList(ONE).contains(this.getType())) {
            return "1D";
        }
        if (Arrays.asList(TWO).contains(this.getType())) {
            return "2D";
        }
        if (this.getType().equals(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D)) {
            return "3D";
        }
        assert (false) : "Unrecognised image type: " + this.getType();
        return "Unknown";
    }

    private @NonNull String getDescriptiveTextImageChannelOrder() {
        return (String)NullUtils.neverNull((Object)this.getChannelOrder().toString());
    }

    public int getDataFormatSize() {
        switch (this.type) {
            case CL_SNORM_INT8: {
                return 1;
            }
            case CL_SNORM_INT16: {
                return 2;
            }
            case CL_UNORM_INT8: {
                return 1;
            }
            case CL_UNORM_INT16: {
                return 2;
            }
            case CL_UNORM_SHORT_565: {
                return 2;
            }
            case CL_UNORM_SHORT_555: {
                return 2;
            }
            case CL_UNORM_INT_101010: {
                return 4;
            }
            case CL_SIGNED_INT8: {
                return 1;
            }
            case CL_SIGNED_INT16: {
                return 2;
            }
            case CL_SIGNED_INT32: {
                return 4;
            }
            case CL_UNSIGNED_INT8: {
                return 1;
            }
            case CL_UNSIGNED_INT16: {
                return 2;
            }
            case CL_UNSIGNED_INT32: {
                return 4;
            }
            case CL_HALF_FLOAT: {
                return 2;
            }
            case CL_FLOAT: {
                return 4;
            }
            case UNKNOWN: {
                assert (false) : "Image type unknown; no size information available.";
                return 0;
            }
        }
        assert (false) : "Unrecognised image type: " + this.getType();
        return 0;
    }

    private @NonNull String getDescriptiveTextImageChannelDataType() {
        return (String)NullUtils.neverNull((Object)this.getChannelDataType().toString());
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Type", ValueAssetProperty.create(String.valueOf(this.getDescriptiveTextDimensionality()) + " Image"));
        properties.put("Channel order", ValueAssetProperty.create(this.getDescriptiveTextImageChannelOrder()));
        properties.put("Channel data type", ValueAssetProperty.create(this.getDescriptiveTextImageChannelDataType()));
        if (this.getWidth() != null) {
            properties.put("Width", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWidth().toString())));
        }
        if (this.getHeight() != null) {
            properties.put("Height", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getHeight().toString())));
        }
        if (this.getDepth() != null) {
            properties.put("Depth", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getDepth().toString())));
        }
        return properties;
    }

    @Override
    public int getSizeOfMemory() {
        int dataSize;
        FunctionCall creator = this.getCreatedByFunction();
        if (creator.getFunctionSpec().equals(KapiSpec.CL.functions.CLCREATEIMAGE)) {
            CL.Structs.ClImageDescStruct desc = CL.ClCreateImageDecorator.getArgumentImage_desc(creator);
            Long row_pitch = desc.getImage_row_pitch();
            int width = row_pitch.intValue() != 0 ? row_pitch.intValue() : desc.getImage_width().intValue() * this.getDataFormatSize();
            Long slice_pitch = desc.getImage_slice_pitch();
            AbstractConstantOrAliasSpecExtended imageType = desc.getImage_type();
            int slice = slice_pitch.intValue() != 0 ? slice_pitch.intValue() : (desc.getImage_type().equals(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_ARRAY) ? width : width * Math.max(1, desc.getImage_height().intValue()));
            dataSize = imageType.equals(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D) ? slice * Math.max(1, desc.getImage_depth().intValue()) : (imageType.equals(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D_ARRAY) ? slice * desc.getImage_array_size().intValue() : (imageType.equals(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_BUFFER) ? desc.getImage_width().intValue() * this.getDataFormatSize() : slice));
        } else if (creator.getFunctionSpec().equals(KapiSpec.CL.functions.CLCREATEIMAGE2D)) {
            Long width = CL.ClCreateImage2DDecorator.getArgumentImage_width(creator);
            Long height = CL.ClCreateImage2DDecorator.getArgumentImage_height(creator);
            Long row_pitch = CL.ClCreateImage2DDecorator.getArgumentImage_row_pitch(creator);
            dataSize = row_pitch.intValue() != 0 ? row_pitch.intValue() * height.intValue() : width.intValue() * height.intValue() * this.getDataFormatSize();
        } else if (creator.getFunctionSpec().equals(KapiSpec.CL.functions.CLCREATEIMAGE3D)) {
            Long width = CL.ClCreateImage3DDecorator.getArgumentImage_width(creator);
            Long height = CL.ClCreateImage3DDecorator.getArgumentImage_height(creator);
            Long depth = CL.ClCreateImage3DDecorator.getArgumentImage_depth(creator);
            Long row_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_row_pitch(creator);
            Long slice_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_slice_pitch(creator);
            width = row_pitch.intValue() != 0 ? row_pitch : Long.valueOf(width.intValue() * this.getDataFormatSize());
            int slice = slice_pitch.intValue() != 0 ? slice_pitch.intValue() : width.intValue() * height.intValue();
            dataSize = slice * depth.intValue();
        } else {
            assert (false) : String.format("Unrecognised CL image constructor: %s", creator);
            dataSize = 0;
        }
        return dataSize;
    }

    public @NonNull Number @NonNull [] getProcessedData() {
        byte[] data = this.getCurrentDataContents();
        switch (this.type) {
            case CL_HALF_FLOAT: {
                return NumberUtils.getHalfFloatObjectsFromBytes(data);
            }
            case CL_FLOAT: {
                return NumberUtils.getFloatObjectsFromBytes(data);
            }
            case CL_SNORM_INT8: 
            case CL_SIGNED_INT8: {
                return NumberUtils.getByteObjectsForBytesFromBytes(data);
            }
            case CL_SNORM_INT16: 
            case CL_UNORM_SHORT_565: 
            case CL_SIGNED_INT16: {
                return NumberUtils.getShortObjectsForShortsFromBytes(data);
            }
            case CL_SIGNED_INT32: {
                return NumberUtils.getIntegerObjectsForIntegersFromBytes(data);
            }
            case CL_UNORM_SHORT_555: 
            case CL_UNORM_INT_101010: 
            case CL_UNSIGNED_INT32: {
                return NumberUtils.getLongObjectsForUnsignedIntsFromBytes(data);
            }
            case CL_UNORM_INT8: 
            case CL_UNSIGNED_INT8: {
                return NumberUtils.getShortObjectsForUnsignedBytesFromBytes(data);
            }
            case CL_UNORM_INT16: 
            case CL_UNSIGNED_INT16: {
                return NumberUtils.getIntegerObjectsForUnsignedShortsFromBytes(data);
            }
        }
        assert (false) : "Unrecognised CL image data channel type";
        return NumberUtils.getByteObjectsForBytesFromBytes(data);
    }

    @Override
    public  @NonNull ClMemoryAsset.ClMemoryType getMemoryType() {
        return ClMemoryAsset.ClMemoryType.IMAGE;
    }

    public static final class ImageChannelDataType
    extends Enum<ImageChannelDataType> {
        public static final /* enum */ ImageChannelDataType CL_SNORM_INT8 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_SNORM_INT16 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNORM_INT8 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNORM_INT16 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNORM_SHORT_565 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNORM_SHORT_555 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNORM_INT_101010 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_SIGNED_INT8 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_SIGNED_INT16 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_SIGNED_INT32 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNSIGNED_INT8 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNSIGNED_INT16 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_UNSIGNED_INT32 = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_HALF_FLOAT = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType CL_FLOAT = new ImageChannelDataType();
        public static final /* enum */ ImageChannelDataType UNKNOWN = new ImageChannelDataType();
        private static final /* synthetic */ ImageChannelDataType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ImageChannelDataType[]{CL_SNORM_INT8, CL_SNORM_INT16, CL_UNORM_INT8, CL_UNORM_INT16, CL_UNORM_SHORT_565, CL_UNORM_SHORT_555, CL_UNORM_INT_101010, CL_SIGNED_INT8, CL_SIGNED_INT16, CL_SIGNED_INT32, CL_UNSIGNED_INT8, CL_UNSIGNED_INT16, CL_UNSIGNED_INT32, CL_HALF_FLOAT, CL_FLOAT, UNKNOWN};
        }

        public static @NonNull ImageChannelDataType getTypeFromConstant(@NonNull AbstractConstantOrAliasSpecExtended rawType) {
            if (rawType.equals(KapiSpec.CL.constants.CL_SNORM_INT8)) {
                return CL_SNORM_INT8;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_SNORM_INT16)) {
                return CL_SNORM_INT16;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNORM_INT8)) {
                return CL_UNORM_INT8;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNORM_INT16)) {
                return CL_UNORM_INT16;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNORM_SHORT_565)) {
                return CL_UNORM_SHORT_565;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNORM_SHORT_555)) {
                return CL_UNORM_SHORT_555;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNORM_INT_101010)) {
                return CL_UNORM_INT_101010;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_SIGNED_INT8)) {
                return CL_SIGNED_INT8;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_SIGNED_INT16)) {
                return CL_SIGNED_INT16;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_SIGNED_INT32)) {
                return CL_SIGNED_INT32;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNSIGNED_INT8)) {
                return CL_UNSIGNED_INT8;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNSIGNED_INT16)) {
                return CL_UNSIGNED_INT16;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_UNSIGNED_INT32)) {
                return CL_UNSIGNED_INT32;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_HALF_FLOAT)) {
                return CL_HALF_FLOAT;
            }
            if (rawType.equals(KapiSpec.CL.constants.CL_FLOAT)) {
                return CL_SIGNED_INT32;
            }
            assert (false) : "Image channel data type is not recognised: " + rawType;
            return UNKNOWN;
        }

        public static ImageChannelDataType[] values() {
            ImageChannelDataType[] imageChannelDataTypeArray = ENUM$VALUES;
            int n = imageChannelDataTypeArray.length;
            ImageChannelDataType[] imageChannelDataTypeArray2 = new ImageChannelDataType[n];
            System.arraycopy(ENUM$VALUES, 0, imageChannelDataTypeArray2, 0, n);
            return imageChannelDataTypeArray2;
        }

        public static ImageChannelDataType valueOf(String string) {
            return Enum.valueOf(ImageChannelDataType.class, string);
        }
    }
}

