/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.InterestingCallData;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.ClEnqueueCall;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.TimestampUtils;
import com.arm.mgd.utils.NullUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClEnqueueCallData
extends InterestingCallData {
    private static final long serialVersionUID = -1949694408228881980L;
    private final @NonNull ClEnqueueCall functionCall;

    public ClEnqueueCallData(@NonNull ClEnqueueCall functionCall) {
        this.functionCall = functionCall;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        List<Pointer> waitList;
        ArrayList<@NonNull String> details = new ArrayList<String>();
        @Nullable Pointer commandQueue = this.functionCall.getCommandQueue();
        if (commandQueue != null) {
            details.add("Queue=" + commandQueue.toString());
        }
        if (this.functionCall.isBlocking()) {
            details.add("Blocked for " + TimestampUtils.microsecondsToSecondsString(this.functionCall.getWaitTime()) + "s");
        }
        if ((waitList = this.functionCall.getEventWaitList()) != null && waitList.size() != 0) {
            details.add(String.valueOf(waitList.size()) + " " + StringUtils.formatQuantity(waitList.size(), "dependency", "dependencies"));
        }
        if (details.size() == 0) {
            return "";
        }
        return StringUtils.arrayToString(details.toArray());
    }

    @Override
    public @NonNull List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> getInformation() {
        List<Pointer> waitList;
        @NonNull List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> information = super.getInformation();
        @Nullable Pointer commandQueue = this.functionCall.getCommandQueue();
        if (commandQueue != null) {
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Command queue", (String)NullUtils.neverNull((Object)commandQueue.toString())));
        }
        if (this.functionCall.canBlock()) {
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Blocking call", this.functionCall.isBlocking() ? "True" : "False"));
        }
        if ((waitList = this.functionCall.getEventWaitList()) != null) {
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Wait list size", (String)NullUtils.neverNull((Object)Integer.toString(waitList.size()))));
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Wait list", waitList.size() == 0 ? "None" : StringUtils.arrayToString(waitList.toArray())));
        }
        if (this.functionCall.canHaveEvent()) {
            @Nullable Pointer event = this.functionCall.getEvent();
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Event", event == null ? "None" : (String)NullUtils.neverNull((Object)event.toString())));
        }
        return information;
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
        return type == CommonStatistics.TIME_SPENT_BLOCKED && this.functionCall.isBlocking();
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
        if (type == CommonStatistics.TIME_SPENT_BLOCKED && this.functionCall.isBlocking()) {
            return new Statistic(type, TimestampUtils.microsecondsToSeconds(this.functionCall.getWaitTime()));
        }
        throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
    }
}

