/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.asset.objects.gen.AbstractClBufferMemoryAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClBufferMemoryAsset
extends AbstractClBufferMemoryAsset
implements IBufferItem {
    private static final long serialVersionUID = -6174210290448991469L;
    private final @NonNull String textLabel = "Buffer 0x" + Long.toHexString(this.getId());

    public ClBufferMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull ClContextAsset contextAsset, @NonNull Bitfield flags) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, contextAsset, flags);
    }

    @Override
    public @NonNull String getLabelText() {
        return this.textLabel;
    }

    private @NonNull String getDescriptiveTextBufferSize() {
        if (this.getSize() == null) {
            return "Unknown";
        }
        return String.valueOf((String)NullUtils.neverNull((Object)this.getSize().toString())) + " bytes";
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = super.getProperties();
        properties.put("Size", ValueAssetProperty.create(this.getDescriptiveTextBufferSize()));
        return properties;
    }

    @Override
    public int getSizeOfMemory() {
        Long size = this.getSize();
        return size == null ? 0 : size.intValue();
    }

    @Override
    public long getSizeOfBuffer() {
        return this.getSizeOfMemory();
    }

    @Override
    public @NonNull IBufferUsage getBufferUsage() {
        return new IBufferUsage(){

            @Override
            public String getLabelText() {
                return "CL_BUFFER";
            }
        };
    }

    @Override
    public byte @Nullable [] getDataForBuffer() {
        return this.getCurrentDataContents();
    }

    @Override
    public  @NonNull ClMemoryAsset.ClMemoryType getMemoryType() {
        return ClMemoryAsset.ClMemoryType.BUFFER;
    }
}

