/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.IMappableObject;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.jdt.annotation.NonNull;

public class AssetTable
implements Iterable<IAssetItem>,
Serializable,
IMappableObject<AssetTable> {
    private static final long serialVersionUID = 343326680315375201L;
    private final LinkedHashMap<@NonNull Long, IAssetItem> assetMap = new LinkedHashMap();
    private final @NonNull AssetTableSpec assetTableSpec;
    private Long maximumID = null;
    private final @NonNull ISnapshotAssetParent snapshotAssetParent;

    public AssetTable(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull AssetTableSpec assetTableSpec) {
        this.snapshotAssetParent = snapshotAssetParent;
        this.assetTableSpec = assetTableSpec;
    }

    public @NonNull AssetTableSpec getAssetTableSpec() {
        return this.assetTableSpec;
    }

    public @NonNull IAssetItem @NonNull [] toArray() {
        return this.assetMap.values().toArray(new IAssetItem[this.assetMap.size()]);
    }

    public void remove(Long id) {
        this.assetMap.remove(id);
        this.maximumID = this.maximumID != null && this.maximumID.equals(id) && this.assetMap.size() > 0 ? Collections.max(this.assetMap.keySet()) : null;
    }

    public IAssetItem get(Long id) {
        return this.assetMap.get(id);
    }

    @Deprecated
    public IAssetItem get(long id) {
        return this.get((Long)id);
    }

    @Deprecated
    public IAssetItem get(Pointer id) {
        return this.get((Long)id.address());
    }

    public boolean isEmpty() {
        return this.assetMap.isEmpty();
    }

    public int size() {
        return this.assetMap.size();
    }

    public void resetToDefault(@NonNull FunctionCall currentFunctionCall) {
        this.assetMap.clear();
        if (this.assetTableSpec == KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC) {
            this.addAsset(GlFramebufferAsset.createFramebufferZero(this.snapshotAssetParent, currentFunctionCall));
        }
        if (this.assetTableSpec == KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC) {
            this.addAsset(new GlVertexArrayObjectAsset(this.snapshotAssetParent, currentFunctionCall, 0L));
        }
        if (this.assetTableSpec == KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC) {
            this.addAsset(new GlTextureAsset(this.snapshotAssetParent, currentFunctionCall, 0L));
        }
        if (this.assetTableSpec == KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC) {
            this.addAsset(new GlTextureUnitAsset(this.snapshotAssetParent, currentFunctionCall, GlTextureUnitAsset.convertTextureUnitEnumToTextureUnitId(KapiSpec.GLES.constants.GL_TEXTURE0)));
        }
        if (this.assetTableSpec == KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS.SPEC) {
            this.addAsset(new GlTransformFeedbackAsset(this.snapshotAssetParent, currentFunctionCall, 0L));
        }
    }

    @Override
    public Iterator<@NonNull IAssetItem> iterator() {
        Iterator<@NonNull IAssetItem> iterator = this.assetMap.values().iterator();
        return iterator;
    }

    public IAssetItem addAsset(@NonNull IAssetItem ai) {
        if (this.maximumID == null || this.maximumID < ai.getId()) {
            this.maximumID = ai.getId();
        }
        return this.assetMap.put(ai.getId(), ai);
    }

    public Long getMaximumID() {
        return this.maximumID;
    }

    public @NonNull Collection<@NonNull IAssetItem> asCollection() {
        return NullUtils.unmodifiableCollection((Collection)NullUtils.neverNullCollection(this.assetMap.values()));
    }

    @Override
    public AssetTable mapObject(TraceStateSnapshot snapshot) {
        return snapshot.getAssetTableBySpec(this.assetTableSpec);
    }
}

