/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.BlitFramebufferCallData;
import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClEnqueueCallData;
import com.arm.mgd.core.asset.ClKernelAsset;
import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.DrawArraysCallData;
import com.arm.mgd.core.asset.DrawElementsCallData;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexAttributeHelper;
import com.arm.mgd.core.asset.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.InterestingCallData;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.programvariable.ShaderAttribute;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.asset.texture.CompressedTextureValidator;
import com.arm.mgd.core.asset.texture.IGlTextureLayerData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.texture.TextureOverride;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.ClEnqueueCall;
import com.arm.mgd.core.target.data.ClKernelAttachment;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.ProgramGeometryShaderProperties;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.FunctionCallProcessor;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.TextureAssetUtils;
import com.arm.mgd.core.util.TimestampUtils;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetProcessor
extends FunctionCallProcessor {
    public static final AssetProcessor INSTANCE = new AssetProcessor();

    @Override
    public Method getMethodForFunctionCall(String functionName) throws SecurityException, NoSuchMethodException {
        try {
            return AssetProcessor.class.getMethod(functionName, TraceStateSnapshot.class, FunctionCall.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return AssetProcessor.class.getMethod(functionName, TraceStateSnapshot.class, InterestingFunctionCall.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return AssetProcessor.class.getMethod(functionName, TraceStateSnapshot.class, DrawFunctionCall.class);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    return AssetProcessor.class.getMethod(functionName, TraceStateSnapshot.class, ClEnqueueCall.class);
                }
            }
        }
    }

    public static void glDrawBuffers(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        ArrayList<AbstractConstantOrAliasSpecExtended> drawBuffers = new ArrayList<AbstractConstantOrAliasSpecExtended>();
        LongsArgAttachment bufferValues = GLES.GlDrawBuffersDecorator.getArgumentBufs(functionCall);
        int drawBuffersIndex = 0;
        while (drawBuffersIndex < 15) {
            if (drawBuffersIndex < bufferValues.size()) {
                drawBuffers.add(KapiSpec.GLES.getConstantSpecByValue(bufferValues.get(drawBuffersIndex)));
            } else {
                drawBuffers.add(KapiSpec.GLES.constants.GL_NONE);
            }
            ++drawBuffersIndex;
        }
        StateItem stateItem = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING);
        Long framebufferId = stateItem.getValue()[0].getValueAsLong();
        IAssetItem assetItem = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC).get(framebufferId);
        if (assetItem instanceof GlFramebufferAsset) {
            GlFramebufferAsset framebuffer = (GlFramebufferAsset)assetItem;
            framebuffer.setDrawBuffers(drawBuffers);
        }
    }

    public static void glShaderSource(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long shaderId = GLES.GlShaderSourceDecorator.getArgumentShader(functionCall);
        StringsArgAttachment sourceProvider = GLES.GlShaderSourceDecorator.getArgumentString(functionCall);
        GlShaderAsset si = (GlShaderAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).get(shaderId);
        if (si != null) {
            si.setSource(functionCall, sourceProvider);
        } else {
            TraceAnalysisLogger.error(currentState, functionCall, "Failed to set shader source; the shader id doesn't represent a shader object.");
        }
    }

    public static void glShaderBinary(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        LongsArgAttachment shaderIds = GLES.GlShaderBinaryDecorator.getArgumentShaders(functionCall);
        for (Long shaderId : shaderIds) {
            GlShaderAsset shaderAsset = (GlShaderAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).get(shaderId);
            if (shaderAsset == null) {
                TraceAnalysisLogger.error(currentState, functionCall, "The target for glShaderBinary upload is invalid.");
                return;
            }
            shaderAsset.setBinary(functionCall, GLES.GlShaderBinaryDecorator.getArgumentBinaryformat(functionCall), GLES.GlShaderBinaryDecorator.getArgumentBinary(functionCall));
        }
    }

    public static void glVertexAttrib1f(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib1fDecorator.getArgumentIndex(functionCall);
        Float v0 = GLES.GlVertexAttrib1fDecorator.getArgumentX(functionCall);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, v0);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib1fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib1fvDecorator.getArgumentIndex(functionCall);
        FloatsArgAttachment value = GLES.GlVertexAttrib1fvDecorator.getArgumentV(functionCall);
        assert (value.size() == 1);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, value.get(0));
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib2f(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib2fDecorator.getArgumentIndex(functionCall);
        Float v0 = GLES.GlVertexAttrib2fDecorator.getArgumentX(functionCall);
        Float v1 = GLES.GlVertexAttrib2fDecorator.getArgumentY(functionCall);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, v0, v1);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib2fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib2fvDecorator.getArgumentIndex(functionCall);
        FloatsArgAttachment value = GLES.GlVertexAttrib2fvDecorator.getArgumentV(functionCall);
        assert (value.size() == 2);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, value.get(0), value.get(1));
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib3f(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib3fDecorator.getArgumentIndex(functionCall);
        Float v0 = GLES.GlVertexAttrib3fDecorator.getArgumentX(functionCall);
        Float v1 = GLES.GlVertexAttrib3fDecorator.getArgumentY(functionCall);
        Float v2 = GLES.GlVertexAttrib3fDecorator.getArgumentZ(functionCall);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, v0, v1, v2);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib3fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib3fvDecorator.getArgumentIndex(functionCall);
        FloatsArgAttachment value = GLES.GlVertexAttrib3fvDecorator.getArgumentV(functionCall);
        assert (value.size() == 3);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, value.get(0), value.get(1), value.get(2));
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib4f(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib4fDecorator.getArgumentIndex(functionCall);
        Float v0 = GLES.GlVertexAttrib4fDecorator.getArgumentX(functionCall);
        Float v1 = GLES.GlVertexAttrib4fDecorator.getArgumentY(functionCall);
        Float v2 = GLES.GlVertexAttrib4fDecorator.getArgumentZ(functionCall);
        Float v3 = GLES.GlVertexAttrib4fDecorator.getArgumentW(functionCall);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, v0, v1, v2, v3);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glVertexAttrib4fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttrib4fvDecorator.getArgumentIndex(functionCall);
        FloatsArgAttachment value = GLES.GlVertexAttrib4fvDecorator.getArgumentV(functionCall);
        assert (value.size() == 4);
        AssetProcessor.setVertexAttribf(currentState, functionCall, index, value.get(0), value.get(1), value.get(2), value.get(3));
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    private static void setVertexAttribf(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Long index, Float ... v) {
        assert (v.length <= 4);
        if (!AssetProcessor.isVertexAttribIdInRange(currentState, index)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Vertex attribute ID >= GL_MAX_VERTEX_ATTRIBS.");
            return;
        }
        Number[] value = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
        int i = 0;
        while (i < Math.min(v.length, value.length)) {
            value[i] = v[i];
            ++i;
        }
        GlVertexAttributeAsset attrib = GlVertexAttributeAsset.getVertexAttributeAssetById(currentState, functionCall, index);
        attrib.getNonArrayDataSource().setValue(value, functionCall);
    }

    public static void glBindVertexArray(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        assert (functionCall != null);
        GlVertexArrayObjectAsset vao = GlVertexArrayObjectAsset.getOrCreateVertexArrayObjectAt(currentState, functionCall, GLES.GlBindVertexArrayDecorator.getArgumentArray(functionCall));
        vao.replaceElementArrayBufferBinding(currentState);
    }

    public static void glVertexAttribPointer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttribPointerDecorator.getArgumentIndex(functionCall);
        int size = GLES.GlVertexAttribPointerDecorator.getArgumentSize(functionCall);
        AbstractConstantOrAliasSpecExtended type = GLES.GlVertexAttribPointerDecorator.getArgumentType(functionCall);
        AbstractConstantOrAliasSpecExtended normalized = GLES.GlVertexAttribPointerDecorator.getArgumentNormalized(functionCall);
        int stride = GLES.GlVertexAttribPointerDecorator.getArgumentStride(functionCall);
        Pointer ptr = GLES.GlVertexAttribPointerDecorator.getArgumentPointer(functionCall);
        AssetProcessor.sharedGlVertexAttribXPointer(currentState, functionCall, index, size, type, normalized, stride, ptr, false);
    }

    public static void glVertexAttribIPointer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlVertexAttribIPointerDecorator.getArgumentIndex(functionCall);
        int size = GLES.GlVertexAttribIPointerDecorator.getArgumentSize(functionCall);
        AbstractConstantOrAliasSpecExtended type = GLES.GlVertexAttribIPointerDecorator.getArgumentType(functionCall);
        AbstractConstantOrAliasSpecExtended normalized = KapiSpec.GLES.constants.GL_FALSE;
        int stride = GLES.GlVertexAttribIPointerDecorator.getArgumentStride(functionCall);
        Pointer ptr = GLES.GlVertexAttribIPointerDecorator.getArgumentPointer(functionCall);
        AssetProcessor.sharedGlVertexAttribXPointer(currentState, functionCall, index, size, type, normalized, stride, ptr, true);
    }

    private static void sharedGlVertexAttribXPointer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull Long index, int size, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull AbstractConstantOrAliasSpecExtended normalized, int stride, @NonNull Pointer ptr, boolean integer) {
        if (!AssetProcessor.isVertexAttribIdInRange(currentState, index)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Vertex attribute 'index' out of range.");
            return;
        }
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
        GlVertexAttributeAsset attrib = GlVertexAttributeAsset.getVertexAttributeAssetById(currentState, functionCall, index);
        attrib.setPreviousModificationFunction(functionCall);
        boolean validInput = true;
        try {
            if (size < 1 || size > 4) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Vertex attribute 'size' out of range 1..4.");
                validInput = false;
            }
            if (!KapiSpec.GLES.constantGroups.VERTEXATTRIBPOINTERTYPE.contains(type)) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Vertex attribute 'type' unrecognised.");
                validInput = false;
            }
            if ((KapiSpec.GLES.constants.GL_UNSIGNED_INT_2_10_10_10_REV.equals(type) || KapiSpec.GLES.constants.GL_INT_2_10_10_10_REV.equals(type)) && size != 4) {
                TraceAnalysisLogger.warning(currentState, functionCall, "GL_UNSIGNED_INT_2_10_10_10_REV or GL_INT_2_10_10_10_REV specified as type, but size is not 4.");
                validInput = false;
            }
            if (!KapiSpec.GLES.constants.GL_TRUE.equals(normalized) && !KapiSpec.GLES.constants.GL_FALSE.equals(normalized)) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Vertex attribute 'normalized' unrecognised.");
                validInput = false;
            }
            if (stride < 0) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Vertex attribute 'stride' less than zero.");
                validInput = false;
            }
            GlBufferAsset serverBufferAsset = null;
            if (validInput) {
                attrib.setArraySize(size);
                attrib.setArrayType(type);
                attrib.setArrayNormalized(KapiSpec.GLES.constants.GL_TRUE.equals(normalized));
                attrib.setArrayInteger(integer);
                attrib.setVboRelativeOffset(0L);
                serverBufferAsset = (GlBufferAsset)currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_ARRAY_BUFFER_BINDING).getValueAsAsset();
            }
            GlVertexBufferBindingAsset newbinding = attrib.getParentAsset().getOrCreateNewGlVertexBufferBindingAsset(index);
            attrib.setVboBinding(newbinding);
            attrib.setArrayStride(stride);
            attrib.setArrayPointer(ptr);
            long offset = serverBufferAsset == null ? 0L : ptr.address();
            long effectiveStride = GlVertexAttributeHelper.getEffectiveStride(stride, size, type);
            GlVertexBufferBindingAsset vboBinding = attrib.getVboBinding();
            vboBinding.setBuffer(serverBufferAsset);
            vboBinding.setOffset(offset);
            vboBinding.setStride(effectiveStride);
        }
        catch (NumberFormatException nfx) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Argument value unrecognised: " + nfx.getMessage());
        }
        catch (UnsupportedTypeException e) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Unsupported type: " + e.getMessage());
        }
    }

    private static boolean isVertexAttribIdInRange(@NonNull TraceStateSnapshot currentState, Long index) {
        if (index < 0L) {
            return false;
        }
        StateValue maxVertAttribs = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_MAX_VERTEX_ATTRIBS).getValue()[0];
        if (maxVertAttribs == StateValue.UNKNOWN) {
            return true;
        }
        return index < maxVertAttribs.getValueAsLong();
    }

    public static void glEnableVertexAttribArray(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlEnableVertexAttribArrayDecorator.getArgumentIndex(functionCall);
        AssetProcessor.setEnableStateOfVertexAttribArray(currentState, functionCall, index, true);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    public static void glDisableVertexAttribArray(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long index = GLES.GlDisableVertexAttribArrayDecorator.getArgumentIndex(functionCall);
        AssetProcessor.setEnableStateOfVertexAttribArray(currentState, functionCall, index, false);
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, index);
    }

    private static void setEnableStateOfVertexAttribArray(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Long index, boolean enabled) {
        if (!AssetProcessor.isVertexAttribIdInRange(currentState, index)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Vertex attribute ID >= GL_MAX_VERTEX_ATTRIBS.");
            return;
        }
        GlVertexAttributeAsset attrib = GlVertexAttributeAsset.getVertexAttributeAssetById(currentState, functionCall, index);
        attrib.setArrayEnabled(enabled);
        attrib.setPreviousModificationFunction(functionCall);
    }

    public static void glClear(@NonNull TraceStateSnapshot currentState, final @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -4844647291011479460L;

                @Override
                public @NonNull String getDescriptiveText() {
                    return (String)NullUtils.neverNull((Object)GLES.GlClearDecorator.getArgumentMask(functionCall).toString());
                }
            });
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glClearBufferfi(@NonNull TraceStateSnapshot currentState, final @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 5004541967924256810L;

                @Override
                public @NonNull String getDescriptiveText() {
                    String flagString = GLES.GlClearBufferfiDecorator.getArgumentBuffer(functionCall).toString();
                    if (GLES.GlClearBufferfiDecorator.getArgumentBuffer(functionCall).equals(KapiSpec.GLES.constants.GL_COLOR)) {
                        flagString = String.valueOf(flagString) + ", DRAWBUFFER " + GLES.GlClearBufferfiDecorator.getArgumentDrawbuffer(functionCall);
                    }
                    return (String)NullUtils.neverNull((Object)flagString);
                }
            });
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glClearBufferfv(@NonNull TraceStateSnapshot currentState, final @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 8289159053670793946L;

                @Override
                public @NonNull String getDescriptiveText() {
                    String flagString = GLES.GlClearBufferfvDecorator.getArgumentBuffer(functionCall).toString();
                    if (GLES.GlClearBufferfvDecorator.getArgumentBuffer(functionCall).equals(KapiSpec.GLES.constants.GL_COLOR)) {
                        flagString = String.valueOf(flagString) + ", DRAWBUFFER " + GLES.GlClearBufferfvDecorator.getArgumentDrawbuffer(functionCall);
                    }
                    return (String)NullUtils.neverNull((Object)flagString);
                }
            });
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glClearBufferiv(@NonNull TraceStateSnapshot currentState, final @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 3225665399429336690L;

                @Override
                public @NonNull String getDescriptiveText() {
                    String flagString = GLES.GlClearBufferivDecorator.getArgumentBuffer(functionCall).toString();
                    if (GLES.GlClearBufferivDecorator.getArgumentBuffer(functionCall).equals(KapiSpec.GLES.constants.GL_COLOR)) {
                        flagString = String.valueOf(flagString) + ", DRAWBUFFER " + GLES.GlClearBufferivDecorator.getArgumentDrawbuffer(functionCall);
                    }
                    return (String)NullUtils.neverNull((Object)flagString);
                }
            });
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glClearBufferuiv(@NonNull TraceStateSnapshot currentState, final @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 873782625906379399L;

                @Override
                public @NonNull String getDescriptiveText() {
                    String flagString = GLES.GlClearBufferuivDecorator.getArgumentBuffer(functionCall).toString();
                    if (GLES.GlClearBufferuivDecorator.getArgumentBuffer(functionCall).equals(KapiSpec.GLES.constants.GL_COLOR)) {
                        flagString = String.valueOf(flagString) + ", DRAWBUFFER " + GLES.GlClearBufferuivDecorator.getArgumentDrawbuffer(functionCall);
                    }
                    return (String)NullUtils.neverNull((Object)flagString);
                }
            });
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glDrawArrays(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawArraysCallProcessor(currentState, functionCall);
    }

    public static void glDrawArraysInstanced(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawArraysCallProcessor(currentState, functionCall);
    }

    public static void glDrawArraysIndirect(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawArraysCallProcessor(currentState, functionCall);
    }

    public static void glDrawElements(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawElementsIndirect(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawElementsInstanced(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawElementsInstancedBaseVertex(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawRangeElementsBaseVertex(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawElementsBaseVertex(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    public static void glDrawRangeElements(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        AssetProcessor.drawElementsCallProcessor(currentState, functionCall);
    }

    private static void drawElementsCallProcessor(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new DrawElementsCallData(functionCall, currentState));
        }
        AssetProcessor.drawCallProcessor(currentState, functionCall);
    }

    private static void drawArraysCallProcessor(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new DrawArraysCallData(functionCall, currentState));
        }
        AssetProcessor.drawCallProcessor(currentState, functionCall);
    }

    private static void drawCallProcessor(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        GlProgramAsset program = GlProgramHelper.getCurrentProgramAsset(currentState, KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        if (program == null) {
            if (!currentState.getCurrentContext().getApiVersion().equals(GLESApiVersion.GLES1x)) {
                TraceAnalysisLogger.error(currentState, functionCall, "Current program is not set.");
            }
            return;
        }
        for (ShaderAttribute shaderAttribute : program.getAttributes()) {
            GlVertexAttributeAsset vertexAttribAsset = shaderAttribute.getVertexAttributeAsset(currentState);
            try {
                if (!vertexAttribAsset.isArrayEnabled()) continue;
                vertexAttribAsset.checkBounds();
            }
            catch (ApiUsageException e) {
                TraceAnalysisLogger.warning(currentState, (FunctionCall)functionCall, e, null);
            }
        }
        GlShaderAsset vertexShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        if (vertexShader == null) {
            TraceAnalysisLogger.error(currentState, functionCall, "No vertex shader present.");
            return;
        }
        InterestingCallData data = functionCall.getInterestingCallData();
        assert (data.hasDataForStatisticType(CommonStatistics.NUMBER_OF_INDICES));
        assert (data.hasDataForStatisticType(CommonStatistics.NUMBER_OF_VERTICES));
        long vertexCount = data.getStatistic(CommonStatistics.NUMBER_OF_VERTICES).getValue().longValue();
        if (vertexCount < 0L) {
            TraceAnalysisLogger.error(currentState, functionCall, "Number of vertices is negative.");
            return;
        }
        vertexShader.incrementCurrentFrameShaderInvocations(vertexCount);
        ProgramGeometryShaderProperties gsp = program.getGeometryShaderProperties();
        GlShaderAsset geometryShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_GEOMETRY_SHADER);
        long indexCount = data.getStatistic(CommonStatistics.NUMBER_OF_INDICES).getValue().longValue();
        if (gsp != null && geometryShader != null) {
            geometryShader.incrementCurrentFrameShaderInvocations(gsp.calculateNumberOfOutputPrimitives(indexCount));
        }
        GlShaderAsset tessControlShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER);
        GlShaderAsset tessEvalShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER);
        Long patchSize = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PATCH_VERTICES).getValue()[0].getValueAsLong();
        if (tessControlShader != null) {
            tessControlShader.incrementCurrentFrameShaderInvocations(indexCount / patchSize);
        }
        if (tessEvalShader != null) {
            tessEvalShader.incrementCurrentFrameShaderInvocations(indexCount / patchSize);
        }
        if (currentState.getStateItemBySpec((StateSpec)KapiSpec.GLES.states.GL_DEPTH_TEST).getValue()[0].value.equals(KapiSpec.GLES.constants.GL_TRUE)) {
            functionCall.setDepthTestEnabled(true);
        } else {
            functionCall.setDepthTestEnabled(false);
        }
        if (currentState.getStateItemBySpec((StateSpec)KapiSpec.GLES.states.GL_STENCIL_TEST).getValue()[0].value.equals(KapiSpec.GLES.constants.GL_TRUE)) {
            functionCall.setStencilTestEnabled(true);
        } else {
            functionCall.setStencilTestEnabled(false);
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
        GlVertexArrayObjectAsset vaoAsset = GlVertexArrayObjectAsset.getCurrentVertexArrayObject(currentState);
        Map<Long, GlVertexAttributeAsset> attributes = vaoAsset.getVertexAttributesCollection();
        for (GlVertexAttributeAsset attribute : attributes.values()) {
            if (!attribute.isArrayEnabled()) continue;
            attribute.getNonArrayDataSource().setValue(GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX, functionCall);
        }
    }

    private static void removeFramebufferIfNoAttachments(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        if (GlFramebufferAsset.isCaptureAffectedByFunction(functionCall)) {
            StateSpec mappedTargetStateSpec = GlFramebufferAsset.mapTargetToStateSpec(KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER);
            GlFramebufferAsset framebufferAsset = GlFramebufferAsset.getBoundFramebufferAsset(currentState, (StateSpec)NullUtils.neverNull((Object)mappedTargetStateSpec));
            if (framebufferAsset == null) {
                TraceAnalysisLogger.error(currentState, functionCall, "Missing framebuffer asset for target" + KapiSpec.GLES.constants.GL_FRAMEBUFFER);
                return;
            }
            framebufferAsset.removeFramebuffer(functionCall);
        }
    }

    public static void clCreateKernel(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        ClProgramAsset clProgram;
        Pointer programId = CL.ClCreateKernelDecorator.getArgumentProgram(functionCall);
        Pointer kernelId = CL.ClCreateKernelDecorator.getReturnValue(functionCall);
        StringsArgAttachment kernelName = CL.ClCreateKernelDecorator.getArgumentKernel_name(functionCall);
        if (kernelId != null && (clProgram = (ClProgramAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC).get(programId)) != null) {
            String name = kernelName.getConcatenatedString();
            ClKernelAsset item = new ClKernelAsset(currentState.asSnapshotAssetParent(), functionCall, kernelId.address(), name, clProgram);
            currentState.addAsset(item);
        }
    }

    public static void clCreateKernelsInProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Pointer programId = CL.ClCreateKernelsInProgramDecorator.getArgumentProgram(functionCall);
        LongsArgAttachment kernels = CL.ClCreateKernelsInProgramDecorator.getArgumentKernels(functionCall);
        @NonNull HashMap<K, V> kernelAttachments = new HashMap();
        functionCall.findFreeAttachments(ClKernelAttachment.class).forEach(attachment -> kernelAttachments.put(attachment.getKernelId(), attachment));
        ClProgramAsset clProgram = (ClProgramAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC).get(programId);
        if (clProgram != null) {
            for (Long kernel : kernels) {
                @Nullable ClKernelAttachment attachment2 = (ClKernelAttachment)kernelAttachments.get(kernel);
                String kernelName = attachment2 == null ? "Unknown" : attachment2.getKernelName();
                ClKernelAsset item = new ClKernelAsset(currentState.asSnapshotAssetParent(), functionCall, kernel, kernelName, clProgram);
                currentState.addAsset(item);
            }
        }
    }

    public static void clCreateProgramWithBuiltInKernels(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Pointer context_id = CL.ClCreateProgramWithBuiltInKernelsDecorator.getArgumentContext(functionCall);
        ClContextAsset clContext = (ClContextAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.CONTEXT_TRAITS.SPEC).get((Long)context_id.address());
        assert (clContext != null);
        Pointer programId = CL.ClCreateProgramWithBuiltInKernelsDecorator.getReturnValue(functionCall);
        ClProgramAsset item = new ClProgramAsset(currentState.asSnapshotAssetParent(), functionCall, programId.address(), clContext);
        currentState.addAsset(item);
    }

    public static void clLinkProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Pointer context_id = CL.ClLinkProgramDecorator.getArgumentContext(functionCall);
        ClContextAsset clContext = (ClContextAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.CONTEXT_TRAITS.SPEC).get((Long)context_id.address());
        assert (clContext != null);
        Pointer programId = CL.ClLinkProgramDecorator.getReturnValue(functionCall);
        ClProgramAsset item = new ClProgramAsset(currentState.asSnapshotAssetParent(), functionCall, programId.address(), clContext);
        currentState.addAsset(item);
    }

    public static void clBuildProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Pointer programId = CL.ClBuildProgramDecorator.getArgumentProgram(functionCall);
        ClProgramAsset clProgram = (ClProgramAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC).get(programId);
        StringsArgAttachment options = CL.ClBuildProgramDecorator.getArgumentOptions(functionCall);
        clProgram.setBuildOptions(options.getConcatenatedString());
    }

    public static void clEnqueueNDRangeKernel(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        LongsArgAttachment globalWorkSizes = CL.ClEnqueueNDRangeKernelDecorator.getArgumentGlobal_work_size(functionCall);
        LongsArgAttachment localWorkSizes = CL.ClEnqueueNDRangeKernelDecorator.getArgumentLocal_work_size(functionCall);
        Pointer kernelId = CL.ClEnqueueNDRangeKernelDecorator.getArgumentKernel(functionCall);
        ComputeWorkgroupSize globalWorkSize = null;
        ComputeWorkgroupSize localWorkSize = null;
        final ClKernelAsset clKernel = (ClKernelAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC).get(kernelId);
        if (clKernel != null) {
            long minValue = Long.MAX_VALUE;
            for (Long element : globalWorkSizes) {
                minValue = Math.min(minValue, element);
            }
            if (!globalWorkSizes.isEmpty() && globalWorkSizes.size() <= 3 && minValue > 0L) {
                globalWorkSize = ComputeWorkgroupSize.createFromLongList(globalWorkSizes.asList());
            }
            minValue = Long.MAX_VALUE;
            for (Long element : localWorkSizes) {
                minValue = Math.min(minValue, element);
            }
            if (!localWorkSizes.isEmpty() && localWorkSizes.size() <= 3 && minValue > 0L) {
                localWorkSize = ComputeWorkgroupSize.createFromLongList(localWorkSizes.asList());
            }
            if (globalWorkSize != null) {
                clKernel.addInvocation(localWorkSize, globalWorkSize);
            }
        }
        if (!functionCall.hasInterestingCallData()) {
            final ComputeWorkgroupSize finalGlobalWork = globalWorkSize;
            final ComputeWorkgroupSize finalLocalWork = localWorkSize;
            functionCall.setInterestingCallData(new ClEnqueueCallData(functionCall){
                private static final long serialVersionUID = -3569714941308994399L;

                @Override
                public @NonNull String getDescriptiveText() {
                    ArrayList<@NonNull String> items = new ArrayList<String>();
                    if (clKernel != null) {
                        items.add(clKernel.getKernelName());
                    }
                    if (finalGlobalWork != null) {
                        items.add("Global: " + finalGlobalWork.toString());
                    }
                    items.add("Local: " + (finalLocalWork == null ? "NULL" : finalLocalWork.toString()));
                    items.add(super.getDescriptiveText());
                    return StringUtils.arrayToString(items.toArray());
                }

                @Override
                public @NonNull List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> getInformation() {
                    List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> information = super.getInformation();
                    information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Kernel", clKernel == null ? "NULL" : clKernel.getKernelName()));
                    information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Global work size", finalGlobalWork == null ? "NULL" : finalGlobalWork.toString()));
                    information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Local work size", finalLocalWork == null ? "NULL" : finalLocalWork.toString()));
                    return information;
                }
            });
        }
    }

    public static void clEnqueueTask(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        Pointer kernelId = CL.ClEnqueueTaskDecorator.getArgumentKernel(functionCall);
        ClKernelAsset clKernel = (ClKernelAsset)currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC).get(kernelId);
        if (clKernel != null) {
            clKernel.addInvocation(new ComputeWorkgroupSize(1L), new ComputeWorkgroupSize(1L));
        }
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void glCompressedTexImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlCompressedTexImage2DDecorator.getArgumentTarget(functionCall);
        Integer level = GLES.GlCompressedTexImage2DDecorator.getArgumentLevel(functionCall);
        AbstractConstantOrAliasSpecExtended internalFormat = GLES.GlCompressedTexImage2DDecorator.getArgumentInternalformat(functionCall);
        AssetProcessor.checkInternalFormat(currentState, functionCall, internalFormat);
        int width = GLES.GlCompressedTexImage2DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlCompressedTexImage2DDecorator.getArgumentHeight(functionCall);
        Dimension size = new Dimension(width, height);
        TextureArgAttachment attachment = GLES.GlCompressedTexImage2DDecorator.getArgumentData(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset != null) {
            boolean validData = CompressedTextureValidator.validateCompressedTextureData(currentState, functionCall, width, height, 1, internalFormat, attachment);
            IGlTextureLayerData textureData = validData ? IGlTextureLayerData.create(attachment) : null;
            textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(0, 0, target, width, height), size, internalFormat, null, textureData, true);
            StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
            if (!Long.valueOf(0L).equals(usingPBO.value)) {
                textureAsset.setNote(functionCall, "Using GL_PIXEL_UNPACK_BUFFER_BINDING");
            }
        }
    }

    public static void checkInternalFormat(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, AbstractConstantOrAliasSpecExtended internalFormat) {
        if (!(KapiSpec.GLES.constantGroups.TEXTUREINTERNALFORMAT.contains(internalFormat) || KapiSpec.GLES.constantGroups.COMPRESSEDTEXTUREINTERNALFORMAT.contains(internalFormat) || KapiSpec.GLES.constantGroups.ASTCFORMATS.contains(internalFormat))) {
            TraceAnalysisLogger.error(currentState, functionCall, "Format " + internalFormat + " is not a recognized internal format for textures.");
        }
    }

    public static void glTexImage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlTexImage3DDecorator.getArgumentTarget(functionCall);
        Integer level = GLES.GlTexImage3DDecorator.getArgumentLevel(functionCall);
        AbstractConstantOrAliasSpecExtended internalFormat = GLES.GlTexImage3DDecorator.getArgumentInternalformat(functionCall);
        AssetProcessor.checkInternalFormat(currentState, functionCall, internalFormat);
        AbstractConstantOrAliasSpecExtended type = GLES.GlTexImage3DDecorator.getArgumentType(functionCall);
        int width = GLES.GlTexImage3DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlTexImage3DDecorator.getArgumentHeight(functionCall);
        Integer depthOrNumberOfArrayElements = GLES.GlTexImage3DDecorator.getArgumentDepth(functionCall);
        TextureArgAttachment attachment = GLES.GlTexImage3DDecorator.getArgumentPixels(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset == null) {
            return;
        }
        if (TextureAssetUtils.isTargetUsingDepthAsArrayIndex(target)) {
            int numberOfArrayElements = depthOrNumberOfArrayElements;
            Dimension size = new Dimension(width, height);
            int arrayIndex = 0;
            while (arrayIndex < numberOfArrayElements) {
                IByteDataProvider data = attachment.getData();
                IGlTextureLayerData arrayData = null;
                if (data != null) {
                    int bytesPerPixel = data.getLength() / (width * height * numberOfArrayElements);
                    int from = arrayIndex * width * height * bytesPerPixel;
                    int to = (arrayIndex + 1) * width * height * bytesPerPixel;
                    arrayData = IGlTextureLayerData.create(attachment, from, to);
                }
                textureAsset.addTextureLayerToLevel(functionCall, target, arrayIndex, level, new GlImageOffset(0, 0, target, width, height), size, internalFormat, type, arrayData, true);
                ++arrayIndex;
            }
        } else {
            int depth = depthOrNumberOfArrayElements;
            Dimension size = new Dimension(width, height, depth);
            textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(0, 0, 0, target, width, height, depth), size, internalFormat, type, IGlTextureLayerData.create(attachment), true);
        }
        StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
        if (!Long.valueOf(0L).equals(usingPBO.value)) {
            textureAsset.setNote(functionCall, "Using GL_PIXEL_UNPACK_BUFFER_BINDING");
        }
    }

    public static void glTexSubImage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlTexSubImage3DDecorator.getArgumentTarget(functionCall);
        int level = GLES.GlTexSubImage3DDecorator.getArgumentLevel(functionCall);
        int xOffset = GLES.GlTexSubImage3DDecorator.getArgumentXoffset(functionCall);
        int yOffset = GLES.GlTexSubImage3DDecorator.getArgumentYoffset(functionCall);
        int zOffset = GLES.GlTexSubImage3DDecorator.getArgumentZoffset(functionCall);
        int width = GLES.GlTexSubImage3DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlTexSubImage3DDecorator.getArgumentHeight(functionCall);
        Integer depthOrNumberOfArrayElements = GLES.GlTexSubImage3DDecorator.getArgumentDepth(functionCall);
        AbstractConstantOrAliasSpecExtended format = GLES.GlTexSubImage3DDecorator.getArgumentFormat(functionCall);
        AbstractConstantOrAliasSpecExtended type = GLES.GlTexSubImage3DDecorator.getArgumentType(functionCall);
        TextureArgAttachment attachment = GLES.GlTexSubImage3DDecorator.getArgumentPixels(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset == null) {
            return;
        }
        if (!TextureAssetUtils.isTargetUsingDepthAsArrayIndex(target)) {
            if (!textureAsset.hasMipmapLevel(target, null, level)) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Texture level not previously defined.");
            }
            int depth = depthOrNumberOfArrayElements;
            Dimension size = new Dimension(width, height, depth);
            textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(xOffset, yOffset, zOffset, target, width, height, depth), size, format, type, IGlTextureLayerData.create(attachment), false);
        } else {
            int numberOfArrayElements = depthOrNumberOfArrayElements;
            Dimension size = new Dimension(width, height);
            int arrayIndex = zOffset;
            while (arrayIndex < numberOfArrayElements) {
                if (!textureAsset.hasMipmapLevel(target, arrayIndex, level)) {
                    TraceAnalysisLogger.warning(currentState, functionCall, "Texture level not previously defined.");
                }
                IByteDataProvider data = attachment.getData();
                IGlTextureLayerData arrayData = null;
                if (data != null) {
                    int bytesPerPixel = data.getLength() / (width * height * numberOfArrayElements);
                    int from = arrayIndex * width * height * bytesPerPixel;
                    int to = (arrayIndex + 1) * width * height * bytesPerPixel;
                    arrayData = IGlTextureLayerData.create(attachment, from, to);
                }
                textureAsset.addTextureLayerToLevel(functionCall, target, arrayIndex, level, new GlImageOffset(xOffset, yOffset, target, width, height), size, format, type, arrayData, false);
                ++arrayIndex;
            }
        }
        StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
        if (!Long.valueOf(0L).equals(usingPBO.value)) {
            textureAsset.setNote(functionCall, "Using GL_PIXEL_UNPACK_BUFFER_BINDING");
        }
    }

    public static void glTexImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Frame parentFrame;
        AbstractConstantOrAliasSpecExtended target = GLES.GlTexImage2DDecorator.getArgumentTarget(functionCall);
        Integer level = GLES.GlTexImage2DDecorator.getArgumentLevel(functionCall);
        AbstractConstantOrAliasSpecExtended internalFormat = GLES.GlTexImage2DDecorator.getArgumentInternalformat(functionCall);
        AssetProcessor.checkInternalFormat(currentState, functionCall, internalFormat);
        AbstractConstantOrAliasSpecExtended type = GLES.GlTexImage2DDecorator.getArgumentType(functionCall);
        int width = GLES.GlTexImage2DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlTexImage2DDecorator.getArgumentHeight(functionCall);
        Dimension size = new Dimension(width, height);
        TextureArgAttachment attachment = GLES.GlTexImage2DDecorator.getArgumentPixels(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset == null) {
            return;
        }
        textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(0, 0, target, width, height), size, internalFormat, type, IGlTextureLayerData.create(attachment), true);
        StringJoiner stringJoiner = new StringJoiner("\n");
        StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
        if (!Long.valueOf(0L).equals(usingPBO.value)) {
            stringJoiner.add("Using GL_PIXEL_UNPACK_BUFFER_BINDING");
        }
        if ((parentFrame = (Frame)NullUtils.neverNull((Object)functionCall.getParentFrame())).isReplayed()) {
            IByteDataProvider data;
            FrameOverrides fo = parentFrame.getFrameOverrides();
            TextureOverride to = (TextureOverride)fo.get(FrameOverrides.OverrideType.TEXTURE_OVERRIDE, textureAsset);
            IByteDataProvider iByteDataProvider = data = to != null ? to.getTextureData() : null;
            if (data != null && data.equals(attachment.getData())) {
                stringJoiner.add("This texture was created from a Texture Override");
            }
        }
        textureAsset.setNote(functionCall, stringJoiner.toString());
    }

    public static void glTexSubImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlTexSubImage2DDecorator.getArgumentTarget(functionCall);
        int level = GLES.GlTexSubImage2DDecorator.getArgumentLevel(functionCall);
        int xOffset = GLES.GlTexSubImage2DDecorator.getArgumentXoffset(functionCall);
        int yOffset = GLES.GlTexSubImage2DDecorator.getArgumentYoffset(functionCall);
        int width = GLES.GlTexSubImage2DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlTexSubImage2DDecorator.getArgumentHeight(functionCall);
        Dimension size = new Dimension(width, height);
        AbstractConstantOrAliasSpecExtended format = GLES.GlTexSubImage2DDecorator.getArgumentFormat(functionCall);
        AbstractConstantOrAliasSpecExtended type = GLES.GlTexSubImage2DDecorator.getArgumentType(functionCall);
        TextureArgAttachment attachment = GLES.GlTexSubImage2DDecorator.getArgumentPixels(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset == null) {
            return;
        }
        if (!textureAsset.hasMipmapLevel(target, null, level)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Texture level not previously defined.");
        }
        textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(xOffset, yOffset, target, width, height), size, format, type, IGlTextureLayerData.create(attachment), false);
        StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
        if (!Long.valueOf(0L).equals(usingPBO.value)) {
            textureAsset.setNote(functionCall, "Using GL_PIXEL_UNPACK_BUFFER_BINDING");
        }
    }

    public static void glCompressedTexSubImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlCompressedTexSubImage2DDecorator.getArgumentTarget(functionCall);
        int level = GLES.GlCompressedTexSubImage2DDecorator.getArgumentLevel(functionCall);
        int xOffset = GLES.GlCompressedTexSubImage2DDecorator.getArgumentXoffset(functionCall);
        int yOffset = GLES.GlCompressedTexSubImage2DDecorator.getArgumentYoffset(functionCall);
        int width = GLES.GlCompressedTexSubImage2DDecorator.getArgumentWidth(functionCall);
        int height = GLES.GlCompressedTexSubImage2DDecorator.getArgumentHeight(functionCall);
        Dimension size = new Dimension(width, height);
        AbstractConstantOrAliasSpecExtended format = (AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)GLES.GlCompressedTexSubImage2DDecorator.getArgumentFormat(functionCall));
        TextureArgAttachment attachment = GLES.GlCompressedTexSubImage2DDecorator.getArgumentData(functionCall);
        GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(functionCall, currentState, target);
        if (textureAsset != null) {
            if (!textureAsset.hasMipmapLevel(target, null, level)) {
                TraceAnalysisLogger.error(currentState, functionCall, "Level " + level + " for texture " + textureAsset.getId() + " has not been previously defined.");
                return;
            }
            boolean validData = CompressedTextureValidator.validateCompressedTextureData(currentState, functionCall, width, height, 1, format, attachment);
            IGlTextureLayerData textureData = validData ? IGlTextureLayerData.create(attachment) : null;
            textureAsset.addTextureLayerToLevel(functionCall, target, null, level, new GlImageOffset(xOffset, yOffset, target, width, height), size, format, null, textureData, false);
            StateValue usingPBO = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_PIXEL_UNPACK_BUFFER_BINDING).getValue()[0];
            if (!Long.valueOf(0L).equals(usingPBO.value)) {
                textureAsset.setNote(functionCall, "Using GL_PIXEL_UNPACK_BUFFER_BINDING");
            }
        }
    }

    public static StateItem getTextureCurrentBoundState(@NonNull TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended target) {
        TargetBindingSpec simplifiedTarget = KapiSpec.GLES.targetBindingMaps.SIMPLE_TEXTURE_TARGET.specObject.getTargetBinding(target);
        if (simplifiedTarget == null) {
            return null;
        }
        TargetBindingSpec bindingStateItem = KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject.getTargetBinding(simplifiedTarget.getBinding());
        if (bindingStateItem == null) {
            return null;
        }
        return currentState.getStateItemBySpec((StateSpec)NullUtils.neverNull((Object)bindingStateItem.getState()));
    }

    public static GlTextureAsset getTextureAssetByConstantSpec(@NonNull FunctionCall functionCall, @NonNull TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended target) {
        IAssetItem assetItem = null;
        StateItem boundTextureState = AssetProcessor.getTextureCurrentBoundState(currentState, target);
        if (boundTextureState != null) {
            Long boundTextureId = boundTextureState.getValue()[0].getValueAsLong();
            AssetTable texturesTable = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
            assetItem = texturesTable.get(boundTextureId);
        } else {
            TraceAnalysisLogger.error(currentState, functionCall, "No texture is bound to " + target.getName() + ".");
        }
        return (GlTextureAsset)assetItem;
    }

    private static void glFramebufferTexture2DShared(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, AbstractConstantOrAliasSpecExtended target, AbstractConstantOrAliasSpecExtended attachment, Long texture, AbstractConstantOrAliasSpecExtended texTarget, Integer level) {
        GlFramebufferAttachmentAsset[] oldAssets;
        assert (target != null);
        assert (attachment != null);
        assert (texture != null);
        assert (texTarget != null);
        assert (level != null);
        if (!GlFramebufferAsset.isValidConstantSpecTarget(target)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Unrecognized target " + target);
            return;
        }
        StateSpec mappedTargetStateSpec = GlFramebufferAsset.mapTargetToStateSpec(target);
        GlFramebufferAsset framebuffer = GlFramebufferAsset.getBoundFramebufferAsset(currentState, (StateSpec)NullUtils.neverNull((Object)mappedTargetStateSpec));
        if (framebuffer == null) {
            TraceAnalysisLogger.error(currentState, functionCall, "Missing framebuffer asset for target" + target);
            return;
        }
        framebuffer.setPreviousModificationFunction(functionCall);
        GlFramebufferAttachmentAsset[] glFramebufferAttachmentAssetArray = oldAssets = framebuffer.clearAttachment(attachment);
        int n = oldAssets.length;
        int n2 = 0;
        while (n2 < n) {
            IAssetItem attachmentAsset;
            GlFramebufferAttachmentAsset oldAsset = glFramebufferAttachmentAssetArray[n2];
            if (oldAsset != null && (attachmentAsset = oldAsset.getAsset()) != null) {
                attachmentAsset.setNote(functionCall, "");
                if (attachmentAsset instanceof GlTextureAsset) {
                    GlTextureAsset oldTextureAsset = (GlTextureAsset)attachmentAsset;
                    oldTextureAsset.removeBoundTo(framebuffer.getId(), attachment, functionCall);
                }
            }
            ++n2;
        }
        if (texture != 0L) {
            GlTextureAsset textureAsset = (GlTextureAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC).get(texture);
            if (textureAsset == null) {
                TraceAnalysisLogger.error(currentState, functionCall, "Texture " + texture + " does not exist. Cannot bind to framebuffer.");
                return;
            }
            AbstractConstantOrAliasSpecExtended textureCubeMapFace = KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP.equals(textureAsset.getTextureTarget()) ? texTarget : null;
            framebuffer.attachAsset(new GlFramebufferTextureAttachmentAsset(functionCall, framebuffer, (long)attachment.getResolvedValue(), textureAsset, textureCubeMapFace, level.longValue()));
            textureAsset.addBoundTo(framebuffer.getId(), attachment, functionCall);
            textureAsset.setEverBoundToFramebuffer(true);
        }
    }

    public static void glFramebufferTexture2DMultisampleEXT(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlFramebufferTexture2DMultisampleEXTDecorator.getArgumentTarget(functionCall);
        AbstractConstantOrAliasSpecExtended attachment = GLES.GlFramebufferTexture2DMultisampleEXTDecorator.getArgumentAttachment(functionCall);
        Long texture = GLES.GlFramebufferTexture2DMultisampleEXTDecorator.getArgumentTexture(functionCall);
        AbstractConstantOrAliasSpecExtended texTarget = GLES.GlFramebufferTexture2DMultisampleEXTDecorator.getArgumentTextarget(functionCall);
        Integer level = GLES.GlFramebufferTexture2DMultisampleEXTDecorator.getArgumentLevel(functionCall);
        AssetProcessor.glFramebufferTexture2DShared(currentState, functionCall, target, attachment, texture, texTarget, level);
    }

    public static void glFramebufferTexture2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlFramebufferTexture2DDecorator.getArgumentTarget(functionCall);
        AbstractConstantOrAliasSpecExtended attachment = GLES.GlFramebufferTexture2DDecorator.getArgumentAttachment(functionCall);
        Long texture = GLES.GlFramebufferTexture2DDecorator.getArgumentTexture(functionCall);
        AbstractConstantOrAliasSpecExtended texTarget = GLES.GlFramebufferTexture2DDecorator.getArgumentTextarget(functionCall);
        Integer level = GLES.GlFramebufferTexture2DDecorator.getArgumentLevel(functionCall);
        AssetProcessor.glFramebufferTexture2DShared(currentState, functionCall, target, attachment, texture, texTarget, level);
    }

    public static void glFramebufferTextureLayer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        GlFramebufferAttachmentAsset[] oldAssets;
        AbstractConstantOrAliasSpecExtended target = GLES.GlFramebufferTextureLayerDecorator.getArgumentTarget(functionCall);
        AbstractConstantOrAliasSpecExtended attachment = GLES.GlFramebufferTextureLayerDecorator.getArgumentAttachment(functionCall);
        Long texture = GLES.GlFramebufferTextureLayerDecorator.getArgumentTexture(functionCall);
        Integer level = GLES.GlFramebufferTextureLayerDecorator.getArgumentLevel(functionCall);
        Integer layer = GLES.GlFramebufferTextureLayerDecorator.getArgumentLayer(functionCall);
        assert (target != null);
        assert (attachment != null);
        assert (texture != null);
        assert (level != null);
        assert (layer != null);
        if (!GlFramebufferAsset.isValidConstantSpecTarget(target)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Unrecognized target " + target);
            return;
        }
        StateSpec mappedTargetStateSpec = GlFramebufferAsset.mapTargetToStateSpec(target);
        GlFramebufferAsset framebuffer = GlFramebufferAsset.getBoundFramebufferAsset(currentState, (StateSpec)NullUtils.neverNull((Object)mappedTargetStateSpec));
        if (framebuffer == null) {
            TraceAnalysisLogger.error(currentState, functionCall, "Missing framebuffer asset for target" + target);
            return;
        }
        framebuffer.setPreviousModificationFunction(functionCall);
        GlFramebufferAttachmentAsset[] glFramebufferAttachmentAssetArray = oldAssets = framebuffer.clearAttachment(attachment);
        int n = oldAssets.length;
        int n2 = 0;
        while (n2 < n) {
            IAssetItem attachmentAsset;
            GlFramebufferAttachmentAsset oldAsset = glFramebufferAttachmentAssetArray[n2];
            if (oldAsset != null && (attachmentAsset = oldAsset.getAsset()) != null) {
                attachmentAsset.setNote(functionCall, "");
            }
            ++n2;
        }
        if (texture != 0L) {
            GlTextureAsset textureAsset = (GlTextureAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC).get(texture);
            if (textureAsset == null) {
                TraceAnalysisLogger.error(currentState, functionCall, "Texture " + texture + " does not exist. Cannot bind to framebuffer.");
                return;
            }
            framebuffer.attachAsset(new GlFramebufferTextureAttachmentAsset(functionCall, framebuffer, (long)attachment.getResolvedValue(), textureAsset, layer, level.longValue()));
            textureAsset.addBoundTo(framebuffer.getId(), attachment, functionCall);
        }
    }

    public static void glFramebufferRenderbuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        GlFramebufferAttachmentAsset[] oldAssets;
        AbstractConstantOrAliasSpecExtended target = GLES.GlFramebufferRenderbufferDecorator.getArgumentTarget(functionCall);
        AbstractConstantOrAliasSpecExtended attachment = GLES.GlFramebufferRenderbufferDecorator.getArgumentAttachment(functionCall);
        AbstractConstantOrAliasSpecExtended renderbufferTarget = GLES.GlFramebufferRenderbufferDecorator.getArgumentRenderbuffertarget(functionCall);
        Long renderbuffer = GLES.GlFramebufferRenderbufferDecorator.getArgumentRenderbuffer(functionCall);
        assert (target != null);
        assert (attachment != null);
        assert (renderbufferTarget != null);
        assert (renderbuffer != null);
        if (!GlFramebufferAsset.isValidConstantSpecTarget(target)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Unrecognized target " + target);
            return;
        }
        GlFramebufferAsset framebuffer = GlFramebufferAsset.getBoundFramebufferAsset(currentState, (StateSpec)NullUtils.neverNull((Object)GlFramebufferAsset.mapTargetToStateSpec(target)));
        if (framebuffer == null) {
            TraceAnalysisLogger.error(currentState, functionCall, "Missing framebuffer asset for target" + target);
            return;
        }
        framebuffer.setPreviousModificationFunction(functionCall);
        GlFramebufferAttachmentAsset[] glFramebufferAttachmentAssetArray = oldAssets = framebuffer.clearAttachment(attachment);
        int n = oldAssets.length;
        int n2 = 0;
        while (n2 < n) {
            GlFramebufferAttachmentAsset oldAsset = glFramebufferAttachmentAssetArray[n2];
            if (oldAsset != null) {
                IAssetItem attachmentAsset = oldAsset.getAsset();
                if (attachmentAsset != null) {
                    attachmentAsset.setNote(functionCall, "");
                }
                if (attachmentAsset instanceof GlRenderbufferAsset) {
                    GlRenderbufferAsset renderbufferAsset = (GlRenderbufferAsset)attachmentAsset;
                    renderbufferAsset.removeBoundTo(framebuffer.getId(), attachment, functionCall);
                }
            }
            ++n2;
        }
        if (renderbuffer != 0L) {
            GlRenderbufferAsset rbAsset = (GlRenderbufferAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS.SPEC).get(renderbuffer);
            if (rbAsset == null) {
                TraceAnalysisLogger.error(currentState, functionCall, "Renderbuffer " + renderbuffer + " does not exist. Cannot bind to framebuffer.");
                return;
            }
            rbAsset.addBoundTo(framebuffer.getId(), attachment, functionCall);
            framebuffer.attachAsset(new GlFramebufferRenderbufferAttachmentAsset(functionCall, framebuffer, attachment.getResolvedValue(), rbAsset));
            rbAsset.setNote(functionCall, "Renderbuffer bound to " + framebuffer.getLabelText() + " (" + attachment + ")");
        }
    }

    public static void glBindBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended newBinding = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
        Long bufferId = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
        AssetTable bufferAssetTable = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC);
        GlBufferAsset bufferAsset = (GlBufferAsset)bufferAssetTable.get(bufferId);
        if (KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER.equals(newBinding)) {
            GlVertexArrayObjectAsset vao = GlVertexArrayObjectAsset.getOrCreateVertexArrayObjectAt(currentState, functionCall, null);
            vao.setElementArrayBufferBinding(bufferAsset);
        }
        AssetProcessor.bindBufferShared(currentState, functionCall, newBinding, bufferId);
    }

    private static void bindBufferShared(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, AbstractConstantOrAliasSpecExtended newBinding, Long bufferId) {
        GlBufferAsset bufferAsset = null;
        if (bufferId != 0L) {
            AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC);
            bufferAsset = (GlBufferAsset)assetTableBySpec.get(bufferId);
            if (bufferAsset == null) {
                return;
            }
            try {
                bufferAsset.setFirstBinding(newBinding);
            }
            catch (OneShotPropertyFailureException e) {
                AssetProcessorBase.handleOneShotPropertyFailure(currentState, functionCall, e);
            }
        }
    }

    public static void glBindBufferBase(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended newBinding = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
        Long bufferId = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
        AssetProcessor.bindBufferShared(currentState, functionCall, newBinding, bufferId);
    }

    public static void glBindBufferRange(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended newBinding = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
        Long bufferId = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
        assert (bufferId != null);
        AssetProcessor.bindBufferShared(currentState, functionCall, newBinding, bufferId);
    }

    public static void glBlitFramebuffer(@NonNull TraceStateSnapshot currentState, @NonNull DrawFunctionCall functionCall) {
        StateSpec mappedTargetStateSpec;
        GlFramebufferAsset drawAsset;
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new BlitFramebufferCallData(currentState));
        }
        if ((drawAsset = GlFramebufferAsset.getBoundFramebufferAsset(currentState, (StateSpec)NullUtils.neverNull((Object)(mappedTargetStateSpec = GlFramebufferAsset.mapTargetToStateSpec(KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER))))) != null) {
            drawAsset.setPreviousModificationFunction(functionCall);
        }
        AssetProcessor.removeFramebufferIfNoAttachments(currentState, functionCall);
    }

    public static void glBufferData(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlBufferDataDecorator.getArgumentTarget(functionCall);
        BufferArgAttachment attachment = GLES.GlBufferDataDecorator.getArgumentData(functionCall);
        AbstractConstantOrAliasSpecExtended usage = GLES.GlBufferDataDecorator.getArgumentUsage(functionCall);
        int size = GLES.GlBufferDataDecorator.getArgumentSize(functionCall).intValue();
        assert (target != null);
        StateItem targetBindingState = AssetProcessor.getTargetBufferStateItem(currentState, target);
        if (targetBindingState != null) {
            GlBufferAsset bufferAsset = (GlBufferAsset)targetBindingState.getValueAsAsset();
            if (bufferAsset != null) {
                bufferAsset.setData(currentState, functionCall, usage, size, attachment);
            }
        } else {
            TraceAnalysisLogger.error(currentState, functionCall, "No buffer is bound to " + target.getName() + ". Unable to set buffer data.");
        }
    }

    public static void glBufferSubData(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AbstractConstantOrAliasSpecExtended target = GLES.GlBufferSubDataDecorator.getArgumentTarget(functionCall);
        long size = GLES.GlBufferSubDataDecorator.getArgumentSize(functionCall);
        BufferArgAttachment attachment = GLES.GlBufferSubDataDecorator.getArgumentData(functionCall);
        int offset = GLES.GlBufferSubDataDecorator.getArgumentOffset(functionCall).intValue();
        assert (target != null);
        StateItem targetBindingState = AssetProcessor.getTargetBufferStateItem(currentState, target);
        if (targetBindingState != null) {
            GlBufferAsset bufferAsset = (GlBufferAsset)targetBindingState.getValueAsAsset();
            if (bufferAsset != null) {
                if (offset < 0) {
                    TraceAnalysisLogger.error(currentState, functionCall, "Offset is less than 0. Not setting buffer data.");
                    return;
                }
                if (size < 0L) {
                    TraceAnalysisLogger.error(currentState, functionCall, "Size is less than 0. Not setting buffer data.");
                    return;
                }
                try {
                    bufferAsset.setSubData(currentState, functionCall, attachment, offset);
                }
                catch (ApiUsageException e) {
                    TraceAnalysisLogger.error(currentState, functionCall, e, null);
                }
            }
        } else {
            TraceAnalysisLogger.error(currentState, functionCall, "No buffer is bound to " + target.getName() + ". Unable to set buffer data.");
        }
    }

    static StateSpec getTargetBufferState(AbstractConstantOrAliasSpecExtended target) {
        TargetBindingSpec binding = KapiSpec.GLES.targetBindingMaps.BUFFER_TARGETS.specObject.getTargetBinding(target);
        if (binding != null) {
            return binding.getState();
        }
        return null;
    }

    public static StateItem getTargetBufferStateItem(@NonNull TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended target) {
        StateSpec stateSpec = AssetProcessor.getTargetBufferState(target);
        if (stateSpec != null) {
            return currentState.getStateItemBySpec(stateSpec);
        }
        return null;
    }

    public static void eglMakeCurrent(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Pointer contextHandle = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
        currentState.makeCurrentContext(functionCall.getTid(), (Pointer)NullUtils.neverNull((Object)contextHandle), functionCall);
    }

    public static void glInvalidateFramebuffer(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -2354865571050387983L;

                @Override
                public @NonNull String getDescriptiveText() {
                    @NonNull AbstractConstantOrAliasSpecExtended target = GLES.GlInvalidateFramebufferDecorator.getArgumentTarget(functionCall);
                    @NonNull LongsArgAttachment attachments = GLES.GlInvalidateFramebufferDecorator.getArgumentAttachments(functionCall);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Target ").append(target.getName());
                    if (!attachments.isEmpty()) {
                        sb.append(", Attachments ").append(attachments.toStrings());
                    }
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }
            });
        }
    }

    public static void glDispatchCompute(@NonNull TraceStateSnapshot currentState, @NonNull InterestingFunctionCall functionCall) {
        ComputeWorkgroupSize size;
        final long numGroupsX = GLES.GlDispatchComputeDecorator.getArgumentNum_groups_x(functionCall);
        final long numGroupsY = GLES.GlDispatchComputeDecorator.getArgumentNum_groups_y(functionCall);
        final long numGroupsZ = GLES.GlDispatchComputeDecorator.getArgumentNum_groups_z(functionCall);
        long totalNumGroups = numGroupsX * numGroupsY * numGroupsZ;
        GlProgramAsset program = GlProgramHelper.getCurrentProgramAsset(currentState, KapiSpec.GLES.constants.GL_COMPUTE_SHADER);
        ComputeWorkgroupSize computeWorkgroupSize = size = program == null ? null : program.getComputeLocalWorkGroupSize();
        if (program != null) {
            GlShaderAsset computeShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_COMPUTE_SHADER);
            if (computeShader != null) {
                long localInstancesRun = size == null ? 0L : size.getTotalWorkgroupSize();
                computeShader.incrementCurrentFrameShaderInvocations(totalNumGroups * localInstancesRun);
            } else {
                TraceAnalysisLogger.error(currentState, functionCall, "No compute shader present.");
            }
        }
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 6166384796531419347L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    if (size != null) {
                        sb.append("Local Size ").append(size.toString()).append(", ");
                    }
                    sb.append("Num Groups ").append(numGroupsX).append(", ").append(numGroupsY).append(", ").append(numGroupsZ);
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }
            });
        }
    }

    public static void glDispatchComputeIndirect(@NonNull TraceStateSnapshot currentState, @NonNull InterestingFunctionCall functionCall) {
        ComputeWorkgroupSize size;
        GlProgramAsset program = GlProgramHelper.getCurrentProgramAsset(currentState, KapiSpec.GLES.constants.GL_COMPUTE_SHADER);
        ComputeWorkgroupSize computeWorkgroupSize = size = program == null ? null : program.getComputeLocalWorkGroupSize();
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 6166384796531419347L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    if (size != null) {
                        sb.append("Local Size ").append(size.toString()).append(", ");
                    }
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }
            });
        }
    }

    public static void glVertexAttribI4i(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, GLES.GlVertexAttribI4iDecorator.getArgumentIndex(functionCall));
    }

    public static void glVertexAttribI4ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, GLES.GlVertexAttribI4uiDecorator.getArgumentIndex(functionCall));
    }

    public static void glVertexAttribI4iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, GLES.GlVertexAttribI4ivDecorator.getArgumentIndex(functionCall));
    }

    public static void glVertexAttribI4uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        AssetProcessor.shaderAttributeSetLastModified(currentState, functionCall, GLES.GlVertexAttribI4uivDecorator.getArgumentIndex(functionCall));
    }

    public static void glUniformBlockBinding(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long programID = GLES.GlUniformBlockBindingDecorator.getArgumentProgram(functionCall);
        Long blockIndex = GLES.GlUniformBlockBindingDecorator.getArgumentUniformBlockIndex(functionCall);
        Long blockBinding = GLES.GlUniformBlockBindingDecorator.getArgumentUniformBlockBinding(functionCall);
        assert (blockBinding != null);
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC);
        GlProgramAsset programAsset = (GlProgramAsset)assetTableBySpec.get(programID);
        if (programAsset == null) {
            return;
        }
        GlUniformBindingPointAsset bindingPoint = AssetProcessorBase.getOrCreateNewGlUniformBindingPointAsset(currentState, functionCall, blockBinding);
        assert (bindingPoint != null);
        programAsset.setUniformBlockBinding(blockIndex, bindingPoint);
        AssetProcessor.processUniformBufferBlockDataForProgram(currentState, functionCall, bindingPoint, programAsset);
    }

    public static void glUseProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        Long programId = GLES.GlUseProgramDecorator.getArgumentProgram(functionCall);
        assert (programId != null);
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC);
        GlProgramAsset programAsset = (GlProgramAsset)assetTableBySpec.get(programId);
        if (programAsset == null) {
            return;
        }
        programAsset.setPreviousModificationFunction(functionCall);
        AssetProcessor.processUniformBufferBlockDataFor(currentState, functionCall, programAsset);
    }

    public static void clWaitForEvents(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clFlush(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clFinish(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueReadBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueReadBufferRect(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueWriteBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueWriteBufferRect(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueFillBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueCopyBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueCopyBufferRect(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueReadImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueWriteImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueFillImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueCopyImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueCopyImageToBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueCopyBufferToImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueMapBuffer(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueMapImage(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueUnmapMemObject(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueMigrateMemObjects(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueNativeKernel(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueMarkerWithWaitList(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueBarrierWithWaitList(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueWaitForEvents(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueBarrier(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    public static void clEnqueueMarker(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        AssetProcessor.processCLEnqueueCall(currentState, functionCall);
    }

    private static void processCLEnqueueCall(@NonNull TraceStateSnapshot currentState, @NonNull ClEnqueueCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            functionCall.setInterestingCallData(new ClEnqueueCallData(functionCall));
        }
    }

    public static void vkWaitForFences(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Long numberOfFences = VULKAN.VkWaitForFencesDecorator.getArgumentFenceCount(functionCall);
            final AbstractConstantOrAliasSpecExtended waitAll = VULKAN.VkWaitForFencesDecorator.getArgumentWaitAll(functionCall);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = 9061591206087145501L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Fence count ").append(numberOfFences.toString());
                    if (waitAll.equals(KapiSpec.VULKAN.constants.VK_TRUE)) {
                        sb.append(", ").append("Wait All");
                    }
                    sb.append(", ").append("Blocked for ").append(TimestampUtils.microsecondsToSecondsString(functionCall.getWaitTime())).append("s");
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }

                @Override
                public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
                    return type == CommonStatistics.TIME_SPENT_BLOCKED;
                }

                @Override
                public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
                    if (type == CommonStatistics.TIME_SPENT_BLOCKED) {
                        return new Statistic(type, TimestampUtils.microsecondsToSeconds(functionCall.getWaitTime()));
                    }
                    throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
                }
            });
        }
    }

    public static void vkQueueSubmit(@NonNull TraceStateSnapshot currentState, @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Pointer queue = VULKAN.VkQueueSubmitDecorator.getArgumentQueue(functionCall);
            final Long submitCount = VULKAN.VkQueueSubmitDecorator.getArgumentSubmitCount(functionCall);
            final Handle fence = VULKAN.VkQueueSubmitDecorator.getArgumentFence(functionCall);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -6567729522638593674L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Queue ").append(queue.toString());
                    sb.append(", ").append("Submit count ").append(submitCount);
                    if (!fence.isEmptyHandle()) {
                        sb.append(", ").append("Fence ").append(fence);
                    }
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }
            });
        }
        List<VULKAN.Structs.VkSubmitInfo> submitInfos = VULKAN.VkQueueSubmitDecorator.getArgumentPSubmits(functionCall);
        AssetTable table = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC);
        for (VULKAN.Structs.VkSubmitInfo info : submitInfos) {
            LongsArgAttachment cmdBuffers = info.getPCommandBuffers();
            for (Long cmdBufferID : cmdBuffers) {
                VkCommandBufferAsset cmdBuffer = (VkCommandBufferAsset)table.get(cmdBufferID);
                if (cmdBuffer == null) continue;
                cmdBuffer.updateDeviceMemory(currentState, functionCall);
            }
        }
    }

    public static void vkQueueWaitIdle(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Pointer queue = VULKAN.VkQueueWaitIdleDecorator.getArgumentQueue(functionCall);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -6020304861031155249L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Queue ").append(queue.toString());
                    sb.append(", ").append("Blocked for ").append(TimestampUtils.microsecondsToSecondsString(functionCall.getWaitTime())).append("s");
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }

                @Override
                public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
                    return type == CommonStatistics.TIME_SPENT_BLOCKED;
                }

                @Override
                public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
                    if (type == CommonStatistics.TIME_SPENT_BLOCKED) {
                        return new Statistic(type, TimestampUtils.microsecondsToSeconds(functionCall.getWaitTime()));
                    }
                    throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
                }
            });
        }
    }

    public static void vkDeviceWaitIdle(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Pointer device = VULKAN.VkDeviceWaitIdleDecorator.getArgumentDevice(functionCall);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -2995546267200558824L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Device ").append(device.toString());
                    sb.append(", ").append("Blocked for ").append(TimestampUtils.microsecondsToSecondsString(functionCall.getWaitTime())).append("s");
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }

                @Override
                public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
                    return type == CommonStatistics.TIME_SPENT_BLOCKED;
                }

                @Override
                public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
                    if (type == CommonStatistics.TIME_SPENT_BLOCKED) {
                        return new Statistic(type, TimestampUtils.microsecondsToSeconds(functionCall.getWaitTime()));
                    }
                    throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
                }
            });
        }
    }

    public static void vkAcquireNextImageKHR(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Handle swapchain = VULKAN.VkAcquireNextImageKHRDecorator.getArgumentSwapchain(functionCall);
            final Long timeout = VULKAN.VkAcquireNextImageKHRDecorator.getArgumentTimeout(functionCall);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -2995546267200558824L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Swapchain ").append(swapchain.toString());
                    sb.append(", ").append("Timeout ");
                    if (timeout == -1L) {
                        sb.append("Indefinite");
                    } else {
                        sb.append(Long.toUnsignedString(timeout));
                    }
                    sb.append(", ").append("Blocked for ").append(TimestampUtils.microsecondsToSecondsString(functionCall.getWaitTime())).append("s");
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }

                @Override
                public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
                    return type == CommonStatistics.TIME_SPENT_BLOCKED;
                }

                @Override
                public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
                    if (type == CommonStatistics.TIME_SPENT_BLOCKED) {
                        return new Statistic(type, TimestampUtils.microsecondsToSeconds(functionCall.getWaitTime()));
                    }
                    throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
                }
            });
        }
    }

    public static void vkGetQueryPoolResults(@NonNull TraceStateSnapshot currentState, final @NonNull InterestingFunctionCall functionCall) {
        if (!functionCall.hasInterestingCallData()) {
            final Handle queryPool = VULKAN.VkGetQueryPoolResultsDecorator.getArgumentQueryPool(functionCall);
            final Long queryCount = VULKAN.VkGetQueryPoolResultsDecorator.getArgumentQueryCount(functionCall);
            Bitfield flags = VULKAN.VkGetQueryPoolResultsDecorator.getArgumentFlags(functionCall);
            final boolean blocking = flags.contains(KapiSpec.VULKAN.constants.VK_QUERY_RESULT_WAIT_BIT);
            functionCall.setInterestingCallData(new InterestingCallData(){
                private static final long serialVersionUID = -2995546267200558824L;

                @Override
                public @NonNull String getDescriptiveText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Query pool ").append(queryPool.toString());
                    sb.append(", ").append("Count ").append(queryCount.toString());
                    if (blocking) {
                        sb.append(", ").append("Blocked for ").append(TimestampUtils.microsecondsToSecondsString(functionCall.getWaitTime())).append("s");
                    }
                    return (String)NullUtils.neverNull((Object)sb.toString());
                }

                @Override
                public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
                    return type == CommonStatistics.TIME_SPENT_BLOCKED && blocking;
                }

                @Override
                public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
                    if (type == CommonStatistics.TIME_SPENT_BLOCKED && blocking) {
                        return new Statistic(type, TimestampUtils.microsecondsToSeconds(functionCall.getWaitTime()));
                    }
                    throw new IllegalArgumentException("Statistic '" + type + "' is not supported.");
                }
            });
        }
    }

    public static void vkUpdateDescriptorSets(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) {
        List<VULKAN.Structs.VkWriteDescriptorSet> writeDescriptorSets = VULKAN.VkUpdateDescriptorSetsDecorator.getArgumentPDescriptorWrites(functionCall);
        for (VULKAN.Structs.VkWriteDescriptorSet writeDescriptorSetOperation : writeDescriptorSets) {
            try {
                Handle dstDescriptorSetHandle = writeDescriptorSetOperation.getDstSet();
                VkDescriptorSetAsset descriptorSetAsset = AssetProcessorBase.getVkDescriptorSetAsset(currentState, functionCall, AssetProcessorBase.asAssetID((Handle)NullUtils.neverNull((Object)dstDescriptorSetHandle)));
                if (descriptorSetAsset == null) {
                    return;
                }
                descriptorSetAsset.updateDescriptors(currentState, writeDescriptorSetOperation);
            }
            catch (AbortActionException e) {
                TraceAnalysisLogger.warning(currentState, functionCall, e.getMessage());
            }
        }
    }

    private static void processUniformBufferBlockDataForProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlUniformBindingPointAsset bindingPoint, @NonNull GlProgramAsset programAsset) {
        GlBufferAsset bufferAsset = bindingPoint.getBuffer();
        Set<ProgramResourceDescriptor> boundBlocks = programAsset.getUniformBlocksBoundTo(bindingPoint);
        for (ProgramResourceDescriptor block : boundBlocks) {
            for (ShaderUniform uniform : programAsset.getUniformsContainer().getBlock(block.getName()).values()) {
                if (bufferAsset != null) {
                    try {
                        uniform.setValueFromBuffer(currentState, functionCall, bufferAsset, bindingPoint.getOffset(), bindingPoint.getLength());
                    }
                    catch (UnsupportedTypeException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                uniform.clearValue(functionCall);
            }
        }
    }

    private static void shaderAttributeSetLastModified(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Long attributeIndex) {
        if (attributeIndex == null) {
            return;
        }
        GlProgramAsset currentProgram = GlProgramHelper.getCurrentProgramAsset(currentState, KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        if (currentProgram == null) {
            return;
        }
        ShaderAttribute attribute = currentProgram.getAttributeByLocation(attributeIndex);
        if (attribute == null) {
            return;
        }
        attribute.setPreviousModificationFunction(functionCall);
    }

    public static void processUniformBufferBlockDataForAllBoundToBindingPoint(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlUniformBindingPointAsset bindingPoint) {
        @NonNull Collection<@NonNull GlProgramAsset> currentPrograms = GlProgramHelper.getCurrentProgramAssets(currentState);
        if (currentPrograms.isEmpty()) {
            return;
        }
        for (GlProgramAsset program : currentPrograms) {
            AssetProcessor.processUniformBufferBlockDataForProgram(currentState, functionCall, bindingPoint, program);
        }
    }

    private static void processUniformBufferBlockDataFor(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset glProgramAsset) {
        AssetTable ubpAssets = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS.SPEC);
        for (IAssetItem asset : ubpAssets) {
            GlUniformBindingPointAsset bindingPoint = (GlUniformBindingPointAsset)asset;
            assert (bindingPoint != null);
            AssetProcessor.processUniformBufferBlockDataForProgram(currentState, functionCall, bindingPoint, glProgramAsset);
        }
    }

    public static void processUniformBufferBlockDataFor(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlBufferAsset glBufferAsset) {
        @NonNull Collection<@NonNull GlProgramAsset> currentPrograms = GlProgramHelper.getCurrentProgramAssets(currentState);
        if (currentPrograms.isEmpty()) {
            return;
        }
        AssetTable ubpAssets = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS.SPEC);
        HashSet<@NonNull GlUniformBindingPointAsset> boundAssets = new HashSet<GlUniformBindingPointAsset>();
        for (IAssetItem asset : ubpAssets) {
            GlUniformBindingPointAsset bindingPoint = (GlUniformBindingPointAsset)asset;
            GlBufferAsset boundBuffer = bindingPoint.getBuffer();
            if (boundBuffer == null || !glBufferAsset.equals(boundBuffer)) continue;
            boundAssets.add(bindingPoint);
        }
        for (GlProgramAsset program : currentPrograms) {
            for (GlUniformBindingPointAsset bindingPoint : boundAssets) {
                AssetProcessor.processUniformBufferBlockDataForProgram(currentState, functionCall, bindingPoint, program);
            }
        }
    }
}

