/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAssetItem
implements IAssetItem,
Serializable {
    private static final long serialVersionUID = 1637684119835780679L;
    private final @NonNull FunctionCall createdByFunction;
    private @Nullable FunctionCall previousModificationFunction;
    private final @NonNull Long id;
    private final @NonNull AssetTableSpec assetSpec;
    private @NonNull String note = "";
    private final UniqueInstanceId uniqueInstanceId;
    private final @NonNull ISnapshotAssetParent snapshotAssetParent;

    protected AbstractAssetItem(@NonNull AssetTableSpec assetSpec, @NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, UniqueInstanceId uniqueInstanceId, long id) {
        assert (assetSpec != null);
        this.assetSpec = assetSpec;
        this.snapshotAssetParent = snapshotAssetParent;
        this.createdByFunction = createdByFunction;
        this.uniqueInstanceId = uniqueInstanceId;
        this.id = NullUtils.longValueOf((long)id);
    }

    protected AbstractAssetItem(@NonNull AssetTableSpec assetSpec, @NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(assetSpec, snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    @Override
    public final @NonNull AssetTableSpec getAssetSpec() {
        return this.assetSpec;
    }

    @Override
    public final @NonNull FunctionCall getCreatedByFunction() {
        return this.createdByFunction;
    }

    @Override
    public final @NonNull Long getId() {
        return this.id;
    }

    @Override
    public int getLabelIndex() {
        return this.id.intValue();
    }

    @Override
    public final @Nullable FunctionCall getPreviousModificationFunction() {
        return this.previousModificationFunction;
    }

    @Override
    public boolean isAssetActive() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            AbstractAssetItem other = (AbstractAssetItem)obj;
            if (this.createdByFunction == other.createdByFunction && this.id.equals(other.id)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() << 16 | this.id.intValue();
    }

    @Override
    public @NonNull String getToolTipText() {
        return this.getLabelText();
    }

    public String toString() {
        return String.format("%s %d # %s", this.getClass().getSimpleName(), this.id, this.uniqueInstanceId);
    }

    @Override
    public final @NonNull String getNote() {
        return this.note;
    }

    @Override
    public final void setNote(String note) {
        this.note = note != null ? note : "";
    }

    @Override
    public final void setNote(@NonNull FunctionCall lastModification, String note) {
        this.previousModificationFunction = lastModification;
        this.note = note != null ? note : "";
    }

    @Override
    public IAssetItem mapObject(TraceStateSnapshot snapshot) {
        return snapshot.getAssetTableBySpec(this.assetSpec).get(this.id);
    }

    @Override
    public void setPreviousModificationFunction(@NonNull FunctionCall previousModificationFunction) {
        this.previousModificationFunction = previousModificationFunction;
    }

    @Override
    public UniqueInstanceId getUniqueInstanceId() {
        return this.uniqueInstanceId;
    }

    public @NonNull ISnapshotAssetParent getSnapshotAssetParent() {
        return this.snapshotAssetParent;
    }

    @Override
    public void doMidstreamTraceUpdatePostProcessing(FunctionCall functionCall) {
    }

    @Override
    public @NonNull String getSimpleValue() {
        return this.getLabelText();
    }
}

