/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.utils.NullUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class SynchronousADBExecutor
implements IADBExecutor {
    private static final Pattern TOKENIZER = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private final @NonNull ArrayList<@NonNull IADBExecutor.IResult> resultHistory = new ArrayList();
    private final long perCommandTimeout;
    private final @NonNull TimeUnit perCommandTimeoutUnit;

    public SynchronousADBExecutor(long perCommandTimeout, @NonNull TimeUnit perCommandTimeoutUnit) {
        this.perCommandTimeout = perCommandTimeout;
        this.perCommandTimeoutUnit = perCommandTimeoutUnit;
    }

    private static @NonNull Process exec(@NonNull String command) throws IADBTask.InvalidADBException {
        Matcher matcher = TOKENIZER.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            String withinQuotesGroup = matcher.group(1);
            if (withinQuotesGroup != null) {
                tokens.add(withinQuotesGroup);
                continue;
            }
            tokens.add(matcher.group());
        }
        if (tokens.isEmpty()) {
            throw new IADBTask.InvalidADBException("Command \"" + command + "\"" + " could not be executed");
        }
        try {
            return (Process)NullUtils.neverNull((Object)new ProcessBuilder(tokens).redirectErrorStream(true).start());
        }
        catch (IOException e) {
            throw new IADBTask.InvalidADBException(e);
        }
    }

    private static @NonNull String waitUntilProcessOutputEnds(@NonNull Process process) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder output = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)NullUtils.neverNull((Object)output.toString());
    }

    private static int waitForExitCode(@NonNull String command, @NonNull Process process) throws IADBTask.InvalidADBException {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IADBTask.InvalidADBException("Command \"" + command + "\"" + " was interrupted");
        }
    }

    @Override
    public @NonNull IADBExecutor.IResult executeCommand(@NonNull String command, long timeout, @NonNull TimeUnit unit) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        SynchronousADBExecutorResult synchronousADBExecutorResult;
        block6: {
            Process process = null;
            SynchronousADBExecutorResult result = null;
            try {
                Process finalProcess = process = SynchronousADBExecutor.exec(command);
                AtomicBoolean timedOut = new AtomicBoolean(false);
                CoreInstance.getScheduledExecutorService().schedule(() -> {
                    if (finalProcess.isAlive()) {
                        timedOut.set(true);
                        finalProcess.destroy();
                    }
                }, timeout, unit);
                String output = SynchronousADBExecutor.waitUntilProcessOutputEnds(process);
                result = new SynchronousADBExecutorResult(command, output, SynchronousADBExecutor.waitForExitCode(command, process));
                if (timedOut.get()) {
                    throw new IADBTask.ADBTimeoutException("An ADB command timed out after " + TimeUnit.SECONDS.convert(timeout, unit) + "s: " + command);
                }
                synchronousADBExecutorResult = result;
                if (process != null) {
                    process.destroy();
                }
                if (result == null) break block6;
                this.resultHistory.add(result);
            }
            catch (Throwable throwable) {
                if (process != null) {
                    process.destroy();
                }
                if (result != null) {
                    this.resultHistory.add(result);
                }
                throw throwable;
            }
        }
        return synchronousADBExecutorResult;
    }

    @Override
    public @NonNull IADBExecutor.IResult executeCommand(@NonNull String command) throws IADBTask.InvalidADBException {
        try {
            return this.executeCommand(command, this.perCommandTimeout, this.perCommandTimeoutUnit);
        }
        catch (IADBTask.ADBExecutionException e) {
            throw new IADBTask.InvalidADBException(e);
        }
    }

    @Override
    public int getUnusedLocalPort() throws IADBTask.ADBExecutionException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ServerSocket socket = new ServerSocket(0);){
                return socket.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IADBTask.ADBExecutionException("Unable to retrieve an available host-side port.");
        }
    }

    public @NonNull List<@NonNull IADBExecutor.IResult> getCommandHistory() {
        return new ArrayList<IADBExecutor.IResult>(this.resultHistory);
    }

    private class SynchronousADBExecutorResult
    implements IADBExecutor.IResult {
        private final @NonNull String command;
        private final @NonNull String output;
        private final int exitCode;

        public String toString() {
            return "SynchronousADBExecutorResult [output=\"" + this.output + "\", exitCode=" + this.exitCode + "]";
        }

        private SynchronousADBExecutorResult(@NonNull String command, String output, int exitCode) {
            this.command = command;
            this.output = output;
            this.exitCode = exitCode;
        }

        @Override
        public @NonNull String getCommand() {
            return this.command;
        }

        @Override
        public @NonNull String getOutput() {
            return this.output;
        }

        @Override
        public int getExitCode() {
            return this.exitCode;
        }
    }
}

