/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.PackageInterceptor;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PackageLayerDriver
extends PackageInterceptor {
    private Map<@NonNull String, @Nullable String> oldScalarSettings = new TreeMap<String, String>();
    private Map<@NonNull String, @Nullable String> oldDriverSetting = new TreeMap<String, String>();

    PackageLayerDriver(@NonNull ADBDevice device, @NonNull String packageName, @NonNull IADBWrapper adbWrapper, @NonNull IAndroidBridgeFile hostInterceptorFile, @Nullable IADBExecutor adbExecutor) {
        super(device, packageName, adbWrapper, hostInterceptorFile, adbExecutor);
    }

    protected abstract @NonNull String getDebugLayersParam();

    protected abstract @NonNull String getLayerDriverID();

    @Override
    public void insert() throws IADBTask.ADBException {
        assert (!this.isInstalled()) : String.valueOf(this.getAPIName()) + " driver and settings are already installed and cannot be installed again";
        try {
            @NonNull String enableGPUDebugLayersParam = "enable_gpu_debug_layers";
            @NonNull String enableGPUDebugAppParam = "gpu_debug_app";
            for (String settingName : NullUtils.neverNullList(Arrays.asList("enable_gpu_debug_layers", "gpu_debug_app"))) {
                this.oldScalarSettings.put(settingName, this.getADBWrapper().getGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), settingName));
            }
            this.getADBWrapper().setGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), "enable_gpu_debug_layers", "1");
            this.getADBWrapper().setGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), "gpu_debug_app", this.getPackageName());
            @Nullable String oldDebugLayersValue = this.getADBWrapper().setFirstValueOfGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), this.getDebugLayersParam(), this.getLayerDriverID());
            this.oldDriverSetting.put(this.getDebugLayersParam(), oldDebugLayersValue);
            super.insert();
        }
        catch (IADBTask.ADBException e) {
            this.removeSettings();
            throw e;
        }
    }

    protected void removeOldDebugLayerDriverSettings() throws IADBTask.ADBException {
        assert (!this.isInstalled()) : "This function must be called before layer driver insertion";
        this.removeGlobalDebugLayerDriverSettings(true);
    }

    private void removeGlobalDebugLayerDriverSettings(boolean deleteOnEmpty) throws IADBTask.ADBException {
        this.getADBWrapper().removeValueFromGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), this.getDebugLayersParam(), this.getLayerDriverID(), deleteOnEmpty);
    }

    @Override
    public void close() throws IADBTask.ADBException {
        if (this.isInstalled()) {
            super.close();
            this.removeSettings();
        }
    }

    private void removeSettings() throws IADBTask.ADBException {
        Iterator<@NonNull String> scalarKeyIterator = this.oldScalarSettings.keySet().iterator();
        while (scalarKeyIterator.hasNext()) {
            @NonNull String settingName = scalarKeyIterator.next();
            String settingValue = this.oldScalarSettings.get(settingName);
            if (settingValue == null) {
                this.getADBWrapper().deleteGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), settingName);
            } else {
                this.getADBWrapper().setGlobalDeviceSetting(this.getADBExecutor(), this.getDevice(), settingName, settingValue);
            }
            scalarKeyIterator.remove();
        }
        if (!this.oldDriverSetting.isEmpty()) {
            boolean wasOriginallyUnset = this.oldDriverSetting.get(this.getDebugLayersParam()) == null;
            this.removeGlobalDebugLayerDriverSettings(wasOriginallyUnset);
            this.oldDriverSetting.clear();
        }
    }

    @Override
    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder("PackageLayerDriver [");
        toStringBuilder.append("API=").append(this.getAPIName()).append(", ");
        toStringBuilder.append("driver file on host=").append(this.getHostInterceptorFile().getAbsolutePath()).append(", ");
        toStringBuilder.append("device=").append(this.getDevice().getUnambiguousName()).append(", ");
        toStringBuilder.append("Android package=").append(this.getPackageName()).append(", ");
        toStringBuilder.append(this.isInstalled() ? "installed" : "not installed").append("]");
        return toStringBuilder.toString();
    }
}

