/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.IPackageInterceptor;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.core.util.CoreLogging;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PackageInterceptor
implements IPackageInterceptor {
    private static final String INTERCEPTOR_INSTALL_TIMEOUT_ENVVAR = "INTERCEPTOR_INSTALL_TIMEOUT";
    private static final int DEFAULT_TIMEOUT_SECONDS = 180;
    private static final int TIMEOUT_SECONDS = PackageInterceptor.getTimeoutInSeconds();
    private final @NonNull ADBDevice device;
    private final @NonNull String packageName;
    private final @NonNull IADBWrapper adbWrapper;
    private final @NonNull IADBExecutor adbExecutor;
    private final @NonNull IAndroidBridgeFile hostInterceptorFile;
    private boolean installed = false;

    PackageInterceptor(@NonNull ADBDevice device, @NonNull String packageName, @NonNull IADBWrapper adbWrapper, @NonNull IAndroidBridgeFile hostInterceptorFile, @Nullable IADBExecutor adbExecutor) {
        this.device = device;
        this.packageName = packageName;
        this.adbWrapper = adbWrapper;
        this.hostInterceptorFile = hostInterceptorFile;
        this.adbExecutor = adbExecutor == null ? new SynchronousADBExecutor(TIMEOUT_SECONDS, TimeUnit.SECONDS) : adbExecutor;
    }

    protected abstract @NonNull String getAPIName();

    @Override
    public @NonNull ADBDevice getDevice() {
        return this.device;
    }

    @Override
    public @NonNull String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    private static int getTimeoutInSeconds() {
        @Nullable String timeoutEnvVar = System.getenv(INTERCEPTOR_INSTALL_TIMEOUT_ENVVAR);
        if (timeoutEnvVar == null) {
            return 180;
        }
        try {
            return Integer.valueOf(timeoutEnvVar);
        }
        catch (NumberFormatException ex) {
            CoreLogging.warning(null, "Unable to parse timeout value: " + timeoutEnvVar + ". Please provide the timeout as an integer value representing the number of seconds.");
            return 180;
        }
    }

    @Override
    public @NonNull IADBWrapper getADBWrapper() {
        return this.adbWrapper;
    }

    @Override
    public @NonNull IADBExecutor getADBExecutor() {
        return this.adbExecutor;
    }

    @Override
    public void insert() throws IADBTask.ADBException {
        assert (!this.installed) : String.valueOf(this.getAPIName()) + " driver and settings are already installed and cannot be installed again";
        try {
            this.getADBWrapper().pushFileToDeviceAsPackage(this.getADBExecutor(), this.getDevice(), this.hostInterceptorFile.getAbsolutePath(), this.getInstalledInterceptorBasename(), this.getPackageName());
        }
        catch (IADBTask.ADBException e) {
            this.removeInterceptorFile();
            throw e;
        }
        this.installed = true;
    }

    @Override
    public void close() throws IADBTask.ADBException {
        if (this.installed) {
            this.removeInterceptorFile();
            this.installed = false;
        }
    }

    protected void removeInterceptorFile() throws IADBTask.ADBException {
        this.getADBWrapper().deleteFileAsPackage(this.getADBExecutor(), this.getDevice(), this.getPackageName(), this.getInstalledInterceptorBasename());
    }

    @Override
    public @NonNull IAndroidBridgeFile getHostInterceptorFile() {
        return this.hostInterceptorFile;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder("PackageInterceptor [");
        toStringBuilder.append("API=").append(this.getAPIName()).append(", ");
        toStringBuilder.append("driver file on host=").append(this.hostInterceptorFile.getAbsolutePath()).append(", ");
        toStringBuilder.append("device=").append(this.getDevice().getUnambiguousName()).append(", ");
        toStringBuilder.append("Android package=").append(this.getPackageName()).append(", ");
        toStringBuilder.append(this.installed ? "installed" : "not installed").append("]");
        return toStringBuilder.toString();
    }

    protected void setInstalled(boolean installed) {
        this.installed = installed;
    }
}

