/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBForwardedPort;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.PackageInterceptor;
import com.arm.mgd.jdibridge.JDILibraryInjector;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InjectableGLESPackageInterceptor
extends PackageInterceptor {
    private final @NonNull IJDILibraryInjector libraryInjector;
    private static final @NonNull String DATA_BASE_DIR = "/data/data/";
    private static final long DEFAULT_JDI_CONNECTION_TIMEOUT = 10L;
    private static final @NonNull TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final int DEFAULT_APP_LAUNCH_TIMEOUT_IN_SECONDS = 20;
    private final long JDIConnectionTimeout;
    private final @NonNull TimeUnit timeoutUnit;
    private final int appLaunchTimeoutInSeconds;
    private static final @NonNull String INSTALLED_INTERCEPTOR_BASENAME = "libAGA.so";

    InjectableGLESPackageInterceptor(@NonNull ADBDevice device, @NonNull String packageName, @NonNull IADBWrapper adbWrapper, @NonNull IAndroidBridgeFile hostInterceptorFile, @Nullable IADBExecutor adbExecutor, @NonNull IJDILibraryInjector libraryInjector, long JDIConnectionTimeout, @NonNull TimeUnit timeoutUnit, int appLaunchTimeoutInSeconds) {
        super(device, packageName, adbWrapper, hostInterceptorFile, adbExecutor);
        this.libraryInjector = libraryInjector;
        this.JDIConnectionTimeout = JDIConnectionTimeout;
        this.timeoutUnit = timeoutUnit;
        this.appLaunchTimeoutInSeconds = appLaunchTimeoutInSeconds;
    }

    public InjectableGLESPackageInterceptor(@NonNull ADBDevice device, @NonNull String packageName, @NonNull IADBWrapper adbWrapper, @NonNull IAndroidBridgeFile hostInterceptorFile) {
        super(device, packageName, adbWrapper, hostInterceptorFile, null);
        this.libraryInjector = JDILibraryInjector::injectLibrary;
        this.JDIConnectionTimeout = 10L;
        this.timeoutUnit = DEFAULT_TIMEOUT_UNIT;
        this.appLaunchTimeoutInSeconds = 20;
    }

    @Override
    public @NonNull String getInstalledInterceptorBasename() {
        return INSTALLED_INTERCEPTOR_BASENAME;
    }

    @Override
    protected @NonNull String getAPIName() {
        return "OpenGL ES";
    }

    @Override
    public boolean launchPackageInDebugMode() {
        return true;
    }

    @Override
    public void onApplicationLaunch() throws IADBTask.ADBException {
        IADBExecutor executor = this.getADBExecutor();
        IADBWrapper wrapper = this.getADBWrapper();
        ADBDevice device = this.getDevice();
        boolean injected = false;
        int timeWaitedInSeconds = 0;
        while (timeWaitedInSeconds < this.appLaunchTimeoutInSeconds) {
            Set<Integer> pidSet = wrapper.getPID(executor, device, this.getPackageName());
            if (pidSet.size() == 1) {
                Integer pid = (Integer)pidSet.stream().findAny().orElseThrow(() -> new AssertionError((Object)"Process ID must exist here"));
                this.injectLibrary(pid);
                injected = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IADBTask.ADBException(e);
            }
            ++timeWaitedInSeconds;
        }
        if (!injected) {
            throw new IADBTask.ADBExecutionException("Timed out waiting for package to launch.");
        }
    }

    public @NonNull String getInstalledInterceptorLocation() {
        return DATA_BASE_DIR + this.getPackageName() + "/" + this.getInstalledInterceptorBasename();
    }

    private void injectLibrary(@NonNull Integer pid) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        IADBExecutor executor = this.getADBExecutor();
        IADBWrapper wrapper = this.getADBWrapper();
        ADBDevice device = this.getDevice();
        ADBForwardedPort forwardedPort = wrapper.createNewForwardedPort(executor, device, "jdwp:" + pid.toString());
        try {
            this.libraryInjector.injectLibrary(forwardedPort.getHostPort(), this.getInstalledInterceptorLocation(), this.JDIConnectionTimeout, this.timeoutUnit);
        }
        catch (Throwable e) {
            throw new IADBTask.ADBExecutionException(e);
        }
    }

    @FunctionalInterface
    public static interface IJDILibraryInjector {
        public void injectLibrary(int var1, @NonNull String var2, long var3, @NonNull TimeUnit var5) throws Throwable;
    }
}

