/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.util.HashUtils;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IAndroidBridgeFile {
    public @NonNull String getAbsolutePath();

    default public @NonNull File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public @NonNull String getFileName();

    public long getLength();

    public byte @NonNull [] getMD5() throws IADBTask.InvalidADBException;

    public static @NonNull IAndroidBridgeFile create(final @NonNull File file) throws IADBTask.InvalidADBException {
        Path absolutePath;
        final Path filePath = file.toPath();
        try {
            absolutePath = (Path)NullUtils.neverNull((Object)filePath.toAbsolutePath());
        }
        catch (Throwable t) {
            throw new IADBTask.InvalidADBException(t);
        }
        final String absolutePathString = (String)NullUtils.neverNull((Object)absolutePath.toString());
        final String fileName = (String)NullUtils.neverNull((Object)absolutePath.getFileName().toString());
        return new IAndroidBridgeFile(){
            private byte @Nullable [] fileMD5 = null;
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            public @NonNull String getAbsolutePath() {
                return absolutePathString;
            }

            @Override
            public @NonNull String getFileName() {
                return fileName;
            }

            private byte @NonNull [] getMD5uncached() throws IADBTask.InvalidADBException {
                byte[] fileBytes;
                try {
                    fileBytes = Files.readAllBytes(filePath);
                }
                catch (IOException e) {
                    throw new IADBTask.InvalidADBException(e);
                }
                return HashUtils.getMD5Hash(NullUtils.neverNull((byte[])fileBytes));
            }

            @Override
            public byte @NonNull [] getMD5() throws IADBTask.InvalidADBException {
                if (this.fileMD5 == null) {
                    this.fileMD5 = this.getMD5uncached();
                }
                if (!$assertionsDisabled && this.fileMD5 == null) {
                    throw new AssertionError();
                }
                return this.fileMD5;
            }

            @Override
            public long getLength() {
                return file.length();
            }
        };
    }
}

