/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBForwardedPort;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.ADBWrapper;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IADBWrapper {
    public static @NonNull IADBWrapper create(@NonNull String adbPath) {
        return new ADBWrapper(adbPath);
    }

    public @NonNull String getADBPath();

    public void validateADBIsUsable(@NonNull IADBExecutor var1) throws IADBTask.InvalidADBException;

    public void startADBServer(@NonNull IADBExecutor var1, @NonNull ADBDevice var2) throws IADBTask.InvalidADBException;

    public @NonNull List<@NonNull ADBDeviceIdentifier> getDeviceIdentifiers(@NonNull IADBExecutor var1) throws IADBTask.InvalidADBException;

    public @NonNull ADBDevice getDevice(@NonNull IADBExecutor var1, @NonNull ADBDeviceIdentifier var2) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException, ADBDeviceStillBootingException;

    public @NonNull ADBDeviceIdentifier getDeviceIdentifierForIDString(@NonNull IADBExecutor var1, @NonNull String var2) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException, ADBDeviceStillBootingException;

    public @NonNull String getDeviceProperty(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public @Nullable String getGlobalDeviceSetting(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public void setDeviceProperty(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void setGlobalDeviceSetting(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void deleteGlobalDeviceSetting(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    default public @Nullable String setLastValueOfGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key, @NonNull String valueToSet) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        Stream<String> newItem;
        String originalValue = this.getGlobalDeviceSetting(executor, device, key);
        if (originalValue == null || originalValue.strip().isEmpty()) {
            this.setGlobalDeviceSetting(executor, device, key, valueToSet);
            return originalValue;
        }
        String strippedOriginal = originalValue.strip();
        String[] parts = strippedOriginal.split(IADBWrapper.getAndroidSettingDelimiter());
        Stream<String> originalItems = Arrays.stream(parts).filter(p -> !p.contentEquals(valueToSet));
        @NonNull String newValue = Stream.concat(originalItems, newItem = Stream.of(valueToSet)).collect(Collectors.joining(IADBWrapper.getAndroidSettingDelimiter(), "", ""));
        if (!newValue.contentEquals(strippedOriginal)) {
            this.setGlobalDeviceSetting(executor, device, key, newValue);
        }
        return originalValue;
    }

    default public @Nullable String setFirstValueOfGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key, @NonNull String valueToSet) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String originalValue = this.getGlobalDeviceSetting(executor, device, key);
        if (originalValue == null || originalValue.strip().isEmpty()) {
            this.setGlobalDeviceSetting(executor, device, key, valueToSet);
            return originalValue;
        }
        String strippedOriginal = originalValue.strip();
        String[] parts = strippedOriginal.split(IADBWrapper.getAndroidSettingDelimiter());
        Stream<String> originalItems = Arrays.stream(parts).filter(p -> !p.contentEquals(valueToSet));
        Stream<String> newItem = Stream.of(valueToSet);
        @NonNull String newValue = Stream.concat(newItem, originalItems).collect(Collectors.joining(IADBWrapper.getAndroidSettingDelimiter(), "", ""));
        if (!newValue.contentEquals(strippedOriginal)) {
            this.setGlobalDeviceSetting(executor, device, key, newValue);
        }
        return originalValue;
    }

    default public @Nullable String removeValueFromGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key, @NonNull String valueToRemove, boolean deleteOnEmpty) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String originalValue = this.getGlobalDeviceSetting(executor, device, key);
        if (originalValue == null || !originalValue.contains(valueToRemove)) {
            return originalValue;
        }
        String stringToSet = IADBWrapper.removeAndroidSettingFromString(originalValue, valueToRemove);
        if (!stringToSet.contentEquals(originalValue.strip())) {
            if (deleteOnEmpty && stringToSet.isBlank()) {
                this.deleteGlobalDeviceSetting(executor, device, key);
            } else {
                this.setGlobalDeviceSetting(executor, device, key, stringToSet);
            }
        }
        return originalValue;
    }

    private static @NonNull String removeAndroidSettingFromString(@NonNull String settings, @NonNull String valueToRemove) {
        String strippedSettings = settings.strip();
        String[] parts = strippedSettings.split(IADBWrapper.getAndroidSettingDelimiter());
        String stringToSet = Arrays.stream(parts).filter(p -> !p.contentEquals(valueToRemove)).collect(Collectors.joining(IADBWrapper.getAndroidSettingDelimiter(), "", ""));
        return (String)NullUtils.neverNull((Object)stringToSet);
    }

    private static @NonNull String getAndroidSettingDelimiter() {
        return ":";
    }

    default public @NonNull ADBForwardedPort getNewOrExistingForwardedPort(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String targetPort) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        Optional<ADBForwardedPort> existingPort;
        String deviceID = device.getID();
        long duplicateIdCount = NullUtils.filteredStream(this.getDeviceIdentifiers(executor), identifier -> deviceID.equals(identifier.getID())).count();
        if (duplicateIdCount == 0L) {
            throw new IADBTask.ADBExecutionException("Device " + device + " is no longer connected");
        }
        if (duplicateIdCount == 1L && (existingPort = this.getForwardedPorts(executor).stream().filter(port -> port.getID().equals(device.getID()) && port.getDevicePort().equals(targetPort)).findAny()).isPresent()) {
            return (ADBForwardedPort)NullUtils.neverNull((Object)existingPort.get());
        }
        return this.createNewForwardedPort(executor, device, targetPort);
    }

    public @NonNull ADBForwardedPort createNewForwardedPort(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull List<@NonNull ADBForwardedPort> getForwardedPorts(@NonNull IADBExecutor var1) throws IADBTask.InvalidADBException;

    public void removeAllForwardedPorts(@NonNull IADBExecutor var1) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull List<@NonNull ADBInstalledPackage> getInstalledPackages(@NonNull IADBExecutor var1, @NonNull ADBDevice var2) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull List<@NonNull ADBInstalledPackage> getInstalledPackages(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, boolean var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull List<@NonNull ADBInstalledPackage> getDebuggablePackages(@NonNull IADBExecutor var1, @NonNull ADBDevice var2) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull List<@NonNull ADBInstalledPackage> getDebuggablePackages(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, boolean var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void installApplication(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void uninstallApplication(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public boolean isAPKInstalledOnDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull String getDumpsysOutputForPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public @NonNull String getInstalledPackageVersion(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void pushFileToDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void pushFileToDeviceAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4, @NonNull String var5) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    default public void pushFileToDeviceAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String hostFilePath, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.pushFileToDeviceAsPackage(executor, device, hostFilePath, ".", packageName);
    }

    public boolean doesFileExistOnDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public boolean doesFileExistOnDeviceAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public boolean doesFileExistOnDeviceWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public String @NonNull [] getMountPoints(@NonNull IADBExecutor var1, @NonNull ADBDevice var2) throws IADBTask.InvalidADBException;

    public @NonNull String getMountPointForPath(String var1, String[] var2);

    public @NonNull String getMountPointForPath(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public void remountPartitionAsReadWritableWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void copyFileWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void copyFileAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4, @NonNull String var5) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void moveFileWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void createSymlinkWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void createHardLinkWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void deleteFile(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void deleteFileWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void deleteFileAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void createFolderRecursivelyWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void setAccessPermissionForFileAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4, @NonNull String var5) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void setAccessPermissionForFileWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void setAccessPermissionForDirectoryWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public byte @NonNull [] getMD5Digest(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public long getFreeSpaceForPartition(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void startService(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException;

    public void startServiceWithFlags(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, String ... var4) throws IADBTask.InvalidADBException;

    public void waitUntilServiceRunningOnDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, long var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void forceStopAndroidApplicationFromNamedPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public void rebootDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2) throws IADBTask.InvalidADBException;

    public void launchIntentOnDevice(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, boolean var4) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public boolean checkIfProcessIsRunning(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public int getProcessIDForNamedProcess(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull String getLogcatOutputForTag(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.InvalidADBException;

    public void deleteFolderRecursivelyWithRoot(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException;

    public @NonNull IADBExecutor.IResult runAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, String var4) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException;

    public boolean killAllAsPackage(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3, @NonNull String var4) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException;

    public @NonNull Set<@NonNull Integer> getPID(@NonNull IADBExecutor var1, @NonNull ADBDevice var2, @NonNull String var3) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException;

    public static class ADBDeviceStillBootingException
    extends Exception {
        private static final long serialVersionUID = 8953691812890966686L;
    }
}

