/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.IDaemonRunner;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GADaemonRunner
implements IDaemonRunner {
    private final @NonNull ADBDevice device;
    private final @NonNull ADBInstalledPackage app;
    private final @NonNull IAndroidBridgeFile daemonFile;
    private final @NonNull IADBWrapper adbWrapper;
    private final @NonNull ProcessBuilder processBuilder;
    private @Nullable Process process;

    public GADaemonRunner(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull IAndroidBridgeFile daemonFile, @NonNull IADBWrapper adbWrapper) {
        this.device = device;
        this.app = app;
        this.daemonFile = daemonFile;
        this.adbWrapper = adbWrapper;
        List<String> tokens = Arrays.asList(adbWrapper.getADBPath(), "-s", device.getIdentifier().getQualifier(), "shell", "run-as", "'" + app.getPackageName() + "'", "'./" + daemonFile.getFileName() + "'", "--port", "UDS", "--exitOnHostDisconnect", "</dev/null", ">", "'" + this.getDaemonLogFilename() + "'", "2>&1");
        this.processBuilder = new ProcessBuilder(tokens);
        this.processBuilder.redirectErrorStream(true);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.process == null) {
            this.process = this.processBuilder.start();
        }
    }

    @Override
    public synchronized void stop() throws IOException, InterruptedException, IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        Process p = this.process;
        if (p != null) {
            p.destroy();
            this.adbWrapper.killAllAsPackage(new SynchronousADBExecutor(30L, TimeUnit.SECONDS), this.device, this.app.getPackageName(), this.daemonFile.getFileName());
            this.process = null;
        }
    }

    @Override
    public synchronized boolean isRunning() {
        Process p = this.process;
        return p != null && p.isAlive();
    }

    private @NonNull String getDaemonLogFilename() {
        @NonNull String safePackageName = (String)NullUtils.neverNull((Object)this.app.getPackageName().replaceAll("\\W", "_"));
        return "/data/local/tmp/" + this.daemonFile.getFileName() + "_" + safePackageName + ".log";
    }
}

