/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.AndroidSDKVersion;
import com.arm.mgd.utils.NullUtils;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class DumpsysOutputParser {
    private static final @NonNull String ANDROID_MAIN_INTENT_MODERN_ANDROID = "\"android.intent.action.MAIN\"";
    private static final @NonNull String ANDROID_MAIN_INTENT_ANDROID_6 = " android.intent.action.MAIN:";
    private static final @NonNull String ANDROID_6_ACTIVITY_NAME_INDENT = "        ";
    private static final @NonNull String MODERN_ANDROID_ATTRIBUTE_INDENT = "          ";
    private static final @NonNull String QUALIFIED_PATTERN_STRING_ANDROID_6 = " +[0-9a-f]+ %s/(.+)";
    private static final @NonNull String QUALIFIED_PATTERN_STRING_MODERN_ANDROID = " +[0-9a-f]+ %s/(.+) filter [0-9a-f]+";
    private static final @NonNull String PRIMARYCPU_ABI_STRING = "primaryCpuAbi=";

    private DumpsysOutputParser() {
    }

    public static @NonNull Set<@NonNull String> getMainActivitiesFromModernAndroidOutput(@NonNull String output, @NonNull String packageName) {
        HashSet<@NonNull String> activities = new HashSet<String>();
        Pattern qualifiedPattern = Pattern.compile(String.format(QUALIFIED_PATTERN_STRING_MODERN_ANDROID, Pattern.quote(packageName)));
        String activityName = null;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(output);){
            while (scanner.hasNextLine()) {
                Matcher qualifiedMatcher;
                String line = scanner.nextLine();
                if (activityName != null) {
                    if (!line.startsWith(MODERN_ANDROID_ATTRIBUTE_INDENT)) {
                        activityName = null;
                        continue;
                    }
                    if (line.contains(ANDROID_MAIN_INTENT_MODERN_ANDROID)) {
                        activities.add(activityName);
                        activityName = null;
                        continue;
                    }
                }
                if (!(qualifiedMatcher = qualifiedPattern.matcher(line)).matches()) continue;
                activityName = qualifiedMatcher.group(1);
                assert (activityName != null);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return activities;
    }

    public static @NonNull Set<@NonNull String> getMainActivitiesFromAndroid6Output(@NonNull String output, @NonNull String packageName) {
        HashSet<@NonNull String> activities = new HashSet<String>();
        boolean foundMainSection = false;
        Pattern qualifiedPattern = Pattern.compile(String.format(QUALIFIED_PATTERN_STRING_ANDROID_6, Pattern.quote(packageName)));
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(output);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!foundMainSection) {
                    foundMainSection = line.contains(ANDROID_MAIN_INTENT_ANDROID_6);
                    continue;
                }
                if (!line.startsWith(ANDROID_6_ACTIVITY_NAME_INDENT)) {
                    break;
                }
                Matcher qualifiedMatcher = qualifiedPattern.matcher(line);
                if (!qualifiedMatcher.matches()) continue;
                @NonNull String activityName = (String)NullUtils.neverNull((Object)qualifiedMatcher.group(1));
                activities.add(activityName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return activities;
    }

    public static @NonNull Set<@NonNull String> getMainActivitiesFromDeviceOutput(@NonNull ADBDevice device, @NonNull String output, @NonNull String packageName) {
        if (device.getSDKAPILevel() > AndroidSDKVersion.MARSHMALLOW_6_0_0.apiLevel) {
            return DumpsysOutputParser.getMainActivitiesFromModernAndroidOutput(output, packageName);
        }
        return DumpsysOutputParser.getMainActivitiesFromAndroid6Output(output, packageName);
    }

    public static ADBDevice.Architecture getPrimaryCPUAbi(@NonNull String output) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner scanner = new Scanner(output);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (!line.startsWith(PRIMARYCPU_ABI_STRING)) continue;
                @NonNull String abiString = line.substring(PRIMARYCPU_ABI_STRING.length());
                return ADBDevice.Architecture.parseArchitecture(abiString);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ADBDevice.Architecture.UNKNOWN;
    }
}

