/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.GADaemonRunner;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.adb.IDaemonRunner;
import com.arm.mgd.core.adb.IPackageInterceptor;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidPackageTraceManager
implements IAndroidPackageTraceManager {
    private @NonNull IAndroidPackageTraceManager.TraceLifecycleState lifecycleState = IAndroidPackageTraceManager.TraceLifecycleState.UNTRACED;
    private final @NonNull Set<Consumer<IAndroidPackageTraceManager.TraceLifecycleState>> lifecycleCallbacks = new HashSet<Consumer<IAndroidPackageTraceManager.TraceLifecycleState>>();
    private final @NonNull ADBDevice device;
    private final @NonNull ADBInstalledPackage app;
    private final @NonNull IADBWrapper adbWrapper;
    private final @NonNull IADBExecutor adbExecutor;
    private final @NonNull String activity;
    private final @NonNull IAndroidBridgeFile daemonFile;
    private final @NonNull String daemonBaseName;
    private @NonNull IDaemonRunner daemonRunner;
    private final @NonNull List<@NonNull IPackageInterceptor> driverList;
    private @NonNull ICoreProgressMonitor monitor = ICoreProgressMonitor.NULL_MONITOR;
    private static final int WORK_FOR_EACH_TASK = 100;

    AndroidPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity, @NonNull List<@NonNull IPackageInterceptor> driverList, @NonNull IAndroidBridgeFile daemonFile, @NonNull IADBWrapper adbWrapper, @Nullable IADBExecutor adbExecutor, @Nullable IDaemonRunner daemonRunner) {
        this.device = device;
        this.app = app;
        this.activity = activity;
        this.driverList = driverList;
        this.daemonFile = daemonFile;
        this.daemonBaseName = (String)NullUtils.neverNull((Object)daemonFile.getFileName());
        this.adbWrapper = adbWrapper;
        this.adbExecutor = adbExecutor == null ? new SynchronousADBExecutor(30L, TimeUnit.SECONDS) : adbExecutor;
        this.daemonRunner = daemonRunner == null ? new GADaemonRunner(device, app, daemonFile, adbWrapper) : daemonRunner;
    }

    public AndroidPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity, @NonNull List<@NonNull IPackageInterceptor> driverList, @NonNull IAndroidBridgeFile daemonFile, @NonNull IADBWrapper adbWrapper) {
        this(device, app, activity, driverList, daemonFile, adbWrapper, null, null);
    }

    @Override
    public IAndroidPackageTraceManager.TraceLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    public synchronized void registerLifecycleCallback(@NonNull Consumer<IAndroidPackageTraceManager.TraceLifecycleState> callback) {
        this.lifecycleCallbacks.add(callback);
    }

    @Override
    public void setProgressMonitor(@NonNull ICoreProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private synchronized void setLifecycleState(@NonNull IAndroidPackageTraceManager.TraceLifecycleState lifecycleState) {
        if (this.lifecycleState != lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.lifecycleCallbacks.forEach(callback -> callback.accept(lifecycleState));
        }
    }

    @Override
    public void prepareCapture() throws IADBTask.ADBException {
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.UNTRACED) : "prepareCapture() not called over untraced app";
        try {
            this.installInterceptors();
            this.installGADaemon();
            this.runGADaemon();
        }
        catch (IADBTask.ADBException e) {
            StringBuilder errorDescription = new StringBuilder("While installing the application-level tracing components: ").append(e.getLocalizedMessage());
            try {
                this.close();
            }
            catch (IADBTask.ADBException closeException) {
                errorDescription.append(". Further errors occurred removing successfully installed components. ").append(closeException.getLocalizedMessage());
            }
            throw new IADBTask.ADBExecutionException((String)NullUtils.neverNull((Object)errorDescription.toString()));
        }
    }

    private void runGADaemon() throws IADBTask.ADBException {
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.DAEMON_STOPPED) : "Invalid state: daemon is supposed to be installed but stopped";
        try {
            this.monitor.setTask("Launching GA daemon", 100);
            this.daemonRunner.start();
            this.monitor.incProgress(100);
            if (!this.daemonRunner.isRunning()) {
                throw new IADBTask.ADBExecutionException("Can't launch Graphics Analyzer daemon (" + this.daemonBaseName + ")");
            }
        }
        catch (IADBTask.ADBException | IOException e) {
            @NonNull ArrayList<@NonNull Throwable> removalExceptions = new ArrayList<Throwable>();
            this.stopGADaemon(removalExceptions);
            if (!removalExceptions.isEmpty()) {
                CoreLogging.warning(null, "Can't stop daemon after launch failure (but daemon might not have been started): " + AndroidPackageTraceManager.describe(removalExceptions));
            }
            throw new IADBTask.ADBException((String)NullUtils.neverNull((Object)e.getMessage()));
        }
        this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.READY_TO_TRACE);
    }

    private void installGADaemon() throws IADBTask.ADBException {
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.INTERCEPTOR_INSTALLED) : "Invalid state: interceptors must be installed by this stage";
        try {
            this.monitor.setTask("Installing GA daemon", 100);
            this.adbWrapper.pushFileToDeviceAsPackage(this.adbExecutor, this.device, (String)NullUtils.neverNull((Object)this.daemonFile.getAbsolutePath()), this.daemonBaseName, this.app.getPackageName());
            this.adbWrapper.setAccessPermissionForFileAsPackage(this.adbExecutor, this.device, this.daemonBaseName, "777", this.app.getPackageName());
            this.monitor.incProgress(100);
        }
        catch (IADBTask.ADBException e) {
            @NonNull ArrayList<@NonNull Throwable> removalExceptions = new ArrayList<Throwable>();
            this.deleteDaemon(removalExceptions);
            if (!removalExceptions.isEmpty()) {
                CoreLogging.warning(null, "Can't delete daemon after installation failure (but daemon might not have been installed): " + AndroidPackageTraceManager.describe(removalExceptions));
            }
            throw e;
        }
        this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.DAEMON_STOPPED);
    }

    private void installInterceptors() throws IADBTask.ADBException {
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.UNTRACED) : "Invalid state: interceptor installation should be first step";
        if (this.driverList.isEmpty()) {
            CoreLogging.info(null, "Not installing interceptors");
        } else {
            @NonNull ArrayList<@NonNull IPackageInterceptor> attemptedDriverInstallations = new ArrayList<IPackageInterceptor>();
            try {
                this.monitor.setTask("Installing interceptors", 100);
                int workForEachDriver = 100 / this.driverList.size();
                for (IPackageInterceptor driver : this.driverList) {
                    attemptedDriverInstallations.add(driver);
                    driver.insert();
                    this.monitor.incProgress(workForEachDriver);
                }
                this.monitor.incProgress(100 - workForEachDriver * this.driverList.size());
            }
            catch (IADBTask.ADBException e) {
                @NonNull ArrayList<@NonNull Throwable> removalExceptions = new ArrayList<Throwable>();
                this.removeDrivers(attemptedDriverInstallations, removalExceptions);
                if (!removalExceptions.isEmpty()) {
                    CoreLogging.warning(null, "Can't remove driver(s) after installation failure (but driver(s) might not have been installed): " + AndroidPackageTraceManager.describe(removalExceptions));
                }
                throw e;
            }
        }
        this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.INTERCEPTOR_INSTALLED);
    }

    private void stopGADaemon(@NonNull List<@NonNull Throwable> removalExceptions) {
        this.monitor.setTask("Stopping GA daemon", 100);
        try {
            this.daemonRunner.stop();
        }
        catch (IADBTask.ADBExecutionException | IADBTask.InvalidADBException | IOException | InterruptedException e) {
            removalExceptions.add(e);
        }
        this.monitor.incProgress(100);
    }

    private void deleteDaemon(@NonNull List<@NonNull Throwable> removalExceptions) {
        this.monitor.setTask("Removing GA daemon", 100);
        try {
            this.adbWrapper.deleteFileAsPackage(this.adbExecutor, this.device, this.app.getPackageName(), this.daemonBaseName);
        }
        catch (IADBTask.ADBExecutionException | IADBTask.InvalidADBException e) {
            removalExceptions.add(e);
        }
        this.monitor.incProgress(100);
    }

    private static @NonNull String describe(@NonNull List<@NonNull Throwable> throwables) {
        String description = throwables.stream().map(Throwable::getLocalizedMessage).collect(Collectors.joining("; "));
        return (String)NullUtils.neverNull((Object)description);
    }

    private void removeDrivers(@NonNull List<@NonNull IPackageInterceptor> drivers, @NonNull List<@NonNull Throwable> removalExceptions) {
        this.monitor.setTask("Removing layers", 100);
        int workForEachDriver = this.driverList.isEmpty() ? 100 : 100 / this.driverList.size();
        @NonNull ArrayDeque<@NonNull IPackageInterceptor> driversForRemoval = new ArrayDeque<IPackageInterceptor>(drivers);
        while (!driversForRemoval.isEmpty()) {
            try {
                ((IPackageInterceptor)driversForRemoval.removeLast()).close();
            }
            catch (IADBTask.ADBException e) {
                removalExceptions.add(e);
            }
            this.monitor.incProgress(workForEachDriver);
        }
        this.monitor.incProgress(100 - workForEachDriver * this.driverList.size());
    }

    @Override
    public void startPackage() throws IADBTask.ADBException {
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.READY_TO_TRACE) : "prepareCapture() should be called before startPackage()";
        this.monitor.setTask("Killing the app (if already running)", 100);
        this.adbWrapper.forceStopAndroidApplicationFromNamedPackage(this.adbExecutor, this.device, this.app.getPackageName());
        this.monitor.incProgress(100);
        this.monitor.setTask("Launching the activity", 100);
        @NonNull String intentToLaunch = this.app.getLaunchableIntent(this.activity);
        this.monitor.setSubTask("Launching " + intentToLaunch);
        boolean launchInDebugMode = this.driverList.stream().anyMatch(IPackageInterceptor::launchPackageInDebugMode);
        this.adbWrapper.launchIntentOnDevice(this.adbExecutor, this.device, intentToLaunch, launchInDebugMode);
        for (IPackageInterceptor driver : this.driverList) {
            driver.onApplicationLaunch();
        }
        this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.TRACING);
        this.monitor.incProgress(100);
    }

    @Override
    public void close() throws IADBTask.ADBException {
        @NonNull ArrayList<@NonNull Throwable> removalExceptions = new ArrayList<Throwable>();
        if (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.UNTRACED) {
            return;
        }
        if (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.TRACING) {
            this.stopAndroidApplication(removalExceptions);
            this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.READY_TO_TRACE);
        }
        if (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.READY_TO_TRACE) {
            this.stopGADaemon(removalExceptions);
            this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.DAEMON_STOPPED);
        }
        if (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.DAEMON_STOPPED) {
            this.deleteDaemon(removalExceptions);
            this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.INTERCEPTOR_INSTALLED);
        }
        assert (this.getLifecycleState() == IAndroidPackageTraceManager.TraceLifecycleState.INTERCEPTOR_INSTALLED) : "interceptor expected to be installed without daemon or app running";
        this.removeDrivers(this.driverList, removalExceptions);
        this.setLifecycleState(IAndroidPackageTraceManager.TraceLifecycleState.UNTRACED);
        if (!removalExceptions.isEmpty()) {
            throw new IADBTask.ADBExecutionException("When uninstalling application-level tracing components: " + AndroidPackageTraceManager.describe(removalExceptions));
        }
    }

    private void stopAndroidApplication(@NonNull List<@NonNull Throwable> removalExceptions) {
        this.monitor.setTask("Stopping Android application", 100);
        try {
            this.adbWrapper.forceStopAndroidApplicationFromNamedPackage(this.adbExecutor, this.device, this.app.getPackageName());
        }
        catch (IADBTask.ADBException e) {
            removalExceptions.add(e);
        }
        this.monitor.incProgress(100);
    }

    @Override
    public @NonNull ADBDevice getDevice() {
        return this.device;
    }

    @Override
    public @NonNull IADBExecutor getExecutor() {
        return this.adbExecutor;
    }
}

