/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBTaskDescription;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.AndroidBridgeTask;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.util.CoreLogging;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidConnector {
    protected final @NonNull IADBWrapper wrapper;
    protected static final @NonNull String LOCALHOST = "127.0.0.1";
    protected static final int DEFAULT_HOST_PORT = 5002;
    private static final String ANDROID_DAEMON_SOCKET_NAME = "localabstract:aga-daemon-host";

    public AndroidConnector(@NonNull IADBWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public @NonNull IADBTask<Void> connectToDevice(@NonNull ADBDevice device, @NonNull ConnectToDeviceCallback callback) {
        return this.createTask(device, AndroidBridge.ConnectionOperationTag.CONNECT_TAG, (IADBExecutor executor) -> {
            int hostPort;
            try {
                hostPort = this.wrapper.getNewOrExistingForwardedPort(executor, device, ANDROID_DAEMON_SOCKET_NAME).getHostPort();
            }
            catch (IADBTask.ADBExecutionException e) {
                CoreLogging.warning(null, "Failed to set up port forwarding; using default local port 5002");
                hostPort = 5002;
            }
            boolean connected = callback.doConnect(LOCALHOST, hostPort);
            if (!connected) {
                throw new IADBTask.ADBExecutionException("Could not complete connection to device");
            }
            return null;
        });
    }

    protected <T> @NonNull IADBTask<T> createTask(@Nullable ADBDevice device, @NonNull ADBTaskDescription description, @NonNull AndroidBridgeTask.ADBTaskSupplier<T> task) {
        return this.createTask(device, description, null, task);
    }

    protected <T> @NonNull IADBTask<T> createTask(@Nullable ADBDevice device,  @NonNull AndroidBridge.ConnectionOperationTag tag, @NonNull AndroidBridgeTask.ADBTaskSupplier<T> task) {
        return this.createTask(device, tag.description, tag, task);
    }

    protected <T> @NonNull IADBTask<T> createTask(@Nullable ADBDevice device, @NonNull ADBTaskDescription description, @Nullable AndroidBridgeTask.ITaskTag tag, @NonNull AndroidBridgeTask.ADBTaskSupplier<T> task) {
        return new AndroidBridgeTask<Object>(device, description, tag, executor -> {
            this.wrapper.validateADBIsUsable(executor);
            if (device != null) {
                this.wrapper.startADBServer(executor, device);
                List<@NonNull ADBDeviceIdentifier> identifiers = this.wrapper.getDeviceIdentifiers(executor);
                if (!identifiers.contains(device.getIdentifier())) {
                    throw new IADBTask.ADBExecutionException("Device is no longer connected");
                }
            }
            return task.get(executor);
        });
    }

    @FunctionalInterface
    public static interface ConnectToDeviceCallback {
        public boolean doConnect(@NonNull String var1, int var2);
    }
}

