/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBForwardedPort;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.ADBTaskDescription;
import com.arm.mgd.core.adb.AndroidBridgeTask;
import com.arm.mgd.core.adb.AndroidConnector;
import com.arm.mgd.core.adb.AndroidPackageTraceManager;
import com.arm.mgd.core.adb.AndroidSDKVersion;
import com.arm.mgd.core.adb.EmptyGLESPackageLayerDriver;
import com.arm.mgd.core.adb.EmptyVulkanPackageLayerDriver;
import com.arm.mgd.core.adb.GLESPackageLayerDriver;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.adb.IAndroidBridgeFile;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.adb.IPackageInterceptor;
import com.arm.mgd.core.adb.InjectableGLESPackageInterceptor;
import com.arm.mgd.core.adb.VulkanPackageLayerDriver;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidBridge
extends AndroidConnector {
    private static final @NonNull String VULKAN_SHARED_LIBRARY_BASENAME = "libVkLayerAGA.so";
    private static final @NonNull String TARGET_INSTALL_DIRECTORY_MARSHMALLOW = "/data/local/debug/";
    private static final @NonNull String TARGET_VULKAN_LAYER_INSTALL_DIRECTORY_MARSHMALLOW = "/data/local/debug/vulkan/";
    private static final @NonNull String TARGET_VULKAN_LAYER_LOCATION_32_MARSHMALLOW = "/data/local/debug/vulkan/libVkLayerAGA.so";
    private static final @NonNull String TARGET_VULKAN_LAYER_LOCATION_64_MARSHMALLOW = "/data/local/debug/vulkan/libVkLayerAGA64.so";
    private static final @NonNull String @NonNull [] TARGET_VULKAN_LAYER_LOCATION_SUBPATHS_MARSHMALLOW = new String[]{"/data/local/debug/", "/data/local/debug/vulkan/"};
    private static final @NonNull String TARGET_VULKAN_LAYER_INSTALL_DIRECTORY = "/system/";
    private static final @NonNull String TARGET_VULKAN_LAYER_LOCATION_32 = "/system/fake-libs/libVkLayerAGA.so";
    private static final @NonNull String TARGET_VULKAN_LAYER_LOCATION_64 = "/system/fake-libs64/libVkLayerAGA.so";
    private static final @NonNull String @NonNull [] TARGET_VULKAN_LAYER_LOCATION_SUBPATHS = new String[0];
    private static final @NonNull String TARGET_REPLAY_DIRECTORY = "/sdcard/mgd/replay/";
    private static final @NonNull String TARGET_COUNTER_CONFIG_PARTITION = "/data";
    private static final @NonNull String TARGET_COUNTER_CONFIG_DIRECTORY = "/data/data/com.mali.testjava/";
    private static final @NonNull String TARGET_COUNTER_CONFIG_LOCATION = "/data/data/com.mali.testjava/.mali_config";
    private static final @NonNull String DEVICE_INFO_SERVICE_ID = "com.arm.mgd.androidapp/.replay.DeviceInfoService";
    private static final @NonNull String DEVICE_INFO_SERVICE_TAG = "DeviceInfoService";
    private final @NonNull IAndroidBridgeFile mgddaemonAArch32;
    private final @NonNull IAndroidBridgeFile interceptorAArch32;
    private final @NonNull IAndroidBridgeFile interceptorAArch32Layer;
    private final @NonNull IAndroidBridgeFile mgddaemonAArch64;
    private final @NonNull IAndroidBridgeFile interceptorAArch64;
    private final @NonNull IAndroidBridgeFile interceptorAArch64Layer;
    private final @NonNull String targetStorageDirectory;
    private final @NonNull IAndroidBridgeFile interceptorAArch32Vulkan;
    private final @NonNull IAndroidBridgeFile interceptorAArch64Vulkan;
    private static final @NonNull String VULKAN = "Vulkan";
    private static final @NonNull String OPENGL_ES = "OpenGL ES";
    private static final @NonNull String DRIVER_UNSUPPORTED_FOR_ARCHITECTURE_MESSAGE = "%s layer driver unsupported for your device architecture.";
    private static final @NonNull String DRIVER_UNSUPPORTED_FOR_DEVICE_MESSAGE = "Device does not support %s layer drivers. A driver must be installed into your app.";

    AndroidBridge(@NonNull IADBWrapper wrapper, @NonNull IAndroidBridgeFile mgddaemonAArch32, @NonNull IAndroidBridgeFile interceptorAArch32, @NonNull IAndroidBridgeFile interceptorAArch32Layer, @NonNull IAndroidBridgeFile mgddaemonAArch64, @NonNull IAndroidBridgeFile interceptorAArch64, @NonNull IAndroidBridgeFile interceptorAArch64Layer, @NonNull IAndroidBridgeFile vulkan_interceptor32, @NonNull IAndroidBridgeFile vulkan_interceptor64, @NonNull String targetStorageDirectory) {
        super(wrapper);
        this.mgddaemonAArch32 = mgddaemonAArch32;
        this.interceptorAArch32 = interceptorAArch32;
        this.interceptorAArch32Layer = interceptorAArch32Layer;
        this.mgddaemonAArch64 = mgddaemonAArch64;
        this.interceptorAArch64 = interceptorAArch64;
        this.interceptorAArch64Layer = interceptorAArch64Layer;
        this.targetStorageDirectory = targetStorageDirectory;
        this.interceptorAArch32Vulkan = vulkan_interceptor32;
        this.interceptorAArch64Vulkan = vulkan_interceptor64;
    }

    public static @NonNull IADBTask<@NonNull AndroidBridge> create(@NonNull String adbPath, @Nullable String mgdReleaseInstallRootDir, @Nullable String developmentRootDir) {
        return new AndroidBridgeTask<AndroidBridge>(null, ADBTaskDescription.INITIALIZE_ANDROID_BRIDGE, null, executor -> {
            IADBWrapper wrapper = IADBWrapper.create(adbPath);
            wrapper.validateADBIsUsable(executor);
            try {
                @NonNull String targetStorageDirectory = "/sdcard/";
                String mgddaemonAArch32ReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm/aga-daemon";
                String mgddaemonAArch32DevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-32/build/output/aga-daemon";
                String interceptorAArch32ReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm/libAGA.so";
                String interceptorAArch32DevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-32/build/output/libAGA.so";
                String interceptorAArch32LayerReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm/libGLES_layer_aga.so";
                String interceptorAArch32LayerDevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-layer-32/build/output/libGLES_layer_aga.so";
                String mgddaemonAArch64ReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm64/aga-daemon";
                String mgddaemonAArch64DevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-64/build/output/aga-daemon";
                String interceptorAArch64ReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm64/libAGA.so";
                String interceptorAArch64DevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-64/build/output/libAGA.so";
                String interceptorAArch64LayerReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm64/libGLES_layer_aga.so";
                String interceptorAArch64LayerDevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-layer-64/build/output/libGLES_layer_aga.so";
                String interceptorAArch32VulkanReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm/libVK_layer_aga.so";
                String interceptorAArch32VulkanDevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-vk-layer-32/build/output/libVK_layer_aga.so";
                String interceptorAArch64VulkanReleasePath = String.valueOf(mgdReleaseInstallRootDir) + "/target/android/arm64/libVK_layer_aga.so";
                String interceptorAArch64VulkanDevPath = String.valueOf(developmentRootDir) + "/native/interceptor/mvn/arm-android-vk-layer-64/build/output/libVK_layer_aga.so";
                IAndroidBridgeFile mgddaemonAArch32 = AndroidBridge.getAndroidBridgeFile(mgddaemonAArch32ReleasePath, mgddaemonAArch32DevPath);
                IAndroidBridgeFile interceptorAArch32 = AndroidBridge.getAndroidBridgeFile(interceptorAArch32ReleasePath, interceptorAArch32DevPath);
                IAndroidBridgeFile interceptorAArch32Layer = AndroidBridge.getAndroidBridgeFile(interceptorAArch32LayerReleasePath, interceptorAArch32LayerDevPath);
                IAndroidBridgeFile mgddaemonAArch64 = AndroidBridge.getAndroidBridgeFile(mgddaemonAArch64ReleasePath, mgddaemonAArch64DevPath);
                IAndroidBridgeFile interceptorAArch64 = AndroidBridge.getAndroidBridgeFile(interceptorAArch64ReleasePath, interceptorAArch64DevPath);
                IAndroidBridgeFile interceptorAArch64Layer = AndroidBridge.getAndroidBridgeFile(interceptorAArch64LayerReleasePath, interceptorAArch64LayerDevPath);
                IAndroidBridgeFile interceptorAArch32Vulkan = AndroidBridge.getAndroidBridgeFile(interceptorAArch32VulkanReleasePath, interceptorAArch32VulkanDevPath);
                IAndroidBridgeFile interceptorAArch64Vulkan = AndroidBridge.getAndroidBridgeFile(interceptorAArch64VulkanReleasePath, interceptorAArch64VulkanDevPath);
                if (mgddaemonAArch32 == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 32-bit daemon application.");
                }
                if (interceptorAArch32 == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 32-bit OpenGL ES interceptor library.");
                }
                if (interceptorAArch32Layer == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 32-bit OpenGL ES interceptor layer.");
                }
                if (mgddaemonAArch64 == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 64-bit daemon application.");
                }
                if (interceptorAArch64 == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 64-bit OpenGL ES interceptor library.");
                }
                if (interceptorAArch64Layer == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 64-bit OpenGL ES interceptor layer.");
                }
                if (interceptorAArch32Vulkan == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 32-bit Vulkan interceptor layer.");
                }
                if (interceptorAArch64Vulkan == null) {
                    throw new IADBTask.InvalidADBException("Couldn't find the 64-bit Vulkan interceptor layer.");
                }
                return new AndroidBridge(wrapper, mgddaemonAArch32, interceptorAArch32, interceptorAArch32Layer, mgddaemonAArch64, interceptorAArch64, interceptorAArch64Layer, interceptorAArch32Vulkan, interceptorAArch64Vulkan, "/sdcard/");
            }
            catch (IADBTask.InvalidADBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IADBTask.InvalidADBException("Could not determine installation location of MGD: " + e.getMessage());
            }
        });
    }

    private static @Nullable IAndroidBridgeFile getAndroidBridgeFile(String ... potentialPaths) {
        return Stream.of(potentialPaths).map(File::new).filter(File::exists).map(AndroidBridge::getAndroidBridgeFileUnsafe).findFirst().orElse(null);
    }

    private static IAndroidBridgeFile getAndroidBridgeFileUnsafe(File fileToWrap) {
        try {
            return IAndroidBridgeFile.create((File)NullUtils.neverNull((Object)fileToWrap));
        }
        catch (IADBTask.InvalidADBException e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    public @NonNull IADBTask<@NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice>> getDevices(@NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> existingDevices) {
        HashMap<@NonNull ADBDeviceIdentifier, ADBDevice> duplicateExistingDevices = new HashMap<ADBDeviceIdentifier, ADBDevice>(existingDevices);
        return this.createTask(null, ADBTaskDescription.GET_ADB_DEVICES, (IADBExecutor executor) -> {
            @NonNull List<@NonNull ADBDeviceIdentifier> identifiers = this.wrapper.getDeviceIdentifiers(executor);
            @NonNull HashMap<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> newDevices = new HashMap<ADBDeviceIdentifier, ADBDevice>();
            for (ADBDeviceIdentifier identifier : identifiers) {
                ADBDevice device = (ADBDevice)duplicateExistingDevices.get(identifier);
                if (device == null && identifier.getStatus() == ADBDeviceIdentifier.Status.DEVICE) {
                    try {
                        device = this.wrapper.getDevice(executor, identifier);
                    }
                    catch (IADBTask.ADBExecutionException e) {
                        CoreLogging.warning(null, e, "Unable to query information about device " + identifier.getID());
                        identifier = new ADBDeviceIdentifier(identifier.getID(), identifier.getQualifier(), ADBDeviceIdentifier.Status.ERROR);
                    }
                    catch (IADBWrapper.ADBDeviceStillBootingException aDBDeviceStillBootingException) {
                        // empty catch block
                    }
                }
                newDevices.put(identifier, device);
            }
            return newDevices;
        });
    }

    public @NonNull IADBTask<@NonNull List<@NonNull ADBForwardedPort>> getForwardedPorts() {
        return this.createTask(null, ADBTaskDescription.GET_FORWARDED_PORTS, (IADBExecutor executor) -> this.wrapper.getForwardedPorts(executor));
    }

    public @NonNull IADBTask<Void> removeAllForwardedPorts() {
        return this.createTask(null, ADBTaskDescription.REMOVE_ALL_FORWARDED_PORTS, (IADBExecutor executor) -> {
            this.wrapper.removeAllForwardedPorts(executor);
            return null;
        });
    }

    public @NonNull IADBTask<@NonNull ADBForwardedPort> getNewOrExistingForwardedPort(@NonNull ADBDevice device, @NonNull String targetPort) {
        return this.createTask(device, ADBTaskDescription.GET_NEW_OR_EXISTING_FORWARDED_PORT, (IADBExecutor executor) -> this.wrapper.getNewOrExistingForwardedPort(executor, device, targetPort));
    }

    public @NonNull IADBTask<@NonNull List<@NonNull ADBInstalledPackage>> getInstalledPackages(@NonNull ADBDevice device) {
        return this.createTask(device, ADBTaskDescription.GET_INSTALLED_PACKAGES, (IADBExecutor executor) -> this.wrapper.getInstalledPackages(executor, device));
    }

    public @NonNull IADBTask<Void> installAPILayerToApp(@NonNull IAndroidPackageTraceManager traceManager) {
        return this.createTask(traceManager.getDevice(), InstallableComponentOperationTag.PER_APP_TRACING_INSTALL_TAG, (IADBExecutor executor) -> {
            traceManager.prepareCapture();
            return null;
        });
    }

    public @NonNull IADBTask<Void> removeAPILayerFromApp(@NonNull IAndroidPackageTraceManager traceManager) {
        return this.createTask(traceManager.getDevice(), InstallableComponentOperationTag.PER_APP_TRACING_REMOVAL_TAG, (IADBExecutor executor) -> {
            traceManager.close();
            return null;
        });
    }

    public @NonNull IADBTask<@NonNull InstallableComponentStatus> getRootInterceptorInstallStatus(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_INTERCEPTOR_QUERY_STATUS_TAG, (IADBExecutor executor) -> {
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            ArrayList<@NonNull InstallableComponentStatus> statuses = new ArrayList<InstallableComponentStatus>();
            switch (architecture) {
                case AArch64: {
                    statuses.add(this.getRootFileInstallStatus(executor, device, this.interceptorAArch64, InterceptorLocationManager.getCanonicalInterceptorLocation64(device)));
                    statuses.add(this.getPathInstallStatus(executor, device, InterceptorLocationManager.getOtherInterceptorLocations64(device)));
                }
                case AArch32: {
                    statuses.add(this.getRootFileInstallStatus(executor, device, this.interceptorAArch32, InterceptorLocationManager.getCanonicalInterceptorLocation32(device)));
                    statuses.add(this.getPathInstallStatus(executor, device, InterceptorLocationManager.getOtherInterceptorLocations32(device)));
                    break;
                }
                default: {
                    return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH;
                }
            }
            InstallableComponentStatus status = AndroidBridge.getAggregateInstallationStatus(statuses);
            if (!device.isRooted() && status == InstallableComponentStatus.NOT_INSTALLED) {
                return InstallableComponentStatus.NOT_INSTALLED_NOT_ROOTED;
            }
            return status;
        });
    }

    public @NonNull InstallableComponentStatus getGLESInterceptorLayerLocalAppStorageInstallStatus(@NonNull ADBDevice device) {
        switch (device.getArchitecture()) {
            case AArch64: 
            case AArch32: {
                if (device.isLocalAppStorageGLESLayerSupported()) {
                    return InstallableComponentStatus.NOT_INSTALLED;
                }
                return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_OS_VERSION_UNSUPPORTED;
            }
        }
        return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH;
    }

    protected @Nullable IAndroidBridgeFile getAppropriateGlesLayerForDeviceIfExists(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        if (!device.isLocalAppStorageGLESLayerSupported()) {
            CoreLogging.warning(null, NullUtils.formattedString((String)DRIVER_UNSUPPORTED_FOR_DEVICE_MESSAGE, (Object[])new Object[]{OPENGL_ES}));
            return null;
        }
        switch (app.getPrimaryCpuAbi()) {
            case AArch32: {
                return this.interceptorAArch32Layer;
            }
            case AArch64: {
                return this.interceptorAArch64Layer;
            }
        }
        switch (device.getArchitecture()) {
            case AArch32: {
                return this.interceptorAArch32Layer;
            }
            case AArch64: {
                return this.interceptorAArch64Layer;
            }
        }
        CoreLogging.warning(null, NullUtils.formattedString((String)DRIVER_UNSUPPORTED_FOR_ARCHITECTURE_MESSAGE, (Object[])new Object[]{OPENGL_ES}));
        return null;
    }

    protected @Nullable IAndroidBridgeFile getAppropriateVulkanLayerForDeviceIfExists(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        if (!device.couldSupportVulkan()) {
            CoreLogging.warning(null, NullUtils.formattedString((String)DRIVER_UNSUPPORTED_FOR_DEVICE_MESSAGE, (Object[])new Object[]{VULKAN}));
            return null;
        }
        switch (app.getPrimaryCpuAbi()) {
            case AArch32: {
                return this.interceptorAArch32Vulkan;
            }
            case AArch64: {
                return this.interceptorAArch64Vulkan;
            }
        }
        switch (device.getArchitecture()) {
            case AArch32: {
                return this.interceptorAArch32Vulkan;
            }
            case AArch64: {
                return this.interceptorAArch64Vulkan;
            }
        }
        CoreLogging.warning(null, NullUtils.formattedString((String)DRIVER_UNSUPPORTED_FOR_ARCHITECTURE_MESSAGE, (Object[])new Object[]{VULKAN}));
        return null;
    }

    private @NonNull IAndroidBridgeFile getGADaemonForDevice(@NonNull ADBDevice device) throws IADBTask.ADBExecutionException {
        switch (device.getArchitecture()) {
            case AArch32: {
                return this.mgddaemonAArch32;
            }
            case AArch64: {
                return this.mgddaemonAArch64;
            }
        }
        throw new IADBTask.ADBExecutionException("Cannot find GA daemon binary for architecture \"" + (Object)((Object)device.getArchitecture()) + "\"");
    }

    private @Nullable IAndroidBridgeFile getGAInterceptorForDevice(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        switch (app.getPrimaryCpuAbi()) {
            case AArch32: {
                return this.interceptorAArch32;
            }
            case AArch64: {
                return this.interceptorAArch64;
            }
        }
        switch (device.getArchitecture()) {
            case AArch32: {
                return this.interceptorAArch32;
            }
            case AArch64: {
                return this.interceptorAArch64;
            }
        }
        CoreLogging.warning(null, "Cannot find GA Interceptor library for architecture \"" + (Object)((Object)device.getArchitecture()) + "\"");
        return null;
    }

    public @NonNull InstallableComponentStatus getVulkanLayerLocalAppStorageInstallStatus(@NonNull ADBDevice device) {
        switch (device.getArchitecture()) {
            case AArch64: 
            case AArch32: {
                if (device.isLocalAppStorageVulkanLayerSupported()) {
                    return InstallableComponentStatus.NOT_INSTALLED;
                }
                return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_OS_VERSION_UNSUPPORTED;
            }
        }
        return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH;
    }

    public @NonNull IADBTask<Void> installRootInterceptor(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_INTERCEPTOR_INSTALL_TAG, (IADBExecutor executor) -> {
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            switch (architecture) {
                case AArch64: {
                    this.installSingleRootInterceptor(executor, device, this.interceptorAArch64, InterceptorLocationManager.getInterceptorSubpaths64(device), InterceptorLocationManager.getCanonicalInterceptorLocation64(device), InterceptorLocationManager.getOtherInterceptorLocations64(device));
                }
                case AArch32: {
                    this.installSingleRootInterceptor(executor, device, this.interceptorAArch32, InterceptorLocationManager.getInterceptorSubpaths32(device), InterceptorLocationManager.getCanonicalInterceptorLocation32(device), InterceptorLocationManager.getOtherInterceptorLocations32(device));
                    this.wrapper.rebootDevice(executor, device);
                    break;
                }
                default: {
                    throw new IADBTask.ADBExecutionException("Cannot install the interceptor for a rooted device on architecture \"" + architecture.name() + "\"");
                }
            }
            return null;
        });
    }

    void installSingleRootInterceptor(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull IAndroidBridgeFile sourceFile, @NonNull String @NonNull [] targetInterceptorLocationSubpaths, @NonNull String targetCanonicalInterceptorLocation, @NonNull String @NonNull [] targetOtherInterceptorLocations) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String mountPoint = this.wrapper.getMountPointForPath(executor, device, targetCanonicalInterceptorLocation);
        this.wrapper.remountPartitionAsReadWritableWithRoot(executor, device, mountPoint);
        String[] stringArray = targetInterceptorLocationSubpaths;
        int n = targetInterceptorLocationSubpaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            assert (targetCanonicalInterceptorLocation.contains(path));
            this.wrapper.createFolderRecursivelyWithRoot(executor, device, path);
            this.wrapper.setAccessPermissionForDirectoryWithRoot(executor, device, path, "755");
            ++n2;
        }
        this.installSystemFileWith777Permissions(executor, device, sourceFile, mountPoint, targetCanonicalInterceptorLocation);
        stringArray = targetOtherInterceptorLocations;
        n = targetOtherInterceptorLocations.length;
        n2 = 0;
        while (n2 < n) {
            String otherLocation = stringArray[n2];
            this.wrapper.createSymlinkWithRoot(executor, device, targetCanonicalInterceptorLocation, otherLocation);
            if (!this.wrapper.doesFileExistOnDevice(executor, device, otherLocation)) {
                this.wrapper.createHardLinkWithRoot(executor, device, targetCanonicalInterceptorLocation, otherLocation);
                if (!this.wrapper.doesFileExistOnDevice(executor, device, otherLocation)) {
                    throw new IADBTask.ADBExecutionException("Unable to create \"" + otherLocation + "\" such that it can be read by non-privileged users");
                }
            }
            ++n2;
        }
    }

    public @NonNull IADBTask<Void> uninstallRootInterceptor(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_INTERCEPTOR_UNINSTALL_TAG, (IADBExecutor executor) -> {
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            switch (architecture) {
                case AArch64: {
                    String path;
                    String targetInterceptorLocation = InterceptorLocationManager.getCanonicalInterceptorLocation64(device);
                    String mountPoint = this.wrapper.getMountPointForPath(executor, device, targetInterceptorLocation);
                    this.deleteSystemFile(executor, device, mountPoint, targetInterceptorLocation);
                    String[] stringArray = InterceptorLocationManager.getOtherInterceptorLocations64(device);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        path = stringArray[n2];
                        this.deleteSystemFile(executor, device, mountPoint, path);
                        ++n2;
                    }
                }
                case AArch32: {
                    String path;
                    String targetInterceptorLocation = InterceptorLocationManager.getCanonicalInterceptorLocation32(device);
                    String mountPoint = this.wrapper.getMountPointForPath(executor, device, targetInterceptorLocation);
                    this.deleteSystemFile(executor, device, mountPoint, targetInterceptorLocation);
                    String[] stringArray = InterceptorLocationManager.getOtherInterceptorLocations32(device);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        path = stringArray[n2];
                        this.deleteSystemFile(executor, device, mountPoint, path);
                        ++n2;
                    }
                    this.wrapper.rebootDevice(executor, device);
                }
            }
            return null;
        });
    }

    public @NonNull IADBTask<@NonNull InstallableComponentStatus> getRootVulkanLayerInstallStatus(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_VULKAN_LAYER_QUERY_STATUS_TAG, (IADBExecutor executor) -> {
            String installLocation32;
            String installLocation64;
            if (!device.couldSupportVulkan()) {
                return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_VULKAN_UNSUPPORTED;
            }
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            ArrayList<@NonNull InstallableComponentStatus> statuses = new ArrayList<InstallableComponentStatus>();
            if (device.getSDKAPILevel() <= AndroidSDKVersion.MARSHMALLOW_6_0_0.apiLevel) {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64_MARSHMALLOW;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32_MARSHMALLOW;
            } else {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32;
            }
            switch (architecture) {
                case AArch64: {
                    statuses.add(this.getRootFileInstallStatus(executor, device, this.interceptorAArch64, installLocation64));
                }
                case AArch32: {
                    statuses.add(this.getRootFileInstallStatus(executor, device, this.interceptorAArch32, installLocation32));
                    break;
                }
                default: {
                    return InstallableComponentStatus.CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH;
                }
            }
            return AndroidBridge.getAggregateInstallationStatus(statuses);
        });
    }

    public @NonNull IADBTask<Void> installRootVulkanLayer(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_VULKAN_LAYER_INSTALL_TAG, (IADBExecutor executor) -> {
            String[] subPaths;
            String installLocation32;
            String installLocation64;
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            if (device.getSDKAPILevel() <= AndroidSDKVersion.MARSHMALLOW_6_0_0.apiLevel) {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64_MARSHMALLOW;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32_MARSHMALLOW;
                subPaths = TARGET_VULKAN_LAYER_LOCATION_SUBPATHS_MARSHMALLOW;
            } else {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32;
                subPaths = TARGET_VULKAN_LAYER_LOCATION_SUBPATHS;
            }
            @NonNull String partition = this.wrapper.getMountPointForPath(executor, device, installLocation32);
            switch (architecture) {
                case AArch64: 
                case AArch32: {
                    this.wrapper.remountPartitionAsReadWritableWithRoot(executor, device, partition);
                    String[] stringArray = subPaths;
                    int n = subPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        assert (installLocation32.contains(path));
                        assert (installLocation64.contains(path));
                        this.createFolderRecursivelyWithRootAndGive777Permissions(executor, device, path);
                        ++n2;
                    }
                    break;
                }
                default: {
                    throw new IADBTask.ADBExecutionException("Cannot install the Vulkan Layer for a rooted device on architecture \"" + architecture.name() + "\"");
                }
            }
            switch (architecture) {
                case AArch64: {
                    this.installSystemFileWith777Permissions(executor, device, this.interceptorAArch64, partition, installLocation64);
                }
                case AArch32: {
                    this.installSystemFileWith777Permissions(executor, device, this.interceptorAArch32, partition, installLocation32);
                    break;
                }
                default: {
                    throw new AssertionError((Object)architecture);
                }
            }
            return null;
        });
    }

    public @NonNull IADBTask<Void> uninstallRootVulkanLayer(@NonNull ADBDevice device) {
        return this.createTask(device, InstallableComponentOperationTag.ROOT_VULKAN_LAYER_UNINSTALL_TAG, (IADBExecutor executor) -> {
            String installLocation32;
            String installLocation64;
            if (device.getSDKAPILevel() <= AndroidSDKVersion.MARSHMALLOW_6_0_0.apiLevel) {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64_MARSHMALLOW;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32_MARSHMALLOW;
            } else {
                installLocation64 = TARGET_VULKAN_LAYER_LOCATION_64;
                installLocation32 = TARGET_VULKAN_LAYER_LOCATION_32;
            }
            @NonNull String partition = this.wrapper.getMountPointForPath(executor, device, installLocation32);
            @NonNull ADBDevice.Architecture architecture = device.getArchitecture();
            switch (architecture) {
                case AArch64: {
                    this.deleteSystemFile(executor, device, partition, installLocation64);
                }
                case AArch32: {
                    this.deleteSystemFile(executor, device, partition, installLocation32);
                }
            }
            return null;
        });
    }

    private static @NonNull InstallableComponentStatus getAggregateInstallationStatus(@NonNull List<@NonNull InstallableComponentStatus> statuses) {
        boolean allInstalled = true;
        boolean anyInstalledOrOutOfDate = false;
        for (InstallableComponentStatus status : statuses) {
            allInstalled &= status == InstallableComponentStatus.INSTALLED;
            anyInstalledOrOutOfDate |= status == InstallableComponentStatus.OUT_OF_DATE || status == InstallableComponentStatus.INSTALLED;
        }
        if (allInstalled) {
            return InstallableComponentStatus.INSTALLED;
        }
        if (anyInstalledOrOutOfDate) {
            return InstallableComponentStatus.OUT_OF_DATE;
        }
        return InstallableComponentStatus.NOT_INSTALLED;
    }

    private void installSystemFileWith777Permissions(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull IAndroidBridgeFile sourceFile, @NonNull String destinationPartition, @NonNull String destinationFile) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        assert (destinationFile.contains(destinationPartition));
        long freeSpace = this.wrapper.getFreeSpaceForPartition(executor, device, destinationPartition);
        if (freeSpace < sourceFile.getLength()) {
            throw new IADBTask.ADBExecutionException(NullUtils.formattedString((String)"Not enough space on the %s filesystem to install %s. %.2f megabytes are required, %.2f megabytes are available.", (Object[])new Object[]{destinationPartition, sourceFile.getFileName(), NullUtils.doubleValueOf((double)((double)sourceFile.getLength() / 1048576.0)), NullUtils.doubleValueOf((double)((double)freeSpace / 1048576.0))}));
        }
        this.wrapper.remountPartitionAsReadWritableWithRoot(executor, device, destinationPartition);
        String tempStorageFile = String.valueOf(this.targetStorageDirectory) + sourceFile.getFileName();
        this.wrapper.pushFileToDevice(executor, device, sourceFile.getAbsolutePath(), tempStorageFile);
        String tempDestinationFile = String.valueOf(destinationFile) + ".mgdtemp";
        try {
            this.wrapper.moveFileWithRoot(executor, device, tempStorageFile, tempDestinationFile);
        }
        catch (IADBTask.ADBExecutionException e) {
            this.wrapper.deleteFileWithRoot(executor, device, tempStorageFile);
            throw e;
        }
        try {
            this.wrapper.setAccessPermissionForFileWithRoot(executor, device, tempDestinationFile, "777");
            byte[] targetFileHash = this.wrapper.getMD5Digest(executor, device, tempDestinationFile, this.targetStorageDirectory);
            if (!Arrays.equals(sourceFile.getMD5(), targetFileHash)) {
                long freeSpaceAfterMD5 = this.wrapper.getFreeSpaceForPartition(executor, device, destinationPartition);
                if (freeSpaceAfterMD5 == 0L) {
                    throw new IADBTask.ADBExecutionException("Installation failed due to insufficient space. This means that Android under-reported how much free space was available. " + String.format("Try freeing more space on %s and running the installation again.", destinationPartition));
                }
                throw new IADBTask.ADBExecutionException("Copy of file to " + destinationFile + " failed; mismatched MD5 checksum detected. You can try running the installation again");
            }
            this.wrapper.moveFileWithRoot(executor, device, tempDestinationFile, destinationFile);
        }
        catch (IADBTask.ADBExecutionException e) {
            this.wrapper.deleteFileWithRoot(executor, device, tempDestinationFile);
            throw e;
        }
    }

    private void createFolderRecursivelyWithRootAndGive777Permissions(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String directoryName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.wrapper.createFolderRecursivelyWithRoot(executor, device, directoryName);
        this.wrapper.setAccessPermissionForDirectoryWithRoot(executor, device, directoryName, "777");
    }

    private void deleteSystemFile(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String filePartition, @NonNull String deviceFileToDelete) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.wrapper.remountPartitionAsReadWritableWithRoot(executor, device, filePartition);
        this.wrapper.deleteFileWithRoot(executor, device, deviceFileToDelete);
    }

    public @NonNull IADBTask<Void> rebootDevice(@NonNull ADBDevice device) {
        return this.createTask(device, ADBTaskDescription.REBOOT_DEVICE, (IADBExecutor executor) -> {
            this.wrapper.rebootDevice(executor, device);
            return null;
        });
    }

    private @NonNull InstallableComponentStatus getRootFileInstallStatus(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull IAndroidBridgeFile sourceFile, @NonNull String targetFileLocation) throws IADBTask.InvalidADBException {
        if (!this.wrapper.doesFileExistOnDevice(executor, device, targetFileLocation)) {
            return InstallableComponentStatus.NOT_INSTALLED;
        }
        byte[] targetFileHash = null;
        try {
            targetFileHash = this.wrapper.getMD5Digest(executor, device, targetFileLocation, this.targetStorageDirectory);
        }
        catch (IADBTask.ADBExecutionException aDBExecutionException) {
            // empty catch block
        }
        if (!Arrays.equals(sourceFile.getMD5(), targetFileHash)) {
            return InstallableComponentStatus.OUT_OF_DATE;
        }
        return InstallableComponentStatus.INSTALLED;
    }

    private @NonNull InstallableComponentStatus getPathInstallStatus(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String @NonNull [] paths) throws IADBTask.InvalidADBException {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String loc = stringArray[n2];
            if (!this.wrapper.doesFileExistOnDevice(executor, device, loc)) {
                return InstallableComponentStatus.NOT_INSTALLED;
            }
            ++n2;
        }
        return InstallableComponentStatus.INSTALLED;
    }

    public @NonNull IADBTask<Void> disconnectFromDevice(@NonNull ADBDevice device, @NonNull DisconnectFromDeviceCallback callback) {
        return this.createTask(device, ConnectionOperationTag.DISCONNECT_TAG, (IADBExecutor executor) -> {
            callback.doDisconnect();
            return null;
        });
    }

    public @NonNull IADBTask<Void> uploadReplayFile(@NonNull ADBDevice device, @NonNull File replayFile) {
        return this.createTask(device, ConnectionOperationTag.REPLAY_UPLOAD_TAG, (IADBExecutor executor) -> {
            IAndroidBridgeFile bridgeFile = IAndroidBridgeFile.create(replayFile);
            String targetFile = TARGET_REPLAY_DIRECTORY + bridgeFile.getFileName();
            this.wrapper.pushFileToDevice(executor, device, bridgeFile.getAbsolutePath(), targetFile);
            byte[] targetFileHash = this.wrapper.getMD5Digest(executor, device, targetFile, this.targetStorageDirectory);
            if (!Arrays.equals(bridgeFile.getMD5(), targetFileHash)) {
                throw new IADBTask.ADBExecutionException("Copy of file to " + targetFile + " failed; mismatched MD5 checksum detected. You can try uploading again.");
            }
            return null;
        });
    }

    public @NonNull IADBTask<String> getRawLogcatOutput(@NonNull ADBDevice device, @NonNull String tag) {
        return this.createTask(device, ConnectionOperationTag.CONNECT_TAG, (IADBExecutor executor) -> this.wrapper.getLogcatOutputForTag(executor, device, tag, "-v raw"));
    }

    public @NonNull IADBTask<String> getDeviceEGLConfigs(@NonNull ADBDevice device) {
        return this.createTask(device, ConnectionOperationTag.CONNECT_TAG, (IADBExecutor executor) -> {
            try {
                this.wrapper.getLogcatOutputForTag(executor, device, "", "-c");
                this.wrapper.startServiceWithFlags(executor, device, DEVICE_INFO_SERVICE_ID, "--es query configs");
                return this.wrapper.getLogcatOutputForTag(executor, device, DEVICE_INFO_SERVICE_TAG, "-v raw");
            }
            catch (IADBTask.InvalidADBException e) {
                CoreLogging.warning(null, e, "Unable to retrieve EGL configs from device " + device.getID());
                return "";
            }
        });
    }

    public @NonNull IADBTask<Void> uploadCounterConfigurationFile(@NonNull ADBDevice device, @NonNull File configurationFile) {
        return this.createTask(device, ConnectionOperationTag.CONFIG_UPLOAD_TAG, (IADBExecutor executor) -> {
            IAndroidBridgeFile bridgeFile = IAndroidBridgeFile.create(configurationFile);
            this.wrapper.createFolderRecursivelyWithRoot(executor, device, TARGET_COUNTER_CONFIG_DIRECTORY);
            this.installSystemFileWith777Permissions(executor, device, bridgeFile, TARGET_COUNTER_CONFIG_PARTITION, TARGET_COUNTER_CONFIG_LOCATION);
            this.wrapper.setAccessPermissionForFileWithRoot(executor, device, TARGET_COUNTER_CONFIG_LOCATION, "777");
            return null;
        });
    }

    public @NonNull IADBTask<Void> deleteCounterConfigurationFiles(@NonNull ADBDevice device) {
        return this.createTask(device, ConnectionOperationTag.CONFIG_DELETE_TAG, (IADBExecutor executor) -> {
            this.wrapper.deleteFolderRecursivelyWithRoot(executor, device, TARGET_COUNTER_CONFIG_DIRECTORY);
            return null;
        });
    }

    public @NonNull IADBTask<Void> startTracedPackage(@NonNull IAndroidPackageTraceManager traceManager) {
        return this.createTask(traceManager.getDevice(), ConnectionOperationTag.PER_APP_TRACING_START_APP, (IADBExecutor executor) -> {
            traceManager.startPackage();
            return null;
        });
    }

    private <T> @NonNull IADBTask<T> createTask(@Nullable ADBDevice device, @NonNull InstallableComponentOperationTag tag, @NonNull AndroidBridgeTask.ADBTaskSupplier<T> task) {
        return this.createTask(device, tag.description, tag, task);
    }

    public @Nullable IPackageInterceptor getGLESDriver(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        if (device.getSDKAPILevel() >= AndroidSDKVersion.ANDROID_10.apiLevel) {
            @Nullable IAndroidBridgeFile glesLayerDriver = this.getAppropriateGlesLayerForDeviceIfExists(device, app);
            if (glesLayerDriver == null) {
                return null;
            }
            return new GLESPackageLayerDriver(device, app.getPackageName(), this.wrapper, glesLayerDriver);
        }
        @Nullable IAndroidBridgeFile glesInterceptor = this.getGAInterceptorForDevice(device, app);
        if (glesInterceptor == null) {
            return null;
        }
        return new InjectableGLESPackageInterceptor(device, app.getPackageName(), this.wrapper, glesInterceptor);
    }

    public @NonNull IPackageInterceptor getEmptyGLESDriver(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        return new EmptyGLESPackageLayerDriver(device, app.getPackageName(), this.wrapper, this.getEmptyAndroidBridgeFile());
    }

    private @NonNull IAndroidBridgeFile getEmptyAndroidBridgeFile() {
        return new IAndroidBridgeFile(){

            @Override
            public byte @NonNull [] getMD5() {
                return new byte[0];
            }

            @Override
            public long getLength() {
                return 0L;
            }

            @Override
            public @NonNull String getFileName() {
                return "";
            }

            @Override
            public @NonNull String getAbsolutePath() {
                return "";
            }
        };
    }

    private @Nullable IPackageInterceptor getVulkanDriver(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        @Nullable IAndroidBridgeFile vulkanLayerDriver = this.getAppropriateVulkanLayerForDeviceIfExists(device, app);
        if (vulkanLayerDriver == null) {
            return null;
        }
        return new VulkanPackageLayerDriver(device, app.getPackageName(), this.wrapper, vulkanLayerDriver);
    }

    private @NonNull IPackageInterceptor getEmptyVulkanDriver(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app) {
        return new EmptyVulkanPackageLayerDriver(device, app.getPackageName(), this.wrapper, this.getEmptyAndroidBridgeFile());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull IAndroidPackageTraceManager getNoAPIPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity) throws IADBTask.ADBExecutionException {
        @NonNull @NonNull List driverList = NullUtils.emptyList();
        return new AndroidPackageTraceManager(device, app, activity, driverList, this.getGADaemonForDevice(device), this.wrapper);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull IAndroidPackageTraceManager getGLESPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity) throws IADBTask.ADBExecutionException {
        @NonNull @NonNull List driverList = NullUtils.asNullFilteredList((Object[])new IPackageInterceptor[]{this.getGLESDriver(device, app), this.getEmptyVulkanDriver(device, app)});
        return new AndroidPackageTraceManager(device, app, activity, driverList, this.getGADaemonForDevice(device), this.wrapper);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull IAndroidPackageTraceManager getVulkanPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity) throws IADBTask.ADBExecutionException {
        @NonNull @NonNull List driverList = NullUtils.asNullFilteredList((Object[])new IPackageInterceptor[]{this.getEmptyGLESDriver(device, app), this.getVulkanDriver(device, app)});
        return new AndroidPackageTraceManager(device, app, activity, driverList, this.getGADaemonForDevice(device), this.wrapper);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull IAndroidPackageTraceManager getMultiAPIPackageTraceManager(@NonNull ADBDevice device, @NonNull ADBInstalledPackage app, @NonNull String activity) throws IADBTask.ADBExecutionException {
        @NonNull @NonNull List driverList = NullUtils.asNullFilteredList((Object[])new IPackageInterceptor[]{this.getGLESDriver(device, app), this.getVulkanDriver(device, app)});
        return new AndroidPackageTraceManager(device, app, activity, driverList, this.getGADaemonForDevice(device), this.wrapper);
    }

    public @Nullable ADBInstalledPackage getPackage(@NonNull String packageName, @NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        @NonNull List<@NonNull ADBInstalledPackage> debuggablePackages = this.wrapper.getDebuggablePackages(executor, device);
        List<@NonNull T> matchingPackages = debuggablePackages.stream().filter(debuggablePackage -> debuggablePackage.getPackageName().equals(packageName)).collect(Collectors.toList());
        if (matchingPackages.isEmpty()) {
            return null;
        }
        if (matchingPackages.size() > 1) {
            throw new IADBTask.ADBExecutionException("Multiple packages were found named \"" + packageName + "\"");
        }
        return (ADBInstalledPackage)matchingPackages.get(0);
    }

    public static enum ConnectionOperationTag implements AndroidBridgeTask.ITaskTag
    {
        CONNECT_TAG(ADBTaskDescription.CONNECT_TO_DEVICE),
        DISCONNECT_TAG(ADBTaskDescription.DISCONNECT_FROM_DEVICE),
        REPLAY_UPLOAD_TAG(ADBTaskDescription.UPLOAD_REPLAY_FILE),
        REPLAY_TAG(ADBTaskDescription.REPLAY_FILE),
        CONFIG_UPLOAD_TAG(ADBTaskDescription.UPLOAD_COUNTER_CONFIG),
        CONFIG_DELETE_TAG(ADBTaskDescription.DELETE_COUNTER_CONFIG),
        PER_APP_TRACING_START_APP(ADBTaskDescription.PER_APP_TRACING_START_APP);

        public final @NonNull ADBTaskDescription description;

        private ConnectionOperationTag(ADBTaskDescription description) {
            this.description = description;
        }
    }

    public static interface DisconnectFromDeviceCallback {
        public void doDisconnect();
    }

    public static enum InstallableComponentOperationTag implements AndroidBridgeTask.ITaskTag
    {
        ROOT_DAEMON_QUERY_STATUS_TAG(ADBTaskDescription.ROOT_DAEMON_QUERY_STATUS, InstallableComponentType.ROOT_DAEMON, InstallableComponentOperationType.QUERY_STATUS),
        ROOT_DAEMON_INSTALL_TAG(ADBTaskDescription.ROOT_DAEMON_INSTALL, InstallableComponentType.ROOT_DAEMON, InstallableComponentOperationType.INSTALL),
        ROOT_DAEMON_UNINSTALL_TAG(ADBTaskDescription.ROOT_DAEMON_UNINSTALL, InstallableComponentType.ROOT_DAEMON, InstallableComponentOperationType.UNINSTALL),
        ROOT_INTERCEPTOR_QUERY_STATUS_TAG(ADBTaskDescription.ROOT_INTERCEPTOR_QUERY_STATUS, InstallableComponentType.ROOT_INTERCEPTOR, InstallableComponentOperationType.QUERY_STATUS),
        ROOT_INTERCEPTOR_INSTALL_TAG(ADBTaskDescription.ROOT_INTERCEPTOR_INSTALL, InstallableComponentType.ROOT_INTERCEPTOR, InstallableComponentOperationType.INSTALL),
        PER_APP_TRACING_INSTALL_TAG(ADBTaskDescription.PER_APP_TRACING_INSTALL, InstallableComponentType.PER_APP_TRACING, InstallableComponentOperationType.INSTALL),
        ROOT_INTERCEPTOR_UNINSTALL_TAG(ADBTaskDescription.ROOT_INTERCEPTOR_UNINSTALL, InstallableComponentType.ROOT_INTERCEPTOR, InstallableComponentOperationType.UNINSTALL),
        ROOT_VULKAN_LAYER_QUERY_STATUS_TAG(ADBTaskDescription.ROOT_VULKAN_LAYER_QUERY_STATUS, InstallableComponentType.ROOT_VULKAN_LAYER, InstallableComponentOperationType.QUERY_STATUS),
        ROOT_VULKAN_LAYER_INSTALL_TAG(ADBTaskDescription.ROOT_VULKAN_LAYER_INSTALL, InstallableComponentType.ROOT_VULKAN_LAYER, InstallableComponentOperationType.INSTALL),
        ROOT_VULKAN_LAYER_UNINSTALL_TAG(ADBTaskDescription.ROOT_VULKAN_LAYER_UNINSTALL, InstallableComponentType.ROOT_VULKAN_LAYER, InstallableComponentOperationType.UNINSTALL),
        PER_APP_TRACING_REMOVAL_TAG(ADBTaskDescription.PER_APP_TRACING_REMOVAL, InstallableComponentType.PER_APP_TRACING, InstallableComponentOperationType.UNINSTALL);

        public final @NonNull ADBTaskDescription description;
        public final @NonNull InstallableComponentType componentType;
        public final @NonNull InstallableComponentOperationType operationType;

        private InstallableComponentOperationTag(@NonNull ADBTaskDescription description, InstallableComponentType componentType, InstallableComponentOperationType operationType) {
            this.description = description;
            this.componentType = componentType;
            this.operationType = operationType;
        }
    }

    public static enum InstallableComponentOperationType {
        INSTALL,
        UNINSTALL,
        QUERY_STATUS;

    }

    public static enum InstallableComponentStatus {
        INSTALLED,
        OUT_OF_DATE,
        NOT_INSTALLED,
        NOT_INSTALLED_NOT_ROOTED,
        CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH,
        CAN_NOT_BE_INSTALLED_VULKAN_UNSUPPORTED,
        CAN_NOT_BE_INSTALLED_OS_VERSION_UNSUPPORTED;

    }

    public static enum InstallableComponentType {
        ROOT_DAEMON,
        ROOT_INTERCEPTOR,
        PER_APP_TRACING,
        ROOT_VULKAN_LAYER;

    }

    static class InterceptorLocationManager {
        private static final @NonNull String CANONICAL_INTERCEPTOR_LOCATION_32 = "/system/lib/egl/libGLES_aga.so";
        private static final @NonNull String @NonNull [] INTERCEPTOR_LOCATION_32_SUBPATHS = new String[]{"/system/lib/egl/"};
        private static final @NonNull String @NonNull [] OTHER_INTERCEPTOR_LOCATIONS_32 = new String[]{"/system/lib/egl/libGLES.so", "/system/lib/egl/libGLES"};
        private static final @NonNull String CANONICAL_INTERCEPTOR_LOCATION_32_TREBLE = "/vendor/lib/egl/libGLES_aga.so";
        private static final @NonNull String @NonNull [] INTERCEPTOR_LOCATION_32_SUBPATHS_TREBLE = new String[]{"/vendor/lib/egl/"};
        private static final @NonNull String @NonNull [] OTHER_INTERCEPTOR_LOCATIONS_32_TREBLE = new String[]{"/vendor/lib/egl/libGLES.so", "/vendor/lib/egl/libGLES"};
        private static final @NonNull String CANONICAL_INTERCEPTOR_LOCATION_64 = "/system/lib64/egl/libGLES_aga.so";
        private static final @NonNull String @NonNull [] INTERCEPTOR_LOCATION_64_SUBPATHS = new String[]{"/system/lib64/egl/"};
        private static final @NonNull String @NonNull [] OTHER_INTERCEPTOR_LOCATIONS_64 = new String[]{"/system/lib64/egl/libGLES.so", "/system/lib64/egl/libGLES"};
        private static final @NonNull String CANONICAL_INTERCEPTOR_LOCATION_64_TREBLE = "/vendor/lib64/egl/libGLES_aga.so";
        private static final @NonNull String @NonNull [] INTERCEPTOR_LOCATION_64_SUBPATHS_TREBLE = new String[]{"/vendor/lib64/egl/"};
        private static final @NonNull String @NonNull [] OTHER_INTERCEPTOR_LOCATIONS_64_TREBLE = new String[]{"/vendor/lib64/egl/libGLES.so", "/vendor/lib64/egl/libGLES"};

        InterceptorLocationManager() {
        }

        public static @NonNull String getCanonicalInterceptorLocation32(@NonNull ADBDevice device) {
            return device.isTreble() ? CANONICAL_INTERCEPTOR_LOCATION_32_TREBLE : CANONICAL_INTERCEPTOR_LOCATION_32;
        }

        public static @NonNull String getCanonicalInterceptorLocation64(@NonNull ADBDevice device) {
            return device.isTreble() ? CANONICAL_INTERCEPTOR_LOCATION_64_TREBLE : CANONICAL_INTERCEPTOR_LOCATION_64;
        }

        public static @NonNull String @NonNull [] getOtherInterceptorLocations32(@NonNull ADBDevice device) {
            return device.isTreble() ? OTHER_INTERCEPTOR_LOCATIONS_32_TREBLE : OTHER_INTERCEPTOR_LOCATIONS_32;
        }

        public static @NonNull String @NonNull [] getOtherInterceptorLocations64(@NonNull ADBDevice device) {
            return device.isTreble() ? OTHER_INTERCEPTOR_LOCATIONS_64_TREBLE : OTHER_INTERCEPTOR_LOCATIONS_64;
        }

        public static @NonNull String @NonNull [] getInterceptorSubpaths32(@NonNull ADBDevice device) {
            return device.isTreble() ? INTERCEPTOR_LOCATION_32_SUBPATHS_TREBLE : INTERCEPTOR_LOCATION_32_SUBPATHS;
        }

        public static @NonNull String @NonNull [] getInterceptorSubpaths64(@NonNull ADBDevice device) {
            return device.isTreble() ? INTERCEPTOR_LOCATION_64_SUBPATHS_TREBLE : INTERCEPTOR_LOCATION_64_SUBPATHS;
        }
    }
}

