/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBForwardedPort;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.ADBTempDir;
import com.arm.mgd.core.adb.DumpsysOutputParser;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBWrapper;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.HashUtils;
import com.arm.mgd.core.util.Pair;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ADBWrapper
implements IADBWrapper {
    protected final @NonNull String adbPath;
    private static final @NonNull String @NonNull [] ADB_SERVER_MESSAGES = new String[]{"List of devices attached", "daemon not running", "daemon started successfully"};
    static final @NonNull String FORWARD_FAILURE_MESSAGE = "Failed to forward port.";
    static final @NonNull String ADB_FORWARD_COMMAND_PATTERN = "forward \"tcp:%d\" \"%s\"";
    private static final Pattern FORWARDED_PORT_PATTERN = Pattern.compile("^([^*]\\S*)\\stcp:(\\d+)\\s(\\S+)\\s*$");
    private static final @NonNull Pattern PackagePattern = (Pattern)NullUtils.neverNull((Object)Pattern.compile("package:(.+)=(.+)"));

    protected ADBWrapper(@NonNull String adbPath) {
        this.adbPath = adbPath;
    }

    @Override
    public void validateADBIsUsable(@NonNull IADBExecutor executor) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult validateResult;
        try {
            validateResult = this.submitADBCommand(executor, "version", 10, TimeUnit.SECONDS);
        }
        catch (IADBTask.ADBExecutionException e) {
            String message = e.getMessage();
            assert (message != null);
            throw new IADBTask.InvalidADBException(message);
        }
        if (!validateResult.getOutput().startsWith("Android Debug Bridge")) {
            throw new IADBTask.InvalidADBException("Unable to validate ADB");
        }
    }

    @Override
    public void startADBServer(@NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult startResult;
        try {
            startResult = this.submitADBCommand(executor, device, "start-server", 10, TimeUnit.SECONDS);
        }
        catch (IADBTask.ADBExecutionException e) {
            throw new IADBTask.InvalidADBException(e);
        }
        if (startResult.getOutput().contains("* failed to start daemon *")) {
            throw new IADBTask.InvalidADBException("Unable to start ADB server");
        }
    }

    private static boolean shouldLineBeParsedForDeviceIdentifier(@Nullable String line) {
        if (line == null || line.isEmpty()) {
            return false;
        }
        String[] stringArray = ADB_SERVER_MESSAGES;
        int n = ADB_SERVER_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (line.contains(message)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static @Nullable ADBDeviceIdentifier mapStringToDeviceIdentifier(@NonNull String input) {
        String possibleQualifier;
        String[] split = input.split("\\s+");
        @Nullable String id = split.length >= 1 ? split[0] : null;
        @Nullable String statusString = split.length >= 2 ? split[1] : null;
        ADBDeviceIdentifier.Status status = statusString != null ? ADBDeviceIdentifier.Status.parseStatus(statusString) : null;
        String string = possibleQualifier = split.length >= 3 ? split[2] : null;
        if (id == null || status == null) {
            return null;
        }
        String qualifier = possibleQualifier == null || !possibleQualifier.contains("usb:") ? id : possibleQualifier;
        return new ADBDeviceIdentifier(id, qualifier, status);
    }

    @Override
    public @NonNull List<@NonNull ADBDeviceIdentifier> getDeviceIdentifiers(@NonNull IADBExecutor executor) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, "devices -l");
        @NonNull List<@NonNull ADBDeviceIdentifier> devices = Stream.of(result.getOutput().split("\\r?\\n")).filter(ADBWrapper::shouldLineBeParsedForDeviceIdentifier).map(ADBWrapper::mapStringToDeviceIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        return devices;
    }

    @Override
    public @NonNull ADBDevice getDevice(@NonNull IADBExecutor executor, @NonNull ADBDeviceIdentifier identifier) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException, IADBWrapper.ADBDeviceStillBootingException {
        StringBuilder rootAdbShellParams;
        String suCommandLinePrefix;
        int androidSDKVersion;
        StringBuilder nonRootEnvironment = new StringBuilder();
        if (identifier.getStatus() != ADBDeviceIdentifier.Status.DEVICE) {
            throw new IADBTask.ADBExecutionException("Device " + identifier.getID() + " is not online");
        }
        if (this.getDeviceIdentifierProperty(executor, identifier, "sys.boot_completed", nonRootEnvironment).isEmpty()) {
            throw new IADBWrapper.ADBDeviceStillBootingException();
        }
        @NonNull String manufacturer = this.getDeviceIdentifierProperty(executor, identifier, "ro.product.manufacturer", nonRootEnvironment);
        @NonNull String model = this.getDeviceIdentifierProperty(executor, identifier, "ro.product.model", nonRootEnvironment);
        @NonNull String androidVersion = this.getDeviceIdentifierProperty(executor, identifier, "ro.build.version.release", nonRootEnvironment);
        boolean isTreble = this.getDeviceIdentifierProperty(executor, identifier, "ro.treble.enabled", nonRootEnvironment).equals("true");
        try {
            androidSDKVersion = Integer.parseInt(this.getDeviceIdentifierProperty(executor, identifier, "ro.build.version.sdk", nonRootEnvironment).replaceAll("[^\\d.]", ""));
        }
        catch (NumberFormatException e) {
            throw new IADBTask.ADBExecutionException("Failed to retrieve Android SDK version for device " + identifier.getID());
        }
        @NonNull ADBDevice.Architecture architecture = ADBDevice.Architecture.parseArchitecture(this.getDeviceIdentifierProperty(executor, identifier, "ro.product.cpu.abilist", nonRootEnvironment));
        if (architecture == ADBDevice.Architecture.UNKNOWN) {
            architecture = ADBDevice.Architecture.parseArchitecture(this.getDeviceIdentifierProperty(executor, identifier, "ro.product.cpu.abi", nonRootEnvironment));
        }
        boolean isRooted = !(suCommandLinePrefix = this.probeRootCommandLine(executor, identifier, rootAdbShellParams = new StringBuilder())).isEmpty();
        IADBExecutor.IResult md5SumResult = this.submitADBCommand(executor, identifier, "shell " + (nonRootEnvironment.length() == 0 ? "" : nonRootEnvironment + " ") + "\"test | md5sum -b\"", 10, TimeUnit.SECONDS);
        String expectedMD5 = "d41d8cd98f00b204e9800998ecf8427e";
        boolean hasMd5Sum = md5SumResult.getOutput().contains("d41d8cd98f00b204e9800998ecf8427e");
        return new ADBDevice(identifier, manufacturer, model, androidVersion, androidSDKVersion, architecture, isRooted, hasMd5Sum, isTreble, (String)NullUtils.neverNull((Object)nonRootEnvironment.toString()), (String)NullUtils.neverNull((Object)rootAdbShellParams.toString()), suCommandLinePrefix);
    }

    @Override
    public @NonNull ADBDeviceIdentifier getDeviceIdentifierForIDString(@NonNull IADBExecutor executor, @NonNull String identifier) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException, IADBWrapper.ADBDeviceStillBootingException {
        for (ADBDeviceIdentifier id : this.getDeviceIdentifiers(executor)) {
            if (!id.getID().equals(identifier)) continue;
            return id;
        }
        throw new IADBTask.ADBExecutionException("Device " + identifier + " not found");
    }

    private @NonNull String getDeviceIdentifierProperty(@NonNull IADBExecutor executor, @NonNull ADBDeviceIdentifier identifier, @NonNull String key, @NonNull StringBuilder environmentOverrides) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result;
        String adbShell = String.valueOf(identifier.getQualifierForADB()) + " shell";
        String getPropCommand = "getprop " + key;
        int timeout = 10;
        if (environmentOverrides.length() > 0) {
            result = this.submitADBCommand(executor, String.valueOf(adbShell) + " " + environmentOverrides + " " + getPropCommand, 10, TimeUnit.SECONDS);
        } else {
            String executionFailedPattern = "(?si).*: (not found|Permission denied).*";
            result = this.submitADBCommand(executor, String.valueOf(adbShell) + " " + getPropCommand, 10, TimeUnit.SECONDS);
            if (result.getOutput().matches("(?si).*: (not found|Permission denied).*")) {
                String setSanePath = "\"PATH=/system/bin:/system/xbin:$PATH\"";
                result = this.submitADBCommand(executor, String.valueOf(adbShell) + " " + "\"PATH=/system/bin:/system/xbin:$PATH\"" + " " + getPropCommand, 10, TimeUnit.SECONDS);
                if (!result.getOutput().matches("(?si).*: (not found|Permission denied).*")) {
                    environmentOverrides.setLength(0);
                    environmentOverrides.append("\"PATH=/system/bin:/system/xbin:$PATH\"");
                }
            }
        }
        return (String)NullUtils.neverNull((Object)result.getOutput().trim());
    }

    @Override
    public @NonNull String getDeviceProperty(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key) throws IADBTask.InvalidADBException {
        @NonNull IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " getprop " + key);
        return (String)NullUtils.neverNull((Object)result.getOutput().trim());
    }

    @Override
    public @Nullable String getGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key) throws IADBTask.InvalidADBException {
        String allSettings = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " settings list global").getOutput();
        Pattern propertyListFormat = Pattern.compile("^" + key + "=(.*?\\s*)$");
        Optional<String> matchingLine = Arrays.stream(allSettings.split("\\r?\\n")).filter(propertyListFormat.asMatchPredicate()).findAny();
        if (matchingLine.isEmpty()) {
            return null;
        }
        Matcher matcher = propertyListFormat.matcher(matchingLine.get());
        boolean found = matcher.find();
        assert (found);
        return matcher.group(1);
    }

    @Override
    public void setGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key, @NonNull String value) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " settings put global '" + key + "' '" + value + "'");
        @Nullable String newSetting = this.getGlobalDeviceSetting(executor, device, key);
        if (newSetting == null) {
            throw new IADBTask.ADBExecutionException("Failed to set global device setting \"" + key + "\" to value \"" + value + "\". (Setting is currently unset.)");
        }
        if (!value.contentEquals(newSetting)) {
            throw new IADBTask.ADBExecutionException("Failed to set global device setting \"" + key + "\" to value \"" + value + "\". (Setting value is currently: \"" + newSetting + "\".)");
        }
    }

    @Override
    public void setDeviceProperty(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key, @NonNull String value) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String propertyValueToSet = String.valueOf(value) + ":";
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " setprop " + key + " " + propertyValueToSet);
        String newPropertyValue = this.getDeviceProperty(executor, device, key);
        if (!newPropertyValue.contentEquals(propertyValueToSet)) {
            throw new IADBTask.ADBExecutionException("Failed to set property \"" + key + "\" to value \"" + propertyValueToSet + "\". (Property value is currently: \"" + newPropertyValue + "\".)");
        }
    }

    @Override
    public @NonNull ADBForwardedPort createNewForwardedPort(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String targetPort) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        int hostPort = executor.getUnusedLocalPort();
        @NonNull String command = NullUtils.formattedString((String)ADB_FORWARD_COMMAND_PATTERN, (Object[])new Object[]{NullUtils.intValueOf((int)hostPort), targetPort});
        IADBExecutor.IResult forwardResult = this.submitADBCommand(executor, device, command);
        if (forwardResult.getExitCode() != 0) {
            throw new IADBTask.ADBExecutionException(FORWARD_FAILURE_MESSAGE);
        }
        return this.getForwardedPorts(executor).stream().filter(port -> port.getID().equals(device.getID()) && port.getDevicePort().equals(targetPort) && port.getHostPort() == hostPort).findAny().orElseThrow(() -> new IADBTask.ADBExecutionException(FORWARD_FAILURE_MESSAGE));
    }

    @Override
    public @NonNull List<@NonNull ADBForwardedPort> getForwardedPorts(@NonNull IADBExecutor executor) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult completedProcess = this.submitADBCommand(executor, "forward --list");
        @NonNull List<@NonNull ADBForwardedPort> forwardedPorts = Stream.of(completedProcess.getOutput().split("\\r?\\n")).map(FORWARDED_PORT_PATTERN::matcher).filter(Matcher::matches).map(matcher -> new ADBForwardedPort(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3))).collect(Collectors.toList());
        return forwardedPorts;
    }

    @Override
    public void removeAllForwardedPorts(@NonNull IADBExecutor executor) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, "forward --remove-all");
        if (!this.getForwardedPorts(executor).isEmpty()) {
            throw new IADBTask.ADBExecutionException("Failed to remove all forwarded ports.");
        }
    }

    private ADBInstalledPackage createADBInstalledPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull Pair<@NonNull String, @NonNull String> packageInfo) {
        try {
            String packageName = packageInfo.getSecondValue();
            String dumpsysOutput = this.getDumpsysOutputForPackage(executor, device, packageName);
            if (dumpsysOutput.contains("DEBUGGABLE")) {
                Set<@NonNull String> activities = DumpsysOutputParser.getMainActivitiesFromDeviceOutput(device, dumpsysOutput, packageName);
                return new ADBInstalledPackage(packageInfo.getFirstValue(), packageName, activities, true, DumpsysOutputParser.getPrimaryCPUAbi(dumpsysOutput));
            }
            return new ADBInstalledPackage(packageInfo.getFirstValue(), packageName);
        }
        catch (IADBTask.InvalidADBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public @NonNull List<@NonNull ADBInstalledPackage> getInstalledPackages(@NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        return this.getInstalledPackages(executor, device, true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull List<@NonNull ADBInstalledPackage> getInstalledPackages(@NonNull IADBExecutor executor, @NonNull ADBDevice device, boolean useParallelStream) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult completedProcess = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " pm list packages -f");
        @NonNull List<@NonNull Pair<@NonNull String, @NonNull String>> packageInfo = ADBWrapper.parseListPackagesOutput(completedProcess.getOutput());
        if (packageInfo.isEmpty()) {
            throw new IADBTask.ADBExecutionException("Couldn't get the list of installed packages");
        }
        @NonNull @NonNull @NonNull Stream packageStream = useParallelStream ? (Stream)NullUtils.neverNull(packageInfo.parallelStream()) : (Stream)NullUtils.neverNull(packageInfo.stream());
        List<@NonNull T> packages = packageStream.map(pkg -> this.createADBInstalledPackage(executor, device, (Pair<String, String>)pkg)).collect(Collectors.toList());
        device.updateInstalledPackages((List)NullUtils.neverNull(packages));
        return device.getPackages();
    }

    @Override
    public @NonNull List<@NonNull ADBInstalledPackage> getDebuggablePackages(@NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        return this.getDebuggablePackages(executor, device, true);
    }

    @Override
    public @NonNull List<@NonNull ADBInstalledPackage> getDebuggablePackages(@NonNull IADBExecutor executor, @NonNull ADBDevice device, boolean useParallelStream) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        List<@NonNull ADBInstalledPackage> installedPacakges = this.getInstalledPackages(executor, device, useParallelStream);
        if (installedPacakges.isEmpty()) {
            throw new IADBTask.ADBExecutionException("Couldn't get the list of debuggable packages");
        }
        @NonNull List<@NonNull ADBInstalledPackage> debuggablePackages = installedPacakges.stream().filter(ADBInstalledPackage::isDebuggable).collect(Collectors.toList());
        return debuggablePackages;
    }

    private static @NonNull List<@NonNull Pair<@NonNull String, @NonNull String>> parseListPackagesOutput(@NonNull String output) {
        @NonNull ArrayList<@NonNull Pair<@NonNull String, @NonNull String>> packages = new ArrayList<Pair<String, String>>();
        String[] stringArray = output.split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher m = PackagePattern.matcher(line);
            if (m.matches()) {
                packages.add(new Pair<String, String>((String)NullUtils.neverNull((Object)m.group(1)), (String)NullUtils.neverNull((Object)m.group(2))));
            }
            ++n2;
        }
        return packages;
    }

    @Override
    public void installApplication(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String apkLocation, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, device, "install -r \"" + apkLocation + "\"");
        if (!this.isAPKInstalledOnDevice(executor, device, packageName)) {
            throw new IADBTask.ADBExecutionException("Failed to install " + packageName + " at " + apkLocation);
        }
    }

    @Override
    public void uninstallApplication(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, device, "uninstall " + packageName);
        if (this.isAPKInstalledOnDevice(executor, device, packageName)) {
            throw new IADBTask.ADBExecutionException("Failed to uninstall " + packageName);
        }
    }

    @Override
    public boolean isAPKInstalledOnDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        for (ADBInstalledPackage installedPackage : this.getInstalledPackages(executor, device)) {
            if (!installedPackage.getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getDumpsysOutputForPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " dumpsys package " + packageName).getOutput();
    }

    @Override
    public @NonNull String getInstalledPackageVersion(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String dumpsys = this.getDumpsysOutputForPackage(executor, device, packageName);
        Matcher matcher = Pattern.compile(".*?versionName\\=([\\S]+).*").matcher(dumpsys);
        if (matcher.find()) {
            return (String)NullUtils.neverNull((Object)matcher.group(1));
        }
        throw new IADBTask.ADBExecutionException("Couldn't get the version of " + packageName);
    }

    @Override
    public void pushFileToDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String hostFilePath, @NonNull String targetFilePath) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, NullUtils.formattedString((String)"push \"%s\" \"%s\"", (Object[])new Object[]{hostFilePath, targetFilePath}));
        if (result.getExitCode() != 0 || !this.doesFileExistOnDevice(executor, device, targetFilePath)) {
            throw new IADBTask.ADBExecutionException("Unable to push '" + hostFilePath + "' to '" + targetFilePath + "'");
        }
    }

    @Override
    public void pushFileToDeviceAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String hostFilePath, @NonNull String targetFilePath, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String hostBaseName = FilenameUtils.getName((String)hostFilePath).trim();
        if (hostBaseName.isEmpty()) {
            throw new IADBTask.ADBExecutionException("Copy of directory or empty path attempted");
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (ADBTempDir tempDir = new ADBTempDir(executor, device, this.adbPath);){
            String tempFile = String.valueOf(tempDir.getTempDirName()) + "/" + hostBaseName;
            this.pushFileToDevice(executor, device, hostFilePath, tempFile);
            this.copyFileAsPackage(executor, device, tempFile, targetFilePath, packageName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean doesFileExistOnDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToCheck) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " ls -ld '" + fileToCheck + "'");
        return !result.getOutput().contains("No such file") && !result.getOutput().contains("Permission denied");
    }

    @Override
    public boolean doesFileExistOnDeviceAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToCheck, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.runAsPackage(executor, device, packageName, "ls -ld '" + fileToCheck + "'");
        return !result.getOutput().contains("No such file") && !result.getOutput().contains("Permission denied");
    }

    @Override
    public boolean doesFileExistOnDeviceWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToCheck) throws IADBTask.InvalidADBException {
        IADBExecutor.IResult result = this.runAsRoot(executor, device, "ls -ld '" + fileToCheck + "'");
        return !result.getOutput().contains("No such file") && !result.getOutput().contains("Permission denied");
    }

    @Override
    public void remountPartitionAsReadWritableWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String partitionName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        if (this.hasWritePermissionsOnPartitionWithRoot(executor, device, partitionName)) {
            return;
        }
        this.runAsRoot(executor, device, "mount -o rw,remount " + partitionName);
        if (!this.hasWritePermissionsOnPartitionWithRoot(executor, device, partitionName)) {
            throw new IADBTask.ADBExecutionException("Remounting filesystem " + partitionName + " failed.");
        }
    }

    @Override
    public String @NonNull [] getMountPoints(@NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException {
        int mountPointIndex = 4;
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " cat /proc/self/mountinfo");
        Object[] mountPoints = (String[])Pattern.compile("[\r\n]+").splitAsStream(result.getOutput()).map(line -> {
            String[] tokens = line.split("\\s");
            if (tokens.length > 4) {
                return tokens[4];
            }
            return "";
        }).filter(path -> !path.isEmpty()).sorted().toArray(String[]::new);
        return (String[])NullUtils.neverNull((Object[])mountPoints);
    }

    @Override
    public @NonNull String getMountPointForPath(String path, String[] mountPoints) {
        int pathSeparator = 47;
        assert (!path.isEmpty());
        assert (path.charAt(0) == '/');
        String longestMountPoint = "";
        String[] stringArray = mountPoints;
        int n = mountPoints.length;
        int n2 = 0;
        while (n2 < n) {
            String mountPoint = stringArray[n2];
            if (mountPoint.length() > longestMountPoint.length() && path.startsWith(String.valueOf(mountPoint) + '/')) {
                longestMountPoint = mountPoint;
            }
            ++n2;
        }
        return longestMountPoint.isEmpty() ? (String)NullUtils.neverNull((Object)Character.toString('/')) : longestMountPoint;
    }

    @Override
    public @NonNull String getMountPointForPath(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String path) throws IADBTask.InvalidADBException {
        return this.getMountPointForPath(path, this.getMountPoints(executor, device));
    }

    private boolean hasWritePermissionsOnPartitionWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String partitionName) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        String testFile = String.valueOf(partitionName) + "/testWritePermissionsFile";
        this.runAsRoot(executor, device, "touch '" + testFile + "'");
        if (this.doesFileExistOnDeviceWithRoot(executor, device, testFile)) {
            this.deleteFileWithRoot(executor, device, testFile);
            return true;
        }
        return false;
    }

    private void doSourceDestinationOperationWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String source, @NonNull String destination, @NonNull String operation, @NonNull String operationDescription) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.runAsRoot(executor, device, String.valueOf(operation) + " '" + source + "' '" + destination + "'");
        if (result.getExitCode() != 0 || !this.doesFileExistOnDeviceWithRoot(executor, device, destination)) {
            throw new IADBTask.ADBExecutionException("Unable to " + operationDescription + " from \"" + source + "\" to \"" + destination + "\"");
        }
    }

    private void doSourceDestinationOperationAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String source, @NonNull String destination, @NonNull String operation, @NonNull String operationDescription, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.runAsPackage(executor, device, packageName, String.valueOf(operation) + " '" + source + "' '" + destination + "'");
        if (result.getExitCode() != 0 || !this.doesFileExistOnDeviceAsPackage(executor, device, destination, packageName)) {
            throw new IADBTask.ADBExecutionException("Unable to " + operationDescription + " from \"" + source + "\" to \"" + destination + "\"");
        }
    }

    @Override
    public void copyFileWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String from, @NonNull String to) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.doSourceDestinationOperationWithRoot(executor, device, from, to, "cp -f", "copy file");
    }

    @Override
    public void copyFileAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String from, @NonNull String to, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.doSourceDestinationOperationAsPackage(executor, device, from, to, "cp -f", "copy file", packageName);
    }

    @Override
    public void moveFileWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String from, @NonNull String to) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.doSourceDestinationOperationWithRoot(executor, device, from, to, "mv -f", "move file");
    }

    @Override
    public void createSymlinkWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String source, @NonNull String destination) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.doSourceDestinationOperationWithRoot(executor, device, source, destination, "ln -sf", "create symlink");
    }

    @Override
    public void createHardLinkWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String source, @NonNull String destination) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.doSourceDestinationOperationWithRoot(executor, device, source, destination, "ln -f", "create hard link");
    }

    @Override
    public void deleteFile(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToDelete) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " rm -f '" + fileToDelete + "'");
        if (this.doesFileExistOnDevice(executor, device, fileToDelete)) {
            throw new IADBTask.ADBExecutionException("Unable to delete " + fileToDelete);
        }
    }

    @Override
    public void deleteFileWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToDelete) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsRoot(executor, device, "rm '" + fileToDelete + "'");
        if (this.doesFileExistOnDeviceWithRoot(executor, device, fileToDelete)) {
            throw new IADBTask.ADBExecutionException("Unable to delete " + fileToDelete);
        }
    }

    @Override
    public void deleteFileAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName, @NonNull String fileToDelete) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsPackage(executor, device, packageName, "rm '" + fileToDelete + "'");
        if (this.doesFileExistOnDeviceAsPackage(executor, device, fileToDelete, packageName)) {
            throw new IADBTask.ADBExecutionException("Unable to delete " + fileToDelete);
        }
    }

    @Override
    public void deleteFolderRecursivelyWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String folderToDelete) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsRoot(executor, device, "rm -r '" + folderToDelete + "'");
        if (this.doesFileExistOnDeviceWithRoot(executor, device, folderToDelete)) {
            throw new IADBTask.ADBExecutionException("Unable to delete " + folderToDelete);
        }
    }

    @Override
    public void createFolderRecursivelyWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String directoryName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsRoot(executor, device, "mkdir -p '" + directoryName + "'");
        if (!this.doesFileExistOnDeviceWithRoot(executor, device, directoryName)) {
            throw new IADBTask.ADBExecutionException("Unable to create folder " + directoryName);
        }
    }

    @Override
    public void setAccessPermissionForFileWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToChange, @NonNull String chmodValue) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsRoot(executor, device, "chmod " + chmodValue + " '" + fileToChange + "'");
        this.validateFilePermissionsWithRoot(executor, device, fileToChange, chmodValue);
    }

    @Override
    public void setAccessPermissionForFileAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToChange, @NonNull String chmodValue, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsPackage(executor, device, packageName, "chmod " + chmodValue + " '" + fileToChange + "'");
        this.validateFilePermissionsAsPackage(executor, device, packageName, fileToChange, chmodValue);
    }

    private void validateFilePermissionsWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String fileToChange, @NonNull String chmodValue) throws IADBTask.InvalidADBException {
        String output = this.runAsRoot(executor, device, "ls -l '" + fileToChange + "'").getOutput();
        ADBWrapper.validateFilePermissionsFromLs(output, fileToChange, chmodValue);
    }

    private void validateFilePermissionsAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName, @NonNull String fileToChange, @NonNull String chmodValue) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String output = this.runAsPackage(executor, device, packageName, "ls -l '" + fileToChange + "'").getOutput();
        ADBWrapper.validateFilePermissionsFromLs(output, fileToChange, chmodValue);
    }

    private static void validateFilePermissionsFromLs(@NonNull String output, String fileToChange, String chmodValue) {
        if (output.length() < 10) {
            CoreLogging.warning(null, "Failed to chmod the target file \"" + fileToChange + "\"\n" + "Unexpected chmod output \"" + output + "\"");
            return;
        }
        String substring = output.substring(1, 10);
        String octal = StringUtils.formatUnixPermissionsIntoOctal((String)NullUtils.neverNull((Object)substring));
        if (octal == null || !octal.equals(chmodValue)) {
            CoreLogging.warning(null, "Failed to chmod the target file \"" + fileToChange + "\"");
        }
    }

    @Override
    public void setAccessPermissionForDirectoryWithRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String directoryToChange, @NonNull String chmodValue) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.runAsRoot(executor, device, "chmod " + chmodValue + " '" + directoryToChange + "'");
        this.validateDirectoryPermissions(executor, device, directoryToChange, chmodValue);
    }

    private void validateDirectoryPermissions(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String directoryToChange, @NonNull String chmodValue) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        String output = this.runAsRoot(executor, device, "ls -ld '" + directoryToChange + "'").getOutput();
        if (output.length() < 10) {
            throw new IADBTask.ADBExecutionException("Failed to chmod the target directory \"" + directoryToChange + "\"\n" + "Unexpected chmod output \"" + output + "\"");
        }
        String substring = output.substring(1, 10);
        String octal = StringUtils.formatUnixPermissionsIntoOctal((String)NullUtils.neverNull((Object)substring));
        if (octal == null || !octal.equals(chmodValue)) {
            throw new IADBTask.ADBExecutionException("Failed to chmod the target directory \"" + directoryToChange + "\"");
        }
    }

    @Override
    public byte @NonNull [] getMD5Digest(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String filePath, @NonNull String directoryToPullFrom) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        byte[] digest = null;
        if (device.hasMd5Sum()) {
            IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " md5sum -b " + filePath);
            String output = result.getOutput().trim();
            try {
                digest = DatatypeConverter.parseHexBinary((String)output);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            File destinationFile = null;
            boolean copiedToSDCard = false;
            try {
                destinationFile = FileUtils.getFileInTempDir(String.valueOf(Integer.toString(device.hashCode())) + ".tempfile");
                String absolutePath = destinationFile.getAbsolutePath();
                this.copyFileWithRoot(executor, device, filePath, String.valueOf(directoryToPullFrom) + "mgd.temp");
                copiedToSDCard = true;
                this.submitADBCommand(executor, device, "pull " + directoryToPullFrom + "mgd.temp \"" + absolutePath + "\"");
                destinationFile = new File(absolutePath);
                digest = HashUtils.getMD5Hash(destinationFile);
            }
            finally {
                if (destinationFile != null) {
                    destinationFile.delete();
                }
                if (copiedToSDCard) {
                    this.deleteFile(executor, device, String.valueOf(directoryToPullFrom) + "mgd.temp");
                }
            }
        }
        if (digest == null || digest.length != 16) {
            throw new IADBTask.ADBExecutionException("Unable to get MD5 for " + filePath);
        }
        return digest;
    }

    @Override
    public long getFreeSpaceForPartition(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String partitionName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " df -h " + partitionName);
        List<String> lines = Arrays.asList(result.getOutput().split("\\r?\\n"));
        String partitionInfoLine = null;
        for (String line : lines) {
            if (!line.contains(partitionName)) continue;
            partitionInfoLine = line;
        }
        if (partitionInfoLine == null) {
            throw new IADBTask.ADBExecutionException("Failed to get size information for filesystem \"" + partitionName + "\"");
        }
        if (partitionInfoLine.contains("Permission denied")) {
            throw new IADBTask.ADBExecutionException("Permission denied when querying size of filesystem \"" + partitionName + "\"");
        }
        String[] splitPartition = partitionInfoLine.split("\\s+");
        if (splitPartition.length < 5) {
            throw new IADBTask.ADBExecutionException("Failed to get size information for filesystem \"" + partitionName + "\"");
        }
        return ADBWrapper.parseHumanReadableFreeSpaceString(splitPartition[3]);
    }

    private static long parseHumanReadableFreeSpaceString(@Nullable String freespace) throws IADBTask.ADBExecutionException {
        double space;
        if (freespace == null || freespace.isEmpty()) {
            throw new IADBTask.ADBExecutionException("Could not parse empty free filesystem space string");
        }
        try {
            space = Double.parseDouble(freespace.substring(0, freespace.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new IADBTask.ADBExecutionException("Could not parse free filesystem space string \"" + freespace + "\"");
        }
        char unit = freespace.substring(freespace.length() - 1).charAt(0);
        switch (unit) {
            case 'K': {
                return (long)(space * 1024.0);
            }
            case 'M': {
                return (long)(space * 1024.0 * 1024.0);
            }
            case 'G': {
                return (long)(space * 1024.0 * 1024.0 * 1024.0);
            }
        }
        throw new IADBTask.ADBExecutionException("Could not parse free filesystem space string \"" + freespace + "\"");
    }

    @Override
    public void startService(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String serviceName) throws IADBTask.InvalidADBException {
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " am startservice -n " + serviceName);
    }

    @Override
    public void startServiceWithFlags(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String serviceName, String ... flags) throws IADBTask.InvalidADBException {
        StringBuilder builder = new StringBuilder(String.valueOf(device.getShellCommand()) + " am startservice -n " + serviceName);
        Stream.of(flags).forEach(flag -> {
            StringBuilder stringBuilder2 = builder.append(" " + flag);
        });
        this.submitADBCommand(executor, device, NullUtils.buildString((StringBuilder)builder));
    }

    @Override
    public void forceStopAndroidApplicationFromNamedPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " am force-stop " + packageName);
    }

    @Override
    public void waitUntilServiceRunningOnDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String activityName, long timeoutMillis) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        long startTime = System.currentTimeMillis();
        do {
            IADBExecutor.IResult result;
            if ((result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " dumpsys activity services " + activityName)).getOutput().contains(activityName)) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IADBTask.ADBExecutionException(e);
            }
        } while (System.currentTimeMillis() - startTime < timeoutMillis);
        throw new IADBTask.ADBExecutionException("Timed out while waiting for service " + activityName + " to start");
    }

    @Override
    public void rebootDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device) throws IADBTask.InvalidADBException {
        this.submitADBCommand(executor, device, "reboot");
    }

    @Override
    public int getProcessIDForNamedProcess(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String processName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        try {
            return Integer.parseInt(this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " pgrep " + processName).getOutput().trim());
        }
        catch (NumberFormatException e) {
            throw new IADBTask.ADBExecutionException(NullUtils.formattedString((String)"Unable to find process ID for process %s", (Object[])new Object[]{processName}));
        }
    }

    @Override
    public boolean checkIfProcessIsRunning(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String processName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        return this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " ps " + processName).getOutput().contains(processName);
    }

    private @NonNull String formatADBCommand(@NonNull String command) {
        return NullUtils.formattedString((String)"\"%s\" %s", (Object[])new Object[]{this.adbPath, command});
    }

    private @NonNull String formatADBCommand(@NonNull ADBDeviceIdentifier deviceIdentifier, @NonNull String command) {
        return NullUtils.formattedString((String)"\"%s\" %s %s", (Object[])new Object[]{this.adbPath, deviceIdentifier.getQualifierForADB(), command});
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull ADBDeviceIdentifier deviceIdentifier, @NonNull String command) throws IADBTask.InvalidADBException {
        return executor.executeCommand(this.formatADBCommand(deviceIdentifier, command));
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String command) throws IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device.getIdentifier(), command);
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull ADBDeviceIdentifier deviceIdentifier, @NonNull String command, int timeout, @NonNull TimeUnit unit) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        return executor.executeCommand(this.formatADBCommand(deviceIdentifier, command), timeout, unit);
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String command, int timeout, @NonNull TimeUnit unit) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device.getIdentifier(), command, timeout, unit);
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull String command) throws IADBTask.InvalidADBException {
        return executor.executeCommand(this.formatADBCommand(command));
    }

    protected @NonNull IADBExecutor.IResult submitADBCommand(@NonNull IADBExecutor executor, @NonNull String command, int timeout, @NonNull TimeUnit unit) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        return executor.executeCommand(this.formatADBCommand(command), timeout, unit);
    }

    @Override
    public @NonNull IADBExecutor.IResult runAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName, String commandLine) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " run-as '" + packageName + "' " + commandLine);
        if (result.getExitCode() != 0) {
            if (result.getOutput().contains("run-as: unknown package: ")) {
                throw new IADBTask.ADBExecutionException("No package \"" + packageName + "\"");
            }
            if (result.getOutput().contains("run-as: package not debuggable: ")) {
                throw new IADBTask.ADBExecutionException("Package \"" + packageName + "\" is not debuggable");
            }
        }
        return result;
    }

    protected @NonNull IADBExecutor.IResult runAsRoot(@NonNull IADBExecutor executor, @NonNull ADBDevice device, String commandLine) throws IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device, String.valueOf(device.getSUshellCommand()) + " " + commandLine);
    }

    protected @NonNull IADBExecutor.IResult runAsShell(@NonNull IADBExecutor executor, @NonNull ADBDevice device, String commandLine) throws IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + " " + commandLine);
    }

    protected @NonNull String probeRootCommandLine(@NonNull IADBExecutor executor, @NonNull ADBDeviceIdentifier deviceIdentifier, @NonNull StringBuilder adbShellParams) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        String noSUcommand = "";
        String[] SUcommands = new String[]{"su root -c", "su 0"};
        int forcePTY = 0;
        while (forcePTY <= 1) {
            adbShellParams.setLength(0);
            if (forcePTY == 1) {
                adbShellParams.append("-t -t");
            }
            String[] stringArray = SUcommands;
            int n = SUcommands.length;
            int n2 = 0;
            while (n2 < n) {
                String SUcommand = stringArray[n2];
                String testShellCommand = "shell " + (adbShellParams.length() == 0 ? "" : adbShellParams + " ") + SUcommand + " " + "cat /proc/version  # Find correct su command-line";
                IADBExecutor.IResult result = this.submitADBCommand(executor, deviceIdentifier, testShellCommand, 10, TimeUnit.SECONDS);
                if (result.getOutput().contains("su: not found") || result.getOutput().contains("su: inaccessible")) {
                    return "";
                }
                if (result.getExitCode() == 0 && result.getOutput().contains("Linux")) {
                    return (String)NullUtils.neverNull((Object)SUcommand);
                }
                ++n2;
            }
            ++forcePTY;
        }
        adbShellParams.setLength(0);
        return "";
    }

    @Override
    public void launchIntentOnDevice(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String intentPath, boolean launchAsDebuggable) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.submitADBCommand(executor, device, NullUtils.formattedString((String)"%s am start -S%s -n '%s'", (Object[])new Object[]{device.getShellCommand(), launchAsDebuggable ? " -D" : "", intentPath}));
        if (result.getExitCode() != 0) {
            throw new IADBTask.ADBExecutionException("Intent " + intentPath + " generated an error");
        }
    }

    @Override
    public @NonNull String getLogcatOutputForTag(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String tag, @NonNull String options) throws IADBTask.InvalidADBException {
        return this.submitADBCommand(executor, device, "logcat -d -s " + tag + " " + options).getOutput();
    }

    @Override
    public void deleteGlobalDeviceSetting(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String key) throws IADBTask.InvalidADBException {
        this.submitADBCommand(executor, device, String.valueOf(device.getShellCommand()) + NullUtils.formattedString((String)" settings delete global '%s'", (Object[])new Object[]{key}));
    }

    @Override
    public boolean killAllAsPackage(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName, @NonNull String processName) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        return this.runAsPackage(executor, device, packageName, "killall '" + processName + "'").getExitCode() == 0;
    }

    @Override
    public @NonNull String getADBPath() {
        return this.adbPath;
    }

    @Override
    public @NonNull Set<@NonNull Integer> getPID(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String packageName) throws IADBTask.ADBExecutionException, IADBTask.InvalidADBException {
        IADBExecutor.IResult result = this.runAsShell(executor, device, "pgrep -f '^" + packageName.replace(".", "\\.") + "'");
        return Arrays.stream(result.getOutput().split("[\n\r]+")).filter(l -> l.matches("[0-9]+")).map(Integer::valueOf).collect(Collectors.toSet());
    }
}

