/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IADBTempDir;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;

public class ADBTempDir
implements IADBTempDir {
    private final @NonNull IADBExecutor executor;
    private final @NonNull ADBDevice device;
    private final @NonNull String commandLinePrefix;
    private final @NonNull String tempDirName;

    public ADBTempDir(@NonNull IADBExecutor executor, @NonNull ADBDevice device, @NonNull String adbPath) throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        this.executor = executor;
        this.device = device;
        this.tempDirName = "/data/local/tmp/ga-temp_" + System.currentTimeMillis() + "_" + UUID.randomUUID();
        this.commandLinePrefix = String.valueOf(adbPath) + " " + device.getIdentifier().getQualifierForADB() + " shell ";
        IADBExecutor.IResult result = executor.executeCommand(String.valueOf(this.commandLinePrefix) + "mkdir '" + this.tempDirName + "'");
        if (result.getExitCode() != 0) {
            throw new IADBTask.ADBExecutionException("Can't create temporary directory \"" + this.tempDirName + "\" on device " + device.getUnambiguousName());
        }
    }

    @Override
    public void close() throws IADBTask.InvalidADBException, IADBTask.ADBExecutionException {
        IADBExecutor.IResult result = this.executor.executeCommand(String.valueOf(this.commandLinePrefix) + "rm -rf '" + this.tempDirName + "'");
        if (result.getExitCode() != 0) {
            throw new IADBTask.ADBExecutionException("Can't remove temporary directory \"" + this.tempDirName + "\" on device " + this.device.getUnambiguousName());
        }
    }

    @Override
    public @NonNull String getTempDirName() {
        return this.tempDirName;
    }

    public String toString() {
        return this.getTempDirName();
    }
}

