/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ADBTaskManager {
    private final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("AndroidTaskManager executor", true);
    private final @NonNull ExecutorService threadPool = NamedExecutors.cachedInfiniteThreadPool(10L, TimeUnit.SECONDS, new NamedThreadFactory("AndroidTaskManager Pool"));
    private final @NonNull WeakListenerSet<@NonNull PublicTaskListener> listeners = new WeakListenerSet();
    private final @NonNull ArrayList<@NonNull PrivateTask<?>> queuedPrivateTasks = new ArrayList();
    private final @NonNull ArrayList<@NonNull PrivateTask<?>> runningPrivateTasks = new ArrayList();
    private final @NonNull ArrayList<@NonNull PublicTask> queuedPublicTasks = new ArrayList();
    private final @NonNull ArrayList<@NonNull PublicTask> runningPublicTasks = new ArrayList();
    private final @NonNull ArrayList<@NonNull CompletedPublicTask> completedPublicTasks = new ArrayList();

    public <T> void submitPrivateTask(@NonNull IADBTask<T> task, @NonNull PrivateTaskListener<T> listener) {
        this.executor.runLater(() -> {
            this.queuedPrivateTasks.add(new PrivateTask(task, listener));
            this.scheduleTasks();
        });
    }

    public void submitPublicTask(@NonNull IADBTask<Void> task) {
        this.executor.runLater(() -> {
            PublicTask newTask = new PublicTask(task);
            this.queuedPublicTasks.add(newTask);
            this.listeners.notifyWeakListeners(listener -> listener.onTaskAdded(task));
            this.scheduleTasks();
        });
    }

    public void addListener(@NonNull PublicTaskListener listener) {
        this.executor.runLater(() -> {
            this.listeners.addListenerAsWeakReference(listener);
            for (CompletedPublicTask completedTask : this.completedPublicTasks) {
                listener.onTaskAdded(completedTask.publicTask.task);
                listener.onTaskStarted(completedTask.publicTask.task);
                listener.onTaskCompleted(completedTask.result);
            }
            for (PublicTask publicTask : this.runningPublicTasks) {
                listener.onTaskAdded(publicTask.task);
                listener.onTaskStarted(publicTask.task);
            }
            for (PublicTask publicTask : this.queuedPublicTasks) {
                listener.onTaskAdded(publicTask.task);
            }
        });
    }

    public void removeListener(@NonNull PublicTaskListener listener) {
        this.listeners.removeWeakReference(listener);
    }

    public void removeCompletedPublicTask(@NonNull IADBTask<?> task) {
        this.executor.runLater(() -> {
            Iterator<CompletedPublicTask> completedTaskIterator = this.completedPublicTasks.iterator();
            while (completedTaskIterator.hasNext()) {
                CompletedPublicTask completedTask = completedTaskIterator.next();
                if (!completedTask.publicTask.task.equals(task)) continue;
                completedTaskIterator.remove();
                this.listeners.notifyWeakListeners(listener -> listener.onTaskRemoved(completedPublicTask.result));
            }
        });
    }

    public void clearCompletedPublicTasks() {
        this.executor.runLater(() -> {
            this.listeners.notifyWeakListeners(listener -> {
                for (CompletedPublicTask completedTask : this.completedPublicTasks) {
                    listener.onTaskRemoved(completedTask.result);
                }
            });
            this.completedPublicTasks.clear();
        });
    }

    public void cancelTask(@NonNull IADBTask<?> task) {
        this.executor.runLater(() -> {
            Iterator<PrivateTask<?>> privateTaskIterator = this.queuedPrivateTasks.iterator();
            while (privateTaskIterator.hasNext()) {
                PrivateTask<?> privateTask = privateTaskIterator.next();
                if (!privateTask.task.equals(task)) continue;
                privateTaskIterator.remove();
                CompletedPrivateTask<?> completedTask = privateTask.cancel();
                completedTask.notifyListener();
            }
            Iterator<PublicTask> publicTaskIt = this.queuedPublicTasks.iterator();
            while (publicTaskIt.hasNext()) {
                PublicTask publicTask = publicTaskIt.next();
                if (!publicTask.task.equals(task)) continue;
                publicTaskIt.remove();
                CompletedTask<Void> result = new CompletedTask<Void>(publicTask.task, NullUtils.emptyList(), null, null, new IADBTask.ADBExecutionException("Task was cancelled"));
                CompletedPublicTask completedTask = new CompletedPublicTask(publicTask, result);
                this.completedPublicTasks.add(completedTask);
                this.listeners.notifyWeakListeners(listener -> {
                    listener.onTaskStarted(publicTask.task);
                    listener.onTaskCompleted(completedPublicTask.result);
                });
            }
        });
    }

    public void shutdown() {
        try {
            this.executor.runLater(() -> {
                this.listeners.clear();
                this.queuedPrivateTasks.clear();
                this.queuedPublicTasks.clear();
                this.threadPool.shutdownNow();
                if (this.runningPublicTasks.size() != 0) {
                    try {
                        this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.executor.shutdown();
            }).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void scheduleTasks() {
        assert (this.executor.isCurrentThread());
        Iterator<PrivateTask<?>> privateTaskIt = this.queuedPrivateTasks.iterator();
        while (privateTaskIt.hasNext()) {
            PrivateTask<?> privateTask = privateTaskIt.next();
            if (this.isTaskRunningOnDevice(privateTask.task.getDevice())) continue;
            privateTaskIt.remove();
            this.runningPrivateTasks.add(privateTask);
            this.threadPool.submit(() -> {
                CompletedPrivateTask completedTask = privateTask.complete();
                this.executor.runLater(() -> {
                    boolean removed = this.runningPrivateTasks.remove(privateTask);
                    assert (removed);
                    completedTask.notifyListener();
                    this.scheduleTasks();
                });
            });
        }
        Iterator<PublicTask> publicTaskIt = this.queuedPublicTasks.iterator();
        while (publicTaskIt.hasNext()) {
            PublicTask publicTask = publicTaskIt.next();
            if (this.isTaskRunningOnDevice(publicTask.task.getDevice())) continue;
            publicTaskIt.remove();
            this.runningPublicTasks.add(publicTask);
            this.listeners.notifyWeakListeners(listener -> listener.onTaskStarted(publicTask.task));
            this.threadPool.submit(() -> {
                CompletedTask<Void> result = ADBTaskManager.executeTask(publicTask.task, 60L, TimeUnit.SECONDS);
                CompletedPublicTask completedTask = new CompletedPublicTask(publicTask, result);
                this.executor.runLater(() -> {
                    boolean removed = this.runningPublicTasks.remove(publicTask);
                    assert (removed);
                    this.completedPublicTasks.add(completedTask);
                    this.listeners.notifyWeakListeners(listener -> listener.onTaskCompleted(completedPublicTask.result));
                    this.scheduleTasks();
                });
            });
        }
    }

    private boolean isTaskRunningOnDevice(@Nullable ADBDevice device) {
        if (device != null) {
            for (PrivateTask<?> privateTask : this.runningPrivateTasks) {
                if (!device.equals(privateTask.task.getDevice())) continue;
                return true;
            }
            for (PublicTask publicTask : this.runningPublicTasks) {
                if (!device.equals(publicTask.task.getDevice())) continue;
                return true;
            }
        }
        return false;
    }

    private static <T> @NonNull CompletedTask<T> executeTask(@NonNull IADBTask<T> task, long perCommandTimeout, @NonNull TimeUnit perCommandTimeoutUnit) {
        IADBTask.TaskResult<T> result = null;
        IADBTask.InvalidADBException invalidADBException = null;
        IADBTask.ADBExecutionException adbExecutionException = null;
        SynchronousADBExecutor executor = new SynchronousADBExecutor(perCommandTimeout, perCommandTimeoutUnit);
        try {
            result = task.run(executor);
        }
        catch (IADBTask.InvalidADBException e) {
            invalidADBException = e;
        }
        catch (IADBTask.ADBExecutionException e) {
            adbExecutionException = e;
        }
        catch (Throwable t) {
            invalidADBException = new IADBTask.InvalidADBException("An unknown error occurred: " + t.getMessage(), t);
        }
        return new CompletedTask<T>(task, executor.getCommandHistory(), result, invalidADBException, adbExecutionException);
    }

    private static class CompletedPrivateTask<T> {
        private final @NonNull PrivateTask<T> privateTask;
        private final @NonNull CompletedTask<T> result;

        private CompletedPrivateTask(@NonNull PrivateTask<T> task, @NonNull CompletedTask<T> result) {
            this.privateTask = task;
            this.result = result;
        }

        public void notifyListener() {
            this.privateTask.listener.onTaskCompleted(this.result);
        }
    }

    private static class CompletedPublicTask {
        private final @NonNull PublicTask publicTask;
        private final @NonNull CompletedTask<Void> result;

        private CompletedPublicTask(@NonNull PublicTask task, @NonNull CompletedTask<Void> result) {
            this.publicTask = task;
            this.result = result;
        }
    }

    public static class CompletedTask<T> {
        private final @NonNull IADBTask<T> task;
        private final @NonNull List< @NonNull IADBExecutor.IResult> commandHistory;
        private final @Nullable IADBTask.TaskResult<T> result;
        private final @Nullable IADBTask.InvalidADBException invalidADBException;
        private final @Nullable IADBTask.ADBExecutionException adbExecutionException;

        private CompletedTask(@NonNull IADBTask<T> task, @NonNull List< @NonNull IADBExecutor.IResult> commandHistory, @Nullable IADBTask.TaskResult<T> result, @Nullable IADBTask.InvalidADBException invalidADBException, @Nullable IADBTask.ADBExecutionException adbExecutionException) {
            assert (invalidADBException == null || adbExecutionException == null);
            this.task = task;
            this.commandHistory = NullUtils.unmodifiableList(commandHistory);
            this.result = result;
            this.invalidADBException = invalidADBException;
            this.adbExecutionException = adbExecutionException;
        }

        public @NonNull IADBTask<T> getTask() {
            return this.task;
        }

        public @NonNull List< @NonNull IADBExecutor.IResult> getCommandHistory() {
            return this.commandHistory;
        }

        public void accept(@NonNull CompletedTaskVisitor<T> visitor) {
            if (this.invalidADBException != null) {
                visitor.onTaskThrewInvalidADBException(this.invalidADBException);
            } else if (this.adbExecutionException != null) {
                visitor.onTaskThrewADBExecutionException(this.adbExecutionException);
            } else {
                assert (this.result != null);
                visitor.onTaskSuccess(this.result);
            }
        }

        public static interface CompletedTaskVisitor<T> {
            public void onTaskSuccess(@NonNull IADBTask.TaskResult<T> var1);

            public void onTaskThrewInvalidADBException(@NonNull IADBTask.InvalidADBException var1);

            public void onTaskThrewADBExecutionException(@NonNull IADBTask.ADBExecutionException var1);
        }
    }

    private static class PrivateTask<T> {
        private final @NonNull IADBTask<T> task;
        private final @NonNull PrivateTaskListener<T> listener;

        private PrivateTask(@NonNull IADBTask<T> task, @NonNull PrivateTaskListener<T> listener) {
            this.task = task;
            this.listener = listener;
        }

        private @NonNull CompletedPrivateTask<T> complete() {
            return new CompletedPrivateTask<T>(this, ADBTaskManager.executeTask(this.task, 60L, TimeUnit.SECONDS));
        }

        private @NonNull CompletedPrivateTask<T> cancel() {
            return new CompletedPrivateTask<T>(this, new CompletedTask<T>(this.task, NullUtils.EMPTY_LIST, null, null, new IADBTask.ADBExecutionException("Task was cancelled")));
        }

        public String toString() {
            return "Private ADB task " + this.task.hashCode() + " [" + (Object)((Object)this.task.getDescription()) + "]";
        }
    }

    public static interface PrivateTaskListener<T> {
        public void onTaskCompleted(@NonNull CompletedTask<T> var1);
    }

    private static class PublicTask {
        private final @NonNull IADBTask<Void> task;

        private PublicTask(@NonNull IADBTask<Void> task) {
            this.task = task;
        }

        public String toString() {
            return "Public ADB task " + this.task.hashCode() + " [" + (Object)((Object)this.task.getDescription()) + "]";
        }
    }

    public static interface PublicTaskListener
    extends PrivateTaskListener<Void> {
        public void onTaskAdded(@NonNull IADBTask<Void> var1);

        public void onTaskStarted(@NonNull IADBTask<Void> var1);

        public void onTaskRemoved(@NonNull CompletedTask<Void> var1);
    }
}

