/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.utils.NullUtils;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class ADBInstalledPackage {
    private final @NonNull String location;
    private final @NonNull String packageName;
    private final @NonNull Set<@NonNull String> activities;
    private final boolean isDebuggable;
    private final  @NonNull ADBDevice.Architecture primaryCpuAbi;

    public ADBInstalledPackage(@NonNull String location, @NonNull String packageName, @NonNull Set<@NonNull String> activities, boolean isDebuggable,  @NonNull ADBDevice.Architecture architecture) {
        this.location = location;
        this.packageName = packageName;
        this.isDebuggable = isDebuggable;
        this.activities = NullUtils.unmodifiableSet(activities);
        this.primaryCpuAbi = architecture;
    }

    ADBInstalledPackage(@NonNull String location, @NonNull String packageName) {
        this(location, packageName, NullUtils.EMPTY_SET, false, ADBDevice.Architecture.UNKNOWN);
    }

    public @NonNull String getLocation() {
        return this.location;
    }

    public @NonNull String getPackageName() {
        return this.packageName;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public @NonNull Set<@NonNull String> getMainActivities() {
        return this.activities;
    }

    public  @NonNull ADBDevice.Architecture getPrimaryCpuAbi() {
        return this.primaryCpuAbi;
    }

    public @NonNull String getLaunchableIntent(@NonNull String activityToLaunch) {
        return String.valueOf(this.getPackageName()) + "/" + activityToLaunch;
    }

    public String toString() {
        return String.format("Package: %s Location: %s", this.getPackageName(), this.getLocation());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ADBInstalledPackage)) {
            return false;
        }
        ADBInstalledPackage other = (ADBInstalledPackage)obj;
        return this.packageName.matches(other.packageName) && this.location.matches(other.location) && this.isDebuggable() == other.isDebuggable() && this.activities.equals(other.activities);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

