/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class ADBDeviceIdentifier {
    private final @NonNull String ID;
    private final @NonNull String qualifier;
    private final @NonNull Status status;

    public ADBDeviceIdentifier(@NonNull String ID, @NonNull String qualifier, @NonNull Status status) {
        this.ID = ID;
        this.qualifier = qualifier;
        this.status = status;
    }

    public @NonNull String getQualifier() {
        return this.qualifier;
    }

    public @NonNull String getQualifierForADB() {
        return "-s " + this.getQualifier();
    }

    public @NonNull String getID() {
        return this.ID;
    }

    public @NonNull Status getStatus() {
        return this.status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ADBDeviceIdentifier) {
            ADBDeviceIdentifier device = (ADBDeviceIdentifier)obj;
            return device.getQualifier().equals(this.getQualifier()) && device.getID().equals(this.getID()) && device.getStatus().equals((Object)device.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ID, this.qualifier, this.status});
    }

    public static enum Status {
        OFFLINE("offline"),
        UNAUTHORIZED("unauthorized"),
        ERROR("error"),
        DEVICE("device"),
        UNKNOWN("unknown");

        private final @NonNull String name;

        public @NonNull String getName() {
            return this.name;
        }

        private Status(String name) {
            this.name = name;
        }

        public static @NonNull Status parseStatus(@NonNull String statusString) {
            Status[] statusArray = Status.values();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status status = statusArray[n2];
                if (status.name.equals(statusString)) {
                    return status;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

