/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.adb;

import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.AndroidSDKVersion;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ADBDevice {
    private static final @NonNull String ADB_SHELL_CMD = "shell";
    private final @NonNull ADBDeviceIdentifier identifier;
    private final @NonNull String manufacturer;
    private final @NonNull String model;
    private final @NonNull String androidVersion;
    private final int androidSDKAPILevel;
    private final @NonNull Architecture architecture;
    private final boolean isRooted;
    private final boolean hasMd5Sum;
    private final boolean isTreble;
    private final @NonNull String nonRootEnvironment;
    private final @NonNull String rootAdbShellParams;
    private final @NonNull String suCommand;
    private final @NonNull List<@NonNull ADBInstalledPackage> installedPackages = new ArrayList<ADBInstalledPackage>();

    protected ADBDevice(@NonNull ADBDeviceIdentifier identifier, @NonNull String manufacturer, @NonNull String model, @NonNull String androidVersion, int androidSDKAPILevel, @NonNull Architecture architecture, boolean isRooted, boolean hasMd5Sum, boolean isTreble, @NonNull String nonRootEnvironment, @NonNull String rootAdbShellParams, @NonNull String suCommand) {
        this.identifier = identifier;
        assert (identifier.getStatus() == ADBDeviceIdentifier.Status.DEVICE);
        this.manufacturer = manufacturer;
        this.model = model;
        this.androidVersion = androidVersion;
        this.androidSDKAPILevel = androidSDKAPILevel;
        this.architecture = architecture;
        this.isRooted = isRooted;
        this.hasMd5Sum = hasMd5Sum;
        this.isTreble = isTreble;
        this.nonRootEnvironment = nonRootEnvironment;
        this.rootAdbShellParams = rootAdbShellParams;
        this.suCommand = suCommand;
    }

    public @NonNull ADBDeviceIdentifier getIdentifier() {
        return this.identifier;
    }

    public @NonNull String getQualifier() {
        return this.identifier.getQualifier();
    }

    public @NonNull String getID() {
        return this.identifier.getID();
    }

    public @NonNull String getManufacturer() {
        return this.manufacturer;
    }

    public @NonNull String getModel() {
        return this.model;
    }

    public @NonNull String getAndroidVersion() {
        return this.androidVersion;
    }

    public int getSDKAPILevel() {
        return this.androidSDKAPILevel;
    }

    public @NonNull Architecture getArchitecture() {
        return this.architecture;
    }

    public boolean isRooted() {
        return this.isRooted;
    }

    public boolean hasMd5Sum() {
        return this.hasMd5Sum;
    }

    public boolean isTreble() {
        return this.isTreble;
    }

    public @NonNull String toString() {
        return NullUtils.formattedString((String)"%s %s", (Object[])new Object[]{this.getManufacturer(), this.getModel()});
    }

    public @NonNull String getUnambiguousName() {
        return NullUtils.formattedString((String)"%s %s (%s, %s)", (Object[])new Object[]{this.getManufacturer(), this.getModel(), this.getID(), this.getQualifier()});
    }

    public @NonNull String getAndroidVersionAndSDK() {
        return NullUtils.formattedString((String)"Android %s, API %s", (Object[])new Object[]{this.getAndroidVersion(), NullUtils.neverNull((Object)Integer.toString(this.getSDKAPILevel()))});
    }

    public boolean couldSupportVulkan() {
        return this.androidSDKAPILevel >= AndroidSDKVersion.MARSHMALLOW_6_0_0.apiLevel;
    }

    public boolean isLocalAppStorageVulkanLayerSupported() {
        return this.androidSDKAPILevel >= AndroidSDKVersion.PIE_9_0_0.apiLevel;
    }

    public boolean isLocalAppStorageGLESLayerSupported() {
        return this.androidSDKAPILevel >= AndroidSDKVersion.ANDROID_10.apiLevel;
    }

    public @NonNull String getShellCommand() {
        return ADB_SHELL_CMD + (this.nonRootEnvironment.isEmpty() ? "" : " " + this.nonRootEnvironment);
    }

    public @NonNull String getSUshellCommand() {
        return ADB_SHELL_CMD + (this.rootAdbShellParams.isEmpty() ? " " : " " + this.rootAdbShellParams + " ") + this.suCommand;
    }

    public void updateInstalledPackages(@NonNull List<@NonNull ADBInstalledPackage> packages) {
        this.installedPackages.clear();
        this.installedPackages.addAll(packages);
    }

    public @NonNull List<@NonNull ADBInstalledPackage> getPackages() {
        return this.installedPackages;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ADBDevice) {
            ADBDevice device = (ADBDevice)obj;
            return this.identifier.equals(device.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public static enum Architecture {
        AArch64("arm64-v8a"),
        AArch32("armeabi-v7a"),
        x86_64("x86-64"),
        x86("x86"),
        UNKNOWN("unknown");

        private final @NonNull String name;

        public @NonNull String getName() {
            return this.name;
        }

        private Architecture(String name) {
            this.name = name;
        }

        public static @NonNull Architecture parseArchitecture(@NonNull String architectureString) {
            Architecture[] architectureArray = Architecture.values();
            int n = architectureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Architecture status = architectureArray[n2];
                if (architectureString.contains(status.name)) {
                    return status;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

