/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core;

import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.authorisation.AuthorisationManager;
import com.arm.mgd.core.authorisation.IArmAuthorisationProvider;
import com.arm.mgd.core.devicediscovery.DeviceDiscoveryManager;
import com.arm.mgd.core.navigation.NavigationManager;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.MidgardShaderCompiler;
import com.arm.mgd.core.util.executors.NamedScheduledThreadPoolExecutor;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CoreInstance {
    private static final @NonNull NavigationManager navigationManager = new NavigationManager();
    private static @Nullable AuthorisationManager authorisationManager = null;
    private static final @NonNull ADBTaskManager adbTaskManager = new ADBTaskManager();
    private static @NonNull GlShaderCompiler shaderCompiler = new MidgardShaderCompiler();
    private static final @NonNull ScheduledExecutorService scheduledExecutor = new NamedScheduledThreadPoolExecutor(1, new NamedThreadFactory("CoreInstance Scheduled Executor"));

    public static void setAuthorisationProvider(@NonNull IArmAuthorisationProvider authorisationProvider) {
        authorisationManager = new AuthorisationManager(authorisationProvider);
        ApplicationFeatureAuthoriser.getListOfLifetimeFeatureAuthorisers().forEach(ApplicationFeatureAuthoriser::claimFeature);
    }

    public static @NonNull NavigationManager getNavigationManager() {
        return navigationManager;
    }

    public static @Nullable AuthorisationManager getAuthorisationManager() {
        return authorisationManager;
    }

    public static @NonNull ADBTaskManager getADBTaskManager() {
        return adbTaskManager;
    }

    public static @NonNull ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecutor;
    }

    public static @NonNull GlShaderCompiler getGlShaderCompiler() {
        return shaderCompiler;
    }

    public static @NonNull DeviceDiscoveryManager getDeviceDiscoveryManager() {
        return DeviceDiscoveryManager.getInstance();
    }

    public static void shutdown() {
        if (authorisationManager != null) {
            authorisationManager.releaseAllAuthorisations();
        }
        CoreInstance.getNavigationManager().shutdown();
        CoreInstance.getADBTaskManager().shutdown();
        CoreInstance.getDeviceDiscoveryManager().forceStop();
    }
}

