/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.utils;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.core.devicediscovery.LanDevice;
import com.arm.mgd.core.devicediscovery.SimpleDeviceTracker;
import com.arm.mgd.core.util.AppFinder;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.headless.cli.IMGDCommandLine;
import com.arm.mgd.utils.EclipseUtils;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HeadlessDeviceManager {
    private final @NonNull AndroidBridge bridge;
    private static final @NonNull Collator COLLATOR = (Collator)NullUtils.neverNull((Object)Collator.getInstance());
    private static final @NonNull SimpleDeviceTracker DEVICE_TRACKER = new SimpleDeviceTracker();
    private static final @NonNull Comparator<LanDevice> LAN_DEVICE_COMPARATOR = (first, second) -> {
        int hostNameComparison = COLLATOR.compare(first.getHostname(), second.getHostname());
        if (hostNameComparison != 0) {
            return hostNameComparison;
        }
        return COLLATOR.compare(first.getIp(), second.getIp());
    };
    private static final @NonNull IADBExecutor EXECUTOR = new SynchronousADBExecutor(10L, TimeUnit.SECONDS);
    private static final @NonNull String ADB_LOCATION_FROM_PREFERENCES = "ADB location retrieved from saved preferences: ";
    private static final @NonNull String ADB_LOCATION_AUTODETECTED = "ADB automatically detected at ";
    private static final @NonNull String NO_ADB_LOCATION_PARAM_MESSAGE = "Unable to get ADB location from command line parameters or saved preferences.";
    private static final @NonNull String ADB_LOCATION_IN_PREFERENCES_INVALID = "ADB location in saved preferences is invalid: ";
    @NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> deviceMap = new HashMap<ADBDeviceIdentifier, ADBDevice>();
    private static final @NonNull String DEVICE_TABLE_FORMAT = "%1$-<DEVICE_LEN>s | %2$-17s | %3$-<MODEL_LEN>s";
    private static final @NonNull String DEVICE_LEN = "<DEVICE_LEN>";
    private static final @NonNull String MODEL_LEN = "<MODEL_LEN>";
    private static final @NonNull String DEVICE_COLUMN_TITLE = "Device";
    private static final @NonNull String SUPPORTED_COLUMN_TITLE = "Supported";
    private static final @NonNull String MODEL_COLUMN_TITLE = "Model";
    private static final @NonNull String LINUX_TABLE_FORMAT = "%1$-<HOSTNAME_LEN>s | %2$-<IP_LEN>s";
    private static final @NonNull String HOSTNAME_LEN = "<HOSTNAME_LEN>";
    private static final @NonNull String IP_LEN = "<IP_LEN>";
    private static final @NonNull String HOSTNAME_COLUMN_TITLE = "Host name";
    private static final @NonNull String IP_COLUMN_TITLE = "IP";
    private static final @NonNull String PACKAGE_TABLE_FORMAT = "%1$-<PKG_MAX_LEN>s | %2$-<ACT_MAX_LEN>s | %3$-10s";
    private static final @NonNull String PACKAGE_LEN = "<PKG_MAX_LEN>";
    private static final @NonNull String ACTIVITY_LEN = "<ACT_MAX_LEN>";
    private static final @NonNull String PACKAGE_COLUMN_TITLE = "Package";
    private static final @NonNull String ACTIVITY_COLUMN_TITLE = "Main Activity";
    private static final @NonNull String DEBUGGABLE_COLUMN_TITLE = "Debuggable";

    private HeadlessDeviceManager(@NonNull AndroidBridge bridge) {
        this.bridge = bridge;
        CoreLogging.info(null, (String)"Device manager initialised.");
    }

    public @NonNull AndroidBridge getAndroidBridge() {
        return this.bridge;
    }

    private static int mapEntryToRequiredModelColumnSize(Map.Entry<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> deviceEntry) {
        ADBDevice device = deviceEntry.getValue();
        if (device == null) {
            return deviceEntry.getKey().getStatus().getName().length() + 2;
        }
        return device.getModel().length();
    }

    public static @NonNull String formatTableOfADBDevices(@NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> devices) {
        if (devices.isEmpty()) {
            return "";
        }
        int deviceLen = devices.keySet().stream().mapToInt(id -> id.getID().length()).max().getAsInt();
        int modelLen = devices.entrySet().stream().mapToInt(HeadlessDeviceManager::mapEntryToRequiredModelColumnSize).max().getAsInt();
        Integer deviceColumnSize = Math.max(deviceLen, DEVICE_COLUMN_TITLE.length());
        Integer modelColumnSize = Math.max(modelLen, MODEL_COLUMN_TITLE.length());
        String localFormat = (String)NullUtils.neverNull((Object)DEVICE_TABLE_FORMAT.replace(DEVICE_LEN, deviceColumnSize.toString()).replace(MODEL_LEN, modelColumnSize.toString()));
        String tableContents = devices.entrySet().stream().map(entry -> HeadlessDeviceManager.formatADBDeviceEntryToString((Map.Entry)NullUtils.neverNull((Object)entry), localFormat)).sorted().collect(Collectors.joining(System.lineSeparator()));
        return String.valueOf(String.format(localFormat, DEVICE_COLUMN_TITLE, SUPPORTED_COLUMN_TITLE, MODEL_COLUMN_TITLE)) + System.lineSeparator() + tableContents;
    }

    private static @NonNull String formatADBDeviceEntryToString(@NonNull Map.Entry<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> deviceEntry, @NonNull String format) {
        String supported;
        ADBDeviceIdentifier identifier = deviceEntry.getKey();
        ADBDevice device = deviceEntry.getValue();
        if (identifier.getStatus() != ADBDeviceIdentifier.Status.DEVICE) {
            return NullUtils.formattedString((String)format, (Object[])new Object[]{identifier.getID(), "Unknown", "<" + identifier.getStatus().getName() + ">"});
        }
        assert (device != null);
        String deviceID = device.getID();
        String deviceModel = device.getModel();
        String string = supported = device.isLocalAppStorageVulkanLayerSupported() || device.isLocalAppStorageGLESLayerSupported() ? "Yes" : "No";
        if (device.isLocalAppStorageVulkanLayerSupported() && !device.isLocalAppStorageGLESLayerSupported()) {
            supported = String.valueOf(supported) + " (Vulkan only)";
        }
        return NullUtils.formattedString((String)format, (Object[])new Object[]{deviceID, supported, deviceModel});
    }

    public static @NonNull String formatTableOfLinuxDevices(@NonNull Set<@NonNull LanDevice> linuxDevices) {
        if (linuxDevices.isEmpty()) {
            return "";
        }
        int maxHostnameLen = linuxDevices.stream().mapToInt(dev -> dev.getHostname().length()).max().getAsInt();
        int maxIPLen = linuxDevices.stream().mapToInt(dev -> dev.getIp().length()).max().getAsInt();
        Integer hostnameSize = Math.max(maxHostnameLen, HOSTNAME_COLUMN_TITLE.length());
        Integer IPSize = Math.max(maxIPLen, IP_COLUMN_TITLE.length());
        String localFormat = (String)NullUtils.neverNull((Object)LINUX_TABLE_FORMAT.replace(HOSTNAME_LEN, hostnameSize.toString()).replace(IP_LEN, IPSize.toString()));
        String tableContents = linuxDevices.stream().sorted(LAN_DEVICE_COMPARATOR).map(dev -> HeadlessDeviceManager.formatLanDeviceToLine(localFormat, dev)).collect(Collectors.joining(System.lineSeparator()));
        return String.valueOf(String.format(localFormat, HOSTNAME_COLUMN_TITLE, IP_COLUMN_TITLE)) + System.lineSeparator() + tableContents;
    }

    private static @NonNull String formatLanDeviceToLine(@NonNull String format, @NonNull LanDevice device) {
        return NullUtils.formattedString((String)format, (Object[])new Object[]{device.getHostname(), device.getIp()});
    }

    public @NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> getAllDevicesMap() throws IADBTask.ADBException {
        this.deviceMap = (Map)this.bridge.getDevices(this.deviceMap).run(EXECUTOR).getResults();
        return this.deviceMap;
    }

    public @NonNull String formatTableOfPackagesForDevice(@NonNull ADBDevice device) throws IADBTask.ADBException {
        return HeadlessDeviceManager.formatTableOfPackages((Collection)this.bridge.getInstalledPackages(device).run(EXECUTOR).getResults());
    }

    public static @NonNull String formatTableOfLinuxDevices() {
        return HeadlessDeviceManager.formatTableOfLinuxDevices(DEVICE_TRACKER.getConnectedDevices());
    }

    public static @NonNull String formatTableOfPackages(@NonNull Collection<@NonNull ADBInstalledPackage> packages) {
        if (packages.isEmpty()) {
            return "";
        }
        List activities = packages.stream().flatMap(HeadlessDeviceManager::flatMapPackageToPrintableActivities).sorted().collect(Collectors.toList());
        int maxPackageLen = packages.stream().mapToInt(pkg -> pkg.getPackageName().length()).max().getAsInt();
        int maxActivityLen = activities.stream().mapToInt(act -> act.getActivityName().length()).max().getAsInt();
        Integer packageColumnSize = Math.max(maxPackageLen, PACKAGE_COLUMN_TITLE.length());
        Integer activityColumnSize = Math.max(maxActivityLen, ACTIVITY_COLUMN_TITLE.length());
        String localFormat = (String)NullUtils.neverNull((Object)PACKAGE_TABLE_FORMAT.replace(PACKAGE_LEN, packageColumnSize.toString()).replace(ACTIVITY_LEN, activityColumnSize.toString()));
        String tableContents = activities.stream().map(act -> act.formatToString(localFormat)).collect(Collectors.joining(System.lineSeparator()));
        return String.valueOf(String.format(localFormat, PACKAGE_COLUMN_TITLE, ACTIVITY_COLUMN_TITLE, DEBUGGABLE_COLUMN_TITLE)) + System.lineSeparator() + tableContents;
    }

    private static @NonNull Stream<@NonNull PrintableActivity> flatMapPackageToPrintableActivities(@NonNull ADBInstalledPackage pkg) {
        Set activities = pkg.getMainActivities();
        if (activities.isEmpty()) {
            return (Stream)NullUtils.neverNull(Stream.of(new PrintableActivity(pkg, "Unknown")));
        }
        return (Stream)NullUtils.neverNull(activities.stream().map(act -> new PrintableActivity(pkg, (String)act)));
    }

    public static @NonNull HeadlessDeviceManager create(@NonNull IMGDCommandLine commandLine, @Nullable Path configuredADBLocation) throws IADBTask.ADBException {
        @NonNull String adbPath = (String)NullUtils.neverNull((Object)commandLine.getADBLocation().or(() -> HeadlessDeviceManager.getADBLocation(configuredADBLocation, new ADBAutodetector())).orElseThrow(() -> new IllegalArgumentException(NO_ADB_LOCATION_PARAM_MESSAGE)));
        String currentDevPath = null;
        try {
            currentDevPath = HeadlessDeviceManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String developmentRootDir = currentDevPath != null ? String.valueOf(currentDevPath) + "/../../../" : null;
        String installPath = EclipseUtils.getRootInstallDirectory();
        CoreLogging.info(null, (String)("Checking for install directory at: " + new File(installPath).getAbsolutePath()));
        return new HeadlessDeviceManager((AndroidBridge)AndroidBridge.create((String)adbPath, (String)installPath, (String)developmentRootDir).run(EXECUTOR).getResults());
    }

    static Optional<String> getADBLocation(@Nullable Path configuredADBLocation, @NonNull ADBAutodetector autoDetector) {
        Optional<String> adbLocation = Optional.empty();
        try {
            if (configuredADBLocation == null || configuredADBLocation.toString().isBlank()) {
                File detectedLocation = autoDetector.get();
                if (detectedLocation != null) {
                    adbLocation = Optional.of(detectedLocation.getAbsolutePath());
                    CoreLogging.info(null, (String)(ADB_LOCATION_AUTODETECTED + adbLocation.get()));
                }
            } else {
                adbLocation = Optional.of(configuredADBLocation.toAbsolutePath().toString());
                if (!autoDetector.isValidExecutable(new File(adbLocation.get()))) {
                    throw new IllegalArgumentException(ADB_LOCATION_IN_PREFERENCES_INVALID + adbLocation.get());
                }
                CoreLogging.info(null, (String)(ADB_LOCATION_FROM_PREFERENCES + adbLocation.get()));
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return adbLocation;
    }

    static class ADBAutodetector {
        ADBAutodetector() {
        }

        @Nullable File get() throws IOException, InterruptedException {
            return AppFinder.locate((String)"adb");
        }

        boolean isValidExecutable(@NonNull File file) {
            return AppFinder.isValidExecutable((File)file);
        }
    }

    private static class PrintableActivity
    implements Comparable<PrintableActivity> {
        private final @NonNull ADBInstalledPackage pkg;
        private final @NonNull String activityName;

        public PrintableActivity(@NonNull ADBInstalledPackage pkg, @NonNull String activityName) {
            this.pkg = pkg;
            this.activityName = activityName;
        }

        public @NonNull String formatToString(@NonNull String format) {
            return NullUtils.formattedString((String)format, (Object[])new Object[]{this.pkg.getPackageName(), this.activityName, this.pkg.isDebuggable() ? "Yes" : "No"});
        }

        public @NonNull String getActivityName() {
            return this.activityName;
        }

        @Override
        public int compareTo(PrintableActivity other) {
            if (this.pkg.isDebuggable() && !other.pkg.isDebuggable()) {
                return -1;
            }
            if (!this.pkg.isDebuggable() && other.pkg.isDebuggable()) {
                return 1;
            }
            int packageNameComparison = COLLATOR.compare(this.pkg.getPackageName(), other.pkg.getPackageName());
            if (packageNameComparison != 0) {
                return packageNameComparison;
            }
            return COLLATOR.compare(this.activityName, other.activityName);
        }
    }
}

