/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.connection;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.connection.LiveConnection;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.core.target.io.live.InterceptorStateListener;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.headless.connection.AbstractTargetConnection;
import com.arm.mgd.headless.connection.CliTargetConnection;
import com.arm.mgd.headless.connection.ICliConnectionManagerListener;
import com.arm.mgd.headless.connection.TargetConnectionInterceptorStateListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CliTargetConnectionManager {
    private static final List<AbstractTargetConnection> connections = new ArrayList<AbstractTargetConnection>();
    private static final Set<TargetConnectionInterceptorStateListener> targetConnectionInterceptorStateListeners = new HashSet<TargetConnectionInterceptorStateListener>();
    private static final @NonNull WeakListenerSet<ICliConnectionManagerListener> connectionManagerListeners = new WeakListenerSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetConnectionInterceptorStateListener(@NonNull TargetConnectionInterceptorStateListener listener) {
        Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
        synchronized (set) {
            targetConnectionInterceptorStateListeners.add(listener);
        }
    }

    public static @NonNull CliTargetConnection createLiveConnection(@NonNull String targetIP, int targetPort, @NonNull ADBDevice adbDevice, @NonNull AndroidBridge androidBridge, @NonNull ADBInstalledPackage app, @NonNull String activity, @NonNull ProcessConfig processConfig, boolean installGLES, boolean installVulkan) throws CliTargetConnection.ConnectionFailedException {
        return CliTargetConnectionManager.createLiveConnection(CliTargetConnection.create(targetIP, targetPort, adbDevice, androidBridge, app, activity, processConfig, installGLES, installVulkan));
    }

    public static @NonNull CliTargetConnection createLiveConnection(@NonNull String targetIP, int targetPort, @NonNull ADBDevice adbDevice, @NonNull ProcessConfig processConfig) throws CliTargetConnection.ConnectionFailedException {
        return CliTargetConnectionManager.createLiveConnection(CliTargetConnection.create(targetIP, targetPort, adbDevice, processConfig));
    }

    public static @NonNull CliTargetConnection createLiveConnection(@NonNull String targetIP, int targetPort, @NonNull ProcessConfig processConfig) throws CliTargetConnection.ConnectionFailedException {
        return CliTargetConnectionManager.createLiveConnection(CliTargetConnection.create(targetIP, targetPort, processConfig));
    }

    private static @NonNull CliTargetConnection createLiveConnection(@NonNull CliTargetConnection targetConnection) {
        CliTargetConnectionManager.addNewConnection(targetConnection);
        CliTargetConnectionManager.notifyNewConnection(targetConnection);
        return targetConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable CliTargetConnection getLiveConnectionToAddress(@NonNull SocketAddress address) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!(connection instanceof CliTargetConnection) || !address.equals(((LiveConnection)connection.getTarget().getConnection()).getSocketAddress()) || !connection.isActive()) continue;
                return (CliTargetConnection)connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable CliTargetConnection getLiveConnectionToADBDevice(@NonNull ADBDevice adbDevice) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!(connection instanceof CliTargetConnection) || !adbDevice.equals((Object)((CliTargetConnection)connection).getADBDevice()) || !connection.isActive()) continue;
                return (CliTargetConnection)connection;
            }
        }
        return null;
    }

    public static @Nullable CliTargetConnection getLiveConnectionToDaemon(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice, @NonNull ProcessConfig processConfig) {
        CliTargetConnection connection = null;
        try {
            connection = CliTargetConnection.getLiveConnectionToDaemon(targetIP, targetPort, adbDevice, processConfig);
        }
        catch (CliTargetConnection.ConnectionFailedException e) {
            return null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(@NonNull AbstractTargetConnection connection) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTargetConnectionInterceptorStateListener(@NonNull TargetConnectionInterceptorStateListener listener) {
        Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
        synchronized (set) {
            targetConnectionInterceptorStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNewConnection(@NonNull AbstractTargetConnection connection) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            connections.add(connection);
        }
        if (connection instanceof CliTargetConnection) {
            @NonNull CliTargetConnection liveTargetConnection = (CliTargetConnection)connection;
            @NonNull LiveTarget liveTarget = (LiveTarget)liveTargetConnection.getTarget();
            liveTarget.addInterceptorStateListener((InterceptorStateListener)new PerConnectionInterceptorStateListener(liveTargetConnection));
        }
    }

    public static void addConnectionManagerListener(@NonNull ICliConnectionManagerListener connectionManagerListener) {
        connectionManagerListeners.addListenerAsWeakReference((Object)connectionManagerListener);
    }

    public static void removeConnectionManagerListener(@NonNull ICliConnectionManagerListener connectionManagerListener) {
        connectionManagerListeners.removeWeakReference((Object)connectionManagerListener);
    }

    public static void notifyNewConnection(@NonNull CliTargetConnection newConnection) {
        connectionManagerListeners.notifyWeakListeners(listener -> listener.onNewConnection(newConnection));
    }

    private static class PerConnectionInterceptorStateListener
    implements InterceptorStateListener {
        private final @NonNull CliTargetConnection target;

        public PerConnectionInterceptorStateListener(@NonNull CliTargetConnection target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTargetModifyStateChanged(ModifyStateInterceptorCommand newState) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onTargetModifyStateChanged(newState);
                    }
                }
            }
        }

        private boolean isCurrentTarget() {
            return this.target.isLive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInterceptorStateChanged(@NonNull InterceptorExecutionState oldState, @NonNull InterceptorExecutionState newState, int processID) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onInterceptorStateChanged(oldState, newState, processID);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInterceptorCaptureStateChanged(@NonNull InterceptorCaptureState oldState, @NonNull InterceptorCaptureState newState) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onInterceptorCaptureStateChanged(oldState, newState);
                    }
                }
            }
        }
    }
}

