/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.connection;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.ExecutionStateTargetEventAttachment;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.TargetEvent;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.ITargetEventListener;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.LiveTargetGlobalState;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.connection.InvalidProtocolVersionException;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.headless.connection.AbstractTargetConnection;
import com.arm.mgd.headless.connection.CliTargetConnectionManager;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CliTargetConnection
extends AbstractTargetConnection {
    private static final int ADB_FORWARDING_CONNECT_TIMEOUT_MS = 5000;
    private static final int DAEMON_SOCKET_CONNECT_RETRY_COUNT = 12;
    private static final int DAEMON_SOCKET_CONNECT_POLL_DELAY = 500;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static int traceNumberCounter = 0;
    private final @NonNull Date timestamp = new Date();
    private final int traceNumber = CliTargetConnection.allocateTraceCounter();
    private final @Nullable ADBDevice androidDevice;
    private @Nullable IAndroidPackageTraceManager traceManager;
    private boolean disconnectRequested = false;
    private final Future<?> checkForDisconnectFuture = Executors.newSingleThreadExecutor().submit(() -> {
        while (!this.isDisconnectRequested()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                CoreLogging.warning(null, (String)("Failed to sleep: " + e.getMessage()));
            }
        }
        this.disconnectFromTarget();
        CoreLogging.info(null, (String)"Disconnected");
    });
    private final @NonNull ITargetEventListener addFeatureAuthorisationListener = new ITargetEventListener(){

        public void onTargetDisconnected(@NonNull AbstractTarget abstractTarget) {
            abstractTarget.getModels().stream().map(model -> model.getParentProcessTarget()).forEach(processTarget -> processTarget.addAuthorisationFeature(MgdProtosV2.ProductFeatures.HEADLESS_MODE));
        }
    };

    public static @NonNull CliTargetConnection create(@NonNull String targetIP, int targetPort, @NonNull ProcessConfig processConfig) throws ConnectionFailedException {
        return CliTargetConnection.create(targetIP, targetPort, null, null, processConfig);
    }

    public static @NonNull CliTargetConnection create(@NonNull String targetIP, int targetPort, @NonNull ADBDevice androidDevice, @NonNull AndroidBridge androidBridge, @NonNull ADBInstalledPackage app, @NonNull String activity, @NonNull ProcessConfig processConfig, boolean installGLES, boolean installVulkan) throws ConnectionFailedException {
        try {
            @NonNull IAndroidPackageTraceManager traceManager = CliTargetConnection.getTraceManager(androidBridge, androidDevice, app, activity, installGLES, installVulkan);
            try {
                traceManager.setProgressMonitor(new ICoreProgressMonitor(){

                    public void setTask(String name, int totalWork) {
                        CoreLogging.info(null, (String)("Installation/removal progress: " + name));
                    }

                    public void incProgress(int n) {
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                });
                return CliTargetConnection.create(targetIP, targetPort, androidDevice, traceManager, processConfig);
            }
            catch (Throwable t) {
                CoreLogging.info(null, (String)"Failure occurred. Removing tracing components from device - please wait...");
                CliTargetConnection.closeTraceManager(traceManager);
                throw t;
            }
        }
        catch (IADBTask.ADBException e) {
            throw new ConnectionFailedException((String)NullUtils.neverNull((Object)e.getLocalizedMessage()));
        }
    }

    private static @NonNull IAndroidPackageTraceManager getTraceManager(@NonNull AndroidBridge androidBridge, @NonNull ADBDevice androidDevice, @NonNull ADBInstalledPackage app, @NonNull String activity, boolean installGLES, boolean installVulkan) throws IADBTask.ADBExecutionException {
        if (installGLES) {
            if (installVulkan) {
                return androidBridge.getMultiAPIPackageTraceManager(androidDevice, app, activity);
            }
            return androidBridge.getGLESPackageTraceManager(androidDevice, app, activity);
        }
        if (installVulkan) {
            return androidBridge.getVulkanPackageTraceManager(androidDevice, app, activity);
        }
        return androidBridge.getNoAPIPackageTraceManager(androidDevice, app, activity);
    }

    public static @NonNull CliTargetConnection create(@NonNull String targetIP, int targetPort, @NonNull ADBDevice androidDevice, @NonNull ProcessConfig processConfig) throws ConnectionFailedException {
        return CliTargetConnection.create(targetIP, targetPort, androidDevice, null, processConfig);
    }

    private static @NonNull CliTargetConnection create(@NonNull String targetIP, int targetPort, @Nullable ADBDevice androidDevice, @Nullable IAndroidPackageTraceManager traceManager, @NonNull ProcessConfig processConfig) throws ConnectionFailedException {
        String connectionErrorName;
        String connectionName;
        if (androidDevice != null) {
            connectionName = androidDevice.getUnambiguousName();
            connectionErrorName = androidDevice.toString();
        } else {
            connectionName = NullUtils.formattedString((String)"Target@%s:%s", (Object[])new Object[]{targetIP, NullUtils.stringValueOf((long)targetPort)});
            connectionErrorName = NullUtils.formattedString((String)"%s:%s", (Object[])new Object[]{targetIP, NullUtils.stringValueOf((long)targetPort)});
        }
        return CliTargetConnection.createConnectionWithName(targetIP, targetPort, androidDevice, traceManager, processConfig, connectionName, connectionErrorName);
    }

    private static @NonNull CliTargetConnection createConnectionWithName(@NonNull String targetIP, int targetPort, @Nullable ADBDevice androidDevice, @Nullable IAndroidPackageTraceManager traceManager, @NonNull ProcessConfig processConfig, @NonNull String connectionName, @NonNull String connectionErrorName) throws ConnectionFailedException {
        InetSocketAddress address = new InetSocketAddress(targetIP, targetPort);
        boolean alreadyConnected = false;
        if (androidDevice != null) {
            alreadyConnected = CliTargetConnectionManager.getLiveConnectionToADBDevice(androidDevice) != null;
        } else {
            boolean bl = alreadyConnected = CliTargetConnectionManager.getLiveConnectionToAddress(address) != null;
        }
        if (alreadyConnected) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"You already have a live connection running on %s.", (Object[])new Object[]{connectionErrorName}));
        }
        try {
            if (traceManager != null) {
                CoreLogging.info(null, (String)"Installing tracing components to device - please wait...");
                traceManager.prepareCapture();
                CoreLogging.info(null, (String)"Tracing components installed onto device");
            }
            @NonNull LiveTarget liveTarget = LiveTarget.get((SocketAddress)address, (int)12, (int)5000, (int)500, (String)connectionName, (ProcessConfig)processConfig);
            liveTarget.asyncRead();
            CliTargetConnection cliTargetConnection = new CliTargetConnection(liveTarget, androidDevice, traceManager);
            if (traceManager != null) {
                traceManager.startPackage();
                CoreLogging.info(null, (String)"Started traced application");
            }
            return cliTargetConnection;
        }
        catch (SocketTimeoutException timex) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"Connection timed-out when connecting to %s.\n\nCould not locate the network connection.", (Object[])new Object[]{connectionErrorName}));
        }
        catch (InvalidProtocolVersionException invalidVersionException) {
            throw new ConnectionFailedException(invalidVersionException.getMessage());
        }
        catch (ProtocolVersionException versionException) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"Connection refused when connecting to %s.\n\n%s", (Object[])new Object[]{connectionErrorName, NullUtils.neverNull((Object)versionException.getMessage())}));
        }
        catch (Exception e) {
            @NonNull String errorMessage = (String)NullUtils.neverNull((Object)(e.getMessage() != null ? String.format("%s\n\n", e.getMessage()) : ""));
            throw new ConnectionFailedException(NullUtils.formattedString((String)"%sCannot connect to %s.\n\nEither the network connection to your target device is not working or the daemon is not running on the target.", (Object[])new Object[]{errorMessage, connectionErrorName}));
        }
    }

    public static @NonNull CliTargetConnection getLiveConnectionToDaemon(@NonNull String targetIP, int targetPort, @Nullable ADBDevice androidDevice, @NonNull ProcessConfig processConfig) throws ConnectionFailedException {
        return CliTargetConnection.createConnectionWithName(targetIP, targetPort, androidDevice, null, processConfig, "DaemonConnection", "DaemonConnection error");
    }

    private static void closeTraceManager(@NonNull IAndroidPackageTraceManager traceManager) {
        try {
            traceManager.close();
            CoreLogging.info(null, (String)"Removal of tracing components complete");
        }
        catch (IADBTask.ADBException e) {
            CoreLogging.warning(null, (String)("Can't remove tracing components from device: " + e.getLocalizedMessage()));
        }
    }

    private void closeTraceManager() {
        if (this.traceManager != null) {
            CoreLogging.info(null, (String)"Removing tracing components from device...");
            CliTargetConnection.closeTraceManager((IAndroidPackageTraceManager)NullUtils.neverNull((Object)this.traceManager));
            this.traceManager = null;
        }
    }

    @Override
    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        this.closeTraceManager();
        super.close(iCoreProgressMonitor);
    }

    @Override
    public void close() {
        this.closeTraceManager();
        super.close();
    }

    private CliTargetConnection(@NonNull LiveTarget target, @Nullable ADBDevice androidDevice, @Nullable IAndroidPackageTraceManager traceManager) {
        super((AbstractTarget)target, null);
        this.androidDevice = androidDevice;
        this.traceManager = traceManager;
        target.addTargetEventListener(this.addFeatureAuthorisationListener);
        target.addFeatureAuthorisation(Feature.HEADLESS_MODE);
    }

    public synchronized void requestDisconnect() {
        this.disconnectRequested = true;
    }

    public synchronized boolean isDisconnectRequested() {
        return this.disconnectRequested;
    }

    public void beginWaitingForTimeout(long timeOut) {
        new Thread(() -> {
            try {
                this.checkForDisconnectFuture.get(timeOut, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                CoreLogging.info(null, (String)"Disconnecting on timeout...");
                this.requestDisconnect();
            }
            catch (InterruptedException e) {
                CoreLogging.severe(null, (String)("Failed to finish disconnect service : " + e.getMessage()));
            }
            catch (ExecutionException e) {
                CoreLogging.severe(null, (String)("Failed to finish disconnect service : " + e.getMessage()));
            }
        }).start();
    }

    public void waitForDisconnect() throws InterruptedException, ExecutionException {
        this.checkForDisconnectFuture.get();
    }

    public void disconnectProcessBeforeFrame(@NonNull LiveProcessTarget processTarget, int frameNumber) {
        processTarget.addTargetEventListeners((process, event) -> {
            ExecutionStateTargetEventAttachment state;
            if (event.getEventType() == TargetEvent.TargetEventType.INTERCEPTOR_EXECUTION_STATE_UPDATE && (state = (ExecutionStateTargetEventAttachment)event.findAttachment(ExecutionStateTargetEventAttachment.class)) != null && state.getCurrentInterceptorExecutionState() == InterceptorExecutionState.DETACHED) {
                CoreLogging.info(null, (String)("Disconnecting at frame " + frameNumber));
                this.requestDisconnect();
            }
        });
        try {
            processTarget.sendAddAutomatedTraceCommand(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.TERMINATE, frameNumber));
        }
        catch (Exception e) {
            CoreLogging.severe(null, (String)("Failed to send disconnect command to target : " + e.getMessage()));
        }
    }

    private static synchronized int allocateTraceCounter() {
        return ++traceNumberCounter;
    }

    private @Nullable LiveProcessTarget getLiveProcessTarget() {
        return (LiveProcessTarget)this.getTarget().getActiveProcessTarget();
    }

    public @Nullable ADBDevice getADBDevice() {
        return this.androidDevice;
    }

    @Override
    public boolean canCaptureFrame() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canCaptureFrame() : false;
    }

    @Override
    public boolean canEnableModifyStateFeature(ModifyStateInterceptorCommand feature) {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canEnableModifyStateFeature(feature) : false;
    }

    @Override
    public boolean canPause(boolean currentProcess) {
        if (currentProcess) {
            LiveProcessTarget lpt = this.getLiveProcessTarget();
            return lpt != null ? lpt.canPause() : false;
        }
        return this.isActive();
    }

    @Override
    public boolean canResume() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canResume() : false;
    }

    @Override
    public void captureFrame() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.captureFrame();
        }
    }

    @Override
    public void addAutomatedTraceCommand(AutomatedTraceCommand command) {
        LiveProcessTarget liveProcessTarget = this.getLiveProcessTarget();
        if (liveProcessTarget != null) {
            try {
                liveProcessTarget.sendAddAutomatedTraceCommand(command);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending add deferred command failed");
            }
        }
    }

    @Override
    public void deleteAutomatedTraceCommand(AutomatedTraceCommand command) {
        LiveProcessTarget liveProcessTarget = this.getLiveProcessTarget();
        if (liveProcessTarget != null) {
            try {
                liveProcessTarget.sendDeleteAutomatedTraceCommand(command);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending delete deferred command failed");
            }
        }
    }

    @Override
    public void disableFilmstripMode() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.disableFilmstripMode();
        } else {
            ((LiveTarget)this.getTarget()).setRequestEnabled(LiveTargetGlobalState.FILMSTRIP_MODE, false);
        }
    }

    private void disconnectFromTarget() {
        @NonNull AbstractTarget liveTarget = this.getTarget();
        ((LiveTarget)liveTarget).sendRestoreAllToDefault();
        liveTarget.getConnection().closeConnection();
        for (TraceDataModel model : this.getTarget().getModels()) {
            model.setInputComplete();
        }
    }

    @Override
    public void disconnect() {
        this.requestDisconnect();
    }

    @Override
    public void enableFilmstripMode() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.enableFilmstripMode();
        } else {
            ((LiveTarget)this.getTarget()).setRequestEnabled(LiveTargetGlobalState.FILMSTRIP_MODE, true);
        }
    }

    @Override
    public void enableModifyStateMode(@NonNull ModifyStateInterceptorCommand feature) {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.enableModifyStateMode(feature);
        }
    }

    @Override
    public boolean isActive() {
        return ((LiveTarget)this.getTarget()).isConnectionActive();
    }

    @Override
    public boolean isFilmstripModeEnabled() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.isFilmstripModeEnabled() : false;
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public void pause(boolean currentProcess) {
        try {
            if (currentProcess) {
                LiveProcessTarget lpt = this.getLiveProcessTarget();
                if (lpt != null) {
                    lpt.sendPauseCommand();
                }
            } else {
                ((LiveTarget)this.getTarget()).sendPauseCommand();
            }
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Pause request failed");
        }
    }

    @Override
    public void resume() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.resume();
        }
    }

    @Override
    public void step() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.step();
        }
    }

    @Override
    protected @NonNull String abstractGetName() {
        LiveTarget liveTarget = (LiveTarget)this.getTarget();
        if (liveTarget.isConnectionActive()) {
            return NullUtils.formattedString((String)"%s> Capturing %s", (Object[])new Object[]{NullUtils.stringValueOf((long)this.traceNumber), liveTarget.getConnection().getConnectionName()});
        }
        return NullUtils.formattedString((String)"%s> Capture %s", (Object[])new Object[]{NullUtils.stringValueOf((long)this.traceNumber), liveTarget.getConnection().getConnectionName()});
    }

    @Override
    public @NonNull String getToolTipText() {
        return String.valueOf(super.getToolTipText()) + ", capture started " + DATE_FORMAT.format(this.timestamp);
    }

    @Override
    public void attachHost() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            try {
                lpt.setAttached(true);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending attach command failed");
            }
        }
    }

    @Override
    public void detachHost() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            try {
                lpt.setAttached(false);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending detach command failed");
            }
        }
    }

    @Override
    public boolean canAttachAndDetach() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null && lpt.canAttachAndDetach();
    }

    @Override
    public boolean isDetached() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.isDetached() : true;
    }

    public static class AuthorisationFailedException
    extends Exception {
        private static final long serialVersionUID = -8822289286984028330L;

        public AuthorisationFailedException(@NonNull String message) {
            super(message);
        }
    }

    public static class ConnectionFailedException
    extends Exception {
        private static final long serialVersionUID = -2147074787588495569L;

        public ConnectionFailedException(@NonNull String message) {
            super(message);
        }
    }
}

