/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.connection;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.FileTarget;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractTargetConnection
implements ICoreLoggingSource,
AutoCloseable {
    protected @Nullable File storageFile;
    protected @NonNull AbstractTarget target;

    protected AbstractTargetConnection(@NonNull AbstractTarget target, @Nullable File storageFile) {
        this.target = target;
        this.storageFile = storageFile;
        assert (storageFile != null || !(target instanceof FileTarget)) : "If storageFile is null, target must be FileTarget";
    }

    public abstract boolean canCaptureFrame();

    public abstract boolean canEnableModifyStateFeature(@NonNull ModifyStateInterceptorCommand var1);

    public abstract boolean canPause(boolean var1);

    public abstract boolean canResume();

    public abstract void captureFrame();

    public abstract void addAutomatedTraceCommand(AutomatedTraceCommand var1);

    public abstract void deleteAutomatedTraceCommand(AutomatedTraceCommand var1);

    public abstract void disableFilmstripMode();

    public abstract void disconnect();

    public abstract void enableFilmstripMode();

    public abstract void enableModifyStateMode(@NonNull ModifyStateInterceptorCommand var1);

    public final @Nullable TraceDataModel getActiveModel() {
        return this.target.getActiveModel();
    }

    public final @NonNull String getName() {
        if (this.storageFile != null) {
            return (String)NullUtils.neverNull((Object)this.storageFile.getName());
        }
        return this.abstractGetName();
    }

    public final File getStorageFile() {
        return this.storageFile;
    }

    public final @NonNull AbstractTarget getTarget() {
        return this.target;
    }

    public String getTargetVersionLabel() {
        String versionString = this.target.getConnection().getUnmarshallerVersion();
        return versionString;
    }

    public @NonNull String getToolTipText() {
        String processName;
        TraceDataModel model = this.getActiveModel();
        String string = processName = model != null ? model.getProcessName() : null;
        if (processName == null) {
            processName = "<unknown>";
        }
        return (String)NullUtils.neverNull((Object)String.format("Process %s in %s, trace version %s", processName, this.getTarget().getConnection().getConnectionName(), this.getTargetVersionLabel()));
    }

    public abstract boolean isActive();

    public abstract boolean isFilmstripModeEnabled();

    public abstract boolean isLive();

    public abstract void pause(boolean var1);

    public abstract void resume();

    public abstract void step();

    protected abstract @NonNull String abstractGetName();

    public String getCoreLoggingSourceKey() {
        return this.target.getCoreLoggingSourceKey();
    }

    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        this.target.close(iCoreProgressMonitor);
    }

    @Override
    public void close() {
        this.close(ICoreProgressMonitor.NULL_MONITOR);
    }

    public abstract void attachHost();

    public abstract void detachHost();

    public abstract boolean canAttachAndDetach();

    public abstract boolean isDetached();
}

