/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.headless.cli.MGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLineMessages;
import com.arm.mgd.headless.cli.MGDCommandLineSwitch;
import com.arm.mgd.utils.NullUtils;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.OptionalLong;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MGDCommandLineUtils {
    static @NonNull String makeEnglishList(@NonNull String conjunction, Object ... items) {
        StringBuilder englishList = new StringBuilder();
        int i = 0;
        while (i < items.length) {
            englishList.append(items[i]);
            if (i <= items.length - 2) {
                if (i == items.length - 2) {
                    englishList.append(" ").append(conjunction);
                } else {
                    englishList.append(",");
                }
                englishList.append(" ");
            }
            ++i;
        }
        return (String)NullUtils.neverNull((Object)englishList.toString());
    }

    static @NonNull String andList(Object ... items) {
        return MGDCommandLineUtils.makeEnglishList("and", items);
    }

    static @NonNull String orList(Object ... items) {
        return MGDCommandLineUtils.makeEnglishList("or", items);
    }

    static @NonNull String only(@NonNull MGDCommandLineSwitch item) {
        return (String)NullUtils.neverNull((Object)item.toString());
    }

    static @NonNull String @Nullable [] splitDelimitedString(@Nullable String input, char delimiter) {
        @NonNull String @Nullable [] returnValue = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)input, (String)String.valueOf(delimiter));
        return returnValue;
    }

    static OptionalLong parseOptionalNonNegativeLong(@Nullable String fromString, @NonNull String fromStringDescription) throws MGDCommandLine.CommandLineException {
        if (fromString == null) {
            return OptionalLong.empty();
        }
        String trimmedFromString = fromString.trim();
        if (trimmedFromString.isEmpty()) {
            return OptionalLong.empty();
        }
        try {
            OptionalLong returnValue = OptionalLong.of(Long.parseLong(trimmedFromString));
            if (returnValue.getAsLong() < 0L) {
                throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.format("Supplied %s (\"%s\") was negative; it must be positive or zero", fromStringDescription, trimmedFromString));
            }
            return returnValue;
        }
        catch (NumberFormatException e) {
            throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.format("Could not understand supplied %s (\"%s\"); a decimal whole number is required", fromStringDescription, trimmedFromString));
        }
    }

    static long parseNonNegativeLong(@Nullable String fromString, @NonNull String fromStringDescription) throws MGDCommandLine.CommandLineException {
        OptionalLong parsedLong = MGDCommandLineUtils.parseOptionalNonNegativeLong(fromString, fromStringDescription);
        if (!parsedLong.isPresent()) {
            throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.format("Empty or missing %s was given, but an argument was expected", fromStringDescription));
        }
        return parsedLong.getAsLong();
    }

    static @NonNull NavigableSet<Long> parseNonNegativeLongArrayAsNavigableSet(@NonNull String @Nullable [] fromArray, @NonNull String fromElementDescription) throws MGDCommandLine.CommandLineException {
        if (fromArray == null) {
            return (NavigableSet)NullUtils.neverNull(Collections.emptyNavigableSet());
        }
        TreeSet<Long> returnSet = new TreeSet<Long>();
        String[] stringArray = fromArray;
        int n = fromArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fromElement = stringArray[n2];
            returnSet.add(MGDCommandLineUtils.parseNonNegativeLong(fromElement, fromElementDescription));
            ++n2;
        }
        return returnSet;
    }
}

