/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.headless.cli.CommandLineTraceConfig;
import com.arm.mgd.utils.NullUtils;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum MGDCommandLineSwitch {
    ACTIVITY_SUBSTRING("a", "activity", true),
    ADB_LOCATION(null, "adb-location", true),
    COLLECT_BINARIES(null, "collect-binaries", false),
    COLLECT_EXPLICIT_BUFFERS(null, "collect-explicit-buffers", false),
    COLLECT_EXPLICIT_MEMORY(null, "collect-explicit-memory", false),
    COLLECT_IMPLICIT_BUFFERS(null, "collect-implicit-buffers", false),
    COLLECT_OUTPUT_BUFFERS(null, "collect-output-buffers", false),
    COLLECT_SOURCES(null, "collect-sources", false),
    COLLECT_TEXTURES(null, "collect-textures", false),
    COLLECT_UNIFORMS(null, "collect-uniforms", false),
    DEVICE_ID("d", "device-id", true),
    DEVICE_IP("i", "device-ip", true),
    EXIT_AT_FRAME("x", "exit-at-frame", true),
    EXPORT_FRAME_SHADERS("S", "export-frame-shaders", true),
    EXPORT_FRAME_TEXTURES("T", "export-frame-textures", true),
    EXPORT_FUNCTION_SHADERS(null, "export-function-shaders", true),
    EXPORT_FUNCTION_TEXTURES(null, "export-function-textures", true),
    FRAMES_WITH_ALL_ATTACHMENTS(null, "frames-with-all-attachments", true),
    FRAMES_WITH_DEFAULT_CAPTURE(null, "frames-with-default-capture", true),
    FRAMES_WITH_FRAGMENT_COUNT(null, "frames-with-fragment-count", true),
    FRAMES_WITH_OVERDRAW(null, "frames-with-overdraw", true),
    FRAMES_WITH_SHADER_MAP(null, "frames-with-shader-map", true),
    HELP(null, "help", false),
    LIST_TARGETS(null, "list-targets", false),
    LIST_PACKAGES(null, "list-packages", false),
    NO_ANDROID_INSTALL(null, "no-android-install", false),
    NO_OPENGL_ES(null, "no-opengl-es", false),
    NO_VULKAN(null, "no-vulkan", false),
    PROCESS_NAME("p", "process", true),
    PROCESS_ID(null, "process-id", true),
    TIMEOUT("t", "timeout", true),
    TRACE_OUTPUT_FILE(null, "trace-file-output", true),
    EXPORT_OUTPUT_DIRECTORY(null, "export-output-directory", true),
    TRACE_CONFIG("c", "trace-config", true);

    private final String shortOption;
    private final String longOption;
    private final boolean hasArg;
    public static @NonNull MGDCommandLineSwitch @NonNull [] COLLECT_SWITCHES;
    public static @NonNull MGDCommandLineSwitch @NonNull [] EXPORT_SWITCHES;
    public static @NonNull MGDCommandLineSwitch @NonNull [] FRAMES_WITH_SWITCHES;
    public static @NonNull MGDCommandLineSwitch @NonNull [] LIST_SWITCHES;

    static {
        COLLECT_SWITCHES = new MGDCommandLineSwitch[]{COLLECT_BINARIES, COLLECT_EXPLICIT_BUFFERS, COLLECT_EXPLICIT_MEMORY, COLLECT_IMPLICIT_BUFFERS, COLLECT_OUTPUT_BUFFERS, COLLECT_SOURCES, COLLECT_TEXTURES, COLLECT_UNIFORMS};
        EXPORT_SWITCHES = new MGDCommandLineSwitch[]{EXPORT_FRAME_TEXTURES, EXPORT_FRAME_SHADERS, EXPORT_FUNCTION_TEXTURES, EXPORT_FUNCTION_SHADERS, EXPORT_OUTPUT_DIRECTORY};
        FRAMES_WITH_SWITCHES = new MGDCommandLineSwitch[]{FRAMES_WITH_ALL_ATTACHMENTS, FRAMES_WITH_DEFAULT_CAPTURE, FRAMES_WITH_FRAGMENT_COUNT, FRAMES_WITH_OVERDRAW, FRAMES_WITH_SHADER_MAP};
        LIST_SWITCHES = new MGDCommandLineSwitch[]{LIST_PACKAGES, LIST_TARGETS};
    }

    private MGDCommandLineSwitch(String shortOption, String longOption, boolean hasArg) {
        this.shortOption = shortOption;
        this.longOption = longOption;
        this.hasArg = hasArg;
    }

    public boolean hasShortOption() {
        return this.shortOption != null;
    }

    public boolean hasArg() {
        return this.hasArg;
    }

    public @Nullable String getShortOption() {
        return this.shortOption;
    }

    public @NonNull String getLongOption() {
        return (String)NullUtils.neverNull((Object)this.longOption);
    }

    public String getDescription() {
        String description;
        switch (this) {
            case ACTIVITY_SUBSTRING: {
                description = "Android: Full or partial name of activity in given package (" + (Object)((Object)PROCESS_NAME) + ")";
                break;
            }
            case ADB_LOCATION: {
                description = "Location of the Android Debug Bridge, for live tracing (avoids auto-detection)";
                break;
            }
            case COLLECT_BINARIES: {
                description = "Collect shader/kernel binaries when tracing a target";
                break;
            }
            case COLLECT_EXPLICIT_BUFFERS: {
                description = "Collect buffers passed to API functions when tracing a target";
                break;
            }
            case COLLECT_EXPLICIT_MEMORY: {
                description = "Collect explicit memory when tracing a target";
                break;
            }
            case COLLECT_IMPLICIT_BUFFERS: {
                description = "Collect buffers copied to mapped memory when tracing a target";
                break;
            }
            case COLLECT_OUTPUT_BUFFERS: {
                description = "Collect output buffers when tracing a target";
                break;
            }
            case COLLECT_SOURCES: {
                description = "Collect shader/kernel sources when tracing a target";
                break;
            }
            case COLLECT_TEXTURES: {
                description = "Collect textures when tracing a target";
                break;
            }
            case COLLECT_UNIFORMS: {
                description = "Collect shader uniforms when tracing a target";
                break;
            }
            case DEVICE_ID: {
                description = "Starts a live trace of an ADB device, or together with " + (Object)((Object)LIST_PACKAGES) + " lists ADB packages. Give device identifier in form used by \"adb devices\"";
                break;
            }
            case DEVICE_IP: {
                description = "Starts a live trace. Give IP address / hostname of device";
                break;
            }
            case EXIT_AT_FRAME: {
                description = "Index of final frame that aga will trace before exiting";
                break;
            }
            case EXPORT_FRAME_SHADERS: {
                description = "List of shaders/kernels for given frame index (see below), for exporting from a trace file";
                break;
            }
            case EXPORT_FRAME_TEXTURES: {
                description = "List of textures for given frame index (see below), for exporting from a trace file";
                break;
            }
            case EXPORT_FUNCTION_SHADERS: {
                description = "List of shaders/kernels for given function index (see below), for exporting from a trace file";
                break;
            }
            case EXPORT_FUNCTION_TEXTURES: {
                description = "List of textures for given function index (see below), for exporting from a trace file";
                break;
            }
            case FRAMES_WITH_ALL_ATTACHMENTS: {
                description = "List of frames to capture with all framebuffer attachments, in addition to the framebuffer contents, for live tracing";
                break;
            }
            case FRAMES_WITH_DEFAULT_CAPTURE: {
                description = "List of frames to capture, capturing only the framebuffer content for each draw call, for live tracing";
                break;
            }
            case FRAMES_WITH_FRAGMENT_COUNT: {
                description = "List of frames to capture, capturing fragment processing statistics per draw call instead of framebuffer content, for live tracing";
                break;
            }
            case FRAMES_WITH_OVERDRAW: {
                description = "List of frames to capture, replacing the fragment shader with a custom shader demonstrating overdraw, for live tracing";
                break;
            }
            case FRAMES_WITH_SHADER_MAP: {
                description = "List of frames to capture, replacing shaders with a custom shaders that map to solid colours, providing a visual map of shaders across the frame, for live tracing";
                break;
            }
            case HELP: {
                description = "Display this help text";
                break;
            }
            case LIST_TARGETS: {
                description = "List target devices that are visible over ADB or the local network.";
                break;
            }
            case LIST_PACKAGES: {
                description = "List packages for the target device (" + (Object)((Object)DEVICE_ID) + ")";
                break;
            }
            case NO_ANDROID_INSTALL: {
                description = "Android: Do not install any tracing components onto device (must be pre-installed/configured)";
                break;
            }
            case NO_OPENGL_ES: {
                description = "Android: Do not install tracing components for the OpenGL ES API";
                break;
            }
            case NO_VULKAN: {
                description = "Android: Do not install tracing components for the Vulkan API";
                break;
            }
            case PROCESS_NAME: {
                description = "Name of traced package/process on target device OR name of package/process to export assets from (always REQUIRED)";
                break;
            }
            case PROCESS_ID: {
                description = "Process ID for the named process, for exporting from a trace file (REQUIRED if a trace file contains more than one process with the same name)";
                break;
            }
            case TIMEOUT: {
                description = "Seconds before aga will exit. May run for longer.";
                break;
            }
            case TRACE_OUTPUT_FILE: {
                description = "Trace file to produce, with .mgd extension (REQUIRED when tracing)";
                break;
            }
            case EXPORT_OUTPUT_DIRECTORY: {
                description = "Output directory for exported textures, shader sources, etc. (REQUIRED for exporting assets from a trace file)";
                break;
            }
            case TRACE_CONFIG: {
                String traceConfigsDescription = Stream.of(CommandLineTraceConfig.values()).map(configLevel -> {
                    String configLevelText = "\"" + configLevel.getParameterText() + "\"";
                    return configLevel == CommandLineTraceConfig.LEGACY ? String.valueOf(configLevelText) + " (default)" : configLevelText;
                }).collect(Collectors.joining(", "));
                description = "Trace configuration templates that determine what data the interceptor collects beyond just tracing API calls. Give one of (from least to most verbose) " + traceConfigsDescription;
                break;
            }
            default: {
                description = "*** ADD DESCRIPTION ***";
            }
        }
        return description;
    }

    public String toString() {
        if (this.hasShortOption()) {
            return "-" + this.getShortOption() + "/--" + this.getLongOption();
        }
        return "--" + this.getLongOption();
    }
}

