/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.authorisation.AlwaysAllowAuthorisationProvider;
import com.arm.mgd.core.authorisation.AuthorisationManager;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.authorisation.IArmAuthorisationProvider;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.headless.HeadlessAssetExporter;
import com.arm.mgd.headless.HeadlessLiveConnector;
import com.arm.mgd.headless.cli.CommandLineOutcome;
import com.arm.mgd.headless.cli.DeviceIdentifier;
import com.arm.mgd.headless.cli.IMGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLineMessages;
import com.arm.mgd.headless.connection.CliTargetConnection;
import com.arm.mgd.headless.utils.HeadlessDeviceManager;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.HelpFormatter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MGDCommandLineMain {
    public static @NonNull CommandLineOutcome runCommandLine(String[] args, @Nullable Path configuredADBLocation) {
        try {
            String dir;
            MGDCommandLine commandLine = new MGDCommandLine(args);
            if (commandLine.getHelpCommand()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                HelpFormatter helpFormatter = new HelpFormatter();
                MGDCommandLine.printHelp(helpFormatter, printWriter);
                System.out.println(stringWriter.toString());
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.SUCCESS, null);
            }
            if (!MGDCommandLineMain.checkForHeadlessModeAuthorisation()) {
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.AUTHORISATION_FAILURE, null);
            }
            if (commandLine.getShowDevicesCommand()) {
                HeadlessDeviceManager deviceManager = HeadlessDeviceManager.create(commandLine, configuredADBLocation);
                String ADBTable = HeadlessDeviceManager.formatTableOfADBDevices(deviceManager.getAllDevicesMap());
                if (ADBTable.isEmpty()) {
                    System.out.println("No ADB devices visible.");
                } else {
                    System.out.println("ADB Devices:\n\n" + ADBTable);
                }
                AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
                assert (authManager != null);
                if (((FeatureAuthorisation)authManager.getAuthorisation(Feature.LINUX_DEV_SUPPORT).get()).isAuthorised()) {
                    String linuxTable = HeadlessDeviceManager.formatTableOfLinuxDevices();
                    if (linuxTable.isEmpty()) {
                        System.out.println("No Linux devices visible.");
                    } else {
                        System.out.println("Linux Devices:\n\n" + linuxTable);
                    }
                }
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.SUCCESS, null);
            }
            if (commandLine.getListPackagesCommand()) {
                ADBDevice device;
                HeadlessDeviceManager deviceManager = HeadlessDeviceManager.create(commandLine, configuredADBLocation);
                Map<ADBDeviceIdentifier, ADBDevice> devicesMap = deviceManager.getAllDevicesMap();
                if (devicesMap.isEmpty()) {
                    CoreLogging.info(null, (String)"No ADB devices visible.");
                    return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.SUCCESS, null);
                }
                Optional<String> deviceInput = commandLine.getDeviceID();
                if (devicesMap.size() > 1 && deviceInput.isEmpty()) {
                    throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.ADB_DEVICE_AMBIGUOUS);
                }
                if (deviceInput.isPresent()) {
                    String deviceID = (String)NullUtils.neverNull((Object)commandLine.getDeviceID().get());
                    device = Optional.ofNullable((ADBDevice)devicesMap.entrySet().stream().filter(e -> ((ADBDeviceIdentifier)e.getKey()).getID().equals(deviceID)).findAny().orElseThrow(() -> new MGDCommandLine.CommandLineException(NullUtils.formattedString((String)"Unable to find the specified device: %s", (Object[])new Object[]{deviceID}))).getValue()).orElseThrow(() -> new MGDCommandLine.CommandLineException(NullUtils.formattedString((String)"ADB device ID %s is offline.", (Object[])new Object[]{NullUtils.neverNull((Object)deviceID)})));
                } else {
                    assert (devicesMap.size() == 1);
                    device = (ADBDevice)devicesMap.values().toArray()[0];
                    if (device == null) {
                        ADBDeviceIdentifier deviceID = (ADBDeviceIdentifier)devicesMap.keySet().toArray()[0];
                        throw new MGDCommandLine.CommandLineException(NullUtils.formattedString((String)"ADB device ID %s is offline.", (Object[])new Object[]{deviceID.getID()}));
                    }
                }
                assert (device != null);
                String table = deviceManager.formatTableOfPackagesForDevice(device);
                if (table.isEmpty()) {
                    System.out.println("No packages visible on device identifier " + device.getID() + ".");
                } else {
                    System.out.println("Installed packages for device " + device.getModel() + ":\n\n" + table);
                }
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.SUCCESS, null);
            }
            Optional<String> exportDirectory = commandLine.getExportOutputDirectory();
            Optional<String> traceFile = commandLine.getTraceOutputFile();
            assert (exportDirectory.isPresent() || traceFile.isPresent());
            if (exportDirectory.isPresent() && !new File(dir = exportDirectory.get()).canWrite()) {
                throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.format("Cannot write to output directory: %s", dir));
            }
            if (traceFile.isPresent()) {
                String outputFileString = traceFile.get();
                File outputFile = new File(outputFileString).getCanonicalFile();
                if (outputFile.isDirectory()) {
                    throw new MGDCommandLine.CommandLineException("A directory was passed in as the trace output file. You should provide a complete file path including a file extension.");
                }
                File parent = outputFile.getParentFile();
                if (parent == null || !parent.canWrite()) {
                    throw new MGDCommandLine.CommandLineException(MGDCommandLineMessages.format("The trace output file is not in a writeable location: %s", outputFile.getAbsolutePath()));
                }
            }
            if (MGDCommandLineMain.isAssetExportRequired(commandLine)) {
                HeadlessAssetExporter.exportAssetsFromTraceFile(commandLine);
            }
            if (MGDCommandLineMain.isLiveConnectionRequired(commandLine)) {
                HeadlessLiveConnector.connectToLiveTarget(commandLine, configuredADBLocation);
            }
            return CommandLineOutcome.SUCCESS_OUTCOME;
        }
        catch (Exception e2) {
            if (e2 instanceof MGDCommandLine.CommandLineException) {
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.COMMAND_LINE_EXCEPTION, e2);
            }
            if (e2 instanceof CliTargetConnection.AuthorisationFailedException) {
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.AUTHORISATION_FAILURE, null);
            }
            if (e2 instanceof IndexOutOfBoundsException) {
                return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.GENERAL_EXCEPTION, null);
            }
            return new CommandLineOutcome(CommandLineOutcome.OutcomeCategory.GENERAL_EXCEPTION, e2);
        }
    }

    private static boolean checkForHeadlessModeAuthorisation() throws Exception {
        AlwaysAllowAuthorisationProvider authorisationProvider = new AlwaysAllowAuthorisationProvider();
        CoreInstance.setAuthorisationProvider((IArmAuthorisationProvider)authorisationProvider);
        AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
        assert (authManager != null);
        CoreLogging.info(null, (String)"Checking for headless mode authorisation...");
        FeatureAuthorisation auth = (FeatureAuthorisation)authManager.getAuthorisation(Feature.HEADLESS_MODE).get();
        if (!auth.isAuthorised()) {
            @NonNull String errorMessage = "Authorisation failed for the following reason: " + System.lineSeparator() + auth.getReason() + System.lineSeparator() + Feature.HEADLESS_MODE.getLicenceMissingMessage();
            CoreLogging.warning(null, (String)errorMessage);
            return false;
        }
        return true;
    }

    private static boolean isLiveConnectionRequired(IMGDCommandLine commandLine) {
        return commandLine.getDeviceIdentifier().getNamespace() == DeviceIdentifier.Namespace.IP || commandLine.getDeviceIdentifier().getNamespace() == DeviceIdentifier.Namespace.ADB;
    }

    public static boolean isAssetExportRequired(IMGDCommandLine commandLine) {
        return commandLine.getDeviceIdentifier().getNamespace() == DeviceIdentifier.Namespace.FILE;
    }
}

