/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.core.target.data.interceptorconfig.ISelectableResource;
import com.arm.mgd.core.target.data.interceptorconfig.InterceptorConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClConfig;
import com.arm.mgd.core.target.data.interceptorconfig.cl.ClResource;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesConfig;
import com.arm.mgd.core.target.data.interceptorconfig.gles.GlesResource;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanConfig;
import com.arm.mgd.core.target.data.interceptorconfig.vulkan.VulkanResource;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigPreset;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.headless.cli.CommandLineTraceConfig;
import com.arm.mgd.headless.cli.DeviceIdentifier;
import com.arm.mgd.headless.cli.IMGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLineMessages;
import com.arm.mgd.headless.cli.MGDCommandLineSwitch;
import com.arm.mgd.headless.cli.MGDCommandLineUtils;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MGDCommandLine
implements IMGDCommandLine {
    private static final OptionGroup DEVICE_SELECTION_OPTION_GROUP = new OptionGroup();
    private static final Options COMMAND_LINE_OPTIONS = new Options();
    private final @NonNull List<@NonNull ClResource> clResources = new ArrayList<ClResource>();
    private final @NonNull List<@NonNull GlesResource> glesResources = new ArrayList<GlesResource>();
    private final @NonNull List<@NonNull VulkanResource> vulkanResources = new ArrayList<VulkanResource>();
    private final Optional<String> adbLocation;
    private final @NonNull DeviceIdentifier deviceIdentifier;
    private final @NonNull ProcessConfigPreset tracePreset;
    private final boolean collectBinaries;
    private final boolean collectExplicitBuffers;
    private final boolean collectImplicitBuffers;
    private final boolean collectExplicitMemory;
    private final boolean collectOutputBuffers;
    private final boolean collectSources;
    private final boolean collectTextures;
    private final boolean collectUniforms;
    private final boolean shouldInstallAndroidComponents;
    private final boolean shouldInstallOpenGLES;
    private final boolean shouldInstallVulkan;
    private final boolean showDevices;
    private final boolean listPackages;
    private final boolean help;
    private final Optional<String> deviceID;
    private final Optional<String> traceOutputFile;
    private final Optional<String> exportOutputDirectory;
    private final Optional<String> processName;
    private final Optional<String> processID;
    private final Optional<String> activitySubstring;
    private final OptionalLong timeout;
    private final OptionalLong exitAtFrame;
    private final @NonNull NavigableSet<Long> framesWithDefaultCapture;
    private final @NonNull NavigableSet<Long> framesWithOverdraw;
    private final @NonNull NavigableSet<Long> framesWithAllAttachments;
    private final @NonNull NavigableSet<Long> framesWithShaderMap;
    private final @NonNull NavigableSet<Long> framesWithFragmentCount;
    private final @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> exportTexturesForFrames = new TreeMap<Long, NavigableSet<Long>>();
    private final @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> exportShadersForFrames = new TreeMap<Long, NavigableSet<Long>>();
    private final @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> exportTexturesForFunctions = new TreeMap<Long, NavigableSet<Long>>();
    private final @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> exportShadersForFunctions = new TreeMap<Long, NavigableSet<Long>>();

    static {
        MGDCommandLineSwitch[] mGDCommandLineSwitchArray = MGDCommandLineSwitch.values();
        int n = mGDCommandLineSwitchArray.length;
        int n2 = 0;
        while (n2 < n) {
            MGDCommandLineSwitch commandLineSwitch = mGDCommandLineSwitchArray[n2];
            Option option = new Option(commandLineSwitch.getShortOption(), commandLineSwitch.getLongOption(), commandLineSwitch.hasArg(), commandLineSwitch.getDescription());
            if (commandLineSwitch.equals((Object)MGDCommandLineSwitch.DEVICE_IP) || commandLineSwitch.equals((Object)MGDCommandLineSwitch.DEVICE_ID)) {
                DEVICE_SELECTION_OPTION_GROUP.addOption(option);
            } else {
                COMMAND_LINE_OPTIONS.addOption(option);
            }
            ++n2;
        }
        COMMAND_LINE_OPTIONS.addOptionGroup(DEVICE_SELECTION_OPTION_GROUP);
    }

    private static boolean hasAllSwitchesOnCommandLine(@NonNull CommandLine commandLine, MGDCommandLineSwitch ... commandLineSwitches) {
        boolean allPresent = true;
        MGDCommandLineSwitch[] mGDCommandLineSwitchArray = commandLineSwitches;
        int n = commandLineSwitches.length;
        int n2 = 0;
        while (n2 < n) {
            MGDCommandLineSwitch commandLineSwitch = mGDCommandLineSwitchArray[n2];
            allPresent = allPresent && commandLine.hasOption(commandLineSwitch.getLongOption());
            ++n2;
        }
        return allPresent;
    }

    private static boolean hasAnySwitchesOnCommandLine(@NonNull CommandLine commandLine, MGDCommandLineSwitch ... commandLineSwitches) {
        MGDCommandLineSwitch[] mGDCommandLineSwitchArray = commandLineSwitches;
        int n = commandLineSwitches.length;
        int n2 = 0;
        while (n2 < n) {
            MGDCommandLineSwitch commandLineSwitch = mGDCommandLineSwitchArray[n2];
            if (commandLine.hasOption(commandLineSwitch.getLongOption())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static @Nullable String getOptionFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch) {
        return commandLine.getOptionValue(commandLineSwitch.getLongOption());
    }

    private static String @Nullable [] getOptionValuesFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch) {
        return commandLine.getOptionValues(commandLineSwitch.getLongOption());
    }

    private static @NonNull String @Nullable [] getOptionListFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch, char delimiter) {
        return MGDCommandLineUtils.splitDelimitedString(MGDCommandLine.getOptionFromCommandLine(commandLine, commandLineSwitch), delimiter);
    }

    private static @NonNull String @NonNull [] @NonNull [] getOptionListForAllEntriesFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch, char delimiter) {
        String @Nullable [] values = MGDCommandLine.getOptionValuesFromCommandLine(commandLine, commandLineSwitch);
        if (values == null) {
            return new String[0][0];
        }
        @NonNull String @NonNull [] @NonNull [] allEntries = new String[values.length][];
        int i = 0;
        while (i < values.length) {
            assert (values[i] != null);
            allEntries[i] = (String[])NullUtils.neverNull((Object[])MGDCommandLineUtils.splitDelimitedString(values[i], delimiter));
            ++i;
        }
        return allEntries;
    }

    private static @NonNull String @Nullable [] getOptionListFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch) {
        return MGDCommandLine.getOptionListFromCommandLine(commandLine, commandLineSwitch, ',');
    }

    private static void getPerTraceIndexListFromCommandLine(@NonNull CommandLine commandLine, @NonNull MGDCommandLineSwitch commandLineSwitch, @NonNull NavigableMap<Long, NavigableSet<Long>> perIndexOptionMap, @NonNull String perIndexOptionDescription, @NonNull TraceIndexType indexType) throws CommandLineException {
        String[][] parameterComponentsForAllEntries;
        String[][] stringArray = parameterComponentsForAllEntries = MGDCommandLine.getOptionListForAllEntriesFromCommandLine(commandLine, commandLineSwitch, ':');
        int n = parameterComponentsForAllEntries.length;
        int n2 = 0;
        while (n2 < n) {
            long traceIndex;
            String[] parameterComponents = stringArray[n2];
            if (parameterComponents.length == 1) {
                traceIndex = MGDCommandLineUtils.parseNonNegativeLong(parameterComponents[0], indexType.description);
                perIndexOptionMap.put(traceIndex, Collections.emptyNavigableSet());
            } else {
                if (parameterComponents.length != 2) {
                    throw new CommandLineException("Per-frame specification needs to be in the form <frame-number>:[<frame-index>[,<frame-index>...]]");
                }
                traceIndex = MGDCommandLineUtils.parseNonNegativeLong(parameterComponents[0], indexType.description);
                if (perIndexOptionMap.containsKey(traceIndex)) {
                    throw new CommandLineException("Unable to export assets because the same frame or function index was provided more than once.");
                }
                @NonNull String @Nullable [] optionListForFrame = MGDCommandLineUtils.splitDelimitedString(parameterComponents[1], ',');
                NavigableSet<Long> optionSetForFrame = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(optionListForFrame, perIndexOptionDescription);
                perIndexOptionMap.put(traceIndex, optionSetForFrame);
            }
            ++n2;
        }
    }

    private static @NonNull CommandLine readCommandLine(String[] commandLineArgs) throws CommandLineException {
        CommandLine rawCommandLine;
        block29: {
            DefaultParser parser = new DefaultParser();
            try {
                rawCommandLine = (CommandLine)NullUtils.neverNull((Object)parser.parse(COMMAND_LINE_OPTIONS, commandLineArgs));
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.HELP)) {
                    return rawCommandLine;
                }
                if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.LIST_TARGETS, MGDCommandLineSwitch.LIST_PACKAGES)) {
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.LIST_TARGETS, MGDCommandLineSwitch.LIST_PACKAGES)) {
                        throw new CommandLineException("Cannot list targets and packages in the same command.");
                    }
                    @NonNull MGDCommandLineSwitch @NonNull [] invalidSwitches = (MGDCommandLineSwitch[])Stream.of(new MGDCommandLineSwitch[][]{MGDCommandLineSwitch.COLLECT_SWITCHES, MGDCommandLineSwitch.EXPORT_SWITCHES, MGDCommandLineSwitch.FRAMES_WITH_SWITCHES, {MGDCommandLineSwitch.EXIT_AT_FRAME, MGDCommandLineSwitch.TIMEOUT, MGDCommandLineSwitch.TRACE_CONFIG}}).flatMap(mGDCommandLineSwitchArray -> Stream.of(mGDCommandLineSwitchArray)).toArray(MGDCommandLineSwitch[]::new);
                    if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, invalidSwitches)) {
                        throw new CommandLineException("Cannot trace or export in the same command as a list command.");
                    }
                    return rawCommandLine;
                }
                if (!MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.PROCESS_NAME)) {
                    throw new CommandLineException(MGDCommandLineMessages.MISSING_PROCESS_SPEC);
                }
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.TRACE_OUTPUT_FILE, MGDCommandLineSwitch.EXPORT_OUTPUT_DIRECTORY)) {
                    throw new CommandLineException("Encountered both an export directory and a trace output file; the export directory is only needed for the asset exporter, and the trace output is only needed for a live trace.");
                }
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.ACTIVITY_SUBSTRING, MGDCommandLineSwitch.NO_ANDROID_INSTALL)) {
                    throw new CommandLineException(MGDCommandLineMessages.CANNOT_COMBINE_ACTIVITY_AND_NO_TRACING_COMPONENTS);
                }
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.NO_OPENGL_ES, MGDCommandLineSwitch.NO_VULKAN)) {
                    CoreLogging.warning(null, (String)"Automatic installation of layer drivers for both OpenGL ES and Vulkan has been disabled. No tracing will appear unless a layer driver is installed manually.");
                }
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.TRACE_OUTPUT_FILE)) {
                    if (!MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.EXIT_AT_FRAME, MGDCommandLineSwitch.TIMEOUT)) {
                        throw new CommandLineException(MGDCommandLineMessages.LIVE_TARGET_NEEDS_CLEAN_EXIT_SPEC);
                    }
                    if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_SWITCHES)) {
                        throw new CommandLineException("The --export... switches only apply when a saved trace file is used. This is specified using the first non-switch argument.");
                    }
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.DEVICE_ID, MGDCommandLineSwitch.DEVICE_IP)) {
                        throw new CommandLineException(MGDCommandLineMessages.CANNOT_TRACE_MULTIPLE_TARGETS_AT_ONCE);
                    }
                    if (!MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.PROCESS_NAME)) {
                        throw new CommandLineException(MGDCommandLineMessages.MISSING_PROCESS_SPEC);
                    }
                    if (!rawCommandLine.getArgList().isEmpty()) {
                        throw new CommandLineException("Encountered unwanted non-switch arguments. Only one such argument is allowed: this specifies a trace file.");
                    }
                    break block29;
                }
                if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_OUTPUT_DIRECTORY)) {
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.TIMEOUT)) {
                        throw new CommandLineException(MGDCommandLineMessages.TIMEOUT_CANNOT_BE_USED_WITH_TRACE_FILE);
                    }
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.TRACE_OUTPUT_FILE)) {
                        throw new CommandLineException("Trace output file name is not used for exporting, use the export output directory switch instead");
                    }
                    if (!MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_OUTPUT_DIRECTORY)) {
                        throw new CommandLineException("Export output directory switch is required when interfacing with a trace file");
                    }
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.EXIT_AT_FRAME)) {
                        throw new CommandLineException(MGDCommandLineMessages.FINAL_FRAME_NUMBER_CANNOT_BE_USED_WITH_TRACE_FILE);
                    }
                    if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_SWITCHES)) {
                        throw new CommandLineException(MGDCommandLineMessages.NO_COLLECT_FOR_SAVED_TRACE);
                    }
                    if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_SWITCHES)) {
                        throw new CommandLineException(MGDCommandLineMessages.NO_FRAMES_WITH_FOR_SAVED_TRACE);
                    }
                    if (MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.ADB_LOCATION)) {
                        throw new CommandLineException("The location of ADB is not required for trace files");
                    }
                    if (MGDCommandLine.hasAnySwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.DEVICE_ID, MGDCommandLineSwitch.DEVICE_IP)) {
                        throw new CommandLineException("The device ID/IP switches are for live tracing, and cannot be used when exporting assets from a trace file");
                    }
                    break block29;
                }
                throw new CommandLineException("No output location provided; you must provide either a trace output file (for tracing), or an export directory (when exporting assets)");
            }
            catch (ParseException e) {
                String message = e.getMessage();
                if (e instanceof MissingOptionException) {
                    List missingOptions = ((MissingOptionException)e).getMissingOptions();
                    if (missingOptions.contains(MGDCommandLineSwitch.TRACE_OUTPUT_FILE.getLongOption())) {
                        message = MGDCommandLineMessages.MISSING_OUTPUT_DIRECTORY;
                    }
                } else if (e instanceof AlreadySelectedException && ((AlreadySelectedException)e).getOptionGroup() == DEVICE_SELECTION_OPTION_GROUP) {
                    message = MGDCommandLineMessages.CANNOT_TRACE_MULTIPLE_TARGETS_AT_ONCE;
                }
                throw new CommandLineException(message == null ? "" : message);
            }
        }
        return rawCommandLine;
    }

    public MGDCommandLine(String[] args) throws CommandLineException {
        String deviceIdentifierIPOption;
        CommandLine rawCommandLine = MGDCommandLine.readCommandLine(args);
        this.help = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.HELP);
        this.adbLocation = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.ADB_LOCATION));
        this.deviceIdentifier = !rawCommandLine.getArgList().isEmpty() ? new DeviceIdentifier(DeviceIdentifier.Namespace.FILE, (String)NullUtils.neverNull((Object)rawCommandLine.getArgs()[0])) : ((deviceIdentifierIPOption = MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.DEVICE_IP)) == null ? new DeviceIdentifier(DeviceIdentifier.Namespace.ADB, MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.DEVICE_ID)) : new DeviceIdentifier(DeviceIdentifier.Namespace.IP, deviceIdentifierIPOption));
        this.timeout = MGDCommandLineUtils.parseOptionalNonNegativeLong(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.TIMEOUT), "timeout");
        this.exitAtFrame = MGDCommandLineUtils.parseOptionalNonNegativeLong(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXIT_AT_FRAME), "final frame index");
        String traceConfigOption = MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.TRACE_CONFIG);
        try {
            this.tracePreset = traceConfigOption == null ? CommandLineTraceConfig.LEGACY.getPreset() : CommandLineTraceConfig.of(traceConfigOption).getPreset();
        }
        catch (IllegalArgumentException e) {
            throw new CommandLineException(MGDCommandLineMessages.format("Could not understand supplied trace config level (\"%s\")", traceConfigOption));
        }
        this.collectBinaries = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_BINARIES);
        this.collectExplicitBuffers = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_EXPLICIT_BUFFERS);
        this.collectImplicitBuffers = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_IMPLICIT_BUFFERS);
        this.collectExplicitMemory = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_EXPLICIT_MEMORY);
        this.collectOutputBuffers = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_OUTPUT_BUFFERS);
        this.collectSources = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_SOURCES);
        this.collectTextures = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_TEXTURES);
        this.collectUniforms = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.COLLECT_UNIFORMS);
        this.shouldInstallAndroidComponents = !MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.NO_ANDROID_INSTALL);
        this.shouldInstallOpenGLES = !MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.NO_OPENGL_ES);
        this.shouldInstallVulkan = !MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.NO_VULKAN);
        this.showDevices = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.LIST_TARGETS);
        this.listPackages = MGDCommandLine.hasAllSwitchesOnCommandLine(rawCommandLine, MGDCommandLineSwitch.LIST_PACKAGES);
        this.deviceID = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.DEVICE_ID));
        this.traceOutputFile = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.TRACE_OUTPUT_FILE));
        this.exportOutputDirectory = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_OUTPUT_DIRECTORY));
        this.processName = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.PROCESS_NAME));
        this.processID = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.PROCESS_ID));
        this.activitySubstring = Optional.ofNullable(MGDCommandLine.getOptionFromCommandLine(rawCommandLine, MGDCommandLineSwitch.ACTIVITY_SUBSTRING));
        String frameIndexDescription = "frame index";
        this.framesWithDefaultCapture = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(MGDCommandLine.getOptionListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_DEFAULT_CAPTURE), "frame index");
        this.framesWithOverdraw = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(MGDCommandLine.getOptionListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_OVERDRAW), "frame index");
        this.framesWithAllAttachments = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(MGDCommandLine.getOptionListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_ALL_ATTACHMENTS), "frame index");
        this.framesWithShaderMap = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(MGDCommandLine.getOptionListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_SHADER_MAP), "frame index");
        this.framesWithFragmentCount = MGDCommandLineUtils.parseNonNegativeLongArrayAsNavigableSet(MGDCommandLine.getOptionListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.FRAMES_WITH_FRAGMENT_COUNT), "frame index");
        MGDCommandLine.getPerTraceIndexListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_FRAME_TEXTURES, this.exportTexturesForFrames, "texture index", TraceIndexType.FRAME);
        MGDCommandLine.getPerTraceIndexListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_FRAME_SHADERS, this.exportShadersForFrames, "shader index", TraceIndexType.FRAME);
        MGDCommandLine.getPerTraceIndexListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_FUNCTION_TEXTURES, this.exportTexturesForFunctions, "texture index", TraceIndexType.FUNCTION_CALL);
        MGDCommandLine.getPerTraceIndexListFromCommandLine(rawCommandLine, MGDCommandLineSwitch.EXPORT_FUNCTION_SHADERS, this.exportShadersForFunctions, "shader index", TraceIndexType.FUNCTION_CALL);
        ISelectableResource.SelectableResourceType[] selectableResourceTypeArray = ISelectableResource.SelectableResourceType.values();
        int n = selectableResourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectableResource.SelectableResourceType resource = selectableResourceTypeArray[n2];
            switch (resource) {
                case CL_EXPLICIT_MEMORY_ASSET: {
                    this.clResources.add(new ClResource(resource, this.collectExplicitMemory || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case CL_IMPLICIT_MEMORY_ASSET: {
                    this.clResources.add(new ClResource(resource, this.collectImplicitBuffers || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case CL_PROGRAM_ASSET_SOURCE: {
                    this.clResources.add(new ClResource(resource, this.collectSources || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_EXPLICIT_BUFFER_ASSET: {
                    this.glesResources.add(new GlesResource(resource, this.collectExplicitBuffers || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_IMPLICIT_BUFFER_ASSET: {
                    this.glesResources.add(new GlesResource(resource, this.collectImplicitBuffers || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_SHADER_ASSET_BINARY: {
                    this.glesResources.add(new GlesResource(resource, this.collectBinaries || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_SHADER_ASSET_SOURCE: {
                    this.glesResources.add(new GlesResource(resource, this.collectSources || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_SHADER_ASSET_UNIFORM: {
                    this.glesResources.add(new GlesResource(resource, this.collectUniforms || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case GL_TEXTURE_ASSET: {
                    this.glesResources.add(new GlesResource(resource, this.collectTextures || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case VK_IMPLICIT_DEVICE_MEMORY_ASSET: {
                    this.vulkanResources.add(new VulkanResource(resource, this.collectImplicitBuffers || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
                case VK_SHADER_ASSET_BINARY: {
                    this.vulkanResources.add(new VulkanResource(resource, this.collectBinaries || this.isResourceTypeEnabledBySelectedTracePreset(resource)));
                    break;
                }
            }
            ++n2;
        }
    }

    private boolean isResourceTypeEnabledBySelectedTracePreset(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISelectableResource.SelectableResourceType resource) {
        switch (resource.getApiForResourceType()) {
            case OPENCL: {
                return ((ClResource)this.tracePreset.getConfig().interceptorConfig.getClConfig().getSelectableResource(resource)).isSelected();
            }
            case OPENGL_ES: {
                return ((GlesResource)this.tracePreset.getConfig().interceptorConfig.getGlesConfig().getSelectableResource(resource)).isSelected();
            }
            case VULKAN: {
                return ((VulkanResource)this.tracePreset.getConfig().interceptorConfig.getVulkanConfig().getSelectableResource(resource)).isSelected();
            }
        }
        assert (false);
        throw new IllegalStateException("Unable to identify the API for the resource type: " + resource);
    }

    public static void printHelp(@NonNull HelpFormatter helpFormatter, @NonNull PrintWriter printWriter) {
        String header = "\nThis is " + VersionProperties.FULL_PRODUCT_NAME + " (" + VersionProperties.SHORT_PRODUCT_NAME + "), " + "version " + VersionProperties.PRODUCT_VERSION + ".\n\n" + "Switches:\n";
        String footer = "\nStart a live trace using " + MGDCommandLineUtils.orList(new Object[]{MGDCommandLineSwitch.DEVICE_IP, MGDCommandLineSwitch.DEVICE_ID}) + "; alternatively, replay a saved trace file via the first non-switch argument.\n\n" + "Textures, shaders, kernels and frames are specified by index; the first is numbered 0. " + "Lists of these indexes are " + "comma" + "-separated.\n\n" + MGDCommandLineUtils.andList(new Object[]{MGDCommandLineSwitch.EXPORT_FRAME_TEXTURES, MGDCommandLineSwitch.EXPORT_FRAME_SHADERS, MGDCommandLineSwitch.EXPORT_FUNCTION_TEXTURES, MGDCommandLineSwitch.EXPORT_FUNCTION_SHADERS}) + " are only used with saved trace files. They require an argument in a special format. Give the function / frame index first, then a " + "colon" + ", and finally a list of texture or shader / kernel indexes. " + "For example, \"-S 5" + ':' + "0" + ',' + "2\" " + "will export shaders 0 and 2 (the first and third shaders) from frame 5 (the sixth frame). These switches require " + MGDCommandLineUtils.only(MGDCommandLineSwitch.PROCESS_NAME) + " to avoid ambiguity.\n\n" + "The --collect... and --frames-with... switches apply only to live capture.\n\n" + MGDCommandLineUtils.orList(new Object[]{MGDCommandLineSwitch.EXIT_AT_FRAME, MGDCommandLineSwitch.TIMEOUT}) + " (or both) tell " + VersionProperties.FULL_PRODUCT_NAME + " how to exit cleanly. One or both of these switches is required, as is " + MGDCommandLineUtils.only(MGDCommandLineSwitch.TRACE_OUTPUT_FILE) + ".\n\n" + "For help and support, please visit the Arm Mali graphics community at https://community.arm.com/graphics/";
        String commandLineSyntax = "aga [" + MGDCommandLineUtils.only(MGDCommandLineSwitch.DEVICE_IP) + " <arg> | " + MGDCommandLineUtils.only(MGDCommandLineSwitch.DEVICE_ID) + " <arg>]  " + "[" + MGDCommandLineUtils.only(MGDCommandLineSwitch.PROCESS_NAME) + " <arg>]  " + MGDCommandLineUtils.only(MGDCommandLineSwitch.EXIT_AT_FRAME) + " <arg> | " + MGDCommandLineUtils.only(MGDCommandLineSwitch.TIMEOUT) + " <arg>  " + MGDCommandLineUtils.only(MGDCommandLineSwitch.TRACE_OUTPUT_FILE) + " <arg>  " + "[OTHER-SWITCHES]  " + "[INPUT-TRACE-FILE]";
        helpFormatter.setSyntaxPrefix("Synopsis: ");
        helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), commandLineSyntax, header, COMMAND_LINE_OPTIONS, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), footer, false);
    }

    public String toString() {
        return "MGDCommandLine [clResources=" + this.clResources + ", glesResources=" + this.glesResources + ", vulkanResources=" + this.vulkanResources + ", adbLocation=" + this.adbLocation + ", deviceIdentifier=" + this.deviceIdentifier + ", tracePreset=" + this.tracePreset + ", collectBinaries=" + this.collectBinaries + ", collectExplicitBuffers=" + this.collectExplicitBuffers + ", collectImplicitBuffers=" + this.collectImplicitBuffers + ", collectExplicitMemory=" + this.collectExplicitMemory + ", collectOutputBuffers=" + this.collectOutputBuffers + ", collectSources=" + this.collectSources + ", collectTextures=" + this.collectTextures + ", collectUniforms=" + this.collectUniforms + ", shouldInstallAndroidComponents=" + this.shouldInstallAndroidComponents + ", shouldInstallOpenGLES=" + this.shouldInstallOpenGLES + ", shouldInstallVulkan=" + this.shouldInstallVulkan + ", showDevices=" + this.showDevices + ", listPackages=" + this.listPackages + ", deviceID=" + ", help=" + this.help + this.deviceID + ", traceOutputFile=" + this.traceOutputFile + ", exportOutputDirectory=" + this.exportOutputDirectory + ", processName=" + this.processName + ", processID=" + this.processID + ", activitySubstring=" + this.activitySubstring + ", timeout=" + this.timeout + ", exitAtFrame=" + this.exitAtFrame + ", framesWithDefaultCapture=" + this.framesWithDefaultCapture + ", framesWithOverdraw=" + this.framesWithOverdraw + ", framesWithAllAttachments=" + this.framesWithAllAttachments + ", framesWithShaderMap=" + this.framesWithShaderMap + ", framesWithFragmentCount=" + this.framesWithFragmentCount + ", exportTexturesForFrames=" + this.exportTexturesForFrames + ", exportShadersForFrames=" + this.exportShadersForFrames + ", exportTexturesForFunctions=" + this.exportTexturesForFunctions + ", exportShadersForFunctions=" + this.exportShadersForFunctions + "]";
    }

    @Override
    public Optional<String> getADBLocation() {
        return this.adbLocation;
    }

    @Override
    public DeviceIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    @Override
    public ProcessConfig getProcessConfiguration() {
        InterceptorConfig interceptorConfig = new InterceptorConfig(new ClConfig(this.clResources, false), new GlesConfig(this.glesResources, false), new VulkanConfig(this.vulkanResources, false));
        return new ProcessConfig(interceptorConfig, this.collectOutputBuffers || this.tracePreset.getConfig().outputBuffersEnabled);
    }

    @Override
    public boolean getCollectBinariesCommand() {
        return this.collectBinaries;
    }

    @Override
    public boolean getCollectExplicitBuffersCommand() {
        return this.collectExplicitBuffers;
    }

    @Override
    public boolean getCollectImplicitBuffersCommand() {
        return this.collectImplicitBuffers;
    }

    @Override
    public boolean getCollectExplicitMemoryCommand() {
        return this.collectExplicitMemory;
    }

    @Override
    public boolean getCollectOutputBuffersCommand() {
        return this.collectOutputBuffers;
    }

    @Override
    public boolean getCollectSourcesCommand() {
        return this.collectSources;
    }

    @Override
    public boolean getCollectTexturesCommand() {
        return this.collectTextures;
    }

    @Override
    public boolean getCollectUniformsCommand() {
        return this.collectUniforms;
    }

    @Override
    public Optional<String> getTraceOutputFile() {
        return this.traceOutputFile;
    }

    @Override
    public Optional<String> getExportOutputDirectory() {
        return this.exportOutputDirectory;
    }

    @Override
    public Optional<String> getProcessName() {
        return this.processName;
    }

    @Override
    public Optional<String> getProcessID() {
        return this.processID;
    }

    @Override
    public Optional<String> getActivitySubstring() {
        return this.activitySubstring;
    }

    @Override
    public OptionalLong getTimeout() {
        return this.timeout;
    }

    @Override
    public OptionalLong getExitAtFrame() {
        return this.exitAtFrame;
    }

    @Override
    public NavigableSet<Long> getFramesWithDefaultCapture() {
        return this.framesWithDefaultCapture;
    }

    @Override
    public NavigableSet<Long> getFramesWithOverdraw() {
        return this.framesWithOverdraw;
    }

    @Override
    public NavigableSet<Long> getFramesWithAllAttachments() {
        return this.framesWithAllAttachments;
    }

    @Override
    public NavigableSet<Long> getFramesWithShaderMap() {
        return this.framesWithShaderMap;
    }

    @Override
    public NavigableSet<Long> getFramesWithFragmentCount() {
        return this.framesWithFragmentCount;
    }

    @Override
    public NavigableMap<Long, @NonNull NavigableSet<Long>> getExportTexturesForFrames() {
        return this.exportTexturesForFrames;
    }

    @Override
    public NavigableMap<Long, @NonNull NavigableSet<Long>> getExportShadersForFrames() {
        return this.exportShadersForFrames;
    }

    @Override
    public NavigableMap<Long, @NonNull NavigableSet<Long>> getExportTexturesForFunctions() {
        return this.exportTexturesForFunctions;
    }

    @Override
    public NavigableMap<Long, @NonNull NavigableSet<Long>> getExportShadersForFunctions() {
        return this.exportShadersForFunctions;
    }

    @Override
    public boolean getShowDevicesCommand() {
        return this.showDevices;
    }

    @Override
    public boolean getListPackagesCommand() {
        return this.listPackages;
    }

    @Override
    public boolean getHelpCommand() {
        return this.help;
    }

    @Override
    public Optional<String> getDeviceID() {
        return this.deviceID;
    }

    @Override
    public boolean shouldInstallAndroidComponents() {
        return this.shouldInstallAndroidComponents;
    }

    @Override
    public boolean shouldInstallOpenGLES() {
        return this.shouldInstallOpenGLES;
    }

    @Override
    public boolean shouldInstallVulkan() {
        return this.shouldInstallVulkan;
    }

    public static class CommandLineException
    extends Exception {
        private static final long serialVersionUID = 5193102279485879281L;
        private String parseErrorMessage;

        @Override
        public String getMessage() {
            return this.parseErrorMessage;
        }

        public @NonNull String getUserMessage() {
            String formattedMessage = "aga: " + this.parseErrorMessage + "\n\n";
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printWrapped(printWriter, helpFormatter.getWidth(), formattedMessage);
            MGDCommandLine.printHelp(helpFormatter, printWriter);
            return (String)NullUtils.neverNull((Object)stringWriter.toString());
        }

        public CommandLineException(@NonNull String errorMessage) {
            this.parseErrorMessage = errorMessage;
        }
    }

    private static enum TraceIndexType {
        FRAME("frame index"),
        FUNCTION_CALL("function call index");

        public final @NonNull String description;

        private TraceIndexType(String description) {
            this.description = description;
        }
    }
}

