/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.headless.cli.DeviceIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalLong;
import org.eclipse.jdt.annotation.NonNull;

public interface IMGDCommandLine {
    public @NonNull DeviceIdentifier getDeviceIdentifier();

    public @NonNull ProcessConfig getProcessConfiguration();

    public Optional<String> getTraceOutputFile();

    public Optional<String> getExportOutputDirectory();

    public Optional<String> getADBLocation();

    public boolean getShowDevicesCommand();

    public boolean getListPackagesCommand();

    public boolean getHelpCommand();

    public boolean getCollectBinariesCommand();

    public boolean getCollectExplicitBuffersCommand();

    public boolean getCollectImplicitBuffersCommand();

    public boolean getCollectExplicitMemoryCommand();

    public boolean getCollectOutputBuffersCommand();

    public boolean getCollectSourcesCommand();

    public boolean getCollectTexturesCommand();

    public boolean getCollectUniformsCommand();

    public boolean shouldInstallAndroidComponents();

    public boolean shouldInstallOpenGLES();

    public boolean shouldInstallVulkan();

    public Optional<String> getDeviceID();

    public Optional<String> getProcessName();

    public Optional<String> getProcessID();

    public Optional<String> getActivitySubstring();

    public OptionalLong getTimeout();

    public OptionalLong getExitAtFrame();

    public @NonNull NavigableSet<Long> getFramesWithDefaultCapture();

    public @NonNull NavigableSet<Long> getFramesWithOverdraw();

    public @NonNull NavigableSet<Long> getFramesWithAllAttachments();

    public @NonNull NavigableSet<Long> getFramesWithShaderMap();

    public @NonNull NavigableSet<Long> getFramesWithFragmentCount();

    public @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> getExportTexturesForFrames();

    public @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> getExportShadersForFrames();

    public @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> getExportTexturesForFunctions();

    public @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> getExportShadersForFunctions();

    default public @NonNull List<@NonNull AutomatedTraceCommand> generateAutomatedTraceCommands() {
        ArrayList<@NonNull AutomatedTraceCommand> commands = new ArrayList<AutomatedTraceCommand>();
        this.getFramesWithDefaultCapture().forEach(frame -> {
            boolean bl = commands.add(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.FRAME_CAPTURE, frame.intValue()));
        });
        this.getFramesWithOverdraw().forEach(frame -> {
            boolean bl = commands.add(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.OVERDRAW_CAPTURE, frame.intValue()));
        });
        this.getFramesWithAllAttachments().forEach(frame -> {
            boolean bl = commands.add(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.ALL_ATTACHMENTS_CAPTURE, frame.intValue()));
        });
        this.getFramesWithShaderMap().forEach(frame -> {
            boolean bl = commands.add(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.SHADER_MAP_CAPTURE, frame.intValue()));
        });
        this.getFramesWithFragmentCount().forEach(frame -> {
            boolean bl = commands.add(new AutomatedTraceCommand(AutomatedTraceCommand.AutomatedCommandType.FRAGMENT_COUNT_CAPTURE, frame.intValue()));
        });
        return commands;
    }
}

