/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless.cli;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.headless.cli.MGDCommandLine;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CommandLineOutcome {
    public static final @NonNull CommandLineOutcome SUCCESS_OUTCOME = new CommandLineOutcome(OutcomeCategory.SUCCESS, null);
    private final @NonNull OutcomeCategory outcomeCategory;
    private final @Nullable Exception exception;

    public CommandLineOutcome(@NonNull OutcomeCategory outcomeCategory, @Nullable Exception exception) {
        this.outcomeCategory = outcomeCategory;
        this.exception = exception;
    }

    public @NonNull OutcomeCategory getOutcomeCategory() {
        return this.outcomeCategory;
    }

    public void logErrorMessageFromException() {
        if (this.exception instanceof MGDCommandLine.CommandLineException) {
            CoreLogging.warning(null, (String)((MGDCommandLine.CommandLineException)this.exception).getUserMessage());
        } else if (this.exception != null) {
            CoreLogging.severe(null, (String)((String)NullUtils.neverNull((Object)this.exception.getLocalizedMessage())));
        }
    }

    public static enum OutcomeCategory {
        SUCCESS(0, true),
        GENERAL_EXCEPTION(1, true),
        COMMAND_LINE_EXCEPTION(2, false),
        AUTHORISATION_FAILURE(3, true);

        public final int exitCode;
        public final boolean wasCoreLoaded;

        private OutcomeCategory(int exitCode, boolean wasCoreLoaded) {
            this.exitCode = exitCode;
            this.wasCoreLoaded = wasCoreLoaded;
        }
    }
}

