/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBExecutor;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.SynchronousADBExecutor;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.FunctionCallWriter;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.headless.cli.DeviceIdentifier;
import com.arm.mgd.headless.cli.IMGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLineSwitch;
import com.arm.mgd.headless.connection.CliTargetConnection;
import com.arm.mgd.headless.connection.CliTargetConnectionManager;
import com.arm.mgd.headless.utils.HeadlessDeviceManager;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HeadlessLiveConnector {
    protected static final @NonNull String TRACE_FILE_EXTENSION = ".mgd";
    private static final int CONNECTION_WAIT_TIME = 100;
    private static final int DEFAULT_PORT = 5002;
    public static final @NonNull String FEATURE_AUTHORISATION_FAILED_MESSAGE = "Authorisation failed for the following reason: ";
    private static final @NonNull String ADB_CONNECTION_FAILED_MESSAGE = "Connection to ADB failed.";
    private static final @NonNull String CONNECTION_ISSUE_MESSAGE = "Connection issue: ";
    private static final @NonNull String NO_ADB_DEVICES_MESSAGE = "No ADB devices are visible.";
    private static final @NonNull String NO_DEVICE_ID_OR_IP_MESSAGE = "Connection to live targets requires device ID or IP address";
    private static final @NonNull String NO_EXIT_PARAM_MESSAGE = "Either a timeout or a frame to exit after (or both) must be specified";
    private static final @NonNull String NO_MATCHING_DEVICE_MESSAGE = "Unable to find a device matching identifier. The provided identifier was: %s\nAvailable devices are: ";
    private static final @NonNull String NO_PROCESS_NAME_MESSAGE = "A process name is required";
    private static final @NonNull String NO_TRACE_FILE_NAME_MESSAGE = "You must provide a trace file name";
    private static final @NonNull String PROCESS_ALREADY_STARTED_MESSAGE = "Process started before tracing. Disconnecting...";
    private static final @NonNull String SAVE_TRACE_FAILURE_MESSAGE = "Failed to save trace on disk: ";
    private static final @NonNull String TRACE_COMMAND_FAILURE_MESSAGE = "Failed to send a trace command to target:";
    private static final @NonNull String WAITING_FOR_PROCESS_MESSAGE = "Waiting for process: ";
    private static final @NonNull String NEED_DEVICE_ID = "More than one ADB device connected. You must provide a device ID.";
    private static final @NonNull String WRONG_FILE_EXTENSION = "Trace file names should end with the '.mgd' extension. The extension has been added automatically: ";
    private static final @NonNull String ADB_DEVICE_OFFLINE = "The specified device ID was offline or unauthorized: ";
    private static final @NonNull IADBExecutor EXECUTOR = new SynchronousADBExecutor(60L, TimeUnit.SECONDS);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void connectToLiveTarget(@NonNull IMGDCommandLine commandLine, @Nullable Path configuredADBLocation) throws CliTargetConnection.ConnectionFailedException, ExecutionException, CliTargetConnection.AuthorisationFailedException, IADBTask.ADBException {
        String processName = commandLine.getProcessName().orElseThrow(() -> new IllegalArgumentException(NO_PROCESS_NAME_MESSAGE));
        OptionalLong lastFrame = commandLine.getExitAtFrame();
        OptionalLong timeOut = commandLine.getTimeout();
        String outputFile = (String)NullUtils.neverNull((Object)commandLine.getTraceOutputFile().orElseThrow(() -> new IllegalArgumentException(NO_TRACE_FILE_NAME_MESSAGE)));
        if (!lastFrame.isPresent() && !timeOut.isPresent()) {
            throw new IllegalArgumentException(NO_EXIT_PARAM_MESSAGE);
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            @NonNull CliTargetConnection connection = DeviceConnector.get(commandLine, configuredADBLocation);
            @NonNull FeatureAuthorisation connectionAuthorisation = (FeatureAuthorisation)connection.getTarget().isAuthorised().get();
            if (!connectionAuthorisation.isAuthorised()) {
                @NonNull String errorMessage = FEATURE_AUTHORISATION_FAILED_MESSAGE + System.lineSeparator() + connectionAuthorisation.getReason() + System.lineSeparator() + connectionAuthorisation.getFeature().getLicenceMissingMessage();
                CoreLogging.warning(null, (String)errorMessage);
                throw new CliTargetConnection.AuthorisationFailedException(errorMessage);
            }
            connection.pause(false);
            if (timeOut.isPresent()) {
                connection.beginWaitingForTimeout(timeOut.getAsLong());
            }
            assert (processName != null);
            CoreLogging.info(null, (String)(WAITING_FOR_PROCESS_MESSAGE + processName));
            LiveProcessTarget process = (LiveProcessTarget)connection.getTarget().getFirstConnectedProcessTarget(processName);
            while (process == null) {
                if (connection.isDisconnectRequested()) {
                    connection.waitForDisconnect();
                    if (connection == null) return;
                    connection.close();
                    return;
                }
                Thread.sleep(100L);
                process = (LiveProcessTarget)connection.getTarget().getFirstConnectedProcessTarget(processName);
            }
            if (process.getModel().processStartedBeforeTracing()) {
                CoreLogging.warning(null, (String)((String)NullUtils.neverNull((Object)PROCESS_ALREADY_STARTED_MESSAGE)));
                connection.requestDisconnect();
                connection.waitForDisconnect();
                if (connection == null) return;
                connection.close();
                return;
            }
            try {
                for (AutomatedTraceCommand atc : commandLine.generateAutomatedTraceCommands()) {
                    try {
                        process.sendAddAutomatedTraceCommand(atc);
                    }
                    catch (Exception e) {
                        String error = TRACE_COMMAND_FAILURE_MESSAGE + System.lineSeparator() + atc.toString() + System.lineSeparator() + e.getMessage();
                        CoreLogging.severe(null, (String)error);
                    }
                }
                connection.disconnectProcessBeforeFrame(process, (int)(lastFrame.isPresent() ? lastFrame.getAsLong() : Integer.MAX_VALUE));
                process.resume();
                connection.waitForDisconnect();
                try {
                    HeadlessLiveConnector.saveTrace(connection.getTarget(), HeadlessLiveConnector.addExtensionIfNecessary(outputFile));
                    return;
                }
                catch (IOException e) {
                    CoreLogging.warning(null, (String)(SAVE_TRACE_FAILURE_MESSAGE + e.getMessage()));
                    return;
                }
            }
            catch (InterruptedException e) {
                CoreLogging.severe(null, (String)(CONNECTION_ISSUE_MESSAGE + e.getMessage()));
                connection.requestDisconnect();
                return;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    protected static @NonNull String getActivityName(@NonNull ADBInstalledPackage adbPackage, @NonNull String partialActivityName) throws IADBTask.ADBExecutionException {
        @Nullable String matchedActivity = null;
        int matches = 0;
        for (String activity : adbPackage.getMainActivities()) {
            if (activity.equals(partialActivityName)) {
                return (String)NullUtils.neverNull((Object)activity);
            }
            if (!activity.contains(partialActivityName)) continue;
            ++matches;
            matchedActivity = activity;
        }
        if (matches == 1) {
            return (String)NullUtils.neverNull(matchedActivity);
        }
        StringBuilder errorMessage = new StringBuilder().append(matches).append(" activities were found in package ").append(adbPackage.getPackageName());
        if (!partialActivityName.isEmpty()) {
            errorMessage.append(" matching \"" + partialActivityName + "\" (case-sensitive)");
        }
        errorMessage.append(". Please specify a single activity using ").append((Object)MGDCommandLineSwitch.ACTIVITY_SUBSTRING).append(" or list available activities using ").append((Object)MGDCommandLineSwitch.LIST_PACKAGES).append(".");
        throw new IADBTask.ADBExecutionException((String)NullUtils.neverNull((Object)errorMessage.toString()));
    }

    private static void saveTrace(@NonNull AbstractTarget target, @NonNull String outputFileName) throws IOException {
        File outputFile = new File(outputFileName).getCanonicalFile();
        File parentDirectory = new File(outputFile.getParent());
        parentDirectory.mkdirs();
        FunctionCallWriter.write((File)outputFile, (AbstractTarget)target);
    }

    private static CliTargetConnection.ConnectionFailedException generateException(@NonNull Collection<@NonNull ADBDeviceIdentifier> identifiers, @NonNull String identifier) {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add(String.valueOf(String.format(NO_MATCHING_DEVICE_MESSAGE, identifier)) + System.lineSeparator());
        if (identifiers.isEmpty()) {
            joiner.add("<none>");
        } else {
            identifiers.stream().map(ADBDeviceIdentifier::getID).forEach(joiner::add);
        }
        return new CliTargetConnection.ConnectionFailedException((String)NullUtils.neverNull((Object)joiner.toString()));
    }

    protected static @NonNull String addExtensionIfNecessary(@NonNull String fileName) {
        String fileNameWithExtension;
        if (!fileName.endsWith(TRACE_FILE_EXTENSION)) {
            fileNameWithExtension = String.valueOf(fileName) + TRACE_FILE_EXTENSION;
            CoreLogging.warning(null, (String)(WRONG_FILE_EXTENSION + fileNameWithExtension));
        } else {
            fileNameWithExtension = fileName;
        }
        return fileNameWithExtension;
    }

    static /* synthetic */ CliTargetConnection.ConnectionFailedException access$0(Collection collection, String string) {
        return HeadlessLiveConnector.generateException(collection, string);
    }

    private static class DeviceConnector {
        private static @Nullable CliTargetConnection connection = null;

        private DeviceConnector() {
        }

        public static @NonNull CliTargetConnection get(@NonNull IMGDCommandLine commandLine, @Nullable Path configuredADBLocation) throws CliTargetConnection.ConnectionFailedException, IADBTask.ADBException {
            @NonNull DeviceIdentifier deviceID = commandLine.getDeviceIdentifier();
            switch (deviceID.getNamespace()) {
                case IP: {
                    String identifier = deviceID.getIdentifier();
                    assert (identifier != null);
                    connection = CliTargetConnectionManager.createLiveConnection(identifier, 5002, commandLine.getProcessConfiguration());
                    break;
                }
                case ADB: {
                    ADBDevice device;
                    HeadlessDeviceManager deviceManager = HeadlessDeviceManager.create(commandLine, configuredADBLocation);
                    Map<ADBDeviceIdentifier, ADBDevice> deviceMap = deviceManager.getAllDevicesMap();
                    Set<ADBDeviceIdentifier> deviceIDs = deviceMap.keySet();
                    @Nullable String targetID = commandLine.getDeviceIdentifier().getIdentifier();
                    if (deviceIDs.isEmpty()) {
                        throw new CliTargetConnection.ConnectionFailedException(HeadlessLiveConnector.NO_ADB_DEVICES_MESSAGE);
                    }
                    if (targetID == null) {
                        if (deviceIDs.size() > 1) {
                            throw new CliTargetConnection.ConnectionFailedException(HeadlessLiveConnector.NEED_DEVICE_ID);
                        }
                        device = deviceMap.get(deviceIDs.toArray()[0]);
                    } else {
                        device = deviceMap.entrySet().stream().filter(entry -> targetID.equals(((ADBDeviceIdentifier)entry.getKey()).getID())).map(Map.Entry::getValue).findAny().orElseThrow(() -> HeadlessLiveConnector.generateException(deviceIDs, targetID));
                    }
                    if (device == null) {
                        throw new CliTargetConnection.ConnectionFailedException(HeadlessLiveConnector.ADB_DEVICE_OFFLINE + targetID);
                    }
                    @NonNull AndroidBridge androidBridge = deviceManager.getAndroidBridge();
                    androidBridge.connectToDevice(device, (ipAddress, port) -> {
                        block8: {
                            try {
                                if (commandLine.shouldInstallAndroidComponents()) {
                                    String processName;
                                    ADBInstalledPackage adbPackage;
                                    CliTargetConnection daemonConnection = CliTargetConnectionManager.getLiveConnectionToDaemon(ipAddress, port, device, commandLine.getProcessConfiguration());
                                    if (daemonConnection != null) {
                                        try {
                                            LiveTarget target = (LiveTarget)daemonConnection.getTarget();
                                            if (!target.killDaemonAndCloseConnection()) {
                                                throw new CliTargetConnection.ConnectionFailedException("An older version of the GA Daemon is already running on the device. Please kill the daemon process and try again");
                                            }
                                        }
                                        catch (IOException daemonConnectionException) {
                                            CoreLogging.severe(null, (String)daemonConnectionException.getMessage());
                                        }
                                    }
                                    if ((adbPackage = androidBridge.getPackage(processName = (String)NullUtils.neverNull((Object)commandLine.getProcessName().get()), EXECUTOR, device)) == null) {
                                        throw new IADBTask.ADBExecutionException("No debuggable packages were found named \"" + processName + "\"");
                                    }
                                    @NonNull String activitySubstring = (String)NullUtils.neverNull((Object)commandLine.getActivitySubstring().orElse(""));
                                    connection = CliTargetConnectionManager.createLiveConnection(ipAddress, port, device, androidBridge, adbPackage, HeadlessLiveConnector.getActivityName(adbPackage, activitySubstring), commandLine.getProcessConfiguration(), commandLine.shouldInstallOpenGLES(), commandLine.shouldInstallVulkan());
                                    break block8;
                                }
                                connection = CliTargetConnectionManager.createLiveConnection(ipAddress, port, device, commandLine.getProcessConfiguration());
                            }
                            catch (IADBTask.ADBException | CliTargetConnection.ConnectionFailedException e) {
                                connection = null;
                                CoreLogging.warning(null, (String)(HeadlessLiveConnector.ADB_CONNECTION_FAILED_MESSAGE + System.lineSeparator() + e.getMessage()));
                                return false;
                            }
                        }
                        return true;
                    }).run(EXECUTOR);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(HeadlessLiveConnector.NO_DEVICE_ID_OR_IP_MESSAGE);
                }
            }
            assert (connection != null);
            return connection;
        }
    }
}

