/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.headless;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.export.GlShaderAssetExporter;
import com.arm.mgd.core.export.GlTextureAssetExporter;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IAssetsCollectionGetter;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.IGlShaderAssetGetter;
import com.arm.mgd.headless.CommandLineTargetFactory;
import com.arm.mgd.headless.cli.IMGDCommandLine;
import com.arm.mgd.headless.cli.MGDCommandLine;
import com.arm.mgd.headless.connection.CliTargetConnection;
import com.arm.mgd.headless.utils.HeadlessCoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class HeadlessAssetExporter {
    private static final String DUPLICATE_PROCESS_NAME_MESSAGE = "More than one process in the trace file matched the provided name.\nYou must also provide the process ID for the process you want.\nAvailable IDs are: ";
    private static final String INDEX_OUT_OF_RANGE_MESSAGE = "Failed to export %s. Supplied %s index \"%s\" is out of range.\nPlease provide a valid <%s-number> to export";
    private static final String NO_OUTPUT_DIRECTORY_MESSAGE = "An export output directory is required";
    private static final String NO_PROCESS_WITH_NAME_MESSAGE = "Unable to find process with name \"%s\"";
    private static final String NO_PROCESS_NAME_MESSAGE = "A process name is required";
    private static final String PROCESS_ID_MESSAGE = " and process ID ";
    private static final String UNRECOGNISED_ASSET_TYPE_MESSAGE = "Unrecognised asset type: ";
    private static final @NonNull AssetTableSpec GL_TEXTURE_ASSET_TABLE = KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC;

    public static void exportAssetsFromTraceFile(@NonNull IMGDCommandLine commandLine) throws IOException, ProtocolVersionException, MGDCommandLine.CommandLineException, CliTargetConnection.AuthorisationFailedException {
        HeadlessAssetExporter.exportTexturesIfRequired(commandLine);
        HeadlessAssetExporter.exportShadersIfRequired(commandLine);
    }

    public static void exportTexturesIfRequired(@NonNull IMGDCommandLine commandLine) throws IOException, ProtocolVersionException, MGDCommandLine.CommandLineException, CliTargetConnection.AuthorisationFailedException {
        if (HeadlessAssetExporter.isTextureExportRequired(commandLine)) {
            HeadlessAssetExporter.exportAssets(commandLine, commandLine.getExportTexturesForFrames(), commandLine.getExportTexturesForFunctions(), ExportableAssetType.GL_TEXTURE_ASSET);
        }
    }

    public static void exportShadersIfRequired(@NonNull IMGDCommandLine commandLine) throws IOException, ProtocolVersionException, MGDCommandLine.CommandLineException, CliTargetConnection.AuthorisationFailedException {
        if (HeadlessAssetExporter.isShaderExportRequired(commandLine)) {
            HeadlessAssetExporter.exportAssets(commandLine, commandLine.getExportShadersForFrames(), commandLine.getExportShadersForFunctions(), ExportableAssetType.GL_SHADER_ASSET);
        }
    }

    private static void exportAssets(IMGDCommandLine commandLine, @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> frameAssets, @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> functionAssets, @NonNull ExportableAssetType assetTypeToExport) throws IOException, ProtocolVersionException, CliTargetConnection.AuthorisationFailedException, MGDCommandLine.CommandLineException {
        String processName = commandLine.getProcessName().orElseThrow(() -> new IllegalArgumentException(NO_PROCESS_NAME_MESSAGE));
        @NonNull File outputDirectory = new File(commandLine.getExportOutputDirectory().orElseThrow(() -> new IllegalArgumentException(NO_OUTPUT_DIRECTORY_MESSAGE)));
        @NonNull AbstractTarget target = (AbstractTarget)NullUtils.neverNull((Object)HeadlessAssetExporter.getAuthorisedTarget(commandLine));
        HeadlessAssetExporter.exportAssetsFromTarget(target, outputDirectory, (String)NullUtils.neverNull((Object)processName), commandLine.getProcessID(), frameAssets, functionAssets, assetTypeToExport);
        target.close(ICoreProgressMonitor.NULL_MONITOR);
    }

    private static @NonNull AbstractTarget getAuthorisedTarget(@NonNull IMGDCommandLine commandLine) throws IOException, ProtocolVersionException, CliTargetConnection.AuthorisationFailedException {
        @NonNull AbstractTarget target = CommandLineTargetFactory.makeTarget(commandLine);
        try {
            @NonNull FeatureAuthorisation connectionAuthorisation = (FeatureAuthorisation)target.isAuthorised().get();
            if (!connectionAuthorisation.isAuthorised()) {
                @NonNull String errorMessage = "Authorisation failed for the following reason: " + System.lineSeparator() + connectionAuthorisation.getReason() + System.lineSeparator() + connectionAuthorisation.getFeature().getLicenceMissingMessage();
                CoreLogging.warning(null, (String)errorMessage);
                throw new CliTargetConnection.AuthorisationFailedException(errorMessage);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            CoreLogging.warning(null, (String)((String)NullUtils.neverNull((Object)e.getMessage())));
            throw new CliTargetConnection.AuthorisationFailedException((String)NullUtils.neverNull((Object)e.getMessage()));
        }
        return target;
    }

    private static boolean isTextureExportRequired(IMGDCommandLine commandLine) {
        return !commandLine.getExportTexturesForFrames().isEmpty() || !commandLine.getExportTexturesForFunctions().isEmpty();
    }

    private static boolean isShaderExportRequired(IMGDCommandLine commandLine) {
        return !commandLine.getExportShadersForFrames().isEmpty() || !commandLine.getExportShadersForFunctions().isEmpty();
    }

    private static void exportAssetsFromTarget(@NonNull AbstractTarget target, @NonNull File outputDirectory, @NonNull String processName, Optional<String> optionalProcessID, @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> frameAssets, @NonNull NavigableMap<Long, @NonNull NavigableSet<Long>> functionAssets, @NonNull ExportableAssetType assetTypeToExport) throws MGDCommandLine.CommandLineException {
        String errorMessage;
        Collection textures;
        Predicate<GlTextureAsset> selectedTexturesPredicate;
        Set texturesToGet;
        Collection shaders;
        Set shaderIds;
        int index;
        TraceDataModel modelToExportFrom;
        if (frameAssets.isEmpty() && functionAssets.isEmpty()) {
            return;
        }
        List<@NonNull T> namedProcesses = target.getModels().stream().filter(model -> model.getProcessName().equals(processName)).collect(Collectors.toList());
        if (namedProcesses.size() < 1) {
            throw new IllegalArgumentException(String.format(NO_PROCESS_WITH_NAME_MESSAGE, processName));
        }
        if (namedProcesses.size() > 1) {
            StringJoiner processIDJoiner = new StringJoiner(", ");
            for (TraceDataModel model2 : namedProcesses) {
                processIDJoiner.add(Integer.toString(model2.getProcessID()));
            }
            @NonNull String processIDAsString = optionalProcessID.orElseThrow(() -> new MGDCommandLine.CommandLineException(DUPLICATE_PROCESS_NAME_MESSAGE + processIDJoiner.toString()));
            int processID = Integer.parseInt(processIDAsString);
            modelToExportFrom = namedProcesses.stream().filter(model -> model.getProcessID() == processID).findAny().orElseThrow(() -> new IllegalArgumentException(String.valueOf(String.format(NO_PROCESS_WITH_NAME_MESSAGE, processName)) + PROCESS_ID_MESSAGE + processID));
        } else {
            modelToExportFrom = (TraceDataModel)namedProcesses.get(0);
        }
        block13: for (Long frameIndex : frameAssets.keySet()) {
            try {
                index = Math.toIntExact(frameIndex);
                switch (assetTypeToExport) {
                    case GL_SHADER_ASSET: {
                        shaderIds = (Set)NullUtils.neverNull((Object)((NavigableSet)frameAssets.get(frameIndex)));
                        shaders = IGlShaderAssetGetter.getSpecificShadersAtFrame((TraceDataModel)modelToExportFrom, (Set)shaderIds, (int)index).get();
                        GlShaderAssetExporter.export((Collection)shaders, (File)outputDirectory, (ICoreProgressMonitor)new HeadlessCoreProgressMonitor());
                        continue block13;
                    }
                    case GL_TEXTURE_ASSET: {
                        texturesToGet = (Set)NullUtils.neverNull((Object)((NavigableSet)frameAssets.get(frameIndex)));
                        selectedTexturesPredicate = texturesToGet.isEmpty() ? texture -> true : texture -> texturesToGet.contains(texture.getId());
                        textures = IAssetsCollectionGetter.getAssetsAtFrame((TraceDataModel)modelToExportFrom, (int)frameIndex.intValue(), (AssetTableSpec)GL_TEXTURE_ASSET_TABLE, selectedTexturesPredicate).get();
                        GlTextureAssetExporter.export((Collection)textures, (File)outputDirectory, (ICoreProgressMonitor)new HeadlessCoreProgressMonitor());
                        continue block13;
                    }
                    default: {
                        assert (false) : "Unrecognised asset type: " + (Object)((Object)assetTypeToExport);
                        continue block13;
                    }
                }
            }
            catch (ArithmeticException | IndexOutOfBoundsException e) {
                errorMessage = String.format(INDEX_OUT_OF_RANGE_MESSAGE, new Object[]{assetTypeToExport, "frame", frameIndex, "frame"});
                CoreLogging.warning(null, (String)((String)NullUtils.neverNull((Object)errorMessage)));
                throw new IndexOutOfBoundsException(errorMessage);
            }
        }
        block14: for (Long functionIndex : functionAssets.keySet()) {
            try {
                index = Math.toIntExact(functionIndex);
                switch (assetTypeToExport) {
                    case GL_SHADER_ASSET: {
                        shaderIds = (Set)NullUtils.neverNull((Object)((NavigableSet)functionAssets.get(functionIndex)));
                        shaders = IGlShaderAssetGetter.getSpecificShadersAtFunctionCall((TraceDataModel)modelToExportFrom, (Set)shaderIds, (int)index).get();
                        GlShaderAssetExporter.export((Collection)shaders, (File)outputDirectory, (ICoreProgressMonitor)new HeadlessCoreProgressMonitor());
                        continue block14;
                    }
                    case GL_TEXTURE_ASSET: {
                        texturesToGet = (Set)NullUtils.neverNull((Object)((NavigableSet)functionAssets.get(functionIndex)));
                        selectedTexturesPredicate = texturesToGet.isEmpty() ? texture -> true : texture -> texturesToGet.contains(texture.getId());
                        textures = IAssetsCollectionGetter.getAssetsAtFunctionCall((TraceDataModel)modelToExportFrom, (int)index, (AssetTableSpec)GL_TEXTURE_ASSET_TABLE, selectedTexturesPredicate).get();
                        GlTextureAssetExporter.export((Collection)textures, (File)outputDirectory);
                        continue block14;
                    }
                    default: {
                        assert (false) : "Unrecognised asset type: " + (Object)((Object)assetTypeToExport);
                        continue block14;
                    }
                }
            }
            catch (ArithmeticException | IndexOutOfBoundsException e) {
                errorMessage = String.format(INDEX_OUT_OF_RANGE_MESSAGE, new Object[]{assetTypeToExport, "function", functionIndex, "function"});
                CoreLogging.warning(null, (String)((String)NullUtils.neverNull((Object)errorMessage)));
                throw new IndexOutOfBoundsException(errorMessage);
            }
        }
    }

    public static enum ExportableAssetType {
        GL_SHADER_ASSET,
        GL_TEXTURE_ASSET;

    }
}

