/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.common;

import com.arm.streamline.jni.common.CommonLib;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.jni.common.NativeHandle;
import com.arm.streamline.jni.common.NativeIOException;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public final class MMappedFile
implements AutoCloseable {
    private final @NonNull NativeHandle nativeHandle;

    private static native long createNativeMMappedFile(String var0) throws IOException;

    private static native void destroyNativeMMappedFile(long var0);

    private static native void read(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

    private static native byte read8(long var0, long var2) throws IOException;

    private static native short read16(long var0, long var2, boolean var4) throws IOException;

    private static native int read32(long var0, long var2, boolean var4) throws IOException;

    private static native long read64(long var0, long var2, boolean var4) throws IOException;

    private static native long size(long var0);

    private static long open(@NonNull File file) throws IOException {
        try {
            return MMappedFile.createNativeMMappedFile(file.getAbsolutePath());
        }
        catch (NativeIOException nativeIOException) {
            if (file.isFile() && file.canRead() && file.length() == 0L) {
                return 0L;
            }
            throw nativeIOException;
        }
        catch (NativeException nativeException) {
            if (file.isFile() && file.canRead() && file.length() == 0L) {
                return 0L;
            }
            throw new IOException(nativeException);
        }
    }

    public MMappedFile(@NonNull File file) throws IOException {
        this.nativeHandle = new NativeHandle(MMappedFile.open(file), MMappedFile::destroyNativeMMappedFile);
    }

    @Override
    public void close() {
        this.nativeHandle.close();
    }

    public long size() {
        Optional<Long> optional = this.nativeHandle.doIf(l -> MMappedFile.size(l));
        return optional.orElse(0L);
    }

    public byte read8(long l) throws IOException {
        return this.nativeHandle.doWith(l2 -> MMappedFile.read8(l2, l));
    }

    public short read16(long l, boolean bl) throws IOException {
        return this.nativeHandle.doWith(l2 -> MMappedFile.read16(l2, l, bl));
    }

    public int read32(long l, boolean bl) throws IOException {
        return this.nativeHandle.doWith(l2 -> MMappedFile.read32(l2, l, bl));
    }

    public long read64(long l, boolean bl) throws IOException {
        return this.nativeHandle.doWith(l2 -> MMappedFile.read64(l2, l, bl));
    }

    public void read(long l, byte @NonNull [] byArray, int n, int n2) throws IOException {
        this.nativeHandle.doWith(l2 -> MMappedFile.read(l2, l, byArray, n, n2));
    }

    public void read(long l, byte @NonNull [] byArray) throws IOException {
        this.read(l, byArray, 0, byArray.length);
    }

    static {
        if (!CommonLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load common JNI lib");
        }
    }
}

