/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.rules;

import com.arm.eclipse.cdt.asmlib.model.ARMInstructionInfo;
import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import com.arm.eclipse.cdt.asmlib.model.Directives;
import com.arm.eclipse.cdt.asmlib.model.Registers;
import com.arm.eclipse.cdt.asmlib.rules.AbstractCommentRecogniser;
import com.arm.eclipse.cdt.asmlib.rules.AsmToken;
import com.arm.eclipse.cdt.asmlib.rules.CommentStartRecogniser;
import com.arm.eclipse.cdt.asmlib.rules.GASCommentStartRecogniser;
import com.arm.eclipse.cdt.asmlib.rules.LineReader;
import com.arm.eclipse.cdt.asmlib.rules.PreviouslyParsedQueue;
import com.arm.eclipse.cdt.asmlib.rules.TokenType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;

public class LineTokenizer {
    private final PreviouslyParsedQueue parseCacheStack = new PreviouslyParsedQueue();
    private final boolean fromDisassembler;
    private static final BigInteger maxInt = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private static final String MULTILINE_COMMENT_END = "*/";
    private static final char SEMI_COLON = ';';
    private static final String SEMICOLON_REGEX = ";+";
    private static final String WHITESPACE_REGEX = "\\s*";
    private static final Pattern ARM_LABEL_PATTERN = Pattern.compile("(([A-Za-z0-9_]+)|(\\|[^|;\n\r]+\\|)|(\\|\\|[^|;\n\r]+\\|\\|))");
    private static final Pattern GAS_LABEL_PATTERN = Pattern.compile("\\S+([:])");
    private static final Pattern PRE_PROC_ID_PATTERN = Pattern.compile("([A-Za-z\\$_]+)([A-Z0-9a-z\\$_]+)*");

    public LineTokenizer(boolean fromDisassembler) {
        this.fromDisassembler = fromDisassembler;
    }

    public AsmToken getNextToken(ICharacterScanner scanner, AssemblerModel.AsmMode mode, AssemblerModel.InstSet instSet) {
        AsmToken result = this.parseCacheStack.getTokenReadChars(scanner);
        if (result != null) {
            return result;
        }
        int a = scanner.read();
        scanner.unread();
        if (a == -1) {
            result = new AsmToken("", TokenType.UNDEFINED);
        }
        String line = LineReader.getLine(scanner);
        List<AsmToken> tokens = LineTokenizer.tokeniseLine(line, instSet, mode, this.fromDisassembler);
        AbstractCommentRecogniser csr = LineTokenizer.getCommentRecogniser(mode);
        if (!tokens.isEmpty() && csr.isMultilineCommentStart(tokens.get(tokens.size() - 1).getText(), 0) && !csr.isMultilineComment(tokens.get(tokens.size() - 1).getText(), 0)) {
            ArrayList<String> linesParsed = new ArrayList<String>();
            linesParsed.add(line);
            AsmToken undefToken = tokens.remove(tokens.size() - 1);
            StringBuilder commentContents = new StringBuilder(undefToken.getText());
            boolean foundEndComment = false;
            while (!foundEndComment && scanner.read() != -1) {
                scanner.unread();
                line = LineReader.getLine(scanner);
                linesParsed.add(line);
                int endIndex = line.indexOf(MULTILINE_COMMENT_END);
                if (endIndex == -1) {
                    commentContents.append(line);
                    continue;
                }
                String remainder = line.substring(endIndex + MULTILINE_COMMENT_END.length(), line.length());
                commentContents.append(line.substring(0, endIndex + MULTILINE_COMMENT_END.length()));
                tokens.add(new AsmToken(commentContents.toString(), TokenType.COMMENT));
                tokens.addAll(LineTokenizer.tokeniseLine(remainder, instSet, mode, this.fromDisassembler));
                foundEndComment = true;
            }
            if (!foundEndComment) {
                tokens.add(new AsmToken(commentContents.toString(), TokenType.COMMENT_ERROR));
            }
            for (String l : linesParsed) {
                int i = 0;
                while (i < l.length()) {
                    scanner.unread();
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < line.length()) {
                scanner.unread();
                ++i;
            }
        }
        int j = 0;
        while (j < tokens.size()) {
            this.parseCacheStack.addTokenChars(tokens.get(j));
            ++j;
        }
        result = this.parseCacheStack.getTokenReadChars(scanner);
        if (result == null) {
            result = new AsmToken("", TokenType.UNDEFINED);
        }
        return result;
    }

    public static AbstractCommentRecogniser getCommentRecogniser(AssemblerModel.AsmMode asmFormat) {
        if (AssemblerModel.AsmMode.GAS.equals((Object)asmFormat)) {
            return GASCommentStartRecogniser.getInstance();
        }
        return CommentStartRecogniser.getInstance();
    }

    public static List<AsmToken> tokeniseLine(String line, AssemblerModel.InstSet instSet, AssemblerModel.AsmMode asmFormat, boolean fromDisassembler) {
        if (AssemblerModel.AsmMode.GAS.equals((Object)asmFormat)) {
            return LineTokenizer.tokeniseMultiLine(line, LineTokenizer.getCommentRecogniser(asmFormat), instSet, asmFormat, fromDisassembler);
        }
        return LineTokenizer.tokeniseLine(line, LineTokenizer.getCommentRecogniser(asmFormat), instSet, asmFormat, fromDisassembler);
    }

    private static List<AsmToken> tokeniseLine(String line, AbstractCommentRecogniser recogniser, AssemblerModel.InstSet instSet, AssemblerModel.AsmMode asmFormat, boolean fromDisassembler) {
        String token;
        if (line == null || line.equals("")) {
            return new ArrayList<AsmToken>();
        }
        List<String> lexed = LineTokenizer.lexLine(line, recogniser);
        ArrayList<AsmToken> tokens = new ArrayList<AsmToken>(lexed.size());
        if (lexed.isEmpty()) {
            return tokens;
        }
        boolean restComments = false;
        int tokenIndex = 0;
        String firstToken = lexed.get(tokenIndex);
        while (tokenIndex < lexed.size()) {
            if (recogniser.isComment(firstToken, 0)) {
                tokens.add(new AsmToken(firstToken, TokenType.COMMENT));
                if (!recogniser.isMultilineComment(firstToken, 0)) {
                    restComments = true;
                }
            } else {
                if (!LineTokenizer.isTokenWhitespace(firstToken)) break;
                tokens.add(new AsmToken(firstToken, TokenType.WHITESPACE));
            }
            if (++tokenIndex >= lexed.size()) continue;
            firstToken = lexed.get(tokenIndex);
        }
        if (!fromDisassembler && !restComments && tokenIndex < lexed.size()) {
            if (tokenIndex == 0 && LineTokenizer.isFirstColumnLabel(firstToken, asmFormat)) {
                tokens.add(new AsmToken(firstToken, TokenType.LABEL));
                ++tokenIndex;
            } else if (tokenIndex > 0 && LineTokenizer.isSubsequentColumnLabel(firstToken, asmFormat)) {
                tokens.add(new AsmToken(firstToken, TokenType.LABEL));
                ++tokenIndex;
            } else if (LineTokenizer.isPreProcDirective(firstToken, asmFormat)) {
                String la2;
                String la1;
                tokens.add(new AsmToken(firstToken, TokenType.PRE_PROC));
                if (firstToken.equals("#") && ++tokenIndex + 1 < lexed.size()) {
                    la1 = lexed.get(tokenIndex);
                    la2 = lexed.get(tokenIndex + 1);
                    if (LineTokenizer.isTokenWhitespace(la1) && LineTokenizer.isPreProcIdentifier(la2)) {
                        tokens.add(new AsmToken(la1, TokenType.WHITESPACE));
                        tokens.add(new AsmToken(la2, TokenType.PRE_PROC));
                        tokenIndex += 2;
                    }
                }
                if (tokenIndex + 1 < lexed.size()) {
                    la1 = lexed.get(tokenIndex);
                    la2 = lexed.get(tokenIndex + 1);
                    if (LineTokenizer.isTokenWhitespace(la1) && la2.startsWith("<")) {
                        tokens.add(new AsmToken(la1, TokenType.WHITESPACE));
                        tokens.add(new AsmToken(la2, TokenType.QUOTED_STRING));
                        tokenIndex += 2;
                        while (tokenIndex < lexed.size()) {
                            String token2 = lexed.get(tokenIndex);
                            if (recogniser.isComment(token2, 0) || LineTokenizer.isTokenSemiColon(token2)) break;
                            int firstIndex = token2.indexOf(62);
                            if (firstIndex > 0) {
                                String headerEnd;
                                if (firstIndex == token2.length() - 1) {
                                    headerEnd = token2;
                                } else {
                                    headerEnd = token2.substring(0, firstIndex + 1);
                                    lexed.add(firstIndex, token2.substring(firstIndex, token2.length()));
                                }
                                tokens.add(new AsmToken(headerEnd, TokenType.QUOTED_STRING));
                                ++tokenIndex;
                                break;
                            }
                            tokens.add(new AsmToken(token2, TokenType.QUOTED_STRING));
                            ++tokenIndex;
                        }
                    }
                }
            }
        }
        if (!fromDisassembler && !restComments && tokenIndex < lexed.size() && LineTokenizer.isTokenWhitespace(token = lexed.get(tokenIndex))) {
            tokens.add(new AsmToken(token, TokenType.WHITESPACE));
            ++tokenIndex;
        }
        if (!restComments && tokenIndex < lexed.size()) {
            token = lexed.get(tokenIndex);
            if (!recogniser.isComment(token, 0)) {
                if (LineTokenizer.matchInstructionCode(token, instSet) && LineTokenizer.nextIsWhiteSpaceOrComment(lexed, tokenIndex, recogniser)) {
                    tokens.add(new AsmToken(token, TokenType.INSTRUCTION));
                    ++tokenIndex;
                } else if (LineTokenizer.matchDepracatedInstructionCode(token) && LineTokenizer.nextIsWhiteSpaceOrComment(lexed, tokenIndex, recogniser)) {
                    tokens.add(new AsmToken(token, TokenType.DEPRECATED_INSTRUCTION));
                    ++tokenIndex;
                } else {
                    int gobbleTokens = Directives.isValidDirective(lexed, tokenIndex, asmFormat);
                    if (gobbleTokens > 0 && LineTokenizer.nextIsWhiteSpaceOrComment(lexed, tokenIndex + gobbleTokens - 1, recogniser)) {
                        while (gobbleTokens > 0) {
                            if (gobbleTokens % 2 != 0) {
                                tokens.add(new AsmToken(lexed.get(tokenIndex), TokenType.DIRECTIVE));
                                ++tokenIndex;
                            } else {
                                tokens.add(new AsmToken(lexed.get(tokenIndex), TokenType.WHITESPACE));
                                ++tokenIndex;
                            }
                            --gobbleTokens;
                        }
                    } else if (fromDisassembler && LineTokenizer.nextIsWhiteSpaceOrComment(lexed, tokenIndex, recogniser)) {
                        tokens.add(new AsmToken(token, TokenType.INSTRUCTION));
                        ++tokenIndex;
                    }
                }
            } else if (!recogniser.isMultilineComment(token, 0)) {
                restComments = true;
            }
        }
        while (!restComments && lexed.size() > tokenIndex) {
            TokenType tokenType;
            token = lexed.get(tokenIndex);
            if (recogniser.isComment(token, 0)) {
                if (!recogniser.isMultilineComment(token, 0)) {
                    restComments = true;
                    break;
                }
                tokenType = TokenType.COMMENT;
            } else {
                tokenType = Registers.isValidRegister(token, instSet) || Registers.isValidRegisterRange(token, instSet) ? TokenType.REGISTER : (token.startsWith("#") || token.startsWith("=") ? (token.length() > 1 && LineTokenizer.isValidIntLiteral(token.substring(1)) || LineTokenizer.isValidFloatConstant(token.substring(1)) ? TokenType.LITERAL : TokenType.UNDEFINED) : (LineTokenizer.isTokenWhitespace(token) ? TokenType.WHITESPACE : (token.startsWith("\"") ? TokenType.QUOTED_STRING : TokenType.UNDEFINED)));
            }
            tokens.add(new AsmToken(token, tokenType));
            ++tokenIndex;
        }
        int i = tokenIndex;
        while (restComments && i < lexed.size()) {
            String token3 = lexed.get(i);
            if (LineTokenizer.isTokenWhitespace(token3)) {
                tokens.add(new AsmToken(token3, TokenType.WHITESPACE));
            } else {
                tokens.add(new AsmToken(token3, TokenType.COMMENT));
            }
            ++i;
        }
        return tokens;
    }

    private static List<AsmToken> tokeniseMultiLine(String line, AbstractCommentRecogniser recogniser, AssemblerModel.InstSet instSet, AssemblerModel.AsmMode asmFormat, boolean fromDisassembler) {
        List<String> splitLines = LineTokenizer.splitOnSemiColons(line);
        ArrayList<AsmToken> ret = new ArrayList<AsmToken>();
        for (String splitLine : splitLines) {
            ret.addAll(LineTokenizer.tokeniseLine(splitLine, recogniser, instSet, asmFormat, fromDisassembler));
        }
        return ret;
    }

    private static boolean isPreProcDirective(String token, AssemblerModel.AsmMode format) {
        return token.startsWith("#");
    }

    private static boolean nextIsWhiteSpaceOrComment(List<String> tokens, int tokenIndex, AbstractCommentRecogniser commentRecogniser) {
        if (tokenIndex + 1 < tokens.size()) {
            String nextToken = tokens.get(tokenIndex + 1);
            return LineTokenizer.isTokenWhitespace(nextToken) || commentRecogniser.isComment(nextToken, 0) || commentRecogniser.isMultilineCommentStart(nextToken, 0);
        }
        return true;
    }

    private static boolean isFirstColumnLabel(String token, AssemblerModel.AsmMode format) {
        switch (format) {
            case ARMASM: {
                return ARM_LABEL_PATTERN.matcher(token).matches();
            }
            case GAS: {
                return GAS_LABEL_PATTERN.matcher(token).matches();
            }
        }
        return ARM_LABEL_PATTERN.matcher(token).matches() || GAS_LABEL_PATTERN.matcher(token).matches();
    }

    private static boolean isSubsequentColumnLabel(String token, AssemblerModel.AsmMode format) {
        switch (format) {
            case ARMASM: {
                return false;
            }
            case GAS: {
                return GAS_LABEL_PATTERN.matcher(token).matches();
            }
        }
        return GAS_LABEL_PATTERN.matcher(token).matches();
    }

    private static final boolean isPreProcIdentifier(String token) {
        return PRE_PROC_ID_PATTERN.matcher(token).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidIntLiteral(String literalString) {
        try {
            String number;
            int base;
            if (literalString.startsWith("-")) {
                literalString = literalString.substring(1);
            }
            if (literalString.length() > 1 && literalString.startsWith("&")) {
                base = 16;
                number = literalString.substring(1);
            } else if (literalString.length() > 2 && literalString.startsWith("0x")) {
                base = 16;
                number = literalString.substring(2);
            } else if (literalString.length() > 2 && literalString.charAt(1) == '_') {
                base = Integer.parseInt(Character.toString(literalString.charAt(0)));
                if (base < 2 || base > 9) {
                    return false;
                }
                number = literalString.substring(2);
            } else {
                base = 10;
                number = literalString;
            }
            BigInteger bigValue = new BigInteger(number, base);
            return maxInt.compareTo(bigValue) != -1;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isValidFloatConstant(String candidateConstant) {
        char[] chars = candidateConstant.toCharArray();
        if (chars.length < 3) {
            return false;
        }
        if (chars[0] == '&') {
            String rest = candidateConstant.substring(1);
            return rest.matches("[0-9A-Fa-f]+");
        }
        if (chars[0] == '0' && chars[1] == 'x' && chars[2] == '_') {
            String rest = candidateConstant.substring(2);
            return rest.matches("[0-9A-Fa-f]+");
        }
        if (chars[0] == '0' && chars[1] == 'f' && chars[2] == '_') {
            String rest = candidateConstant.substring(3);
            return rest.matches("[0-9A-Fa-f]{8}");
        }
        if (chars[0] == '0' && chars[1] == 'd') {
            String rest = candidateConstant.substring(3);
            return rest.matches("[0-9A-Fa-f]{16}");
        }
        Pattern pattern = Pattern.compile("[-]?[0-9]+(?:\\.[0-9]+(E[-]?[0-9]+)?|E[-]?[0-9]+)");
        return pattern.matcher(candidateConstant).matches();
    }

    private static boolean matchInstructionCode(String token, AssemblerModel.InstSet instSet) {
        if (AssemblerModel.InstSet.UNKNOWN.equals((Object)instSet)) {
            return ARMInstructionInfo.getInstInfo(token, AssemblerModel.InstSet.AARCH32).isPresent() || ARMInstructionInfo.getInstInfo(token, AssemblerModel.InstSet.AARCH64).isPresent();
        }
        return ARMInstructionInfo.getInstInfo(token, instSet).isPresent();
    }

    private static boolean matchDepracatedInstructionCode(String token) {
        return ARMInstructionInfo.isDeprecatedInstruction(token);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<String> lexLine(String line, AbstractCommentRecogniser recogniser) {
        char c;
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        boolean sawWhiteLast = false;
        boolean sawSemiColonLast = false;
        boolean inLiteral = false;
        int i = 0;
        while (i < line.length()) {
            c = line.charAt(i);
            if (recogniser.isComment(line, i) || recogniser.isMultilineCommentStart(line, i)) {
                if (current.length() > 0) {
                    list.add(current.toString());
                    current.setLength(0);
                }
                if (!recogniser.isMultilineComment(line, i)) {
                    list.add(line.substring(i));
                    return list;
                }
                list.add(line.substring(i, line.indexOf(MULTILINE_COMMENT_END, i) + 2));
                i = line.indexOf(MULTILINE_COMMENT_END, i) + 2;
                break;
            }
            if (Character.isWhitespace(c) || c == ';') {
                if (current.length() == 0) break;
                list.add(current.toString());
                current.setLength(0);
                break;
            }
            current.append(c);
            ++i;
        }
        while (i < line.length()) {
            block36: {
                block37: {
                    c = line.charAt(i);
                    if (c != '\"') break block37;
                    if (inLiteral) {
                        if (current.charAt(current.length() - 1) == '\\') {
                            current.append(c);
                            break block36;
                        } else {
                            current.append(c);
                            list.add(current.toString());
                            inLiteral = false;
                            current.setLength(0);
                            sawWhiteLast = false;
                            sawSemiColonLast = false;
                        }
                        break block36;
                    } else {
                        if (current.length() > 0) {
                            list.add(current.toString());
                            current.setLength(0);
                        }
                        current.append(c);
                        inLiteral = true;
                    }
                    break block36;
                }
                if (inLiteral) {
                    current.append(c);
                } else if (Character.isWhitespace(c)) {
                    if (sawWhiteLast) {
                        current.append(c);
                    } else {
                        if (current.length() > 0) {
                            list.add(current.toString());
                        }
                        current.setLength(0);
                        current.append(c);
                        sawWhiteLast = true;
                        sawSemiColonLast = false;
                    }
                } else if (!recogniser.isComment(line, i) && c == ';') {
                    if (sawSemiColonLast) {
                        current.append(c);
                    } else {
                        if (current.length() > 0) {
                            list.add(current.toString());
                        }
                        current.setLength(0);
                        current.append(c);
                        sawSemiColonLast = true;
                        sawWhiteLast = false;
                    }
                } else {
                    if (sawWhiteLast || sawSemiColonLast) {
                        if (current.length() > 0) {
                            list.add(current.toString());
                        }
                        current.setLength(0);
                        sawWhiteLast = false;
                        sawSemiColonLast = false;
                    }
                    if (recogniser.isComment(line, i) || recogniser.isMultilineCommentStart(line, i)) {
                        if (current.length() > 0) {
                            list.add(current.toString());
                            current.setLength(0);
                        }
                        if (!recogniser.isMultilineComment(line, i)) {
                            list.add(line.substring(i));
                            return list;
                        }
                        list.add(line.substring(i, line.indexOf(MULTILINE_COMMENT_END, i) + 2));
                        i = line.indexOf(MULTILINE_COMMENT_END, i) + 1;
                    } else if (c == '[' || c == ']' || c == '+' || c == '!' || c == ',' || c == '{' || c == '}' || c == '*') {
                        if (current.length() > 0) {
                            list.add(current.toString());
                        }
                        list.add(Character.toString(c));
                        current.setLength(0);
                    } else if (c == '#') {
                        if (current.length() > 0) {
                            list.add(current.toString());
                        }
                        current.setLength(0);
                        current.append(c);
                    } else {
                        current.append(c);
                    }
                }
            }
            ++i;
        }
        if (current.length() >= 1) {
            list.add(current.toString());
        }
        return list;
    }

    private static boolean isTokenWhitespace(String token) {
        return token.matches(WHITESPACE_REGEX);
    }

    private static boolean isTokenSemiColon(String token) {
        return token.matches(SEMICOLON_REGEX);
    }

    private static List<String> splitOnSemiColons(String token) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder curStr = new StringBuilder();
        boolean insideQuotes = false;
        boolean sawSemiColonLast = false;
        GASCommentStartRecogniser csr = GASCommentStartRecogniser.getInstance();
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (csr.isComment(token, i) || csr.isMultilineCommentStart(token, i)) {
                curStr.append(token.substring(i));
                break;
            }
            if (c == ';') {
                if (!insideQuotes) {
                    sawSemiColonLast = true;
                }
                curStr.append(c);
            } else {
                if (sawSemiColonLast) {
                    ret.add(curStr.toString());
                    curStr.setLength(0);
                }
                sawSemiColonLast = false;
                curStr.append(c);
            }
            if (c == '\'' || c == '\"') {
                insideQuotes = !insideQuotes;
            }
            ++i;
        }
        if (curStr.length() != 0) {
            ret.add(curStr.toString());
        }
        return ret;
    }
}

