/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.text.FormattedMessage;
import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;

public enum Messages implements IMessage
{
    FAILED_FIND("01_FAILED_FIND", 1),
    FAILED_READ("02_FAILED_READ", 2),
    FAILED_DESERIALISE("03_FAILED_DESERIALISE", 3),
    ASMMODE_UNKNOWN("04_ASMMODE_UNKNOWN", 4),
    ASMMODE_GAS("05_ASMMODE_GAS", 5),
    ASMMODE_GAS_SHORT("06_ASMMODE_GAS_SHORT", 6),
    ASMMODE_ARMASM("07_ASMMODE_ARMASM", 7),
    ASMMODE_ARMASM_SHORT("08_ASMMODE_ARMASM_SHORT", 8),
    INSTSET_UNKNOWN("09_INSTSET_UNKNOWN", 9),
    INSTSET_AARCH64("10_INSTSET_AARCH64", 10),
    INSTSET_AARCH32("11_INSTSET_AARCH32", 11);

    private static final ResourceBundle RESOURCE_BUNDLE_ENGLISH;
    private static ResourceBundle RESOURCE_BUNDLE_LOCALISED;
    private final String key;
    private final int code;

    static {
        RESOURCE_BUNDLE_ENGLISH = ResourceBundle.getBundle("com/arm/eclipse/cdt/asmlib/model/messages", Locale.ROOT);
        Messages.refreshLocalized();
    }

    public static void refreshLocalized() {
        RESOURCE_BUNDLE_LOCALISED = ResourceBundle.getBundle("com/arm/eclipse/cdt/asmlib/model/messages");
    }

    private Messages(String key, int code) {
        this.key = key;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getEnglishValue(Object ... args) {
        String englishMessage = RESOURCE_BUNDLE_ENGLISH.getString(this.key);
        englishMessage = Messages.removeParameterNames(englishMessage);
        return (args = Messages.removeNesting(args, false)) != null && args.length > 0 ? MessageFormat.format(englishMessage, args) : englishMessage;
    }

    public String getLocalisedValue(Object ... args) {
        String localMessage = RESOURCE_BUNDLE_LOCALISED.getString(this.key);
        localMessage = Messages.removeParameterNames(localMessage);
        return (args = Messages.removeNesting(args, true)) != null && args.length > 0 ? MessageFormat.format(localMessage, args) : localMessage;
    }

    private static Object[] removeNesting(@Nullable Object[] args, boolean localise) {
        if (args != null) {
            boolean isCopy = false;
            int i = 0;
            while (i < args.length) {
                Object a = args[i];
                if (a instanceof IFormattedMessage || a instanceof IMessage) {
                    if (!isCopy) {
                        isCopy = true;
                        args = Arrays.copyOf(args, args.length);
                    }
                    args[i] = a instanceof IFormattedMessage ? (localise ? ((IFormattedMessage)a).getLocalisedValue() : ((IFormattedMessage)a).getEnglishValue()) : (localise ? ((IMessage)a).getLocalisedValue(new Object[0]) : ((IMessage)a).getEnglishValue(new Object[0]));
                }
                ++i;
            }
        }
        return args;
    }

    private static String removeParameterNames(String message) {
        if (message.indexOf(123) < 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        boolean strip = false;
        boolean quoted = false;
        int i = 0;
        while (i < message.length()) {
            char current = message.charAt(i);
            switch (current) {
                case '\'': {
                    builder.append(current);
                    if (quoted) {
                        quoted = false;
                        break;
                    }
                    quoted = true;
                    break;
                }
                case '{': {
                    builder.append(current);
                    if (!quoted) {
                        int end = message.indexOf(125, i);
                        int colon = message.indexOf(58, i);
                        if (colon > 0 && colon < end) {
                            strip = true;
                        }
                    }
                    quoted = false;
                    break;
                }
                case ':': {
                    if (!strip) {
                        builder.append(current);
                    }
                    strip = false;
                    quoted = false;
                    break;
                }
                default: {
                    if (!strip) {
                        builder.append(current);
                    }
                    quoted = false;
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public IFormattedMessage format(Object ... args) {
        return new FormattedMessage((IMessage)this, args);
    }

    public ILayer getLayer() {
        return null;
    }
}

