/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.architecturexml.InstructionSet;
import com.arm.eclipse.cdt.asmlib.model.AsmArea;
import com.arm.eclipse.cdt.asmlib.model.AsmLabel;
import com.arm.eclipse.cdt.asmlib.model.AsmMacro;
import com.arm.eclipse.cdt.asmlib.model.AsmModelComponent;
import com.arm.eclipse.cdt.asmlib.model.Messages;
import com.arm.text.IMessage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AssemblerModel {
    private Map<Integer, AsmLabel> mappedLabels = new ConcurrentHashMap<Integer, AsmLabel>();
    private Map<Integer, AsmArea> areas = new ConcurrentHashMap<Integer, AsmArea>();
    private Map<Integer, AsmMacro> macros = new ConcurrentHashMap<Integer, AsmMacro>();
    @Nonnull
    private AsmMode detectedAsmMode = AsmMode.UNKNOWN;
    @Nullable
    private AsmMode overriddenAsmMode = null;
    @Nonnull
    private InstSet detectedInstSet = InstSet.UNKNOWN;
    @Nullable
    private InstSet overriddenInstSet = null;

    public String getLineCommentString() {
        switch (this.getAsmMode()) {
            case GAS: {
                switch (this.getInstSet()) {
                    case AARCH32: {
                        return "@";
                    }
                }
                return "//";
            }
        }
        return ";";
    }

    @Nonnull
    public AsmMode getAsmMode() {
        return this.overriddenAsmMode != null ? this.overriddenAsmMode : this.detectedAsmMode;
    }

    public boolean isAsmModeOverridden() {
        return this.overriddenAsmMode != null;
    }

    public void setAsmMode(@Nullable AsmMode asmMode, boolean detected) {
        if (detected && asmMode != null) {
            this.detectedAsmMode = asmMode;
        } else {
            this.overriddenAsmMode = asmMode;
        }
    }

    @Nonnull
    public InstSet getInstSet() {
        return this.overriddenInstSet != null ? this.overriddenInstSet : this.detectedInstSet;
    }

    public boolean isInstSetOverridden() {
        return this.overriddenInstSet != null;
    }

    public void setInstSet(@Nullable InstSet instSet, boolean detected) {
        if (detected && instSet != null) {
            this.detectedInstSet = instSet;
        } else {
            this.overriddenInstSet = instSet;
        }
    }

    public List<AsmLabel> getLabels() {
        ArrayList<AsmLabel> labelValues = new ArrayList<AsmLabel>();
        labelValues.addAll(this.mappedLabels.values());
        Collections.sort(labelValues);
        return labelValues;
    }

    public List<AsmMacro> getMacros() {
        ArrayList<AsmMacro> macroValues = new ArrayList<AsmMacro>();
        macroValues.addAll(this.macros.values());
        Collections.sort(macroValues);
        return macroValues;
    }

    public List<AsmModelComponent> getComponents() {
        ArrayList<AsmModelComponent> componentValues = new ArrayList<AsmModelComponent>();
        componentValues.addAll(this.mappedLabels.values());
        componentValues.addAll(this.areas.values());
        componentValues.addAll(this.macros.values());
        Collections.sort(componentValues);
        return componentValues;
    }

    public void addLabel(AsmLabel label) {
        this.mappedLabels.put(label.getOffset(), label);
    }

    public void addMacro(AsmMacro macro) {
        this.macros.put(macro.getOffset(), macro);
    }

    public void removeComponent(int offset) {
        this.mappedLabels.remove(offset);
        this.areas.remove(offset);
        this.macros.remove(offset);
    }

    public void addArea(AsmArea area) {
        this.areas.put(area.getOffset(), area);
    }

    public void removeArea(int offset) {
        this.areas.remove(offset);
    }

    public void removeRegion(int offset, int length) {
        int i = 0;
        while (i < length) {
            this.removeComponent(offset + i);
            this.removeArea(offset + i);
            ++i;
        }
    }

    public Object[] getAreas() {
        ArrayList<AsmArea> areaValues = new ArrayList<AsmArea>();
        areaValues.addAll(this.areas.values());
        Collections.sort(areaValues);
        return areaValues.toArray(new AsmArea[areaValues.size()]);
    }

    public static enum AsmMode {
        UNKNOWN(Messages.ASMMODE_UNKNOWN, Messages.ASMMODE_UNKNOWN),
        GAS(Messages.ASMMODE_GAS, Messages.ASMMODE_GAS_SHORT),
        ARMASM(Messages.ASMMODE_ARMASM, Messages.ASMMODE_ARMASM_SHORT);

        private final IMessage messageLong;
        private final IMessage messageShort;

        private AsmMode(IMessage messageLong, IMessage messageShort) {
            this.messageLong = messageLong;
            this.messageShort = messageShort;
        }

        public String getLocalisedValue() {
            return this.messageLong.getLocalisedValue(new Object[0]);
        }

        public String getShortLocalisedValue() {
            return this.messageShort.getLocalisedValue(new Object[0]);
        }
    }

    public static enum InstSet {
        UNKNOWN(Messages.INSTSET_UNKNOWN),
        AARCH32(Messages.INSTSET_AARCH32),
        AARCH64(Messages.INSTSET_AARCH64);

        private final IMessage message;

        private InstSet(IMessage message) {
            this.message = message;
        }

        public String getLocalisedValue() {
            return this.message.getLocalisedValue(new Object[0]);
        }

        public InstructionSet toArchitectureXMLInstSet() {
            switch (this) {
                case AARCH32: {
                    return InstructionSet.A32;
                }
                case AARCH64: {
                    return InstructionSet.A64;
                }
            }
            return InstructionSet.UNKNOWN;
        }
    }
}

