/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib.model;

import com.arm.architecturexml.ArchDocInspector;
import com.arm.architecturexml.InstInfo;
import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import com.arm.eclipse.cdt.asmlib.model.V8MInstructions;
import com.arm.eclipse.cdt.asmlib.model.WirelessMMX;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class ARMInstructionInfo {
    private static String[] deprecatedInstructions;
    private static String cond;
    private static Pattern deprecatedInstructionPattern;
    private static Map<String, String> deprecatedToCurrentMap;
    private static Pattern validInstructionPattern;

    static {
        cond = "(eq|ne|cs|hs|cc|lo|mi|pl|vs|vc|hi|ls|ge|lt|gt|le|al|nv)?";
        deprecatedInstructions = new String[]{"swi$cond", "smi$cond", "(sxt|uxt)(8|16)$cond"};
        deprecatedToCurrentMap = new HashMap<String, String>();
        deprecatedToCurrentMap.put("swi", "svc");
        deprecatedToCurrentMap.put("smi", "smc");
        deprecatedToCurrentMap.put("sxt8", "sxtb");
        deprecatedToCurrentMap.put("sxt16", "sxth");
        deprecatedToCurrentMap.put("uxt8", "uxtb");
        deprecatedToCurrentMap.put("uxt16", "uxth");
        ARMInstructionInfo.expandVariables(deprecatedInstructions);
        deprecatedInstructionPattern = ARMInstructionInfo.composeRegexes(deprecatedInstructions);
    }

    private static void expandVariables(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            strings[i] = strings[i].replace("$cond", cond);
            strings[i] = String.valueOf(strings[i]) + "(\\.w|\\.n)?";
            ++i;
        }
    }

    private static Pattern composeRegexes(String[] regexes) {
        StringBuilder patternString = new StringBuilder();
        patternString.append('(').append(regexes[0]).append(')');
        int i = 1;
        while (i < regexes.length) {
            patternString.append('|');
            patternString.append("(?:");
            patternString.append(regexes[i]);
            patternString.append(')');
            patternString.append('|');
            patternString.append("(?:");
            patternString.append(regexes[i].toLowerCase());
            patternString.append(')');
            ++i;
        }
        return Pattern.compile(patternString.toString());
    }

    public static String getCurrentVersion(String deprecatedMnemonic) {
        if (!ARMInstructionInfo.isDeprecatedInstruction(deprecatedMnemonic = deprecatedMnemonic.toLowerCase())) {
            return "";
        }
        String longestMatch = "";
        for (String key : deprecatedToCurrentMap.keySet()) {
            if (!deprecatedMnemonic.startsWith(key) || key.length() <= longestMatch.length()) continue;
            longestMatch = key;
        }
        if (!longestMatch.isEmpty()) {
            return deprecatedToCurrentMap.get(longestMatch);
        }
        return "";
    }

    public static String getDeprecatedVersion(String currentMnemonic) {
        for (Map.Entry<String, String> k : deprecatedToCurrentMap.entrySet()) {
            if (!currentMnemonic.toLowerCase().equals(k.getValue())) continue;
            return k.getKey();
        }
        return "";
    }

    public static Optional<InstInfo> getInstInfo(String token, AssemblerModel.InstSet instSet) {
        V8MInstructions v8m;
        if (token == null) {
            return Optional.empty();
        }
        if (validInstructionPattern == null) {
            validInstructionPattern = Pattern.compile("(?:[a-zA-Z0-9]+)(?:\\..*)?");
        }
        if (!validInstructionPattern.matcher(token).matches()) {
            return Optional.empty();
        }
        ArchDocInspector inspector = ArchDocInspector.getInstance();
        Optional<Object> result = inspector.getInstInfo(token, instSet.toArchitectureXMLInstSet());
        if (!result.isPresent() && AssemblerModel.InstSet.AARCH32.equals((Object)instSet) && !(result = WirelessMMX.isValidWirelessMMXInstruction(token) ? Optional.of(new InstInfo(token)) : Optional.empty()).isPresent() && (v8m = V8MInstructions.getInstance()).isValidV8MInstruction(token)) {
            result = Optional.of(new InstInfo(token));
        }
        return result;
    }

    public static boolean isDeprecatedInstruction(String inst) {
        if (!inst.toUpperCase().equals(inst) && !inst.toLowerCase().equals(inst)) {
            return false;
        }
        return deprecatedInstructionPattern.matcher(inst.toLowerCase()).matches();
    }
}

