/*
 * Decompiled with CFR 0.152.
 */
package com.arm.eclipse.cdt.asmlib;

import com.arm.eclipse.cdt.asmlib.rules.TokenType;
import java.util.EnumMap;
import java.util.Map;

public enum AsmTextStyle {
    INSTRUCTION(TokenType.INSTRUCTION, "Instruction", 127, 0, 127, 1),
    DIRECTIVE(TokenType.DIRECTIVE, "Directive", 0, 0, 0, 1),
    REGISTER(TokenType.REGISTER, "Register", 15, 15, 127, 2),
    LABEL(TokenType.LABEL, "Label", 0, 0, 255, 0),
    LITERAL(TokenType.LITERAL, "Literal", 191, 0, 0, 0),
    COMMENT(TokenType.COMMENT, "Comment", 0, 127, 0, 0),
    COMMENT_ERROR(TokenType.COMMENT_ERROR, "CommentError", 0, 127, 0, 0x40000000),
    DEPRECATED(TokenType.DEPRECATED_INSTRUCTION, "Deprecated", 127, 0, 127, 0x20000001),
    QUOTED(TokenType.QUOTED_STRING, "Quoted", 0, 0, 255, 0),
    PREPROC(TokenType.PRE_PROC, "PreProc", 127, 0, 85, 1),
    DEFAULT(TokenType.UNDEFINED, "Default", 0, 0, 0, 0);

    private static final Map<TokenType, AsmTextStyle> tokenTypeMap;
    public final TokenType tokenType;
    public final String colourPrefId;
    public final String textStylePrefiD;
    public final int defaultTextStyle;
    public final int red;
    public final int green;
    public final int blue;
    public final String id;

    static {
        tokenTypeMap = new EnumMap<TokenType, AsmTextStyle>(TokenType.class);
        AsmTextStyle[] asmTextStyleArray = AsmTextStyle.values();
        int n = asmTextStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsmTextStyle style = asmTextStyleArray[n2];
            tokenTypeMap.put(style.tokenType, style);
            ++n2;
        }
    }

    private AsmTextStyle(TokenType tokenType, String name, int red, int green, int blue, int textStyle) {
        this.tokenType = tokenType;
        this.colourPrefId = String.valueOf(name) + "Colour";
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.textStylePrefiD = String.valueOf(name) + "Style";
        this.defaultTextStyle = textStyle;
        this.id = name;
    }

    public static AsmTextStyle fromTokenType(TokenType t) {
        return tokenTypeMap.get((Object)t);
    }
}

