/*
 * Decompiled with CFR 0.152.
 */
package com.arm.rosetta;

import com.arm.rosetta.ArchitectureSubset;
import com.arm.rosetta.CoprocConfig;
import com.arm.rosetta.DirectMappedRosetta;
import com.arm.rosetta.IRosettaCallback;
import com.arm.rosetta.NativeCallbacks;
import com.arm.rosetta.RosettaState;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class RosettaDisassembler
implements AutoCloseable {
    private static final int BUF_SIZE = 4096;
    private final Resources resources;
    private boolean isClosed;
    private static final String DOES_NOT_SUPPORT = "Rosetta disassembly client does not support %s";

    RosettaDisassembler(ArchProfile profile, int majorVersion, int minorVersion) {
        this.resources = new Resources(this.makeRosettaState(profile, majorVersion, minorVersion));
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disassembleA64(long address, long opcode, IRosettaCallback callback, StringBuilder b) {
        Resources resources = this.resources;
        synchronized (resources) {
            this.checkClosed();
            return this.disassemble32(this.resources, address, opcode, true, callback, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disassembleA32(long address, long opcode, IRosettaCallback callback, StringBuilder b) {
        Resources resources = this.resources;
        synchronized (resources) {
            this.checkClosed();
            return this.disassemble32(this.resources, address, opcode, false, callback, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disassembleT32(long address, short opcode1, short opcode2, int itState, boolean thumbEE, CoprocessorType[] cdeCoprocs, IRosettaCallback callback, StringBuilder b) {
        Resources resources = this.resources;
        synchronized (resources) {
            this.checkClosed();
            CoprocConfig.ByVal coprocConfig = new CoprocConfig.ByVal();
            coprocConfig.set((CoprocConfig.CoprocType[])Arrays.stream(cdeCoprocs).map(e -> {
                switch (e) {
                    case CDE: {
                        return CoprocConfig.CoprocType.CP_CDEv1;
                    }
                    case GCP: {
                        return CoprocConfig.CoprocType.CP_GCP;
                    }
                }
                throw new IllegalArgumentException();
            }).toArray(CoprocConfig.CoprocType[]::new));
            DirectMappedRosetta.rosetta_set_coproc_config(this.resources.rosettaState, coprocConfig);
            return this.disassembleThumb(this.resources, address, opcode1, opcode2, itState, thumbEE, callback, b);
        }
    }

    private int disassemble32(Resources resources, long address, long opcode, boolean aarch64, IRosettaCallback callback, StringBuilder b) {
        byte[] out = resources.out;
        resources.publicCallBack = callback;
        int state = aarch64 ? RosettaState.a64.index : RosettaState.a32.index;
        Pointer callbacksPtr = resources.callbacks.getPointer();
        long size = DirectMappedRosetta.rosetta_disass_32(resources.rosettaState, state, address, (int)opcode, resources.ok, out, out.length, callbacksPtr);
        int success = resources.ok.getValue();
        this.sanitiseDisass(out, (int)size, b);
        if (success == 0) {
            b.append(" ; ? Undefined");
        }
        return 4;
    }

    private int disassembleThumb(Resources resources, long address, short opcode1, short opcode2, int itState, boolean thumbEE, IRosettaCallback callback, StringBuilder b) {
        byte[] out = resources.out;
        resources.publicCallBack = callback;
        int state = thumbEE ? RosettaState.t32ee.index : RosettaState.t32.index;
        Pointer callbacksPtr = resources.callbacks.getPointer();
        resources.itState.setValue((byte)itState);
        long size = DirectMappedRosetta.rosetta_disass_thumb(resources.rosettaState, state, (int)address, opcode1, opcode2, resources.itState, resources.width, resources.ok, out, out.length, callbacksPtr);
        int success = resources.ok.getValue();
        this.sanitiseDisass(out, (int)size, b);
        if (success == 0) {
            b.append(" ; ? Undefined");
        }
        return (int)resources.width.getValue();
    }

    private void sanitiseDisass(byte[] output, int size, StringBuilder dest) {
        String s = new String(output, 0, size, StandardCharsets.UTF_8);
        dest.append(s.trim());
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new UnsupportedOperationException("Rosetta disassembly library has been disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Resources resources = this.resources;
        synchronized (resources) {
            if (!this.isClosed) {
                try {
                    this.resources.close();
                }
                finally {
                    this.isClosed = true;
                }
            }
        }
    }

    private Pointer makeRosettaState(ArchProfile profile) {
        ArchitectureSubset subset;
        switch (profile) {
            case PROFILE_32AR: {
                subset = ArchitectureSubset._32AR;
                break;
            }
            case PROFILE_32M: {
                subset = ArchitectureSubset._32M;
                break;
            }
            case PROFILE_64A: {
                subset = ArchitectureSubset._64A;
                break;
            }
            case PROFILE_64R: {
                subset = ArchitectureSubset._64R;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format(DOES_NOT_SUPPORT, new Object[]{profile}));
            }
        }
        return DirectMappedRosetta.rosetta_new(subset.index);
    }

    private Pointer makeRosettaState(ArchProfile profile, int majorVersion, int minorVersion) {
        Pointer rs;
        block0 : switch (profile) {
            case PROFILE_64A: 
            case PROFILE_64R: 
            case PROFILE_32AR: 
            case PROFILE_32M: {
                switch (majorVersion) {
                    case 8: {
                        rs = this.makeRosettaState(profile);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException(String.format(DOES_NOT_SUPPORT, "ARMv" + majorVersion));
            }
            default: {
                throw new UnsupportedOperationException(String.format(DOES_NOT_SUPPORT, new Object[]{profile}));
            }
        }
        DirectMappedRosetta.rosetta_config_capital_ids(rs, 1);
        DirectMappedRosetta.rosetta_config_align_width(rs, 9);
        return rs;
    }

    public static enum ArchProfile {
        PROFILE_64A,
        PROFILE_64R,
        PROFILE_32AR,
        PROFILE_32M;

    }

    public static enum CoprocessorType {
        CDE,
        GCP;

    }

    private static final class Resources
    implements AutoCloseable {
        private Pointer rosettaState;
        private Pointer mem = new Pointer(Native.malloc((long)4096L));
        private final IntByReference ok = new IntByReference();
        private final ByteByReference itState = new ByteByReference();
        private final LongByReference width = new LongByReference();
        private final byte[] out = new byte[4096];
        public final NativeCallbacks callbacks;
        private IRosettaCallback publicCallBack;

        public Resources(Pointer rosettaState) {
            this.rosettaState = rosettaState;
            this.callbacks = new NativeCallbacks();
            this.callbacks.ctx = this.mem;
            this.callbacks.branch = new NativeCallbacks.LabelCallback(4096){

                @Override
                protected String resolveLabel(long destAddr) {
                    if (publicCallBack == null) {
                        return null;
                    }
                    return publicCallBack.resolveBranch(destAddr);
                }
            };
            this.callbacks.pcLoadStore = new NativeCallbacks.PcRelLoadStoreCallback(4096){

                @Override
                protected String resolveData(long accessAddr, int size, long offset, boolean store) {
                    if (publicCallBack == null) {
                        return null;
                    }
                    return publicCallBack.resolvePcRelLoadStore(accessAddr, size, offset, store);
                }
            };
            this.callbacks.adr = new NativeCallbacks.LabelCallback(4096){

                @Override
                protected String resolveLabel(long destAddr) {
                    if (publicCallBack == null) {
                        return null;
                    }
                    return publicCallBack.resolveAdr(destAddr);
                }
            };
            this.callbacks.write();
        }

        @Override
        public void close() {
            if (this.rosettaState != null) {
                DirectMappedRosetta.rosetta_free(this.rosettaState);
                this.rosettaState = null;
                Native.free((long)Pointer.nativeValue((Pointer)this.mem));
                this.mem = null;
            }
        }
    }
}

